"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeletedOccurrenceInfo = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Encapsulates information on the deleted occurrence of a recurring appointment.
 */
class DeletedOccurrenceInfo extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **DeletedOccurrenceInfo** class.
     */
    constructor() {
        super();
        /**
         * The original start date and time of the deleted occurrence.
         *
         * /remarks/    The EWS schema contains a Start property for deleted occurrences but it's really the original start date and time of the occurrence.
         */
        this.originalStart = null;
    }
    /**
     * Gets the original start date and time of the deleted occurrence.
     */
    get OriginalStart() {
        return this.originalStart;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        if (jsObject[XmlElementNames_1.XmlElementNames.Start]) {
            this.originalStart = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[XmlElementNames_1.XmlElementNames.Start]);
        }
    }
}
exports.DeletedOccurrenceInfo = DeletedOccurrenceInfo;
//# sourceMappingURL=DeletedOccurrenceInfo.js.map