"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteRuleOperation = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const RuleOperation_1 = require("./RuleOperation");
/**
 * Represents an operation to delete an existing rule.
 *
 * @sealed
 */
class DeleteRuleOperation extends RuleOperation_1.RuleOperation {
    constructor(ruleId = null) {
        super();
        this.ruleId = ruleId;
    }
    /**
     * Gets or sets the Id of the rule to delete.
     */
    get RuleId() {
        return this.ruleId;
    }
    set RuleId(value) {
        this.SetFieldValue({ getValue: () => this.ruleId, setValue: (updateValue) => { this.ruleId = updateValue; } }, value);
    }
    /**
     * @internal Gets the Xml element name of the DeleteRuleOperation object.
     */
    get XmlElementName() {
        return XmlElementNames_1.XmlElementNames.DeleteRuleOperation;
    }
    /**
     * @internal Validates this instance.
     */
    InternalValidate() {
        EwsUtilities_1.EwsUtilities.ValidateParam(this.ruleId, "RuleId");
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.RuleId, this.RuleId);
    }
}
exports.DeleteRuleOperation = DeleteRuleOperation;
//# sourceMappingURL=DeleteRuleOperation.js.map