"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationNode = void 0;
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const ItemInfo_1 = require("../Core/ServiceObjects/Items/ItemInfo");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents the response to a GetConversationItems operation.
 *
 * @sealed
 */
class ConversationNode extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **ConversationNode** class.
     *
     * @param   {PropertySet}   propertySet   The property set.
     */
    constructor(propertySet) {
        super();
        this.propertySet = null;
        /**
         * Gets or sets the Internet message id of the node.
         */
        this.InternetMessageId = null;
        /**
         * Gets or sets the Internet message id of the parent node.
         */
        this.ParentInternetMessageId = null;
        this.propertySet = propertySet;
    }
    /**
     * Gets the item instance.
     *
     * @param   {ExchangeService}   service          The service.
     * @param   {string}            xmlElementName   Name of the XML element.
     * @return  {Item}              Item.
     */
    GetObjectInstance(service, xmlElementName) {
        return (new ItemInfo_1.ItemInfo()).CreateEwsObjectFromXmlElementName(service, xmlElementName);
    }
    /**
     * @internal Obtains EWS XML element name for this object.
     *
     * @return  {string}      The XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.ConversationNode;
    }
    /**
     * @internal Loads from XMLjsObject.
     *
     * @param   {any}               jsObject   The json property.
     * @param   {ExchangeService}   service        [description]
     */
    LoadFromXmlJsObject(jsObject, service) {
        this.InternetMessageId = jsObject[XmlElementNames_1.XmlElementNames.InternetMessageId];
        if (jsObject[XmlElementNames_1.XmlElementNames.ParentInternetMessageId]) {
            this.ParentInternetMessageId = jsObject[XmlElementNames_1.XmlElementNames.ParentInternetMessageId];
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.Items]) {
            this.Items = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(jsObject, service, XmlElementNames_1.XmlElementNames.Items, this.GetObjectInstance.bind(this), false, /* clearPropertyBag */ this.propertySet, /* requestedPropertySet */ false); /* summaryPropertiesOnly */
        }
    }
}
exports.ConversationNode = ConversationNode;
//# sourceMappingURL=ConversationNode.js.map