"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactPhoneEntity = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents an ContactPhoneEntity object.
 */
class ContactPhoneEntity extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **ContactPhoneEntity** class.
     */
    constructor() {
        super();
        /**
         * Gets the phone entity OriginalPhoneString.
         */
        this.OriginalPhoneString = null;
        /**
         * Gets the phone entity PhoneString.
         */
        this.PhoneString = null;
        /**
         * Gets the phone entity Type.
         */
        this.Type = null;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgOriginalPhoneString:
                    this.OriginalPhoneString = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgPhoneString:
                    this.PhoneString = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgType:
                    this.Type = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.ContactPhoneEntity = ContactPhoneEntity;
//# sourceMappingURL=ContactPhoneEntity.js.map