"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactEntity = void 0;
const ContactPhoneEntityCollection_1 = require("./ContactPhoneEntityCollection");
const StringList_1 = require("./StringList");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtractedEntity_1 = require("./ExtractedEntity");
/**
 * Represents an ContactEntity object.
 */
class ContactEntity extends ExtractedEntity_1.ExtractedEntity {
    /**
     * Initializes a new instance of the **ContactEntity** class.
     */
    constructor() {
        super();
        /**
         * Gets the contact entity PersonName.
         */
        this.PersonName = null;
        /**
         * Gets the contact entity BusinessName.
         */
        this.BusinessName = null;
        /**
         * Gets the contact entity PhoneNumbers.
         */
        this.PhoneNumbers = null;
        /**
         * Gets the contact entity Urls.
         */
        this.Urls = null;
        /**
         * Gets the contact entity EmailAddresses.
         */
        this.EmailAddresses = null;
        /**
         * Gets the contact entity Addresses.
         */
        this.Addresses = null;
        /**
         * Gets the contact entity ContactString.
         */
        this.ContactString = null;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgPersonName:
                    this.PersonName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgBusinessName:
                    this.BusinessName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgPhoneNumbers:
                    this.PhoneNumbers = new ContactPhoneEntityCollection_1.ContactPhoneEntityCollection();
                    this.PhoneNumbers.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.NlgUrls:
                    this.Urls = new StringList_1.StringList(XmlElementNames_1.XmlElementNames.NlgUrl);
                    this.Urls.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.NlgEmailAddresses:
                    this.EmailAddresses = new StringList_1.StringList(XmlElementNames_1.XmlElementNames.NlgEmailAddress);
                    this.EmailAddresses.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.NlgAddresses:
                    this.EmailAddresses = new StringList_1.StringList(XmlElementNames_1.XmlElementNames.NlgEmailAddress);
                    this.Addresses.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.NlgContactString:
                    this.ContactString = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.ContactEntity = ContactEntity;
//# sourceMappingURL=ContactEntity.js.map