"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComplexProperty = void 0;
const EwsLogging_1 = require("../Core/EwsLogging");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
/**
 * Represents a property that can be sent to or retrieved from EWS.
 */
class ComplexProperty {
    constructor() {
        /**@internal */
        this.Namespace = XmlNamespace_1.XmlNamespace.Types;
        //private xmlNamespace: XmlNamespace; ^ no need for pivate property
        this.OnChange = [];
    }
    Changed() {
        if (this.OnChange && this.OnChange.length > 0) {
            this.OnChange.forEach((delegateInstance, index, array) => {
                if (delegateInstance)
                    delegateInstance(this);
            });
        }
    }
    ClearChangeLog() { }
    InternalLoadFromXmlJsObject(jsObject, service, //xmlNamespace: XmlNamespace, xmlElementName: string,
    readAction /*System.Func<T, TResult>*/) {
        //reader.EnsureCurrentNodeIsStartElement(xmlNamespace, xmlElementName);
        //debugger;//check how to implement with jsobject.
        EwsLogging_1.EwsLogging.Assert(false, this.constructor.name + ".LoadFromXmlJsObject", "ComplexProperty - InternalLoadFromXmlJsObject: todo:convert to jsobjectload. object type = " + this.constructor.name);
        throw new Error("ComplexProperty - InternalLoadFromXmlJsObject: todo:convert to jsobjectload. object type = " + this.constructor.name);
        // this.ReadAttributesFromXmlJsObject(jsObject);
        // if (!jsObject.IsEmptyElement) {
        //   do {
        //     jsObject.Read();
        //     switch (jsObject.NodeType) {
        //       case Node.ELEMENT_NODE:
        //         if (!readAction(jsObject)) {
        //           jsObject.SkipCurrentElement();
        //         }
        //         break;
        //       case Node.TEXT_NODE:
        //         this.ReadTextValueFromXmlJsObject(jsObject);
        //         break;
        //     }
        //   }
        //   while (!jsObject.HasRecursiveParent(xmlElementName));
        //   jsObject.SeekLast(); // go back for next process to read.
        //}
    }
    //InternalToJson(service: ExchangeService): any { throw new Error("ComplexProperty.ts - InternalToJson : Not implemented."); }
    InternalValidate() { }
    //LoadFromJson(jsonProperty: JsonObject, service: ExchangeService): any { throw new Error("ComplexProperty.ts - LoadFromJson : Not implemented."); }
    //LoadFromXml(reader: EwsServiceXmlReader, xmlElementName: string): any { throw new Error("ComplexProperty.ts - LoadFromXml : Not implemented."); }
    LoadFromXmlJsObject(jsObject, service) {
        this.InternalLoadFromXmlJsObject(jsObject, service, this.ReadElementsFromXmlJsObject);
        // xmlNamespace || this.Namespace,
        // xmlElementName,
    }
    /**@internal */
    ReadAttributesFromXmlJsObject(reader) { debugger; /*virtual method for derived class to implement if needed*/ }
    /**@internal */
    ReadTextValueFromXmlJsObject(jsObject) { debugger; /*virtual method for derived class to implement if needed*/ }
    SetFieldValue(field, value) {
        var applyChange = false;
        if (field.getValue() == null) {
            applyChange = value != null;
        }
        else {
            var fieldAny = field.getValue();
            if (fieldAny.CompareTo) //todo: fix this if find new ways to check if it implements certain interface - if( field is IComparable)
             {
                applyChange = fieldAny.CompareTo(value) != 0; //todo: until fix the interface check (field as IComparable).CompareTo(value) != 0;
            }
            else {
                applyChange = true;
            }
        }
        if (applyChange) {
            //debugger;//debug; check; check for ref value setting. 
            field.setValue(value);
            this.Changed();
        }
    }
    ReadElementsFromXmlJsObject(jsonProperty, service) { debugger; /* abstract method - should implement*/ }
    ReadElementsFromXmlJsObjectToPatch(jsonProperty, service) { debugger; /* abstract method - should implement*/ }
    //UpdateFromXml(reader: EwsServiceXmlReader, xmlElementName: string): any { throw new Error("ComplexProperty.ts - UpdateFromXml : Not implemented."); }
    UpdateFromXmlJsObject(jsObject, service /*, xmlElementName: string, xmlNamespace?: XmlNamespace*/) {
        this.InternalLoadFromXmlJsObject(jsObject, service, this.ReadElementsFromXmlJsObjectToPatch);
        // xmlNamespace || this.Namespace,
        // xmlElementName,
    }
    /// <summary>
    /// Implements ISelfValidate.Validate. Validates this instance.
    /// </summary>
    Validate() {
        this.InternalValidate();
    }
    /**@internal */
    WriteAttributesToXml(writer) { }
    /**@internal */
    WriteElementsToXml(writer) { }
    /** @internal reverted to simplify child class override - it breaks all derived/child class and throws error "incorrectly extends base class" due to TypeScript design */
    //WriteToXml(writer: EwsServiceXmlWriter, xmlElementName: string): void { throw new Error("ComplexProperty.ts - WriteToXml : Not implemented."); }
    /**@internal */
    WriteToXml(writer, xmlElementName, xmlNamespace) {
        if (!xmlNamespace)
            xmlNamespace = this.Namespace;
        writer.WriteStartElement(xmlNamespace, xmlElementName);
        this.WriteAttributesToXml(writer);
        this.WriteElementsToXml(writer);
        writer.WriteEndElement();
    }
}
exports.ComplexProperty = ComplexProperty;
//# sourceMappingURL=ComplexProperty.js.map