"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompleteName = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents the complete name of a contact.
 */
class CompleteName extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super(...arguments);
        this.title = null;
        this.givenName = null;
        this.middleName = null;
        this.surname = null;
        this.suffix = null;
        this.initials = null;
        this.fullName = null;
        this.nickname = null;
        this.yomiGivenName = null;
        this.yomiSurname = null;
    }
    /**
     * Gets the contact's title.
     */
    get Title() {
        return this.title;
    }
    /**
     * Gets the given name (first name) of the contact.
     */
    get GivenName() {
        return this.givenName;
    }
    /**
     * Gets the middle name of the contact.
     */
    get MiddleName() {
        return this.middleName;
    }
    /**
     * Gets the surname (last name) of the contact.
     */
    get Surname() {
        return this.surname;
    }
    /**
     * Gets the suffix of the contact.
     */
    get Suffix() {
        return this.suffix;
    }
    /**
     * Gets the initials of the contact.
     */
    get Initials() {
        return this.initials;
    }
    /**
     * Gets the full name of the contact.
     */
    get FullName() {
        return this.fullName;
    }
    /**
     * Gets the nickname of the contact.
     */
    get NickName() {
        return this.nickname;
    }
    /**
     * Gets the Yomi given name (first name) of the contact.
     */
    get YomiGivenName() {
        return this.yomiGivenName;
    }
    /**
     * Gets the Yomi surname (last name) of the contact.
     */
    get YomiSurname() {
        return this.yomiSurname;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Title:
                    this.title = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.FirstName:
                    this.givenName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.MiddleName:
                    this.middleName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.LastName:
                    this.surname = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.Suffix:
                    this.suffix = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.Initials:
                    this.initials = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.FullName:
                    this.fullName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NickName:
                    this.nickname = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.YomiFirstName:
                    this.yomiGivenName = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.YomiLastName:
                    this.yomiSurname = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param {EwsServiceXmlWriter} writer  The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Title, this.Title);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.FirstName, this.GivenName);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.MiddleName, this.MiddleName);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.LastName, this.Surname);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Suffix, this.Suffix);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Initials, this.Initials);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.FullName, this.FullName);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.NickName, this.NickName);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.YomiFirstName, this.YomiGivenName);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.YomiLastName, this.YomiSurname);
    }
}
exports.CompleteName = CompleteName;
//# sourceMappingURL=CompleteName.js.map