"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientApp = void 0;
const ClientAppMetadata_1 = require("./ClientAppMetadata");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents a app in GetAppManifests response.
 *
 * @sealed
 */
class ClientApp extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **ClientApp** class.
     */
    constructor() {
        super();
        this.Namespace = XmlNamespace_1.XmlNamespace.Types;
    }
    //ReadToXmlDocument(reader: EwsServiceXmlReader): any { throw new Error("ClientApp.ts - ReadToXmlDocument : Not implemented."); } //not needed.
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        if (jsObject[XmlElementNames_1.XmlElementNames.Manifest]) {
            this.Manifest = jsObject[XmlElementNames_1.XmlElementNames.Manifest];
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.Metadata]) {
            this.Metadata = new ClientAppMetadata_1.ClientAppMetadata();
            this.Metadata.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.Metadata], service);
        }
    }
}
exports.ClientApp = ClientApp;
//# sourceMappingURL=ClientApp.js.map