"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkingPeriod = void 0;
const DayOfTheWeek_1 = require("../../Enumerations/DayOfTheWeek");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const TimeSpan_1 = require("../../TimeSpan");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const ComplexProperty_1 = require("../ComplexProperty");
class WorkingPeriod extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super();
        this.daysOfWeek = [] /*System.Collections.ObjectModel.Collection<DayOfTheWeek>*/;
        this.startTime = null /*System.TimeSpan*/;
        this.endTime = null /*System.TimeSpan*/;
    }
    get DaysOfWeek() { return this.daysOfWeek; } /*System.Collections.ObjectModel.Collection<DayOfTheWeek>*/
    get StartTime() { return this.startTime; } /*System.TimeSpan*/
    get EndTime() { return this.endTime; } /*System.TimeSpan*/
    LoadFromJson(jsonProperty, service) { throw new Error("WorkingPeriod.ts - LoadFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(reader) { throw new Error("WorkingPeriod.ts - TryReadElementFromXmlJsObject : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.DayOfWeek:
                    EwsUtilities_1.EwsUtilities.ParseEnumValueList(this.daysOfWeek, jsonProperty[key], ' ', DayOfTheWeek_1.DayOfTheWeek);
                    break;
                case XmlElementNames_1.XmlElementNames.StartTimeInMinutes:
                    this.startTime = TimeSpan_1.TimeSpan.FromMinutes(Number(jsonProperty[key]));
                    break;
                case XmlElementNames_1.XmlElementNames.EndTimeInMinutes:
                    this.endTime = TimeSpan_1.TimeSpan.FromMinutes(Number(jsonProperty[key]));
                    break;
                default:
                    break;
            }
        }
    }
}
exports.WorkingPeriod = WorkingPeriod;
//# sourceMappingURL=WorkingPeriod.js.map