"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkingHours = void 0;
const LegacyAvailabilityTimeZone_1 = require("../../Misc/Availability/LegacyAvailabilityTimeZone");
const WorkingPeriod_1 = require("./WorkingPeriod");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const ComplexProperty_1 = require("../ComplexProperty");
class WorkingHours extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super(...arguments);
        this.LegacyTimeZone = new LegacyAvailabilityTimeZone_1.LegacyAvailabilityTimeZone();
        this.daysOfTheWeek = [] /*System.Collections.ObjectModel.Collection<DayOfTheWeek>*/;
        //ReadElementsFromXmlJsObject(reader: any): boolean { throw new Error("WorkingHours.ts - TryReadElementFromXmlJsObject : Not implemented."); }
    }
    get TimeZone() {
        return this.timeZone;
    }
    get DaysOfTheWeek() { return this.daysOfTheWeek; } /*System.Collections.ObjectModel.Collection<DayOfTheWeek>*/
    get StartTime() { return this.startTime; } /*System.TimeSpan*/
    get EndTime() { return this.endTime; } /*System.TimeSpan*/
    LoadFromJson(jsonProperty, service) { throw new Error("WorkingHours.ts - LoadFromJson : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.TimeZone:
                    var legacyTimeZone = new LegacyAvailabilityTimeZone_1.LegacyAvailabilityTimeZone();
                    legacyTimeZone.LoadFromXmlJsObject(jsonProperty[key], service);
                    this.LegacyTimeZone = legacyTimeZone;
                    //this.timeZone = legacyTimeZone.ToTimeZoneInfo();
                    break;
                case XmlElementNames_1.XmlElementNames.WorkingPeriodArray:
                    var workingPeriods = []; // new List<WorkingPeriod>();
                    var workingPeriodsArrayObject = jsonProperty[key];
                    var workingPeriodsArray = workingPeriodsArrayObject[XmlElementNames_1.XmlElementNames.WorkingPeriod];
                    if (!Array.isArray(workingPeriodsArray)) {
                        workingPeriodsArray = [workingPeriodsArray];
                    }
                    for (var workingPeriodEntry of workingPeriodsArray) {
                        var workingPeriod = new WorkingPeriod_1.WorkingPeriod();
                        workingPeriod.LoadFromXmlJsObject(workingPeriodEntry, service);
                        workingPeriods.push(workingPeriod);
                    }
                    // Availability supports a structure that can technically represent different working
                    // times for each day of the week. This is apparently how the information is stored in
                    // Exchange. However, no client (Outlook, OWA) either will let you specify different
                    // working times for each day of the week, and Outlook won't either honor that complex
                    // structure if it happens to be in Exchange.
                    // So here we'll do what Outlook and OWA do: we'll use the start and end times of the
                    // first working period, but we'll use the week days of all the periods.
                    this.startTime = workingPeriods[0].StartTime;
                    this.endTime = workingPeriods[0].EndTime;
                    for (var workingPeriod of workingPeriods) {
                        for (var dayOfWeek of workingPeriods[0].DaysOfWeek) {
                            if (this.daysOfTheWeek.indexOf(dayOfWeek) < 0) {
                                this.daysOfTheWeek.push(dayOfWeek);
                            }
                        }
                    }
                    break;
                default:
                    break;
            }
        }
    }
}
exports.WorkingHours = WorkingHours;
//# sourceMappingURL=WorkingHours.js.map