"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Suggestion = void 0;
const SuggestionQuality_1 = require("../../Enumerations/SuggestionQuality");
const TimeSuggestion_1 = require("./TimeSuggestion");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const DateTime_1 = require("../../DateTime");
const EwsServiceJsonReader_1 = require("../../Core/EwsServiceJsonReader");
const ComplexProperty_1 = require("../ComplexProperty");
const EwsLogging_1 = require("../../Core/EwsLogging");
class Suggestion extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super();
        this.date = null;
        this.quality = SuggestionQuality_1.SuggestionQuality.Excellent;
        this.timeSuggestions = []; /*System.Collections.ObjectModel.Collection<TimeSuggestion>;*/
    }
    get Date() {
        return this.date;
    }
    get Quality() {
        return this.quality;
    }
    get TimeSuggestions() {
        return this.timeSuggestions;
    }
    //LoadFromJson(jsonProperty: any, service: ExchangeService): any { throw new Error("Suggestion.ts - LoadFromJson : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        this.date = DateTime_1.DateTime.Parse(jsonProperty[XmlElementNames_1.XmlElementNames.Date]);
        EwsLogging_1.EwsLogging.Log("bug: Suggestion->LoadFromXml:    need to change to millisecond and with datetimekind", true);
        //debugger;
        this.quality = SuggestionQuality_1.SuggestionQuality[jsonProperty[XmlElementNames_1.XmlElementNames.DayQuality]];
        var suggestionArrayObj = jsonProperty[XmlElementNames_1.XmlElementNames.SuggestionArray];
        var suggestions = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(suggestionArrayObj, XmlElementNames_1.XmlElementNames.Suggestion);
        for (var suggestion of suggestions) {
            var timeSuggestion = new TimeSuggestion_1.TimeSuggestion();
            timeSuggestion.LoadFromXmlJsObject(suggestion, service);
            this.timeSuggestions.push(timeSuggestion);
        }
    }
}
exports.Suggestion = Suggestion;
//# sourceMappingURL=Suggestion.js.map