"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarEventDetails = void 0;
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const ComplexProperty_1 = require("../ComplexProperty");
class CalendarEventDetails extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super(...arguments);
        this.storeId = null;
        this.subject = null;
        this.location = null;
        this.isMeeting = false;
        this.isRecurring = false;
        this.isException = false;
        this.isReminderSet = false;
        this.isPrivate = false;
    }
    get StoreId() {
        return this.storeId;
    }
    get Subject() {
        return this.subject;
    }
    get Location() {
        return this.location;
    }
    get IsMeeting() {
        return this.isMeeting;
    }
    get IsRecurring() {
        return this.isRecurring;
    }
    get IsException() {
        return this.isException;
    }
    get IsReminderSet() {
        return this.isReminderSet;
    }
    get IsPrivate() {
        return this.isPrivate;
    }
    LoadFromJson(jsonProperty, service) { throw new Error("CalendarEventDetails.ts - LoadFromJson : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.ID:
                    this.storeId = jsonProperty[key];
                    break;
                case XmlElementNames_1.XmlElementNames.Subject:
                    this.subject = jsonProperty[key];
                    break;
                case XmlElementNames_1.XmlElementNames.Location:
                    this.location = jsonProperty[key];
                    break;
                case XmlElementNames_1.XmlElementNames.IsMeeting:
                    this.isMeeting = ExtensionMethods_1.Convert.toBool(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsRecurring:
                    this.isRecurring = ExtensionMethods_1.Convert.toBool(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsException:
                    this.isException = ExtensionMethods_1.Convert.toBool(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsReminderSet:
                    this.isReminderSet = ExtensionMethods_1.Convert.toBool(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.IsPrivate:
                    this.isPrivate = ExtensionMethods_1.Convert.toBool(jsonProperty[key]);
                    break;
                default:
                    break;
            }
        }
    }
}
exports.CalendarEventDetails = CalendarEventDetails;
//# sourceMappingURL=CalendarEventDetails.js.map