"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebClientUrlCollection = void 0;
const WebClientUrl_1 = require("./WebClientUrl");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents a user setting that is a collection of Exchange web client URLs.
 * @sealed
 */
class WebClientUrlCollection {
    /**
     * @internal Initializes a new instance of the **WebClientUrlCollection** class.
     */
    constructor() {
        this.urls = null;
        this.urls = [];
    }
    /**
     * Gets the URLs.
     */
    get Urls() {
        return this.urls;
    }
    /**
     * @internal Loads instance of WebClientUrlCollection.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     * @returns {WebClientUrlCollection}
     */
    static LoadFromXmlJsObject(jsObject) {
        const instance = new WebClientUrlCollection();
        const element = XmlElementNames_1.XmlElementNames.WebClientUrl;
        let responses = undefined;
        if (Array.isArray(jsObject[element]))
            responses = jsObject[element];
        else
            responses = [jsObject[element]];
        for (let i = 0; i < responses.length; i++) {
            instance.Urls.push(WebClientUrl_1.WebClientUrl.LoadFromXmlJsObject(responses[i]));
        }
        return instance;
    }
}
exports.WebClientUrlCollection = WebClientUrlCollection;
//# sourceMappingURL=WebClientUrlCollection.js.map