"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebClientUrl = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents the URL of the Exchange web client.
 * @sealed
 */
class WebClientUrl {
    constructor(authenticationMethods = null, url = null) {
        this.authenticationMethods = authenticationMethods;
        this.url = url;
    }
    /**
     * Gets the authentication methods.
     */
    get AuthenticationMethods() {
        return this.authenticationMethods;
    }
    /** @internal set */
    set AuthenticationMethods(value) {
        this.authenticationMethods = value;
    }
    /**
     * Gets the URL.
     */
    get Url() {
        return this.url;
    }
    /** @internal set */
    set Url(value) {
        this.url = value;
    }
    /**
     * @internal Loads WebClientUrl instance
     *
     * @param   {any} jsObject  Json Object converted from XML.
     * @returns {WebClientUrl}  WebClientUrl.
     */
    static LoadFromXmlJsObject(jsObject) {
        const webClientUrl = new WebClientUrl();
        webClientUrl.AuthenticationMethods = jsObject[XmlElementNames_1.XmlElementNames.AuthenticationMethods];
        webClientUrl.Url = jsObject[XmlElementNames_1.XmlElementNames.Url];
        return webClientUrl;
    }
}
exports.WebClientUrl = WebClientUrl;
//# sourceMappingURL=WebClientUrl.js.map