"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUserSettingsRequest = void 0;
const AutodiscoverErrorCode_1 = require("../../Enumerations/AutodiscoverErrorCode");
const EwsLogging_1 = require("../../Core/EwsLogging");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const GetUserSettingsResponseCollection_1 = require("../Responses/GetUserSettingsResponseCollection");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const Strings_1 = require("../../Strings");
const UserSettingName_1 = require("../../Enumerations/UserSettingName");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const AutodiscoverRequest_1 = require("./AutodiscoverRequest");
/**
 * @internal Represents a GetUserSettings request.
 */
class GetUserSettingsRequest extends AutodiscoverRequest_1.AutodiscoverRequest {
    constructor(service, url, expectPartnerToken = false) {
        super(service, url);
        this.expectPartnerToken = false;
        this.expectPartnerToken = expectPartnerToken;
        // make an explicit https check.
        if (expectPartnerToken && !(url.Scheme.toLowerCase() === "https")) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.HttpsIsRequired);
        }
    }
    /** @internal Gets or sets the SMTP addresses. */
    get SmtpAddresses() {
        return this.smtpAddresses;
    }
    set SmtpAddresses(value) {
        this.smtpAddresses = value;
    }
    /** @internal Gets or sets the settings. */
    get Settings() {
        return this.settings;
    }
    set Settings(value) {
        this.settings = value;
    }
    /**
     * @internal Gets the partner token.
     */
    get PartnerToken() {
        return this.partnerToken;
    }
    /** @private set */
    set PartnerToken(value) {
        this.partnerToken = value;
    }
    /**
     * @internal Gets the partner token reference.
     */
    get PartnerTokenReference() {
        return this.partnerTokenReference;
    }
    /** @private set */
    set PartnerTokenReference(value) {
        this.partnerTokenReference = value;
    }
    /**
     * @internal Creates the service response.
     *
     * @return  {AutodiscoverResponse}      AutodiscoverResponse
     */
    CreateServiceResponse() {
        return new GetUserSettingsResponseCollection_1.GetUserSettingsResponseCollection();
    }
    /**
     * @internal Executes this instance.
     *
     * @return  {Promise<GetUserSettingsResponseCollection>}      [description]
     */
    Execute() {
        return __awaiter(this, void 0, void 0, function* () {
            const responses = yield this.InternalExecute();
            if (responses.ErrorCode == AutodiscoverErrorCode_1.AutodiscoverErrorCode.NoError) {
                this.PostProcessResponses(responses);
            }
            return responses;
        });
    }
    /**
     * Gets the name of the request XML element.
     *
     * @return  {string}      [description]
     */
    GetRequestXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetUserSettingsRequestMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      [description]
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetUserSettingsResponseMessage;
    }
    /**
     * @internal Gets the WS-Addressing action name.
     *
     * @return  {string}      [description]
     */
    GetWsAddressingActionName() {
        return GetUserSettingsRequest.GetUserSettingsActionUri; // GetUserSettingsActionUri;
    }
    /**
     * Post-process responses to GetUserSettings.
     *
     * @param   {GetUserSettingsResponseCollection}   responses   The GetUserSettings responses.
     */
    PostProcessResponses(responses) {
        // Note:The response collection may not include all of the requested users if the request has been throttled.
        for (let index = 0; index < responses.Count; index++) {
            responses.Responses[index].SmtpAddress = this.SmtpAddresses[index];
        }
    }
    /**
     * @internal Read SOAP headers.
     *
     * @param   {object}   reader   EwsXmlReader
     */
    ReadSoapHeader(jsobject) {
        super.ReadSoapHeader(jsobject);
        return;
        if (this.expectPartnerToken) {
            EwsLogging_1.EwsLogging.Assert(false, "GetUserSettingsRequest.ReadSoapHeader", "Partner tokens not implemented");
            // if (reader.IsElement(XmlNamespace.Autodiscover, XmlElementNames.PartnerToken)) {
            //   this.PartnerToken = reader.ReadInnerXml();
            // }
            // if (reader.IsElement(XmlNamespace.Autodiscover, XmlElementNames.PartnerTokenReference)) {
            //   this.PartnerTokenReference = reader.ReadInnerXml();
            // }
        }
    }
    /**
     * @internal Validates the request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.SmtpAddresses, "smtpAddresses");
        EwsUtilities_1.EwsUtilities.ValidateParam(this.Settings, "settings");
        if (this.Settings.length == 0) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.InvalidAutodiscoverSettingsCount);
        }
        if (this.SmtpAddresses.length == 0) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.InvalidAutodiscoverSmtpAddressesCount);
        }
        for (let smtpAddress of this.SmtpAddresses) {
            if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(smtpAddress)) {
                throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.InvalidAutodiscoverSmtpAddress);
            }
        }
    }
    /**
     * @internal Writes attributes to request XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue("xmlns", EwsUtilities_1.EwsUtilities.AutodiscoverSoapNamespacePrefix, EwsUtilities_1.EwsUtilities.AutodiscoverSoapNamespace);
    }
    /**
     * @internal Writes elements to request XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.Request);
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.Users);
        for (var smtpAddress of this.SmtpAddresses) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.User);
            if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(smtpAddress)) {
                writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.Mailbox, smtpAddress);
            }
            writer.WriteEndElement(); // User
        }
        writer.WriteEndElement(); // Users
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.RequestedSettings);
        for (var setting of this.Settings) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.Setting, UserSettingName_1.UserSettingName[setting]);
        }
        writer.WriteEndElement(); // RequestedSettings
        writer.WriteEndElement(); // Request
    }
    /**
     * @internal Write extra headers.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer
     */
    WriteExtraCustomSoapHeadersToXml(writer) {
        if (this.expectPartnerToken) {
            EwsLogging_1.EwsLogging.Assert(false, "GetUserSettingsRequest.WriteExtraCustomSoapHeadersToXml", "Partner tokens not implemented");
            debugger;
            // writer.WriteElementValue(
            //    XmlNamespace.Autodiscover,
            //    XmlElementNames.BinarySecret,
            //    btoa(ExchangeServiceBase.SessionKey));
            //    //System.Convert.ToBase64String(ExchangeServiceBase.SessionKey));
        }
    }
}
exports.GetUserSettingsRequest = GetUserSettingsRequest;
/**
 * Action Uri of Autodiscover.GetUserSettings method.
 */
GetUserSettingsRequest.GetUserSettingsActionUri = `${EwsUtilities_1.EwsUtilities.AutodiscoverSoapNamespace}/Autodiscover/GetUserSettings`;
//# sourceMappingURL=GetUserSettingsRequest.js.map