"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetDomainSettingsRequest = void 0;
const AutodiscoverErrorCode_1 = require("../../Enumerations/AutodiscoverErrorCode");
const DomainSettingName_1 = require("../../Enumerations/DomainSettingName");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetDomainSettingsResponseCollection_1 = require("../Responses/GetDomainSettingsResponseCollection");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const Strings_1 = require("../../Strings");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const AutodiscoverRequest_1 = require("./AutodiscoverRequest");
/**
 * @internal Represents a GetDomainSettings request.
 */
class GetDomainSettingsRequest extends AutodiscoverRequest_1.AutodiscoverRequest {
    /**
     * @internal Initializes a new instance of the **GetDomainSettingsRequest** class.
     *
     * @param   {AutodiscoverService}   service   Autodiscover service associated with this request.
     * @param   {Uri}                   url       URL of Autodiscover service.
     */
    constructor(service, url) {
        super(service, url);
    }
    /**
     * @internal Gets or sets the domains.
     */
    get Domains() {
        return this.domains;
    }
    set Domains(value) {
        this.domains = value;
    }
    /**
     * @internal Gets or sets the settings.
     */
    get Settings() {
        return this.settings;
    }
    set Settings(value) {
        this.settings = value;
    }
    /**
     * @internal Gets or sets the RequestedVersion.
     */
    get RequestedVersion() {
        return this.requestedVersion;
    }
    set RequestedVersion(value) {
        this.requestedVersion = value;
    }
    /**
     * @internal Creates the service response.
     *
     * @return  {AutodiscoverResponse}      AutodiscoverResponse
     */
    CreateServiceResponse() {
        return new GetDomainSettingsResponseCollection_1.GetDomainSettingsResponseCollection();
    }
    /**
     * @internal Executes this instance.
     *
     * @return  {Promise<GetDomainSettingsResponseCollection>}      [description]
     */
    Execute() {
        return __awaiter(this, void 0, void 0, function* () {
            const responses = yield this.InternalExecute();
            if (responses.ErrorCode == AutodiscoverErrorCode_1.AutodiscoverErrorCode.NoError) {
                this.PostProcessResponses(responses);
            }
            return responses;
        });
    }
    /**
     * Gets the name of the request XML element.
     *
     * @return  {string}      [description]
     */
    GetRequestXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetDomainSettingsRequestMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      [description]
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetDomainSettingsResponseMessage;
    }
    /**
     * @internal Gets the WS-Addressing action name.
     *
     * @return  {string}      [description]
     */
    GetWsAddressingActionName() {
        return GetDomainSettingsRequest.GetDomainSettingsActionUri;
    }
    /**
     * Post-process responses to GetDomainSettings.
     *
     * @param   {GetDomainSettingsResponseCollection}   responses   The GetDomainSettings responses.
     */
    PostProcessResponses(responses) {
        // Note:The response collection may not include all of the requested domains if the request has been throttled.
        for (var index = 0; index < responses.Count; index++) {
            responses.Responses[index].Domain = this.Domains[index];
        }
    }
    /**
     * @internal Validates the request.
     */
    Validate() {
        super.Validate();
        if (this.settings.length == 0) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.InvalidAutodiscoverSettingsCount);
        }
        if (this.domains.length == 0) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.InvalidAutodiscoverDomainsCount);
        }
        for (let domain of this.domains) {
            if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(domain)) {
                throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.InvalidAutodiscoverDomain);
            }
        }
    }
    /**
     * @internal Writes attributes to request XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue("xmlns", EwsUtilities_1.EwsUtilities.AutodiscoverSoapNamespacePrefix, EwsUtilities_1.EwsUtilities.AutodiscoverSoapNamespace);
    }
    /**
     * @internal Writes elements to request XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.Request);
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.Domains);
        for (var domain of this.Domains) {
            if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(domain)) {
                writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.Domain, domain);
            }
        }
        writer.WriteEndElement(); //Domains
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.RequestedSettings);
        for (var setting of this.Settings) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.Setting, DomainSettingName_1.DomainSettingName[setting]);
        }
        writer.WriteEndElement(); //RequestedSettings
        if ((0, ExtensionMethods_1.hasValue)(this.requestedVersion)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Autodiscover, XmlElementNames_1.XmlElementNames.RequestedVersion, ExchangeVersion_1.ExchangeVersion[this.Service.RequestedServerVersion]);
        }
        writer.WriteEndElement(); //Request
    }
}
exports.GetDomainSettingsRequest = GetDomainSettingsRequest;
/**
 * Action Uri of Autodiscover.GetDomainSettings method.
 */
GetDomainSettingsRequest.GetDomainSettingsActionUri = `${EwsUtilities_1.EwsUtilities.AutodiscoverSoapNamespace}/Autodiscover/GetDomainSettings`;
//# sourceMappingURL=GetDomainSettingsRequest.js.map