"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtocolConnection = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents the email Protocol connection settings for pop/imap/smtp protocols.
 * @sealed
 */
class ProtocolConnection {
    constructor(encryptionMethod = null, hostname = null, port = 0) {
        this.encryptionMethod = encryptionMethod;
        this.hostname = hostname;
        this.port = port;
    }
    /**
     * Gets or sets the encryption method.
     */
    get EncryptionMethod() {
        return this.encryptionMethod;
    }
    set EncryptionMethod(value) {
        this.encryptionMethod = value;
    }
    /**
     * Gets or sets the Hostname.
     */
    get Hostname() {
        return this.hostname;
    }
    set Hostname(value) {
        this.hostname = value;
    }
    /**
     * Gets or sets the port number.
     */
    get Port() {
        return this.port;
    }
    set Port(value) {
        this.port = value;
    }
    /**
     * @internal Read user setting with ProtocolConnectionCollection value.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     */
    static LoadFromXmlJsObject(jsObject) {
        const connection = new ProtocolConnection();
        connection.encryptionMethod = jsObject[XmlElementNames_1.XmlElementNames.EncryptionMethod] || null;
        connection.hostname = jsObject[XmlElementNames_1.XmlElementNames.Hostname] || null;
        connection.port = parseInt(jsObject[XmlElementNames_1.XmlElementNames.Port]) || 0;
        return connection;
    }
}
exports.ProtocolConnection = ProtocolConnection;
//# sourceMappingURL=ProtocolConnection.js.map