"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentSharingLocationCollection = void 0;
const DocumentSharingLocation_1 = require("./DocumentSharingLocation");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents a user setting that is a collection of alternate mailboxes.
 * @sealed
 */
class DocumentSharingLocationCollection {
    /**
    * @internal Initializes a new instance of the **DocumentSharingLocationCollection** class.
    */
    constructor() {
        this.entries = [];
    }
    /**
     * Gets the collection of alternate mailboxes.
     */
    get Entries() {
        return this.entries;
    }
    /**
     * @internal Loads instance of DocumentSharingLocationCollection.
     *
     * @param   {any} jsObject  Json Object converted from XML.
     * @returns {DocumentSharingLocationCollection}
     */
    static LoadFromXmlJsObject(jsObject) {
        const instance = new DocumentSharingLocationCollection();
        const element = XmlElementNames_1.XmlElementNames.DocumentSharingLocation;
        let responses = undefined;
        if (Array.isArray(jsObject[element]))
            responses = jsObject[element];
        else
            responses = [jsObject[element]];
        for (let i = 0; i < responses.length; i++) {
            instance.Entries.push(DocumentSharingLocation_1.DocumentSharingLocation.LoadFromXmlJsObject(responses[i]));
        }
        return instance;
    }
}
exports.DocumentSharingLocationCollection = DocumentSharingLocationCollection;
//# sourceMappingURL=DocumentSharingLocationCollection.js.map