"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComparisonHelpers = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
/**
 * @internal Represents a set of helper methods for performing string comparisons.
 * @static
 */
class ComparisonHelpers {
    /**
     * Case insensitive check if the collection contains the string.
     *
     * @param   {any[]}   collection   The collection of objects, only strings are checked
     * @param   {string}  match        String to match
     * @return  {boolean}                true, if match contained in the collection
     */
    CaseInsensitiveContains(collection, match) {
        for (let obj of collection) {
            const str = obj;
            if (str != null) {
                if (ExtensionMethods_1.StringHelper.Compare(str, match, true) == 0) {
                    return true;
                }
            }
        }
    }
}
exports.ComparisonHelpers = ComparisonHelpers;
//# sourceMappingURL=ComparisonHelpers.js.map