"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutodiscoverError = void 0;
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents an error returned by the Autodiscover service.
 * @sealed
 */
class AutodiscoverError {
    /**
     * Initializes a new instance of the **AutodiscoverError** class.
     */
    constructor() {
    }
    /**
     * Gets the time when the error was returned.
     */
    get Time() {
        return this.time;
    }
    /**
     * Gets a hash of the name of the computer that is running Microsoft Exchange Server that has the Client Access server role installed.
     */
    get Id() {
        return this.id;
    }
    /**
     * Gets the error code.
     */
    get ErrorCode() {
        return this.errorCode;
    }
    /**
     * Gets the error message.
     */
    get Message() {
        return this.message;
    }
    /**
     * Gets the debug data.
     */
    get DebugData() {
        return this.debugData;
    }
    /**
     * Parses the XML Js Object creates an Autodiscover error.
     *
     * @param   {any}   jsObject   The object.
     * @return  {AutodiscoverError}            An Autodiscover error.
     */
    Parse(jsObject) {
        const error = new AutodiscoverError();
        error.time = jsObject[XmlAttributeNames_1.XmlAttributeNames.Time] || null;
        error.id = jsObject[XmlAttributeNames_1.XmlAttributeNames.Id] || null;
        error.errorCode = parseInt(jsObject[XmlElementNames_1.XmlElementNames.ErrorCode]) || 0;
        error.message = jsObject[XmlElementNames_1.XmlElementNames.Message] || null;
        error.debugData = jsObject[XmlElementNames_1.XmlElementNames.DebugData] || null;
        return error;
    }
}
exports.AutodiscoverError = AutodiscoverError;
//# sourceMappingURL=AutodiscoverError.js.map