var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { attachRules, createClassName, css, escapeName, transpile, } from '@rocket.chat/css-in-js';
import { createElement, forwardRef, Fragment, useDebugValue, useLayoutEffect, } from 'react';
export var attachClassName = function (props, additionalClassName) { return (__assign(__assign({}, props), { className: props.className
        ? "".concat(props.className, " ").concat(additionalClassName)
        : additionalClassName })); };
var styled = function (type, filter) {
    return function (slices) {
        var _a, _b;
        var values = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            values[_i - 1] = arguments[_i];
        }
        var cssFn = css.apply(void 0, __spreadArray([slices], values, false));
        var fn = typeof window === 'undefined'
            ? (_a = {},
                _a[type] = function (props, ref) {
                    var content = cssFn(props);
                    var computedClassName = createClassName(content);
                    var escapedClassName = escapeName(computedClassName);
                    var transpiledContent = transpile(".".concat(escapedClassName), content);
                    var newProps = attachClassName(__assign({ ref: ref }, props), computedClassName);
                    return createElement(Fragment, {}, createElement('style', {}, transpiledContent), createElement(type, filter ? filter(newProps) : newProps));
                },
                _a) : (_b = {},
            _b[type] = function (props, ref) {
                var content = cssFn(props);
                var computedClassName = createClassName(content);
                useDebugValue(computedClassName);
                useLayoutEffect(function () {
                    var escapedClassName = escapeName(computedClassName);
                    var transpiledContent = transpile(".".concat(escapedClassName), content);
                    var detach = attachRules(transpiledContent);
                    return function () {
                        setTimeout(detach, 1000);
                    };
                }, [computedClassName, content]);
                var newProps = attachClassName(__assign({ ref: ref }, props), computedClassName);
                return createElement(type, filter ? filter(newProps) : newProps);
            },
            _b);
        var component = forwardRef(fn[type]);
        component.displayName = "StyledComponent(".concat(type, ")");
        return component;
    };
};
export default styled;
//# sourceMappingURL=styled.js.map