import {useState as $bBNwq$useState, useRef as $bBNwq$useRef, useCallback as $bBNwq$useCallback} from "react";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 
function $b45bbbaf0c3785df$export$29efd034f1d79f81(props) {
    let { getItems: getItems , collection: collection , selectionManager: selectionManager , onDragStart: onDragStart , onDragMove: onDragMove , onDragEnd: onDragEnd , preview: preview , getAllowedDropOperations: getAllowedDropOperations  } = props;
    let [, setDragging] = (0, $bBNwq$useState)(false);
    let draggingKeys = (0, $bBNwq$useRef)(new Set());
    let draggedKey = (0, $bBNwq$useRef)(null);
    let getKeys = (key)=>{
        // The clicked item is always added to the drag. If it is selected, then all of the
        // other selected items are also dragged. If it is not selected, the only the clicked
        // item is dragged. This matches native macOS behavior.
        let keys = new Set(selectionManager.isSelected(key) ? new Set([
            ...selectionManager.selectedKeys
        ].filter((key)=>!!collection.getItem(key))) : []);
        keys.add(key);
        return keys;
    };
    return {
        collection: collection,
        selectionManager: selectionManager,
        get draggedKey () {
            return draggedKey.current;
        },
        get draggingKeys () {
            return draggingKeys.current;
        },
        isDragging (key) {
            return draggingKeys.current.has(key);
        },
        getKeysForDrag: getKeys,
        getItems (key) {
            return getItems(getKeys(key));
        },
        preview: preview,
        getAllowedDropOperations: getAllowedDropOperations,
        startDrag (key, event) {
            let keys = getKeys(key);
            draggingKeys.current = keys;
            draggedKey.current = key;
            selectionManager.setFocused(false);
            setDragging(true);
            if (typeof onDragStart === "function") onDragStart({
                ...event,
                keys: keys
            });
        },
        moveDrag (event) {
            if (typeof onDragMove === "function") onDragMove({
                ...event,
                keys: draggingKeys.current
            });
        },
        endDrag (event) {
            let { isInternal: isInternal  } = event;
            if (typeof onDragEnd === "function") onDragEnd({
                ...event,
                keys: draggingKeys.current,
                isInternal: isInternal
            });
            draggingKeys.current = new Set();
            draggedKey.current = null;
            setDragging(false);
        }
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 
function $e672e8bc247525d1$export$926850f6ecef79d0(props) {
    let { acceptedDragTypes: acceptedDragTypes = "all" , onInsert: onInsert , onRootDrop: onRootDrop , onItemDrop: onItemDrop , onReorder: onReorder , shouldAcceptItemDrop: shouldAcceptItemDrop , collection: collection , selectionManager: selectionManager , onDropEnter: onDropEnter , getDropOperation: getDropOperation , onDrop: onDrop  } = props;
    let [target, setTarget] = (0, $bBNwq$useState)(null);
    let targetRef = (0, $bBNwq$useRef)(null);
    let getOppositeTarget = (target)=>{
        if (target.dropPosition === "before") {
            let key = collection.getKeyBefore(target.key);
            return key != null ? {
                type: "item",
                key: key,
                dropPosition: "after"
            } : null;
        } else if (target.dropPosition === "after") {
            let key = collection.getKeyAfter(target.key);
            return key != null ? {
                type: "item",
                key: key,
                dropPosition: "before"
            } : null;
        }
    };
    let defaultGetDropOperation = (0, $bBNwq$useCallback)((e)=>{
        let { target: target , types: types , allowedOperations: allowedOperations , isInternal: isInternal , draggingKeys: draggingKeys  } = e;
        if (acceptedDragTypes === "all" || acceptedDragTypes.some((type)=>types.has(type))) {
            let isValidInsert = onInsert && target.type === "item" && !isInternal && (target.dropPosition === "before" || target.dropPosition === "after");
            let isValidReorder = onReorder && target.type === "item" && isInternal && (target.dropPosition === "before" || target.dropPosition === "after");
            // Feedback was that internal root drop was weird so preventing that from happening
            let isValidRootDrop = onRootDrop && target.type === "root" && !isInternal;
            // Automatically prevent items (i.e. folders) from being dropped on themselves.
            let isValidOnItemDrop = onItemDrop && target.type === "item" && target.dropPosition === "on" && !(isInternal && draggingKeys.has(target.key)) && (!shouldAcceptItemDrop || shouldAcceptItemDrop(target, types));
            if (onDrop || isValidInsert || isValidReorder || isValidRootDrop || isValidOnItemDrop) {
                if (getDropOperation) return getDropOperation(target, types, allowedOperations);
                else return allowedOperations[0];
            }
        }
        return "cancel";
    }, [
        acceptedDragTypes,
        getDropOperation,
        onInsert,
        onRootDrop,
        onItemDrop,
        shouldAcceptItemDrop,
        onReorder,
        onDrop
    ]);
    return {
        collection: collection,
        selectionManager: selectionManager,
        target: target,
        setTarget (newTarget) {
            if (this.isDropTarget(newTarget)) return;
            let target = targetRef.current;
            if (target && typeof props.onDropExit === "function") props.onDropExit({
                type: "dropexit",
                x: 0,
                y: 0,
                target: target
            });
            if (newTarget && typeof onDropEnter === "function") onDropEnter({
                type: "dropenter",
                x: 0,
                y: 0,
                target: newTarget
            });
            targetRef.current = newTarget;
            setTarget(newTarget);
        },
        isDropTarget (dropTarget) {
            let target = targetRef.current;
            if ($e672e8bc247525d1$var$isEqualDropTarget(dropTarget, target)) return true;
            // Check if the targets point at the same point between two items, one referring before, and the other after.
            if ((dropTarget === null || dropTarget === void 0 ? void 0 : dropTarget.type) === "item" && (target === null || target === void 0 ? void 0 : target.type) === "item" && dropTarget.key !== target.key && dropTarget.dropPosition !== target.dropPosition && dropTarget.dropPosition !== "on" && target.dropPosition !== "on") return $e672e8bc247525d1$var$isEqualDropTarget(getOppositeTarget(dropTarget), target) || $e672e8bc247525d1$var$isEqualDropTarget(dropTarget, getOppositeTarget(target));
            return false;
        },
        getDropOperation (e) {
            return defaultGetDropOperation(e);
        }
    };
}
function $e672e8bc247525d1$var$isEqualDropTarget(a, b) {
    if (!a) return !b;
    switch(a.type){
        case "root":
            return (b === null || b === void 0 ? void 0 : b.type) === "root";
        case "item":
            return (b === null || b === void 0 ? void 0 : b.type) === "item" && (b === null || b === void 0 ? void 0 : b.key) === a.key && (b === null || b === void 0 ? void 0 : b.dropPosition) === a.dropPosition;
    }
}




export {$b45bbbaf0c3785df$export$29efd034f1d79f81 as useDraggableCollectionState, $e672e8bc247525d1$export$926850f6ecef79d0 as useDroppableCollectionState};
//# sourceMappingURL=module.js.map
