import {createFocusManager as $cIPI0$createFocusManager, getFocusableTreeWalker as $cIPI0$getFocusableTreeWalker} from "@react-aria/focus";
import {useId as $cIPI0$useId, useDescription as $cIPI0$useDescription, filterDOMProps as $cIPI0$filterDOMProps, mergeProps as $cIPI0$mergeProps, isMac as $cIPI0$isMac, scrollIntoViewport as $cIPI0$scrollIntoViewport, getScrollParent as $cIPI0$getScrollParent, useEvent as $cIPI0$useEvent, useLayoutEffect as $cIPI0$useLayoutEffect, isIOS as $cIPI0$isIOS, useLabels as $cIPI0$useLabels} from "@react-aria/utils";
import $cIPI0$react, {useMemo as $cIPI0$useMemo, useRef as $cIPI0$useRef, useEffect as $cIPI0$useEffect} from "react";
import {useField as $cIPI0$useField} from "@react-aria/label";
import {useFocusWithin as $cIPI0$useFocusWithin, usePress as $cIPI0$usePress} from "@react-aria/interactions";
import {useLocalizedStringFormatter as $cIPI0$useLocalizedStringFormatter, useLocale as $cIPI0$useLocale, useDateFormatter as $cIPI0$useDateFormatter, useFilter as $cIPI0$useFilter} from "@react-aria/i18n";
import {toCalendar as $cIPI0$toCalendar, CalendarDate as $cIPI0$CalendarDate} from "@internationalized/date";
import {NumberParser as $cIPI0$NumberParser} from "@internationalized/number";
import {useSpinButton as $cIPI0$useSpinButton} from "@react-aria/spinbutton";
import {LocalizedStringDictionary as $cIPI0$LocalizedStringDictionary} from "@internationalized/string";

function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 

var $dfb4eba373ed9493$exports = {};
var $f23889fffbde9058$exports = {};
$f23889fffbde9058$exports = {
    "calendar": `التقويم`,
    "day": `يوم`,
    "dayPeriod": `ص/م`,
    "endDate": `تاريخ الانتهاء`,
    "era": `العصر`,
    "hour": `الساعات`,
    "minute": `الدقائق`,
    "month": `الشهر`,
    "second": `الثواني`,
    "selectedDateDescription": (args)=>`تاريخ محدد: ${args.date}`,
    "selectedRangeDescription": (args)=>`المدى الزمني المحدد: ${args.startDate} إلى ${args.endDate}`,
    "selectedTimeDescription": (args)=>`الوقت المحدد: ${args.time}`,
    "startDate": `تاريخ البدء`,
    "timeZoneName": `التوقيت`,
    "weekday": `اليوم`,
    "year": `السنة`
};


var $09d9badaa8903929$exports = {};
$09d9badaa8903929$exports = {
    "calendar": `Календар`,
    "day": `ден`,
    "dayPeriod": `пр.об./сл.об.`,
    "endDate": `Крайна дата`,
    "era": `ера`,
    "hour": `час`,
    "minute": `минута`,
    "month": `месец`,
    "second": `секунда`,
    "selectedDateDescription": (args)=>`Избрана дата: ${args.date}`,
    "selectedRangeDescription": (args)=>`Избран диапазон: ${args.startDate} до ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Избрано време: ${args.time}`,
    "startDate": `Начална дата`,
    "timeZoneName": `часова зона`,
    "weekday": `ден от седмицата`,
    "year": `година`
};


var $151b77e0fd711730$exports = {};
$151b77e0fd711730$exports = {
    "calendar": `Kalendář`,
    "day": `den`,
    "dayPeriod": `část dne`,
    "endDate": `Konečné datum`,
    "era": `letopočet`,
    "hour": `hodina`,
    "minute": `minuta`,
    "month": `měsíc`,
    "second": `sekunda`,
    "selectedDateDescription": (args)=>`Vybrané datum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Vybrané období: ${args.startDate} až ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Vybraný čas: ${args.time}`,
    "startDate": `Počáteční datum`,
    "timeZoneName": `časové pásmo`,
    "weekday": `den v týdnu`,
    "year": `rok`
};


var $61915aa8630b90a2$exports = {};
$61915aa8630b90a2$exports = {
    "calendar": `Kalender`,
    "day": `dag`,
    "dayPeriod": `AM/PM`,
    "endDate": `Slutdato`,
    "era": `æra`,
    "hour": `time`,
    "minute": `minut`,
    "month": `måned`,
    "second": `sekund`,
    "selectedDateDescription": (args)=>`Valgt dato: ${args.date}`,
    "selectedRangeDescription": (args)=>`Valgt interval: ${args.startDate} til ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Valgt tidspunkt: ${args.time}`,
    "startDate": `Startdato`,
    "timeZoneName": `tidszone`,
    "weekday": `ugedag`,
    "year": `år`
};


var $35cea00159787840$exports = {};
$35cea00159787840$exports = {
    "calendar": `Kalender`,
    "day": `Tag`,
    "dayPeriod": `Tageshälfte`,
    "endDate": `Enddatum`,
    "era": `Epoche`,
    "hour": `Stunde`,
    "minute": `Minute`,
    "month": `Monat`,
    "second": `Sekunde`,
    "selectedDateDescription": (args)=>`Ausgewähltes Datum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Ausgewählter Bereich: ${args.startDate} bis ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Ausgewählte Zeit: ${args.time}`,
    "startDate": `Anfangsdatum`,
    "timeZoneName": `Zeitzone`,
    "weekday": `Wochentag`,
    "year": `Jahr`
};


var $518b4e82b9eacafd$exports = {};
$518b4e82b9eacafd$exports = {
    "calendar": `Ημερολόγιο`,
    "day": `ημέρα`,
    "dayPeriod": `π.μ./μ.μ.`,
    "endDate": `Ημερομηνία λήξης`,
    "era": `περίοδος`,
    "hour": `ώρα`,
    "minute": `λεπτό`,
    "month": `μήνας`,
    "second": `δευτερόλεπτο`,
    "selectedDateDescription": (args)=>`Επιλεγμένη ημερομηνία: ${args.date}`,
    "selectedRangeDescription": (args)=>`Επιλεγμένο εύρος: ${args.startDate} έως ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Επιλεγμένη ώρα: ${args.time}`,
    "startDate": `Ημερομηνία έναρξης`,
    "timeZoneName": `ζώνη ώρας`,
    "weekday": `καθημερινή`,
    "year": `έτος`
};


var $1c2b297f7e2cf474$exports = {};
$1c2b297f7e2cf474$exports = {
    "era": `era`,
    "year": `year`,
    "month": `month`,
    "day": `day`,
    "hour": `hour`,
    "minute": `minute`,
    "second": `second`,
    "dayPeriod": `AM/PM`,
    "calendar": `Calendar`,
    "startDate": `Start Date`,
    "endDate": `End Date`,
    "weekday": `day of the week`,
    "timeZoneName": `time zone`,
    "selectedDateDescription": (args)=>`Selected Date: ${args.date}`,
    "selectedRangeDescription": (args)=>`Selected Range: ${args.startDate} to ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Selected Time: ${args.time}`
};


var $07f628a707cf9b18$exports = {};
$07f628a707cf9b18$exports = {
    "calendar": `Calendario`,
    "day": `día`,
    "dayPeriod": `a. m./p. m.`,
    "endDate": `Fecha final`,
    "era": `era`,
    "hour": `hora`,
    "minute": `minuto`,
    "month": `mes`,
    "second": `segundo`,
    "selectedDateDescription": (args)=>`Fecha seleccionada: ${args.date}`,
    "selectedRangeDescription": (args)=>`Rango seleccionado: ${args.startDate} a ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Hora seleccionada: ${args.time}`,
    "startDate": `Fecha de inicio`,
    "timeZoneName": `zona horaria`,
    "weekday": `día de la semana`,
    "year": `año`
};


var $db553ffe17c7f4db$exports = {};
$db553ffe17c7f4db$exports = {
    "calendar": `Kalender`,
    "day": `päev`,
    "dayPeriod": `enne/pärast lõunat`,
    "endDate": `Lõppkuupäev`,
    "era": `ajastu`,
    "hour": `tund`,
    "minute": `minut`,
    "month": `kuu`,
    "second": `sekund`,
    "selectedDateDescription": (args)=>`Valitud kuupäev: ${args.date}`,
    "selectedRangeDescription": (args)=>`Valitud vahemik: ${args.startDate} kuni ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Valitud aeg: ${args.time}`,
    "startDate": `Alguskuupäev`,
    "timeZoneName": `ajavöönd`,
    "weekday": `nädalapäev`,
    "year": `aasta`
};


var $4afcfe00cd703f83$exports = {};
$4afcfe00cd703f83$exports = {
    "calendar": `Kalenteri`,
    "day": `päivä`,
    "dayPeriod": `vuorokaudenaika`,
    "endDate": `Päättymispäivä`,
    "era": `aikakausi`,
    "hour": `tunti`,
    "minute": `minuutti`,
    "month": `kuukausi`,
    "second": `sekunti`,
    "selectedDateDescription": (args)=>`Valittu päivämäärä: ${args.date}`,
    "selectedRangeDescription": (args)=>`Valittu aikaväli: ${args.startDate} – ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Valittu aika: ${args.time}`,
    "startDate": `Alkamispäivä`,
    "timeZoneName": `aikavyöhyke`,
    "weekday": `viikonpäivä`,
    "year": `vuosi`
};


var $1d2645d18d4c5be0$exports = {};
$1d2645d18d4c5be0$exports = {
    "calendar": `Calendrier`,
    "day": `jour`,
    "dayPeriod": `cadran`,
    "endDate": `Date de fin`,
    "era": `ère`,
    "hour": `heure`,
    "minute": `minute`,
    "month": `mois`,
    "second": `seconde`,
    "selectedDateDescription": (args)=>`Date sélectionnée : ${args.date}`,
    "selectedRangeDescription": (args)=>`Plage sélectionnée : ${args.startDate} au ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Heure choisie : ${args.time}`,
    "startDate": `Date de début`,
    "timeZoneName": `fuseau horaire`,
    "weekday": `jour de la semaine`,
    "year": `année`
};


var $64cb6a9be1f6fa48$exports = {};
$64cb6a9be1f6fa48$exports = {
    "calendar": `לוח שנה`,
    "day": `יום`,
    "dayPeriod": `לפנה״צ/אחה״צ`,
    "endDate": `תאריך סיום`,
    "era": `תקופה`,
    "hour": `שעה`,
    "minute": `דקה`,
    "month": `חודש`,
    "second": `שנייה`,
    "selectedDateDescription": (args)=>`תאריך נבחר: ${args.date}`,
    "selectedRangeDescription": (args)=>`טווח נבחר: ${args.startDate} עד ${args.endDate}`,
    "selectedTimeDescription": (args)=>`זמן נבחר: ${args.time}`,
    "startDate": `תאריך התחלה`,
    "timeZoneName": `אזור זמן`,
    "weekday": `יום בשבוע`,
    "year": `שנה`
};


var $2a1ef2e8050be27a$exports = {};
$2a1ef2e8050be27a$exports = {
    "calendar": `Kalendar`,
    "day": `dan`,
    "dayPeriod": `AM/PM`,
    "endDate": `Datum završetka`,
    "era": `era`,
    "hour": `sat`,
    "minute": `minuta`,
    "month": `mjesec`,
    "second": `sekunda`,
    "selectedDateDescription": (args)=>`Odabrani datum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Odabrani raspon: ${args.startDate} do ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Odabrano vrijeme: ${args.time}`,
    "startDate": `Datum početka`,
    "timeZoneName": `vremenska zona`,
    "weekday": `dan u tjednu`,
    "year": `godina`
};


var $ad429dca102acd0e$exports = {};
$ad429dca102acd0e$exports = {
    "calendar": `Naptár`,
    "day": `nap`,
    "dayPeriod": `napszak`,
    "endDate": `Befejező dátum`,
    "era": `éra`,
    "hour": `óra`,
    "minute": `perc`,
    "month": `hónap`,
    "second": `másodperc`,
    "selectedDateDescription": (args)=>`Kijelölt dátum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Kijelölt tartomány: ${args.startDate}–${args.endDate}`,
    "selectedTimeDescription": (args)=>`Kijelölt idő: ${args.time}`,
    "startDate": `Kezdő dátum`,
    "timeZoneName": `időzóna`,
    "weekday": `hét napja`,
    "year": `év`
};


var $6e68cb5d1cb97bd2$exports = {};
$6e68cb5d1cb97bd2$exports = {
    "calendar": `Calendario`,
    "day": `giorno`,
    "dayPeriod": `AM/PM`,
    "endDate": `Data finale`,
    "era": `era`,
    "hour": `ora`,
    "minute": `minuto`,
    "month": `mese`,
    "second": `secondo`,
    "selectedDateDescription": (args)=>`Data selezionata: ${args.date}`,
    "selectedRangeDescription": (args)=>`Intervallo selezionato: da ${args.startDate} a ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Ora selezionata: ${args.time}`,
    "startDate": `Data iniziale`,
    "timeZoneName": `fuso orario`,
    "weekday": `giorno della settimana`,
    "year": `anno`
};


var $a82ee9af063ee069$exports = {};
$a82ee9af063ee069$exports = {
    "calendar": `カレンダー`,
    "day": `日`,
    "dayPeriod": `午前/午後`,
    "endDate": `終了日`,
    "era": `時代`,
    "hour": `時`,
    "minute": `分`,
    "month": `月`,
    "second": `秒`,
    "selectedDateDescription": (args)=>`選択した日付 : ${args.date}`,
    "selectedRangeDescription": (args)=>`選択範囲 : ${args.startDate} から ${args.endDate}`,
    "selectedTimeDescription": (args)=>`選択した時間 : ${args.time}`,
    "startDate": `開始日`,
    "timeZoneName": `タイムゾーン`,
    "weekday": `曜日`,
    "year": `年`
};


var $67e9091dbf37d4eb$exports = {};
$67e9091dbf37d4eb$exports = {
    "calendar": `달력`,
    "day": `일`,
    "dayPeriod": `오전/오후`,
    "endDate": `종료 날짜`,
    "era": `연호`,
    "hour": `시`,
    "minute": `분`,
    "month": `월`,
    "second": `초`,
    "selectedDateDescription": (args)=>`선택 일자: ${args.date}`,
    "selectedRangeDescription": (args)=>`선택 범위: ${args.startDate} ~ ${args.endDate}`,
    "selectedTimeDescription": (args)=>`선택 시간: ${args.time}`,
    "startDate": `시작 날짜`,
    "timeZoneName": `시간대`,
    "weekday": `요일`,
    "year": `년`
};


var $75834f9729f653d1$exports = {};
$75834f9729f653d1$exports = {
    "calendar": `Kalendorius`,
    "day": `diena`,
    "dayPeriod": `iki pietų / po pietų`,
    "endDate": `Pabaigos data`,
    "era": `era`,
    "hour": `valanda`,
    "minute": `minutė`,
    "month": `mėnuo`,
    "second": `sekundė`,
    "selectedDateDescription": (args)=>`Pasirinkta data: ${args.date}`,
    "selectedRangeDescription": (args)=>`Pasirinktas intervalas: nuo ${args.startDate} iki ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Pasirinktas laikas: ${args.time}`,
    "startDate": `Pradžios data`,
    "timeZoneName": `laiko juosta`,
    "weekday": `savaitės diena`,
    "year": `metai`
};


var $a2df2c2520b4a7f0$exports = {};
$a2df2c2520b4a7f0$exports = {
    "calendar": `Kalendārs`,
    "day": `diena`,
    "dayPeriod": `priekšpusdienā/pēcpusdienā`,
    "endDate": `Beigu datums`,
    "era": `ēra`,
    "hour": `stundas`,
    "minute": `minūtes`,
    "month": `mēnesis`,
    "second": `sekundes`,
    "selectedDateDescription": (args)=>`Atlasītais datums: ${args.date}`,
    "selectedRangeDescription": (args)=>`Atlasītais diapazons: no ${args.startDate} līdz ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Atlasītais laiks: ${args.time}`,
    "startDate": `Sākuma datums`,
    "timeZoneName": `laika josla`,
    "weekday": `nedēļas diena`,
    "year": `gads`
};


var $aedcd71db4933ed5$exports = {};
$aedcd71db4933ed5$exports = {
    "calendar": `Kalender`,
    "day": `dag`,
    "dayPeriod": `a.m./p.m.`,
    "endDate": `Sluttdato`,
    "era": `tidsalder`,
    "hour": `time`,
    "minute": `minutt`,
    "month": `måned`,
    "second": `sekund`,
    "selectedDateDescription": (args)=>`Valgt dato: ${args.date}`,
    "selectedRangeDescription": (args)=>`Valgt område: ${args.startDate} til ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Valgt tid: ${args.time}`,
    "startDate": `Startdato`,
    "timeZoneName": `tidssone`,
    "weekday": `ukedag`,
    "year": `år`
};


var $3b2df9e54353046c$exports = {};
$3b2df9e54353046c$exports = {
    "calendar": `Kalender`,
    "day": `dag`,
    "dayPeriod": `a.m./p.m.`,
    "endDate": `Einddatum`,
    "era": `tijdperk`,
    "hour": `uur`,
    "minute": `minuut`,
    "month": `maand`,
    "second": `seconde`,
    "selectedDateDescription": (args)=>`Geselecteerde datum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Geselecteerd bereik: ${args.startDate} tot ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Geselecteerde tijd: ${args.time}`,
    "startDate": `Startdatum`,
    "timeZoneName": `tijdzone`,
    "weekday": `dag van de week`,
    "year": `jaar`
};


var $c03fe977fcfafe93$exports = {};
$c03fe977fcfafe93$exports = {
    "calendar": `Kalendarz`,
    "day": `dzień`,
    "dayPeriod": `rano / po południu / wieczorem`,
    "endDate": `Data końcowa`,
    "era": `era`,
    "hour": `godzina`,
    "minute": `minuta`,
    "month": `miesiąc`,
    "second": `sekunda`,
    "selectedDateDescription": (args)=>`Wybrana data: ${args.date}`,
    "selectedRangeDescription": (args)=>`Wybrany zakres: ${args.startDate} do ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Wybrany czas: ${args.time}`,
    "startDate": `Data początkowa`,
    "timeZoneName": `strefa czasowa`,
    "weekday": `dzień tygodnia`,
    "year": `rok`
};


var $569f006fc292345f$exports = {};
$569f006fc292345f$exports = {
    "calendar": `Calendário`,
    "day": `dia`,
    "dayPeriod": `AM/PM`,
    "endDate": `Data final`,
    "era": `era`,
    "hour": `hora`,
    "minute": `minuto`,
    "month": `mês`,
    "second": `segundo`,
    "selectedDateDescription": (args)=>`Data selecionada: ${args.date}`,
    "selectedRangeDescription": (args)=>`Intervalo selecionado: ${args.startDate} a ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Hora selecionada: ${args.time}`,
    "startDate": `Data inicial`,
    "timeZoneName": `fuso horário`,
    "weekday": `dia da semana`,
    "year": `ano`
};


var $7c2494e14452f2dd$exports = {};
$7c2494e14452f2dd$exports = {
    "calendar": `Calendário`,
    "day": `dia`,
    "dayPeriod": `am/pm`,
    "endDate": `Data de Término`,
    "era": `era`,
    "hour": `hora`,
    "minute": `minuto`,
    "month": `mês`,
    "second": `segundo`,
    "selectedDateDescription": (args)=>`Data selecionada: ${args.date}`,
    "selectedRangeDescription": (args)=>`Intervalo selecionado: ${args.startDate} a ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Hora selecionada: ${args.time}`,
    "startDate": `Data de Início`,
    "timeZoneName": `fuso horário`,
    "weekday": `dia da semana`,
    "year": `ano`
};


var $eb82ef981b5592bf$exports = {};
$eb82ef981b5592bf$exports = {
    "calendar": `Calendar`,
    "day": `zi`,
    "dayPeriod": `a.m/p.m.`,
    "endDate": `Dată final`,
    "era": `eră`,
    "hour": `oră`,
    "minute": `minut`,
    "month": `lună`,
    "second": `secundă`,
    "selectedDateDescription": (args)=>`Dată selectată: ${args.date}`,
    "selectedRangeDescription": (args)=>`Interval selectat: de la ${args.startDate} până la ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Ora selectată: ${args.time}`,
    "startDate": `Dată început`,
    "timeZoneName": `fus orar`,
    "weekday": `ziua din săptămână`,
    "year": `an`
};


var $6efa0e119f396950$exports = {};
$6efa0e119f396950$exports = {
    "calendar": `Календарь`,
    "day": `день`,
    "dayPeriod": `AM/PM`,
    "endDate": `Дата окончания`,
    "era": `эра`,
    "hour": `час`,
    "minute": `минута`,
    "month": `месяц`,
    "second": `секунда`,
    "selectedDateDescription": (args)=>`Выбранная дата: ${args.date}`,
    "selectedRangeDescription": (args)=>`Выбранный диапазон: с ${args.startDate} по ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Выбранное время: ${args.time}`,
    "startDate": `Дата начала`,
    "timeZoneName": `часовой пояс`,
    "weekday": `день недели`,
    "year": `год`
};


var $7f5e57085d7f5049$exports = {};
$7f5e57085d7f5049$exports = {
    "calendar": `Kalendár`,
    "day": `deň`,
    "dayPeriod": `AM/PM`,
    "endDate": `Dátum ukončenia`,
    "era": `letopočet`,
    "hour": `hodina`,
    "minute": `minúta`,
    "month": `mesiac`,
    "second": `sekunda`,
    "selectedDateDescription": (args)=>`Vybratý dátum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Vybratý rozsah: od ${args.startDate} do ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Vybratý čas: ${args.time}`,
    "startDate": `Dátum začatia`,
    "timeZoneName": `časové pásmo`,
    "weekday": `deň týždňa`,
    "year": `rok`
};


var $578ee7c11dcdde7a$exports = {};
$578ee7c11dcdde7a$exports = {
    "calendar": `Koledar`,
    "day": `dan`,
    "dayPeriod": `dop/pop`,
    "endDate": `Datum konca`,
    "era": `doba`,
    "hour": `ura`,
    "minute": `minuta`,
    "month": `mesec`,
    "second": `sekunda`,
    "selectedDateDescription": (args)=>`Izbrani datum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Izbrano območje: ${args.startDate} do ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Izbrani čas: ${args.time}`,
    "startDate": `Datum začetka`,
    "timeZoneName": `časovni pas`,
    "weekday": `dan v tednu`,
    "year": `leto`
};


var $bbc3fd6cd0bc9d50$exports = {};
$bbc3fd6cd0bc9d50$exports = {
    "calendar": `Kalendar`,
    "day": `дан`,
    "dayPeriod": `пре подне/по подне`,
    "endDate": `Datum završetka`,
    "era": `ера`,
    "hour": `сат`,
    "minute": `минут`,
    "month": `месец`,
    "second": `секунд`,
    "selectedDateDescription": (args)=>`Izabrani datum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Izabrani opseg: od ${args.startDate} do ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Izabrano vreme: ${args.time}`,
    "startDate": `Datum početka`,
    "timeZoneName": `временска зона`,
    "weekday": `дан у недељи`,
    "year": `година`
};


var $0b04512118591d2a$exports = {};
$0b04512118591d2a$exports = {
    "calendar": `Kalender`,
    "day": `dag`,
    "dayPeriod": `fm/em`,
    "endDate": `Slutdatum`,
    "era": `era`,
    "hour": `timme`,
    "minute": `minut`,
    "month": `månad`,
    "second": `sekund`,
    "selectedDateDescription": (args)=>`Valt datum: ${args.date}`,
    "selectedRangeDescription": (args)=>`Valt intervall: ${args.startDate} till ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Vald tid: ${args.time}`,
    "startDate": `Startdatum`,
    "timeZoneName": `tidszon`,
    "weekday": `veckodag`,
    "year": `år`
};


var $3a49d121fe4c9e1d$exports = {};
$3a49d121fe4c9e1d$exports = {
    "calendar": `Takvim`,
    "day": `gün`,
    "dayPeriod": `ÖÖ/ÖS`,
    "endDate": `Bitiş Tarihi`,
    "era": `çağ`,
    "hour": `saat`,
    "minute": `dakika`,
    "month": `ay`,
    "second": `saniye`,
    "selectedDateDescription": (args)=>`Seçilen Tarih: ${args.date}`,
    "selectedRangeDescription": (args)=>`Seçilen Aralık: ${args.startDate} - ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Seçilen Zaman: ${args.time}`,
    "startDate": `Başlangıç Tarihi`,
    "timeZoneName": `saat dilimi`,
    "weekday": `haftanın günü`,
    "year": `yıl`
};


var $5ba21dbb8914919d$exports = {};
$5ba21dbb8914919d$exports = {
    "calendar": `Календар`,
    "day": `день`,
    "dayPeriod": `дп/пп`,
    "endDate": `Дата завершення`,
    "era": `ера`,
    "hour": `година`,
    "minute": `хвилина`,
    "month": `місяць`,
    "second": `секунда`,
    "selectedDateDescription": (args)=>`Вибрана дата: ${args.date}`,
    "selectedRangeDescription": (args)=>`Вибраний діапазон: ${args.startDate} — ${args.endDate}`,
    "selectedTimeDescription": (args)=>`Вибраний час: ${args.time}`,
    "startDate": `Дата початку`,
    "timeZoneName": `часовий пояс`,
    "weekday": `день тижня`,
    "year": `рік`
};


var $51078838e1b16cd7$exports = {};
$51078838e1b16cd7$exports = {
    "calendar": `日历`,
    "day": `日`,
    "dayPeriod": `上午/下午`,
    "endDate": `结束日期`,
    "era": `纪元`,
    "hour": `小时`,
    "minute": `分钟`,
    "month": `月`,
    "second": `秒`,
    "selectedDateDescription": (args)=>`选定的日期：${args.date}`,
    "selectedRangeDescription": (args)=>`选定的范围：${args.startDate} 至 ${args.endDate}`,
    "selectedTimeDescription": (args)=>`选定的时间：${args.time}`,
    "startDate": `开始日期`,
    "timeZoneName": `时区`,
    "weekday": `工作日`,
    "year": `年`
};


var $33fab8219207655a$exports = {};
$33fab8219207655a$exports = {
    "calendar": `日曆`,
    "day": `日`,
    "dayPeriod": `上午/下午`,
    "endDate": `結束日期`,
    "era": `纪元`,
    "hour": `小时`,
    "minute": `分钟`,
    "month": `月`,
    "second": `秒`,
    "selectedDateDescription": (args)=>`選定的日期：${args.date}`,
    "selectedRangeDescription": (args)=>`選定的範圍：${args.startDate} 至 ${args.endDate}`,
    "selectedTimeDescription": (args)=>`選定的時間：${args.time}`,
    "startDate": `開始日期`,
    "timeZoneName": `时区`,
    "weekday": `工作日`,
    "year": `年`
};


$dfb4eba373ed9493$exports = {
    "ar-AE": $f23889fffbde9058$exports,
    "bg-BG": $09d9badaa8903929$exports,
    "cs-CZ": $151b77e0fd711730$exports,
    "da-DK": $61915aa8630b90a2$exports,
    "de-DE": $35cea00159787840$exports,
    "el-GR": $518b4e82b9eacafd$exports,
    "en-US": $1c2b297f7e2cf474$exports,
    "es-ES": $07f628a707cf9b18$exports,
    "et-EE": $db553ffe17c7f4db$exports,
    "fi-FI": $4afcfe00cd703f83$exports,
    "fr-FR": $1d2645d18d4c5be0$exports,
    "he-IL": $64cb6a9be1f6fa48$exports,
    "hr-HR": $2a1ef2e8050be27a$exports,
    "hu-HU": $ad429dca102acd0e$exports,
    "it-IT": $6e68cb5d1cb97bd2$exports,
    "ja-JP": $a82ee9af063ee069$exports,
    "ko-KR": $67e9091dbf37d4eb$exports,
    "lt-LT": $75834f9729f653d1$exports,
    "lv-LV": $a2df2c2520b4a7f0$exports,
    "nb-NO": $aedcd71db4933ed5$exports,
    "nl-NL": $3b2df9e54353046c$exports,
    "pl-PL": $c03fe977fcfafe93$exports,
    "pt-BR": $569f006fc292345f$exports,
    "pt-PT": $7c2494e14452f2dd$exports,
    "ro-RO": $eb82ef981b5592bf$exports,
    "ru-RU": $6efa0e119f396950$exports,
    "sk-SK": $7f5e57085d7f5049$exports,
    "sl-SI": $578ee7c11dcdde7a$exports,
    "sr-SP": $bbc3fd6cd0bc9d50$exports,
    "sv-SE": $0b04512118591d2a$exports,
    "tr-TR": $3a49d121fe4c9e1d$exports,
    "uk-UA": $5ba21dbb8914919d$exports,
    "zh-CN": $51078838e1b16cd7$exports,
    "zh-TW": $33fab8219207655a$exports
};



/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 








function $3dfb0f96be0d6a08$export$4a931266a3838b86(state, ref, disableArrowNavigation) {
    let { direction: direction  } = (0, $cIPI0$useLocale)();
    let focusManager = (0, $cIPI0$useMemo)(()=>(0, $cIPI0$createFocusManager)(ref), [
        ref
    ]);
    // Open the popover on alt + arrow down
    let onKeyDown = (e)=>{
        if (e.altKey && (e.key === "ArrowDown" || e.key === "ArrowUp") && "setOpen" in state) {
            e.preventDefault();
            e.stopPropagation();
            state.setOpen(true);
        }
        if (disableArrowNavigation) return;
        switch(e.key){
            case "ArrowLeft":
                e.preventDefault();
                e.stopPropagation();
                if (direction === "rtl") focusManager.focusNext();
                else focusManager.focusPrevious();
                break;
            case "ArrowRight":
                e.preventDefault();
                e.stopPropagation();
                if (direction === "rtl") focusManager.focusPrevious();
                else focusManager.focusNext();
                break;
        }
    };
    // Focus the first placeholder segment from the end on mouse down/touch up in the field.
    let focusLast = ()=>{
        var _window_event;
        // Try to find the segment prior to the element that was clicked on.
        let target = (_window_event = window.event) === null || _window_event === void 0 ? void 0 : _window_event.target;
        let walker = (0, $cIPI0$getFocusableTreeWalker)(ref.current, {
            tabbable: true
        });
        if (target) {
            walker.currentNode = target;
            target = walker.previousNode();
        }
        // If no target found, find the last element from the end.
        if (!target) {
            let last;
            do {
                last = walker.lastChild();
                if (last) target = last;
            }while (last);
        }
        // Now go backwards until we find an element that is not a placeholder.
        while(target === null || target === void 0 ? void 0 : target.hasAttribute("data-placeholder")){
            let prev = walker.previousNode();
            if (prev && prev.hasAttribute("data-placeholder")) target = prev;
            else break;
        }
        if (target) target.focus();
    };
    let { pressProps: pressProps  } = (0, $cIPI0$usePress)({
        preventFocusOnPress: true,
        allowTextSelectionOnPress: true,
        onPressStart (e) {
            if (e.pointerType === "mouse") focusLast();
        },
        onPress (e) {
            if (e.pointerType !== "mouse") focusLast();
        }
    });
    return (0, $cIPI0$mergeProps)(pressProps, {
        onKeyDown: onKeyDown
    });
}





const $16f0b7bb276bc17e$export$653eddfc964b0f8a = new WeakMap();
const $16f0b7bb276bc17e$export$300019f83c56d282 = "__role_" + Date.now();
const $16f0b7bb276bc17e$export$7b3062cd49e80452 = "__focusManager_" + Date.now();
function $16f0b7bb276bc17e$export$5591b0b878c1a989(props, state, ref) {
    let { labelProps: labelProps , fieldProps: fieldProps , descriptionProps: descriptionProps , errorMessageProps: errorMessageProps  } = (0, $cIPI0$useField)({
        ...props,
        labelElementType: "span"
    });
    let { focusWithinProps: focusWithinProps  } = (0, $cIPI0$useFocusWithin)({
        ...props,
        onBlurWithin: (e)=>{
            state.confirmPlaceholder();
            if (props.onBlur) props.onBlur(e);
        },
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    let stringFormatter = (0, $cIPI0$useLocalizedStringFormatter)((0, (/*@__PURE__*/$parcel$interopDefault($dfb4eba373ed9493$exports))));
    let message = state.maxGranularity === "hour" ? "selectedTimeDescription" : "selectedDateDescription";
    let field = state.maxGranularity === "hour" ? "time" : "date";
    let description = state.value ? stringFormatter.format(message, {
        [field]: state.formatValue({
            month: "long"
        })
    }) : "";
    let descProps = (0, $cIPI0$useDescription)(description);
    // If within a date picker or date range picker, the date field will have role="presentation" and an aria-describedby
    // will be passed in that references the value (e.g. entire range). Otherwise, add the field's value description.
    let describedBy = props[$16f0b7bb276bc17e$export$300019f83c56d282] === "presentation" ? fieldProps["aria-describedby"] : [
        descProps["aria-describedby"],
        fieldProps["aria-describedby"]
    ].filter(Boolean).join(" ") || undefined;
    let propsFocusManager = props[$16f0b7bb276bc17e$export$7b3062cd49e80452];
    let focusManager = (0, $cIPI0$useMemo)(()=>propsFocusManager || (0, $cIPI0$createFocusManager)(ref), [
        propsFocusManager,
        ref
    ]);
    let groupProps = (0, $3dfb0f96be0d6a08$export$4a931266a3838b86)(state, ref, props[$16f0b7bb276bc17e$export$300019f83c56d282] === "presentation");
    // Pass labels and other information to segments.
    $16f0b7bb276bc17e$export$653eddfc964b0f8a.set(state, {
        ariaLabel: props["aria-label"],
        ariaLabelledBy: [
            labelProps.id,
            props["aria-labelledby"]
        ].filter(Boolean).join(" ") || undefined,
        ariaDescribedBy: describedBy,
        focusManager: focusManager
    });
    let autoFocusRef = (0, $cIPI0$useRef)(props.autoFocus);
    // When used within a date picker or date range picker, the field gets role="presentation"
    // rather than role="group". Since the date picker/date range picker already has a role="group"
    // with a label and description, and the segments are already labeled by this as well, this
    // avoids very verbose duplicate announcements.
    let fieldDOMProps;
    if (props[$16f0b7bb276bc17e$export$300019f83c56d282] === "presentation") fieldDOMProps = {
        role: "presentation"
    };
    else fieldDOMProps = (0, $cIPI0$mergeProps)(fieldProps, {
        role: "group",
        "aria-disabled": props.isDisabled || undefined,
        "aria-describedby": describedBy
    });
    (0, $cIPI0$useEffect)(()=>{
        if (autoFocusRef.current) focusManager.focusFirst();
        autoFocusRef.current = false;
    }, [
        focusManager
    ]);
    let domProps = (0, $cIPI0$filterDOMProps)(props);
    return {
        labelProps: {
            ...labelProps,
            onClick: ()=>{
                focusManager.focusFirst();
            }
        },
        fieldProps: (0, $cIPI0$mergeProps)(domProps, fieldDOMProps, groupProps, focusWithinProps, {
            onKeyDown (e) {
                if (props.onKeyDown) props.onKeyDown(e);
            },
            onKeyUp (e) {
                if (props.onKeyUp) props.onKeyUp(e);
            }
        }),
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps
    };
}
function $16f0b7bb276bc17e$export$4c842f6a241dc825(props, state, ref) {
    return $16f0b7bb276bc17e$export$5591b0b878c1a989(props, state, ref);
}






function $6057a3d2a53a12fd$export$42df105a73306d51(props, state, ref) {
    let buttonId = (0, $cIPI0$useId)();
    let dialogId = (0, $cIPI0$useId)();
    let fieldId = (0, $cIPI0$useId)();
    let stringFormatter = (0, $cIPI0$useLocalizedStringFormatter)((0, (/*@__PURE__*/$parcel$interopDefault($dfb4eba373ed9493$exports))));
    let { labelProps: labelProps , fieldProps: fieldProps , descriptionProps: descriptionProps , errorMessageProps: errorMessageProps  } = (0, $cIPI0$useField)({
        ...props,
        labelElementType: "span"
    });
    let groupProps = (0, $3dfb0f96be0d6a08$export$4a931266a3838b86)(state, ref);
    let labelledBy = fieldProps["aria-labelledby"] || fieldProps.id;
    let { locale: locale  } = (0, $cIPI0$useLocale)();
    let date = state.formatValue(locale, {
        month: "long"
    });
    let description = date ? stringFormatter.format("selectedDateDescription", {
        date: date
    }) : "";
    let descProps = (0, $cIPI0$useDescription)(description);
    let ariaDescribedBy = [
        descProps["aria-describedby"],
        fieldProps["aria-describedby"]
    ].filter(Boolean).join(" ") || undefined;
    let domProps = (0, $cIPI0$filterDOMProps)(props);
    let focusManager = (0, $cIPI0$useMemo)(()=>(0, $cIPI0$createFocusManager)(ref), [
        ref
    ]);
    let { focusWithinProps: focusWithinProps  } = (0, $cIPI0$useFocusWithin)({
        ...props,
        isDisabled: state.isOpen,
        onBlurWithin: props.onBlur,
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    return {
        groupProps: (0, $cIPI0$mergeProps)(domProps, groupProps, fieldProps, descProps, focusWithinProps, {
            role: "group",
            "aria-disabled": props.isDisabled || null,
            "aria-labelledby": labelledBy,
            "aria-describedby": ariaDescribedBy,
            onKeyDown (e) {
                if (state.isOpen) return;
                if (props.onKeyDown) props.onKeyDown(e);
            },
            onKeyUp (e) {
                if (state.isOpen) return;
                if (props.onKeyUp) props.onKeyUp(e);
            }
        }),
        labelProps: {
            ...labelProps,
            onClick: ()=>{
                focusManager.focusFirst();
            }
        },
        fieldProps: {
            ...fieldProps,
            id: fieldId,
            [(0, $16f0b7bb276bc17e$export$300019f83c56d282)]: "presentation",
            "aria-describedby": ariaDescribedBy,
            value: state.value,
            onChange: state.setValue,
            minValue: props.minValue,
            maxValue: props.maxValue,
            placeholderValue: props.placeholderValue,
            hideTimeZone: props.hideTimeZone,
            hourCycle: props.hourCycle,
            shouldForceLeadingZeros: props.shouldForceLeadingZeros,
            granularity: props.granularity,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isRequired: props.isRequired,
            validationState: state.validationState,
            autoFocus: props.autoFocus
        },
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        buttonProps: {
            ...descProps,
            id: buttonId,
            "aria-haspopup": "dialog",
            "aria-label": stringFormatter.format("calendar"),
            "aria-labelledby": `${buttonId} ${labelledBy}`,
            "aria-describedby": ariaDescribedBy,
            "aria-expanded": state.isOpen || undefined,
            onPress: ()=>state.setOpen(true)
        },
        dialogProps: {
            id: dialogId,
            "aria-labelledby": `${buttonId} ${labelledBy}`
        },
        calendarProps: {
            autoFocus: true,
            value: state.dateValue,
            onChange: state.setDateValue,
            minValue: props.minValue,
            maxValue: props.maxValue,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isDateUnavailable: props.isDateUnavailable,
            defaultFocusedValue: state.dateValue ? undefined : props.placeholderValue,
            validationState: state.validationState,
            errorMessage: props.errorMessage
        }
    };
}


/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 





/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ // @ts-ignore




function $3aeceb3a64eb8358$export$d42c60378c8168f8() {
    let { locale: locale  } = (0, $cIPI0$useLocale)();
    return (0, $cIPI0$useMemo)(()=>{
        // Try to use Intl.DisplayNames if possible. It may be supported in browsers, but not support the dateTimeField
        // type as that was only added in v2. https://github.com/tc39/intl-displaynames-v2
        try {
            // @ts-ignore
            return new Intl.DisplayNames(locale, {
                type: "dateTimeField"
            });
        } catch (err) {
            return new $3aeceb3a64eb8358$var$DisplayNamesPolyfill(locale);
        }
    }, [
        locale
    ]);
}
class $3aeceb3a64eb8358$var$DisplayNamesPolyfill {
    of(field) {
        return this.dictionary.getStringForLocale(field, this.locale);
    }
    constructor(locale){
        this.locale = locale;
        this.dictionary = new (0, $cIPI0$LocalizedStringDictionary)((0, (/*@__PURE__*/$parcel$interopDefault($dfb4eba373ed9493$exports))));
    }
}



function $32489daedd52963e$export$1315d136e6f7581(segment, state, ref) {
    let enteredKeys = (0, $cIPI0$useRef)("");
    let { locale: locale  } = (0, $cIPI0$useLocale)();
    let displayNames = (0, $3aeceb3a64eb8358$export$d42c60378c8168f8)();
    let { ariaLabel: ariaLabel , ariaLabelledBy: ariaLabelledBy , ariaDescribedBy: ariaDescribedBy , focusManager: focusManager  } = (0, $16f0b7bb276bc17e$export$653eddfc964b0f8a).get(state);
    let textValue = segment.isPlaceholder ? "" : segment.text;
    let options = (0, $cIPI0$useMemo)(()=>state.dateFormatter.resolvedOptions(), [
        state.dateFormatter
    ]);
    let monthDateFormatter = (0, $cIPI0$useDateFormatter)({
        month: "long",
        timeZone: options.timeZone
    });
    let hourDateFormatter = (0, $cIPI0$useDateFormatter)({
        hour: "numeric",
        hour12: options.hour12,
        timeZone: options.timeZone
    });
    if (segment.type === "month" && !segment.isPlaceholder) {
        let monthTextValue = monthDateFormatter.format(state.dateValue);
        textValue = monthTextValue !== textValue ? `${textValue} – ${monthTextValue}` : monthTextValue;
    } else if (segment.type === "hour" && !segment.isPlaceholder) textValue = hourDateFormatter.format(state.dateValue);
    let { spinButtonProps: spinButtonProps  } = (0, $cIPI0$useSpinButton)({
        // The ARIA spec says aria-valuenow is optional if there's no value, but aXe seems to require it.
        // This doesn't seem to have any negative effects with real AT since we also use aria-valuetext.
        // https://github.com/dequelabs/axe-core/issues/3505
        value: segment.value,
        textValue: textValue,
        minValue: segment.minValue,
        maxValue: segment.maxValue,
        isDisabled: state.isDisabled,
        isReadOnly: state.isReadOnly || !segment.isEditable,
        isRequired: state.isRequired,
        onIncrement: ()=>{
            enteredKeys.current = "";
            state.increment(segment.type);
        },
        onDecrement: ()=>{
            enteredKeys.current = "";
            state.decrement(segment.type);
        },
        onIncrementPage: ()=>{
            enteredKeys.current = "";
            state.incrementPage(segment.type);
        },
        onDecrementPage: ()=>{
            enteredKeys.current = "";
            state.decrementPage(segment.type);
        },
        onIncrementToMax: ()=>{
            enteredKeys.current = "";
            state.setSegment(segment.type, segment.maxValue);
        },
        onDecrementToMin: ()=>{
            enteredKeys.current = "";
            state.setSegment(segment.type, segment.minValue);
        }
    });
    let parser = (0, $cIPI0$useMemo)(()=>new (0, $cIPI0$NumberParser)(locale, {
            maximumFractionDigits: 0
        }), [
        locale
    ]);
    let backspace = ()=>{
        if (parser.isValidPartialNumber(segment.text) && !state.isReadOnly && !segment.isPlaceholder) {
            let newValue = segment.text.slice(0, -1);
            let parsed = parser.parse(newValue);
            if (newValue.length === 0 || parsed === 0) state.clearSegment(segment.type);
            else state.setSegment(segment.type, parsed);
            enteredKeys.current = newValue;
        } else if (segment.type === "dayPeriod") state.clearSegment(segment.type);
    };
    let onKeyDown = (e)=>{
        // Firefox does not fire selectstart for Ctrl/Cmd + A
        // https://bugzilla.mozilla.org/show_bug.cgi?id=1742153
        if (e.key === "a" && ((0, $cIPI0$isMac)() ? e.metaKey : e.ctrlKey)) e.preventDefault();
        if (e.ctrlKey || e.metaKey || e.shiftKey || e.altKey) return;
        switch(e.key){
            case "Backspace":
            case "Delete":
                // Safari on iOS does not fire beforeinput for the backspace key because the cursor is at the start.
                e.preventDefault();
                e.stopPropagation();
                backspace();
                break;
        }
    };
    // Safari dayPeriod option doesn't work...
    let { startsWith: startsWith  } = (0, $cIPI0$useFilter)({
        sensitivity: "base"
    });
    let amPmFormatter = (0, $cIPI0$useDateFormatter)({
        hour: "numeric",
        hour12: true
    });
    let am = (0, $cIPI0$useMemo)(()=>{
        let date = new Date();
        date.setHours(0);
        return amPmFormatter.formatToParts(date).find((part)=>part.type === "dayPeriod").value;
    }, [
        amPmFormatter
    ]);
    let pm = (0, $cIPI0$useMemo)(()=>{
        let date = new Date();
        date.setHours(12);
        return amPmFormatter.formatToParts(date).find((part)=>part.type === "dayPeriod").value;
    }, [
        amPmFormatter
    ]);
    // Get a list of formatted era names so users can type the first character to choose one.
    let eraFormatter = (0, $cIPI0$useDateFormatter)({
        year: "numeric",
        era: "narrow",
        timeZone: "UTC"
    });
    let eras = (0, $cIPI0$useMemo)(()=>{
        if (segment.type !== "era") return [];
        let date = (0, $cIPI0$toCalendar)(new (0, $cIPI0$CalendarDate)(1, 1, 1), state.calendar);
        let eras = state.calendar.getEras().map((era)=>{
            let eraDate = date.set({
                year: 1,
                month: 1,
                day: 1,
                era: era
            }).toDate("UTC");
            let parts = eraFormatter.formatToParts(eraDate);
            let formatted = parts.find((p)=>p.type === "era").value;
            return {
                era: era,
                formatted: formatted
            };
        });
        // Remove the common prefix from formatted values. This is so that in calendars with eras like
        // ERA0 and ERA1 (e.g. Ethiopic), users can press "0" and "1" to select an era. In other cases,
        // the first letter is used.
        let prefixLength = $32489daedd52963e$var$commonPrefixLength(eras.map((era)=>era.formatted));
        if (prefixLength) for (let era of eras)era.formatted = era.formatted.slice(prefixLength);
        return eras;
    }, [
        eraFormatter,
        state.calendar,
        segment.type
    ]);
    let onInput = (key)=>{
        if (state.isDisabled || state.isReadOnly) return;
        let newValue = enteredKeys.current + key;
        switch(segment.type){
            case "dayPeriod":
                if (startsWith(am, key)) state.setSegment("dayPeriod", 0);
                else if (startsWith(pm, key)) state.setSegment("dayPeriod", 12);
                else break;
                focusManager.focusNext();
                break;
            case "era":
                {
                    let matched = eras.find((e)=>startsWith(e.formatted, key));
                    if (matched) {
                        state.setSegment("era", matched.era);
                        focusManager.focusNext();
                    }
                    break;
                }
            case "day":
            case "hour":
            case "minute":
            case "second":
            case "month":
            case "year":
                {
                    if (!parser.isValidPartialNumber(newValue)) return;
                    let numberValue = parser.parse(newValue);
                    let segmentValue = numberValue;
                    let allowsZero = segment.minValue === 0;
                    if (segment.type === "hour" && state.dateFormatter.resolvedOptions().hour12) {
                        switch(state.dateFormatter.resolvedOptions().hourCycle){
                            case "h11":
                                if (numberValue > 11) segmentValue = parser.parse(key);
                                break;
                            case "h12":
                                allowsZero = false;
                                if (numberValue > 12) segmentValue = parser.parse(key);
                                break;
                        }
                        if (segment.value >= 12 && numberValue > 1) numberValue += 12;
                    } else if (numberValue > segment.maxValue) segmentValue = parser.parse(key);
                    if (isNaN(numberValue)) return;
                    let shouldSetValue = segmentValue !== 0 || allowsZero;
                    if (shouldSetValue) state.setSegment(segment.type, segmentValue);
                    if (Number(numberValue + "0") > segment.maxValue || newValue.length >= String(segment.maxValue).length) {
                        enteredKeys.current = "";
                        if (shouldSetValue) focusManager.focusNext();
                    } else enteredKeys.current = newValue;
                    break;
                }
        }
    };
    let onFocus = ()=>{
        enteredKeys.current = "";
        (0, $cIPI0$scrollIntoViewport)(ref.current, {
            containingElement: (0, $cIPI0$getScrollParent)(ref.current)
        });
        // Collapse selection to start or Chrome won't fire input events.
        let selection = window.getSelection();
        selection.collapse(ref.current);
    };
    let compositionRef = (0, $cIPI0$useRef)("");
    // @ts-ignore - TODO: possibly old TS version? doesn't fail in my editor...
    (0, $cIPI0$useEvent)(ref, "beforeinput", (e)=>{
        e.preventDefault();
        switch(e.inputType){
            case "deleteContentBackward":
            case "deleteContentForward":
                if (parser.isValidPartialNumber(segment.text) && !state.isReadOnly) backspace();
                break;
            case "insertCompositionText":
                // insertCompositionText cannot be canceled.
                // Record the current state of the element so we can restore it in the `input` event below.
                compositionRef.current = ref.current.textContent;
                // Safari gets stuck in a composition state unless we also assign to the value here.
                // eslint-disable-next-line no-self-assign
                ref.current.textContent = ref.current.textContent;
                break;
            default:
                if (e.data != null) onInput(e.data);
                break;
        }
    });
    (0, $cIPI0$useEvent)(ref, "input", (e)=>{
        let { inputType: inputType , data: data  } = e;
        switch(inputType){
            case "insertCompositionText":
                // Reset the DOM to how it was in the beforeinput event.
                ref.current.textContent = compositionRef.current;
                // Android sometimes fires key presses of letters as composition events. Need to handle am/pm keys here too.
                // Can also happen e.g. with Pinyin keyboard on iOS.
                if (startsWith(am, data) || startsWith(pm, data)) onInput(data);
                break;
        }
    });
    (0, $cIPI0$useLayoutEffect)(()=>{
        let element = ref.current;
        return ()=>{
            // If the focused segment is removed, focus the previous one, or the next one if there was no previous one.
            if (document.activeElement === element) {
                let prev = focusManager.focusPrevious();
                if (!prev) focusManager.focusNext();
            }
        };
    }, [
        ref,
        focusManager
    ]);
    // spinbuttons cannot be focused with VoiceOver on iOS.
    let touchPropOverrides = (0, $cIPI0$isIOS)() || segment.type === "timeZoneName" ? {
        role: "textbox",
        "aria-valuemax": null,
        "aria-valuemin": null,
        "aria-valuetext": null,
        "aria-valuenow": null
    } : {};
    // Only apply aria-describedby to the first segment, unless the field is invalid. This avoids it being
    // read every time the user navigates to a new segment.
    let firstSegment = (0, $cIPI0$useMemo)(()=>state.segments.find((s)=>s.isEditable), [
        state.segments
    ]);
    if (segment !== firstSegment && state.validationState !== "invalid") ariaDescribedBy = undefined;
    let id = (0, $cIPI0$useId)();
    let isEditable = !state.isDisabled && !state.isReadOnly && segment.isEditable;
    // Prepend the label passed from the field to each segment name.
    // This is needed because VoiceOver on iOS does not announce groups.
    let name = segment.type === "literal" ? "" : displayNames.of(segment.type);
    let labelProps = (0, $cIPI0$useLabels)({
        "aria-label": `${name}${ariaLabel ? `, ${ariaLabel}` : ""}${ariaLabelledBy ? ", " : ""}`,
        "aria-labelledby": ariaLabelledBy
    });
    // Literal segments should not be visible to screen readers. We don't really need any of the above,
    // but the rules of hooks mean hooks cannot be conditional so we have to put this condition here.
    if (segment.type === "literal") return {
        segmentProps: {
            "aria-hidden": true
        }
    };
    return {
        segmentProps: (0, $cIPI0$mergeProps)(spinButtonProps, labelProps, {
            id: id,
            ...touchPropOverrides,
            "aria-invalid": state.validationState === "invalid" ? "true" : undefined,
            "aria-describedby": ariaDescribedBy,
            "aria-readonly": state.isReadOnly || !segment.isEditable ? "true" : undefined,
            "data-placeholder": segment.isPlaceholder || undefined,
            contentEditable: isEditable,
            suppressContentEditableWarning: isEditable,
            spellCheck: isEditable ? "false" : undefined,
            autoCapitalize: isEditable ? "off" : undefined,
            autoCorrect: isEditable ? "off" : undefined,
            // Capitalization was changed in React 17...
            [parseInt((0, $cIPI0$react).version, 10) >= 17 ? "enterKeyHint" : "enterkeyhint"]: isEditable ? "next" : undefined,
            inputMode: state.isDisabled || segment.type === "dayPeriod" || segment.type === "era" || !isEditable ? undefined : "numeric",
            tabIndex: state.isDisabled ? undefined : 0,
            onKeyDown: onKeyDown,
            onFocus: onFocus,
            style: {
                caretColor: "transparent"
            },
            // Prevent pointer events from reaching useDatePickerGroup, and allow native browser behavior to focus the segment.
            onPointerDown (e) {
                e.stopPropagation();
            },
            onMouseDown (e) {
                e.stopPropagation();
            }
        })
    };
}
function $32489daedd52963e$var$commonPrefixLength(strings) {
    // Sort the strings, and compare the characters in the first and last to find the common prefix.
    strings.sort();
    let first = strings[0];
    let last = strings[strings.length - 1];
    for(let i = 0; i < first.length; i++){
        if (first[i] !== last[i]) return i;
    }
    return 0;
}



/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 








function $887cac91b7cc8801$export$12fd5f0e9f4bb192(props, state, ref) {
    var _state_value, _state_value1;
    let stringFormatter = (0, $cIPI0$useLocalizedStringFormatter)((0, (/*@__PURE__*/$parcel$interopDefault($dfb4eba373ed9493$exports))));
    let { labelProps: labelProps , fieldProps: fieldProps , descriptionProps: descriptionProps , errorMessageProps: errorMessageProps  } = (0, $cIPI0$useField)({
        ...props,
        labelElementType: "span"
    });
    let labelledBy = fieldProps["aria-labelledby"] || fieldProps.id;
    let { locale: locale  } = (0, $cIPI0$useLocale)();
    let range = state.formatValue(locale, {
        month: "long"
    });
    let description = range ? stringFormatter.format("selectedRangeDescription", {
        startDate: range.start,
        endDate: range.end
    }) : "";
    let descProps = (0, $cIPI0$useDescription)(description);
    let startFieldProps = {
        "aria-label": stringFormatter.format("startDate"),
        "aria-labelledby": labelledBy
    };
    let endFieldProps = {
        "aria-label": stringFormatter.format("endDate"),
        "aria-labelledby": labelledBy
    };
    let buttonId = (0, $cIPI0$useId)();
    let dialogId = (0, $cIPI0$useId)();
    let groupProps = (0, $3dfb0f96be0d6a08$export$4a931266a3838b86)(state, ref);
    let ariaDescribedBy = [
        descProps["aria-describedby"],
        fieldProps["aria-describedby"]
    ].filter(Boolean).join(" ") || undefined;
    let focusManager = (0, $cIPI0$useMemo)(()=>(0, $cIPI0$createFocusManager)(ref, {
            // Exclude the button from the focus manager.
            accept: (element)=>element.id !== buttonId
        }), [
        ref,
        buttonId
    ]);
    let commonFieldProps = {
        [(0, $16f0b7bb276bc17e$export$7b3062cd49e80452)]: focusManager,
        [(0, $16f0b7bb276bc17e$export$300019f83c56d282)]: "presentation",
        "aria-describedby": ariaDescribedBy,
        minValue: props.minValue,
        maxValue: props.maxValue,
        placeholderValue: props.placeholderValue,
        hideTimeZone: props.hideTimeZone,
        hourCycle: props.hourCycle,
        granularity: props.granularity,
        shouldForceLeadingZeros: props.shouldForceLeadingZeros,
        isDisabled: props.isDisabled,
        isReadOnly: props.isReadOnly,
        isRequired: props.isRequired,
        validationState: state.validationState
    };
    let domProps = (0, $cIPI0$filterDOMProps)(props);
    let { focusWithinProps: focusWithinProps  } = (0, $cIPI0$useFocusWithin)({
        ...props,
        isDisabled: state.isOpen,
        onBlurWithin: props.onBlur,
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    return {
        groupProps: (0, $cIPI0$mergeProps)(domProps, groupProps, fieldProps, descProps, focusWithinProps, {
            role: "group",
            "aria-disabled": props.isDisabled || null,
            "aria-describedby": ariaDescribedBy,
            onKeyDown (e) {
                if (state.isOpen) return;
                if (props.onKeyDown) props.onKeyDown(e);
            },
            onKeyUp (e) {
                if (state.isOpen) return;
                if (props.onKeyUp) props.onKeyUp(e);
            }
        }),
        labelProps: {
            ...labelProps,
            onClick: ()=>{
                focusManager.focusFirst();
            }
        },
        buttonProps: {
            ...descProps,
            id: buttonId,
            "aria-haspopup": "dialog",
            "aria-label": stringFormatter.format("calendar"),
            "aria-labelledby": `${buttonId} ${labelledBy}`,
            "aria-describedby": ariaDescribedBy,
            "aria-expanded": state.isOpen || undefined,
            onPress: ()=>state.setOpen(true)
        },
        dialogProps: {
            id: dialogId,
            "aria-labelledby": `${buttonId} ${labelledBy}`
        },
        startFieldProps: {
            ...startFieldProps,
            ...commonFieldProps,
            value: (_state_value = state.value) === null || _state_value === void 0 ? void 0 : _state_value.start,
            onChange: (start)=>state.setDateTime("start", start),
            autoFocus: props.autoFocus
        },
        endFieldProps: {
            ...endFieldProps,
            ...commonFieldProps,
            value: (_state_value1 = state.value) === null || _state_value1 === void 0 ? void 0 : _state_value1.end,
            onChange: (end)=>state.setDateTime("end", end)
        },
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        calendarProps: {
            autoFocus: true,
            value: state.dateRange,
            onChange: state.setDateRange,
            minValue: props.minValue,
            maxValue: props.maxValue,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isDateUnavailable: props.isDateUnavailable,
            allowsNonContiguousRanges: props.allowsNonContiguousRanges,
            defaultFocusedValue: state.dateRange ? undefined : props.placeholderValue,
            validationState: state.validationState,
            errorMessage: props.errorMessage
        }
    };
}





export {$6057a3d2a53a12fd$export$42df105a73306d51 as useDatePicker, $32489daedd52963e$export$1315d136e6f7581 as useDateSegment, $16f0b7bb276bc17e$export$5591b0b878c1a989 as useDateField, $16f0b7bb276bc17e$export$4c842f6a241dc825 as useTimeField, $887cac91b7cc8801$export$12fd5f0e9f4bb192 as useDateRangePicker, $3aeceb3a64eb8358$export$d42c60378c8168f8 as useDisplayNames};
//# sourceMappingURL=module.js.map
