'use strict';

var electron = require('electron');
var rimraf = require('rimraf');
var redux = require('redux');
var fs = require('fs');
var path = require('path');
var i18next = require('i18next');
var reselect = require('reselect');
var detectBrowsers = require('detect-browsers');
var ElectronStore = require('electron-store');
var semver$1 = require('semver');
var os = require('os');
var electronDl = require('electron-dl');
var Bugsnag = require('@bugsnag/js');
var axios = require('axios');
var xhr = require('@ewsjs/xhr');
var ewsJavascriptApi = require('ews-javascript-api');
var promises = require('node:fs/promises');
var node_path = require('node:path');
var jwt = require('jsonwebtoken');
require('moment');
var process$1 = require('process');
var electronUpdater = require('electron-updater');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var fs__default = /*#__PURE__*/_interopDefault(fs);
var path__default = /*#__PURE__*/_interopDefault(path);
var i18next__default = /*#__PURE__*/_interopDefault(i18next);
var ElectronStore__default = /*#__PURE__*/_interopDefault(ElectronStore);
var os__default = /*#__PURE__*/_interopDefault(os);
var electronDl__default = /*#__PURE__*/_interopDefault(electronDl);
var Bugsnag__default = /*#__PURE__*/_interopDefault(Bugsnag);
var axios__default = /*#__PURE__*/_interopDefault(axios);
var jwt__default = /*#__PURE__*/_interopDefault(jwt);
var process__default = /*#__PURE__*/_interopDefault(process$1);

var files = [
	"app/**/*",
	"package.json"
];
var extraResources = [
	"build/icon.ico",
	"servers.json"
];
var appId = "chat.rocket";
var protocols = {
	name: "Rocket.Chat",
	schemes: [
		"rocketchat"
	]
};
var afterPack = "./build/afterPack.js";
var mac = {
	category: "public.app-category.productivity",
	target: [
		"dmg",
		"pkg",
		"zip",
		"mas"
	],
	icon: "build/icon.icns",
	bundleVersion: "25110",
	helperBundleId: "chat.rocket.electron.helper",
	type: "distribution",
	artifactName: "rocketchat-${version}-${os}.${ext}",
	mergeASARs: false,
	extendInfo: {
		NSMicrophoneUsageDescription: "I need access to your microphone to record the audio you want to send.",
		NSCameraUsageDescription: "I need access to your camera to record the video you want to send.",
		NSScreenCaptureDescription: "I need access to your screen to share it through video calls when you want to."
	},
	hardenedRuntime: true,
	gatekeeperAssess: false,
	provisioningProfile: "Desktop.provisionprofile",
	entitlements: "build/entitlements.mac.plist",
	entitlementsInherit: "build/entitlements.mac.plist"
};
var dmg = {
	background: "build/background.png",
	contents: [
		{
			type: "dir",
			x: 100,
			y: 211
		},
		{
			type: "link",
			path: "/Applications",
			x: 500,
			y: 211
		}
	]
};
var pkg = {
	isRelocatable: false,
	overwriteAction: "upgrade"
};
var mas = {
	entitlements: "build/entitlements.mas.plist",
	entitlementsInherit: "build/entitlements.mas.inherit.plist",
	entitlementsLoginHelper: "build/entitlements.mas.inherit.plist",
	hardenedRuntime: false,
	asarUnpack: [
		"node_modules"
	],
	artifactName: "rocketchat-${version}-mas.${ext}"
};
var win = {
	target: [
		{
			target: "nsis",
			arch: [
				"x64",
				"ia32"
			]
		},
		{
			target: "msi",
			arch: [
				"x64",
				"ia32"
			]
		},
		{
			target: "zip",
			arch: [
				"x64",
				"ia32"
			]
		}
	],
	icon: "build/icon.ico",
	legalTrademarks: "",
	verifyUpdateCodeSignature: true,
	requestedExecutionLevel: "asInvoker",
	signAndEditExecutable: true,
	artifactName: "rocketchat-${version}-${os}-${arch}.${ext}",
	signtoolOptions: {
		sign: "./build/winSignKms.js",
		signingHashAlgorithms: [
			"sha256"
		],
		timeStampServer: "http://timestamp.digicert.com"
	}
};
var nsis = {
	oneClick: false,
	perMachine: false,
	allowElevation: true,
	allowToChangeInstallationDirectory: true,
	installerIcon: "build/installerIcon.ico",
	uninstallerIcon: "build/uninstallerIcon.ico",
	installerSidebar: "build/installerSidebar.bmp",
	uninstallerSidebar: "build/uninstallerSidebar.bmp",
	uninstallDisplayName: "${productName} ${version}",
	include: "build/installer.nsh",
	license: "LICENSE",
	deleteAppDataOnUninstall: false,
	displayLanguageSelector: false,
	unicode: true,
	warningsAsErrors: true,
	runAfterFinish: true,
	createDesktopShortcut: "always",
	createStartMenuShortcut: true,
	menuCategory: false
};
var msi = {
	warningsAsErrors: false,
	additionalWixArgs: [
		"-sval"
	]
};
var appx = {
	backgroundColor: "#2f343d",
	languages: [
		"en-US",
		"en-GB",
		"pt-BR"
	],
	identityName: "0B67C87C.RocketChat",
	publisher: "CN=BBFF7141-7CAF-4FCD-8930-083FCDE6E854",
	publisherDisplayName: "Rocket.Chat Technologies Corp.",
	applicationId: "RocketChat",
	displayName: "Rocket.Chat"
};
var linux = {
	target: [
		"AppImage",
		"tar.gz",
		"deb",
		"rpm",
		"snap",
		"flatpak"
	],
	executableName: "rocketchat-desktop",
	category: "GNOME;GTK;Network;InstantMessaging",
	desktop: {
		entry: {
			Name: "Rocket.Chat",
			Comment: "Official Rocket.Chat Desktop Client",
			GenericName: "Rocket.Chat",
			Categories: "GNOME;GTK;Network;InstantMessaging"
		}
	},
	artifactName: "rocketchat-${version}-${os}-${arch}.${ext}"
};
var deb = {
	fpm: [
		"--after-install=build/linux/postinst.sh"
	]
};
var rpm = {
	fpm: [
		"--rpm-rpmbuild-define=_build_id_links none"
	]
};
var snap = {
	plugs: [
		"desktop",
		"desktop-legacy",
		"home",
		"x11",
		"unity7",
		"browser-support",
		"network",
		"gsettings",
		"pulseaudio",
		"opengl",
		"camera",
		"audio-playback",
		"audio-record",
		"screen-inhibit-control",
		"upower-observe"
	]
};
var afterSign = "./build/notarize.js";
var generateUpdatesFilesForAllChannels = true;
var publish = [
	{
		provider: "github",
		owner: "RocketChat",
		repo: "Rocket.Chat.Electron",
		vPrefixedTagName: false
	}
];
var electronBuilderJson = {
	files: files,
	extraResources: extraResources,
	appId: appId,
	protocols: protocols,
	afterPack: afterPack,
	mac: mac,
	dmg: dmg,
	pkg: pkg,
	mas: mas,
	win: win,
	nsis: nsis,
	msi: msi,
	appx: appx,
	linux: linux,
	deb: deb,
	rpm: rpm,
	snap: snap,
	afterSign: afterSign,
	generateUpdatesFilesForAllChannels: generateUpdatesFilesForAllChannels,
	publish: publish
};

var workspaces = [
	"workspaces/*"
];
var productName = "Rocket.Chat";
var name = "rocketchat";
var description = "Official OSX, Windows, and Linux Desktop Clients for Rocket.Chat";
var version = "4.9.2";
var author = "Rocket.Chat Support <support@rocket.chat>";
var copyright = "© 2016-2025, Rocket.Chat";
var homepage = "https://rocket.chat";
var license = "MIT";
var goUrlShortener = "go.rocket.chat";
var keywords = [
	"rocketchat",
	"desktop",
	"electron"
];
var repository = {
	type: "git",
	url: "git+https://github.com/RocketChat/Rocket.Chat.Electron.git"
};
var bugs = {
	url: "https://github.com/RocketChat/Rocket.Chat.Electron/issues"
};
var main$1 = "app/main.js";
var scripts = {
	postinstall: "run-s install-app-deps clean patch-package",
	"patch-package": "patch-package",
	start: "run-s build:watch",
	clean: "rimraf app dist",
	build: "rollup -c",
	"build:watch": "rollup -c -w",
	"build-mac": "yarn build && yarn electron-builder --publish never --mac --universal",
	"build-mas": "yarn build && yarn electron-builder --publish never --mac mas --universal",
	"build-win": "yarn build && yarn electron-builder --publish never --win",
	"build-linux": "yarn build && yarn electron-builder --publish never --linux",
	"build-assets": "ts-node -O '{\"module\":\"commonjs\"}' src/buildAssets.ts",
	"build-assets-win": "ts-node -O \"{\\\"module\\\":\\\"commonjs\\\"}\" src/buildAssets.ts",
	release: "yarn electron-builder --publish onTagOrDraft --x64",
	"install-app-deps": "electron-builder install-app-deps",
	test: "xvfb-maybe jest --forceExit --detectOpenHandles --maxWorkers=1",
	changelog: "conventional-changelog -p angular -i CHANGELOG.md -s",
	lint: "run-s .:lint:eslint .:lint:tsc",
	".:lint:eslint": "eslint .",
	".:lint:tsc": "tsc --noEmit",
	"lint-fix": "run-s .:lint-fix:eslint .:lint:tsc",
	".:lint-fix:eslint": "eslint --fix .",
	"workspaces:build": "yarn workspaces foreach -At run build"
};
var dependencies = {
	"@bugsnag/js": "~7.22.3",
	"@emotion/css": "~11.11.2",
	"@emotion/react": "~11.11.3",
	"@emotion/styled": "~11.11.0",
	"@ewsjs/xhr": "~2.0.2",
	"@rocket.chat/css-in-js": "~0.31.25",
	"@rocket.chat/desktop-api": "~1.1.0",
	"@rocket.chat/fuselage": "0.58.0",
	"@rocket.chat/fuselage-hooks": "~0.33.1",
	"@rocket.chat/fuselage-polyfills": "~0.31.25",
	"@rocket.chat/icons": "0.37.0",
	axios: "~1.6.4",
	"detect-browsers": "~6.1.0",
	"electron-dl": "4.0.0",
	"electron-store": "~8.1.0",
	"electron-updater": "^5.3.0",
	"ews-javascript-api": "~0.13.2",
	i18next: "~23.7.16",
	jsonwebtoken: "~9.0.2",
	moment: "~2.30.1",
	react: "~18.3.1",
	"react-dom": "~18.3.1",
	"react-hook-form": "~7.49.2",
	"react-i18next": "~14.0.0",
	"react-keyed-flatten-children": "~3.0.0",
	"react-redux": "~9.0.4",
	"react-virtuoso": "~4.6.2",
	redux: "~5.0.1",
	reselect: "~5.0.1",
	rimraf: "~5.0.7",
	semver: "~7.5.4"
};
var devDependencies = {
	"@babel/core": "~7.23.9",
	"@babel/eslint-parser": "~7.23.3",
	"@babel/plugin-proposal-class-properties": "~7.18.6",
	"@babel/plugin-proposal-function-bind": "~7.23.3",
	"@babel/preset-env": "~7.23.7",
	"@babel/preset-react": "~7.23.3",
	"@babel/preset-typescript": "~7.23.3",
	"@electron/fuses": "~1.8.0",
	"@fiahfy/icns-convert": "~0.0.12",
	"@fiahfy/ico-convert": "~0.0.12",
	"@kayahr/jest-electron-runner": "29.14.0",
	"@rocket.chat/eslint-config": "~0.7.0",
	"@rocket.chat/prettier-config": "~0.31.25",
	"@rollup/plugin-babel": "~6.0.4",
	"@rollup/plugin-commonjs": "~25.0.7",
	"@rollup/plugin-json": "~6.1.0",
	"@rollup/plugin-node-resolve": "~15.2.3",
	"@rollup/plugin-replace": "~5.0.5",
	"@types/electron-devtools-installer": "~2.2.5",
	"@types/jest": "~29.5.11",
	"@types/jsonwebtoken": "~9.0.5",
	"@types/node": "~16.18.69",
	"@types/react": "~18.3.18",
	"@types/react-dom": "~18.3.5",
	"@typescript-eslint/eslint-plugin": "~6.17.0",
	"@typescript-eslint/parser": "~6.17.0",
	"builtin-modules": "~3.3.0",
	chokidar: "~3.5.3",
	"conventional-changelog-cli": "~4.1.0",
	"convert-svg-to-png": "~0.6.4",
	electron: "37.6.0",
	"electron-builder": "26.0.3",
	"electron-devtools-installer": "^3.2.0",
	"electron-notarize": "^1.2.2",
	eslint: "~8.56.0",
	"eslint-config-prettier": "~9.1.0",
	"eslint-import-resolver-typescript": "~3.6.1",
	"eslint-plugin-import": "~2.26.0",
	"eslint-plugin-prettier": "~5.1.2",
	"eslint-plugin-react": "~7.33.2",
	"eslint-plugin-react-hooks": "~4.6.0",
	jest: "~29.7.0",
	"jest-environment-jsdom": "~29.7.0",
	jimp: "~0.22.10",
	"npm-run-all": "~4.1.5",
	"patch-package": "~8.0.0",
	prettier: "~3.2.5",
	puppeteer: "23.1.1",
	rollup: "~4.9.6",
	"rollup-plugin-copy": "~3.5.0",
	"ts-jest": "~29.1.4",
	"ts-node": "~10.9.2",
	typescript: "~5.7.3",
	"xvfb-maybe": "~0.2.1"
};
var optionalDependencies = {
	fsevents: "2.3.3"
};
var engines = {
	node: ">=22.17.1"
};
var devEngines = {
	node: ">=22.17.1",
	yarn: ">=4.0.2"
};
var resolutions = {
	"@fiahfy/icns-convert/sharp": "0.29.3",
	"@fiahfy/ico-convert/sharp": "0.29.3"
};
var volta = {
	node: "22.17.1",
	yarn: "4.0.2"
};
var packageManager = "yarn@4.6.0";
var packageJson = {
	"private": true,
	workspaces: workspaces,
	productName: productName,
	name: name,
	description: description,
	version: version,
	author: author,
	copyright: copyright,
	homepage: homepage,
	license: license,
	goUrlShortener: goUrlShortener,
	keywords: keywords,
	repository: repository,
	bugs: bugs,
	main: main$1,
	scripts: scripts,
	dependencies: dependencies,
	devDependencies: devDependencies,
	optionalDependencies: optionalDependencies,
	engines: engines,
	devEngines: devEngines,
	resolutions: resolutions,
	volta: volta,
	packageManager: packageManager
};

const JITSI_SERVER_CAPTURE_SCREEN_PERMISSION_UPDATED = 'jitsi-server-capture-screen-permission-updated';
const JITSI_SERVER_CAPTURE_SCREEN_PERMISSIONS_CLEARED = 'jitsi-server-capture-screen-permissions-cleared';

function _defineProperty(e, r, t) {
  return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
    value: t,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[r] = t, e;
}
function _toPrimitive(t, r) {
  if ("object" != typeof t || !t) return t;
  var e = t[Symbol.toPrimitive];
  if (void 0 !== e) {
    var i = e.call(t, r || "default");
    if ("object" != typeof i) return i;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}
function _toPropertyKey(t) {
  var i = _toPrimitive(t, "string");
  return "symbol" == typeof i ? i : i + "";
}

const isFSA = action => typeof action === 'object' && action !== null && !Array.isArray(action) && 'type' in action && typeof action.type === 'string';
const hasMeta = action => 'meta' in action && typeof action.meta === 'object' && action.meta !== null;
const isResponse = action => hasMeta(action) && action.meta.response === true;
const isLocallyScoped = action => hasMeta(action) && action.meta.scope === 'local';
const isSingleScoped = action => {
  var _ipcMeta, _ipcMeta2;
  return ((_ipcMeta = action.ipcMeta) === null || _ipcMeta === void 0 ? void 0 : _ipcMeta.webContentsId) && ((_ipcMeta2 = action.ipcMeta) === null || _ipcMeta2 === void 0 ? void 0 : _ipcMeta2.scope) === 'single';
};
const isErrored = action => 'meta' in action && action.error === true && action.payload instanceof Error;
const hasPayload = action => 'payload' in action;
const isResponseTo = (id, ...types) => action => isResponse(action) && types.includes(action.type) && action.meta.id === id;

const invoke = (webContents, channel, ...args) => new Promise((resolve, reject) => {
  const id = Math.random().toString(16).slice(2);
  electron.ipcMain.once(`${channel}@${id}`, (_, {
    resolved,
    rejected
  }) => {
    if (rejected) {
      const error = new Error(rejected.message);
      error.name = rejected.name;
      error.stack = rejected.stack;
      reject(error);
      return;
    }
    resolve(resolved);
  });
  webContents.send(channel, id, ...args);
});
const handle = (channel, handler) => {
  electron.ipcMain.handle(channel, (event, ...args) => handler(event.sender, ...args));
  return () => {
    electron.ipcMain.removeHandler(channel);
  };
};

var ActionScope = /*#__PURE__*/function (ActionScope) {
  ActionScope["LOCAL"] = "local";
  ActionScope["SINGLE"] = "single";
  return ActionScope;
}(ActionScope || {});
const forwardToRenderers = api => {
  const renderers = new Set();
  handle('redux/get-initial-state', async webContents => {
    renderers.add(webContents);
    webContents.addListener('destroyed', () => {
      renderers.delete(webContents);
    });
    return api.getState();
  });
  handle('redux/action-dispatched', async (webContents, action) => {
    var _webContents$hostWebC, _webContents$hostWebC2;
    api.dispatch({
      ...action,
      ipcMeta: {
        webContentsId: webContents.id,
        ...(((_webContents$hostWebC = webContents.hostWebContents) === null || _webContents$hostWebC === void 0 ? void 0 : _webContents$hostWebC.id) && {
          viewInstanceId: (_webContents$hostWebC2 = webContents.hostWebContents) === null || _webContents$hostWebC2 === void 0 ? void 0 : _webContents$hostWebC2.id
        }),
        ...action.ipcMeta
      }
    });
  });
  return next => action => {
    if (!isFSA(action) || isLocallyScoped(action)) {
      return next(action);
    }
    const rendererAction = {
      ...action,
      meta: {
        ...(hasMeta(action) && action.meta),
        scope: ActionScope.LOCAL
      }
    };
    if (isSingleScoped(action)) {
      const {
        webContentsId,
        viewInstanceId
      } = action.ipcMeta;
      [...renderers].filter(w => w.id === webContentsId || viewInstanceId && w.id === viewInstanceId).forEach(w => invoke(w, 'redux/action-dispatched', rendererAction));
      return next(action);
    }
    renderers.forEach(webContents => {
      invoke(webContents, 'redux/action-dispatched', rendererAction);
    });
    return next(action);
  };
};

const APP_PATH_SET = 'app/path-set';
const APP_VERSION_SET = 'app/version-set';
const APP_SETTINGS_LOADED = 'app/settings-loaded';
const APP_ALLOWED_NTLM_CREDENTIALS_DOMAINS_SET = 'app/allowed-ntlm-credentials-domains-set';
const APP_MAIN_WINDOW_TITLE_SET = 'app/main-window-title-set';
const APP_MACHINE_THEME_SET = 'app/machine-theme-set';
const APP_SCREEN_CAPTURE_FALLBACK_FORCED_SET = 'app/screen-capture-fallback-forced-set';

const allowedNTLMCredentialsDomains = (state = null, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          allowedNTLMCredentialsDomains = state
        } = action.payload;
        return allowedNTLMCredentialsDomains;
      }
    case APP_ALLOWED_NTLM_CREDENTIALS_DOMAINS_SET:
      {
        if (action.payload === null) return null;
        return action.payload;
      }
    default:
      return state;
  }
};

const appPath = (state = null, action) => {
  switch (action.type) {
    case APP_PATH_SET:
      return action.payload;
    default:
      return state;
  }
};

const appVersion = (state = null, action) => {
  switch (action.type) {
    case APP_VERSION_SET:
      return action.payload;
    default:
      return state;
  }
};

const machineTheme = (state = 'light', action) => {
  switch (action.type) {
    case APP_MACHINE_THEME_SET:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const mainWindowTitle = (state = null, action) => {
  switch (action.type) {
    case APP_MAIN_WINDOW_TITLE_SET:
      return action.payload;
    default:
      return state;
  }
};

const screenCaptureFallbackForced = (state = false, action) => {
  switch (action.type) {
    case APP_SCREEN_CAPTURE_FALLBACK_FORCED_SET:
      return action.payload;
    default:
      return state;
  }
};

const DOWNLOAD_CREATED = 'downloads/created';
const DOWNLOAD_REMOVED = 'downloads/removed';
const DOWNLOADS_CLEARED = 'downloads/cleared';
const DOWNLOAD_UPDATED = 'downloads/updated';

const DownloadStatus = {
  ALL: 'All',
  PAUSED: 'Paused',
  CANCELLED: 'Cancelled'
};

const downloads = (state = {}, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        var _action$payload$downl;
        const initDownloads = (_action$payload$downl = action.payload.downloads) !== null && _action$payload$downl !== void 0 ? _action$payload$downl : {};
        Object.values(initDownloads).forEach(value => {
          if (value.state === 'progressing' || value.state === 'paused') {
            value.state = 'cancelled';
            value.status = DownloadStatus.CANCELLED;
          }
        });
        return initDownloads !== null && initDownloads !== void 0 ? initDownloads : {};
      }
    case DOWNLOAD_CREATED:
      {
        const download = action.payload;
        return {
          ...state,
          [download.itemId]: download
        };
      }
    case DOWNLOAD_UPDATED:
      {
        const existingDownload = state[action.payload.itemId];
        if (!existingDownload) {
          return state; // Don't update if download doesn't exist
        }
        const newState = {
          ...state
        };
        newState[action.payload.itemId] = {
          ...existingDownload,
          ...action.payload
        };
        return newState;
      }
    case DOWNLOAD_REMOVED:
      {
        const newState = {
          ...state
        };
        delete newState[action.payload];
        return newState;
      }
    case DOWNLOADS_CLEARED:
      return {};
    default:
      return state;
  }
};

const allowedJitsiServers = (state = {}, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          allowedJitsiServers = {}
        } = action.payload;
        state = allowedJitsiServers;
        return state;
      }
    case JITSI_SERVER_CAPTURE_SCREEN_PERMISSION_UPDATED:
      {
        state = {
          ...state,
          [action.payload.jitsiServer]: action.payload.allowed
        };
        return state;
      }
    case JITSI_SERVER_CAPTURE_SCREEN_PERMISSIONS_CLEARED:
      {
        state = {};
        return state;
      }
    default:
      return state;
  }
};

const CERTIFICATES_CLEARED = 'certificates/cleared';
const CERTIFICATES_LOADED = 'certificates/loaded';
const CERTIFICATES_CLIENT_CERTIFICATE_REQUESTED = 'certificates/client-certificate-requested';
const TRUSTED_CERTIFICATES_UPDATED = 'trusted-certificates/updated';
const NOT_TRUSTED_CERTIFICATES_UPDATED = 'not-trusted-certificates/updated';
const SELECT_CLIENT_CERTIFICATE_DIALOG_CERTIFICATE_SELECTED = 'select-client-certificate-dialog/certificate-selected';
const SELECT_CLIENT_CERTIFICATE_DIALOG_DISMISSED = 'select-client-certificate-dialog/dismissed';
const EXTERNAL_PROTOCOL_PERMISSION_UPDATED = 'navigation/external-protocol-permission-updated';

const clientCertificates = (state = [], action) => {
  switch (action.type) {
    case CERTIFICATES_CLIENT_CERTIFICATE_REQUESTED:
      return action.payload;
    case SELECT_CLIENT_CERTIFICATE_DIALOG_CERTIFICATE_SELECTED:
    case SELECT_CLIENT_CERTIFICATE_DIALOG_DISMISSED:
      return [];
    default:
      return state;
  }
};
const trustedCertificates = (state = {}, action) => {
  switch (action.type) {
    case CERTIFICATES_LOADED:
    case TRUSTED_CERTIFICATES_UPDATED:
      return action.payload;
    case CERTIFICATES_CLEARED:
      return {};
    case APP_SETTINGS_LOADED:
      {
        const {
          trustedCertificates = state
        } = action.payload;
        return trustedCertificates;
      }
    default:
      return state;
  }
};
const notTrustedCertificates = (state = {}, action) => {
  switch (action.type) {
    case NOT_TRUSTED_CERTIFICATES_UPDATED:
      return action.payload;
    case CERTIFICATES_CLEARED:
      return {};
    case APP_SETTINGS_LOADED:
      {
        const {
          notTrustedCertificates = state
        } = action.payload;
        return notTrustedCertificates;
      }
    default:
      return state;
  }
};
const externalProtocols = (state = {}, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          externalProtocols = {}
        } = action.payload;
        state = externalProtocols;
        return state;
      }
    case EXTERNAL_PROTOCOL_PERMISSION_UPDATED:
      {
        state = {
          ...state,
          [action.payload.protocol]: action.payload.allowed
        };
        return state;
      }
    default:
      return state;
  }
};

const DEEP_LINKS_SERVER_ADDED = 'deep-links/server-added';
const DEEP_LINKS_SERVER_FOCUSED = 'deep-links/server-focused';

const OUTLOOK_CALENDAR_SET_CREDENTIALS = 'outlook-calendar/set-credentials';
const OUTLOOK_CALENDAR_ASK_CREDENTIALS = 'outlook-calendar/ask-credentials';
const OUTLOOK_CALENDAR_DIALOG_DISMISSED = 'outlook-calendar/dialog-dismissed';
const OUTLOOK_CALENDAR_SAVE_CREDENTIALS = 'outlook-calendar/save-credentials';

const ABOUT_DIALOG_DISMISSED = 'about-dialog/dismissed';
const ABOUT_DIALOG_TOGGLE_UPDATE_ON_START = 'about-dialog/toggle-update-on-start';
const ABOUT_DIALOG_UPDATE_CHANNEL_CHANGED = 'about-dialog/update-channel-changed';
const ADD_SERVER_VIEW_SERVER_ADDED = 'add-server/view-server-added';
const CLEAR_CACHE_TRIGGERED = 'clear-cache/triggered';
const CLEAR_CACHE_DIALOG_DELETE_LOGIN_DATA_CLICKED = 'clear-cache-dialog/delete-login-data-clicked';
const CLEAR_CACHE_DIALOG_KEEP_LOGIN_DATA_CLICKED = 'clear-cache-dialog/keep-login-data-clicked';
const LOADING_ERROR_VIEW_RELOAD_SERVER_CLICKED = 'loading-error-view/reload-server-clicked';
const MENU_BAR_ABOUT_CLICKED = 'menu-bar/about-clicked';
const MENU_BAR_ADD_NEW_SERVER_CLICKED = 'menu-bar/add-new-server-clicked';
const MENU_BAR_SELECT_SERVER_CLICKED = 'menu-bar/select-server-clicked';
const MENU_BAR_TOGGLE_IS_MENU_BAR_ENABLED_CLICKED = 'menu-bar/toggle-is-menu-bar-enabled-clicked';
const MENU_BAR_TOGGLE_IS_SHOW_WINDOW_ON_UNREAD_CHANGED_ENABLED_CLICKED = 'menu-bar/toggle-is-show-window-on-unread-changed-enabled-clicked';
const MENU_BAR_TOGGLE_IS_SIDE_BAR_ENABLED_CLICKED = 'menu-bar/toggle-is-side-bar-enabled-clicked';
const MENU_BAR_TOGGLE_IS_TRAY_ICON_ENABLED_CLICKED = 'menu-bar/toggle-is-tray-icon-enabled-clicked';
const MENU_BAR_TOGGLE_IS_DEVELOPER_MODE_ENABLED_CLICKED = 'menu-bar/toggle-is-developer-mode-enabled-clicked';
const MENU_BAR_TOGGLE_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CLICKED = 'menu-bar/toggle-is-video-call-devtools-auto-open-enabled-clicked';
const ROOT_WINDOW_ICON_CHANGED = 'root-window/icon-changed';
const ROOT_WINDOW_STATE_CHANGED = 'root-window/state-changed';
const VIDEO_CALL_WINDOW_STATE_CHANGED = 'video-call-window/state-changed';
const SIDE_BAR_ADD_NEW_SERVER_CLICKED = 'side-bar/add-new-server-clicked';
const SIDE_BAR_CONTEXT_MENU_TRIGGERED = 'side-bar/context-menu-triggered';
const SIDE_BAR_DOWNLOADS_BUTTON_CLICKED = 'side-bar/downloads-button-clicked';
const SIDE_BAR_SETTINGS_BUTTON_CLICKED = 'side-bar/settings-button-clicked';
const SIDE_BAR_REMOVE_SERVER_CLICKED = 'side-bar/remove-server-clicked';
const SIDE_BAR_SERVER_SELECTED = 'side-bar/server-selected';
const SIDE_BAR_SERVERS_SORTED = 'side-bar/servers-sorted';
const TOUCH_BAR_FORMAT_BUTTON_TOUCHED = 'touch-bar/format-button-touched';
const TOUCH_BAR_SELECT_SERVER_TOUCHED = 'touch-bar/select-server-touched';
const UPDATE_DIALOG_DISMISSED = 'update-dialog/dismissed';
const UPDATE_DIALOG_INSTALL_BUTTON_CLICKED = 'update-dialog/install-button-clicked';
const UPDATE_DIALOG_REMIND_UPDATE_LATER_CLICKED = 'update-dialog/remind-update-later-clicked';
const UPDATE_DIALOG_SKIP_UPDATE_CLICKED = 'update-dialog/skip-update-clicked';
const WEBVIEW_READY = 'webview/ready';
const WEBVIEW_ATTACHED = 'webview/attached';
const WEBVIEW_DID_FAIL_LOAD = 'webview/did-fail-load';
const WEBVIEW_DID_NAVIGATE = 'webview/did-navigate';
const WEBVIEW_DID_START_LOADING = 'webview/did-start-loading';
const WEBVIEW_FAVICON_CHANGED = 'webview/favicon-changed';
const WEBVIEW_FOCUS_REQUESTED = 'webview/focus-requested';
const WEBVIEW_MESSAGE_BOX_BLURRED = 'webview/message-box-blurred';
const WEBVIEW_MESSAGE_BOX_FOCUSED = 'webview/message-box-focused';
const WEBVIEW_SCREEN_SHARING_SOURCE_REQUESTED = 'webview/screen-sharing-source-requested';
const WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED = 'webview/screen-sharing-source-responded';
const WEBVIEW_SIDEBAR_STYLE_CHANGED = 'webview/sidebar-style-changed';
const WEBVIEW_SIDEBAR_CUSTOM_THEME_CHANGED = 'webview/sidebar-custom-theme-changed';
const WEBVIEW_GIT_COMMIT_HASH_CHANGED = 'webview/git-commit-hash-changed';
const WEBVIEW_GIT_COMMIT_HASH_CHECK = 'webview/git-commit-hash-check';
const WEBVIEW_TITLE_CHANGED = 'webview/title-changed';
const WEBVIEW_PAGE_TITLE_CHANGED = 'webview/page-title-changed';
const WEBVIEW_UNREAD_CHANGED = 'webview/unread-changed';
const WEBVIEW_USER_LOGGED_IN = 'webview/user-loggedin';
const WEBVIEW_USER_THEME_APPEARANCE_CHANGED = 'webview/user-theme-appearance-changed';
const WEBVIEW_ALLOWED_REDIRECTS_CHANGED = 'webview/allowed-redirects-changed';
const SETTINGS_SET_REPORT_OPT_IN_CHANGED = 'settings/set-bugsnag-opt-in-changed';
const SETTINGS_SET_FLASHFRAME_OPT_IN_CHANGED = 'settings/set-flashframe-opt-in-changed';
const SETTINGS_SET_HARDWARE_ACCELERATION_OPT_IN_CHANGED = 'settings/set-hardware-acceleration-opt-in-changed';
const SETTINGS_SET_INTERNALVIDEOCHATWINDOW_OPT_IN_CHANGED = 'settings/set-internalvideochatwindow-opt-in-changed';
const SETTINGS_SET_MINIMIZE_ON_CLOSE_OPT_IN_CHANGED = 'settings/set-minimize-on-close-opt-in-changed';
const SETTINGS_SET_IS_TRAY_ICON_ENABLED_CHANGED = 'settings/set-is-tray-icon-enabled-changed';
const SETTINGS_SET_IS_SIDE_BAR_ENABLED_CHANGED = 'settings/set-is-side-bar-enabled-changed';
const SETTINGS_SET_IS_MENU_BAR_ENABLED_CHANGED = 'settings/set-is-menu-bar-enabled-changed';
const SETTINGS_SET_IS_VIDEO_CALL_WINDOW_PERSISTENCE_ENABLED_CHANGED = 'settings/set-is-video-call-window-persistence-enabled-changed';
const SETTINGS_SET_IS_DEVELOPER_MODE_ENABLED_CHANGED = 'settings/set-is-developer-mode-enabled-changed';
const SETTINGS_SET_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CHANGED = 'settings/set-is-video-call-devtools-auto-open-enabled-changed';
const SETTINGS_SET_IS_VIDEO_CALL_SCREEN_CAPTURE_FALLBACK_ENABLED_CHANGED = 'settings/set-is-video-call-screen-capture-fallback-enabled-changed';
const SETTINGS_CLEAR_PERMITTED_SCREEN_CAPTURE_PERMISSIONS = 'settings/clear-permitted-screen-capture-permissions';
const SETTINGS_NTLM_CREDENTIALS_CHANGED = 'settings/ntlm-credentials-changed';
const SETTINGS_AVAILABLE_BROWSERS_UPDATED = 'settings/available-browsers-updated';
const SETTINGS_SELECTED_BROWSER_CHANGED = 'settings/selected-browser-changed';
const SET_HAS_TRAY_MINIMIZE_NOTIFICATION_SHOWN = 'notifications/set-has-tray-minimize-notification-shown';
const DOWNLOADS_BACK_BUTTON_CLICKED = 'downloads/back-button-clicked';
const WEBVIEW_SERVER_SUPPORTED_VERSIONS_UPDATED = 'webview/server-supported-versions-updated';
const WEBVIEW_SERVER_UNIQUE_ID_UPDATED = 'webview/server-workspace-uid-updated';
const WEBVIEW_SERVER_IS_SUPPORTED_VERSION = 'webview/server-is-supported-version';
const WEBVIEW_SERVER_SUPPORTED_VERSIONS_LOADING = 'webview/server-supported-versions-loading';
const WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR = 'webview/server-supported-versions-error';
const WEBVIEW_SERVER_VERSION_UPDATED = 'webview/version-updated';
const SUPPORTED_VERSION_DIALOG_DISMISS = 'supported-versions-dialog/dismiss';
const WEBVIEW_SERVER_RELOADED = 'webview/server-reloaded';
const WEBVIEW_PDF_VIEWER_ATTACHED = 'webview/pdf-viewer/attached';
const SIDE_BAR_SERVER_RELOAD = 'side-bar/server-reload';
const SIDE_BAR_SERVER_COPY_URL = 'side-bar/server-copy-url';
const SIDE_BAR_SERVER_OPEN_DEV_TOOLS = 'side-bar/server-open-dev-tools';
const SIDE_BAR_SERVER_FORCE_RELOAD = 'side-bar/server-force-reload';
const SIDE_BAR_SERVER_REMOVE = 'side-bar/server-remove';
const WEBVIEW_FORCE_RELOAD_WITH_CACHE_CLEAR = 'webview/force-reload-with-cache-clear';
const OPEN_SERVER_INFO_MODAL = 'server-info-modal/open';
const CLOSE_SERVER_INFO_MODAL = 'server-info-modal/close';

const SERVERS_LOADED = 'servers/loaded';
const SERVER_URL_RESOLUTION_REQUESTED = 'server/url-resolution-requested';
const SERVER_URL_RESOLVED = 'server/url-resolved';
const SERVER_DOCUMENT_VIEWER_OPEN_URL = 'server/document-viewer/open-url';

/* eslint-disable complexity */

const ensureUrlFormat = serverUrl => {
  if (serverUrl) {
    return new URL(serverUrl).href;
  }
  throw new Error('cannot handle null server URLs');
};
const upsert = (state, server) => {
  const index = state.findIndex(({
    url
  }) => url === server.url);
  if (index === -1) {
    return [...state, server];
  }
  return state.map((_server, i) => i === index ? {
    ..._server,
    ...server
  } : _server);
};
const update = (state, server) => {
  const index = state.findIndex(({
    url
  }) => url === server.url);
  if (index === -1) {
    return state;
  }
  return state.map((_server, i) => i === index ? {
    ..._server,
    ...server
  } : _server);
};
const servers = (state = [], action) => {
  switch (action.type) {
    case ADD_SERVER_VIEW_SERVER_ADDED:
    case DEEP_LINKS_SERVER_ADDED:
      {
        const url = action.payload;
        return upsert(state, {
          url,
          title: url
        });
      }
    case SIDE_BAR_REMOVE_SERVER_CLICKED:
      {
        const _url = action.payload;
        return state.filter(({
          url
        }) => url !== _url);
      }
    case SIDE_BAR_SERVERS_SORTED:
      {
        const urls = action.payload;
        return state.sort(({
          url: a
        }, {
          url: b
        }) => urls.indexOf(a) - urls.indexOf(b));
      }
    case WEBVIEW_TITLE_CHANGED:
      {
        const {
          url,
          title = url
        } = action.payload;
        return upsert(state, {
          url,
          title
        });
      }
    case WEBVIEW_PAGE_TITLE_CHANGED:
      {
        const {
          url,
          pageTitle
        } = action.payload;
        return upsert(state, {
          url,
          pageTitle
        });
      }
    case WEBVIEW_SERVER_SUPPORTED_VERSIONS_UPDATED:
      {
        const {
          url,
          supportedVersions,
          source
        } = action.payload;
        return upsert(state, {
          url,
          supportedVersions,
          supportedVersionsSource: source,
          supportedVersionsFetchState: 'success'
        });
      }
    case WEBVIEW_SERVER_SUPPORTED_VERSIONS_LOADING:
      {
        const {
          url
        } = action.payload;
        return upsert(state, {
          url,
          supportedVersionsFetchState: 'loading'
        });
      }
    case WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR:
      {
        const {
          url
        } = action.payload;
        return upsert(state, {
          url,
          supportedVersionsFetchState: 'error'
        });
      }
    case SUPPORTED_VERSION_DIALOG_DISMISS:
      {
        const {
          url
        } = action.payload;
        return upsert(state, {
          url,
          expirationMessageLastTimeShown: new Date()
        });
      }
    case WEBVIEW_SERVER_UNIQUE_ID_UPDATED:
      {
        const {
          url,
          uniqueID
        } = action.payload;
        return upsert(state, {
          url,
          uniqueID
        });
      }
    case WEBVIEW_USER_THEME_APPEARANCE_CHANGED:
      {
        const {
          url,
          themeAppearance
        } = action.payload;
        return upsert(state, {
          url,
          themeAppearance
        });
      }
    case WEBVIEW_SERVER_IS_SUPPORTED_VERSION:
      {
        const {
          url,
          isSupportedVersion
        } = action.payload;
        return upsert(state, {
          url,
          isSupportedVersion,
          supportedVersionsValidatedAt: new Date()
        });
      }
    case WEBVIEW_SERVER_VERSION_UPDATED:
      {
        const {
          url,
          version
        } = action.payload;
        return upsert(state, {
          url,
          version
        });
      }
    case WEBVIEW_UNREAD_CHANGED:
      {
        const {
          url,
          badge
        } = action.payload;
        return upsert(state, {
          url,
          badge
        });
      }
    case WEBVIEW_USER_LOGGED_IN:
      {
        const {
          url,
          userLoggedIn
        } = action.payload;
        return upsert(state, {
          url,
          userLoggedIn
        });
      }
    case WEBVIEW_ALLOWED_REDIRECTS_CHANGED:
      {
        const {
          url,
          allowedRedirects
        } = action.payload;
        return upsert(state, {
          url,
          allowedRedirects
        });
      }
    case WEBVIEW_SIDEBAR_STYLE_CHANGED:
      {
        const {
          url,
          style
        } = action.payload;
        return upsert(state, {
          url,
          style
        });
      }
    case WEBVIEW_SIDEBAR_CUSTOM_THEME_CHANGED:
      {
        const {
          url,
          customTheme
        } = action.payload;
        return upsert(state, {
          url,
          customTheme
        });
      }
    case WEBVIEW_GIT_COMMIT_HASH_CHANGED:
      {
        const {
          url,
          gitCommitHash
        } = action.payload;
        return upsert(state, {
          url,
          gitCommitHash
        });
      }
    case WEBVIEW_FAVICON_CHANGED:
      {
        const {
          url,
          favicon
        } = action.payload;
        return upsert(state, {
          url,
          favicon
        });
      }
    case WEBVIEW_DID_NAVIGATE:
      {
        const {
          url,
          pageUrl
        } = action.payload;
        if (pageUrl !== null && pageUrl !== void 0 && pageUrl.includes(url)) {
          return upsert(state, {
            url,
            lastPath: pageUrl
          });
        }
        return state;
      }
    case WEBVIEW_DID_START_LOADING:
      {
        const {
          url
        } = action.payload;
        return upsert(state, {
          url,
          failed: false
        });
      }
    case WEBVIEW_DID_FAIL_LOAD:
      {
        const {
          url,
          isMainFrame
        } = action.payload;
        if (isMainFrame) {
          return upsert(state, {
            url,
            failed: true
          });
        }
        return state;
      }
    case SERVERS_LOADED:
      {
        const {
          servers = state
        } = action.payload;
        return servers.map(server => ({
          ...server,
          url: ensureUrlFormat(server.url)
        }));
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          servers = state
        } = action.payload;
        return servers.map(server => ({
          ...server,
          url: ensureUrlFormat(server.url),
          documentViewerOpenUrl: ''
        }));
      }
    case WEBVIEW_READY:
      {
        const {
          url,
          webContentsId
        } = action.payload;
        return update(state, {
          url,
          webContentsId
        });
      }
    case WEBVIEW_ATTACHED:
      {
        const {
          url,
          webContentsId
        } = action.payload;
        return update(state, {
          url,
          webContentsId
        });
      }
    case OUTLOOK_CALENDAR_SAVE_CREDENTIALS:
      {
        const {
          url,
          outlookCredentials
        } = action.payload;
        return upsert(state, {
          url,
          outlookCredentials
        });
      }
    case SERVER_DOCUMENT_VIEWER_OPEN_URL:
      {
        const {
          server,
          documentUrl
        } = action.payload;
        return upsert(state, {
          url: server,
          documentViewerOpenUrl: documentUrl
        });
      }
    default:
      return state;
  }
};

const availableBrowsers = (state = [], action) => {
  switch (action.type) {
    case SETTINGS_AVAILABLE_BROWSERS_UPDATED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        return state;
      }
    default:
      return state;
  }
};

const currentView = (state = 'add-new-server', action) => {
  switch (action.type) {
    case ADD_SERVER_VIEW_SERVER_ADDED:
    case DEEP_LINKS_SERVER_ADDED:
    case DEEP_LINKS_SERVER_FOCUSED:
    case MENU_BAR_SELECT_SERVER_CLICKED:
    case TOUCH_BAR_SELECT_SERVER_TOUCHED:
    case SIDE_BAR_SERVER_SELECTED:
      {
        const url = action.payload;
        return {
          url
        };
      }
    case WEBVIEW_FOCUS_REQUESTED:
      {
        const {
          url,
          view
        } = action.payload;
        if (view === 'downloads') return 'downloads';
        return {
          url
        };
      }
    case SERVERS_LOADED:
      {
        const {
          selected
        } = action.payload;
        return selected ? {
          url: selected
        } : 'add-new-server';
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          currentView = state
        } = action.payload;
        return currentView;
      }
    case MENU_BAR_ADD_NEW_SERVER_CLICKED:
    case SIDE_BAR_ADD_NEW_SERVER_CLICKED:
      return 'add-new-server';
    case SIDE_BAR_REMOVE_SERVER_CLICKED:
      {
        if (typeof state === 'object' && state.url === action.payload) {
          return 'add-new-server';
        }
        return state;
      }
    case SIDE_BAR_DOWNLOADS_BUTTON_CLICKED:
      return 'downloads';
    case SIDE_BAR_SETTINGS_BUTTON_CLICKED:
      return 'settings';
    case DOWNLOADS_BACK_BUTTON_CLICKED:
      return {
        url: action.payload
      };
    default:
      return state;
  }
};

const initialServerInfoModalState = {
  isOpen: false,
  serverData: null
};
const serverInfoModal = (state = initialServerInfoModalState, action) => {
  switch (action.type) {
    case OPEN_SERVER_INFO_MODAL:
      return {
        isOpen: true,
        serverData: action.payload
      };
    case CLOSE_SERVER_INFO_MODAL:
      return initialServerInfoModalState;
    default:
      return state;
  }
};
const dialogs = (state = {
  serverInfoModal: initialServerInfoModalState
}, action) => {
  switch (action.type) {
    case OPEN_SERVER_INFO_MODAL:
    case CLOSE_SERVER_INFO_MODAL:
      return {
        ...state,
        serverInfoModal: serverInfoModal(state.serverInfoModal, action)
      };
    default:
      return state;
  }
};

const hasHideOnTrayNotificationShown = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.hasHideOnTrayNotificationShown);
    case SET_HAS_TRAY_MINIMIZE_NOTIFICATION_SHOWN:
      return action.payload;
    default:
      return state;
  }
};

const isAddNewServersEnabled = (state = true, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isAddNewServersEnabled);
    default:
      return state;
  }
};

const isDeveloperModeEnabled = (state = false, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_DEVELOPER_MODE_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_DEVELOPER_MODE_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isDeveloperModeEnabled = state
        } = action.payload;
        return isDeveloperModeEnabled;
      }
    default:
      return state;
  }
};

const UPDATE_SKIPPED = 'update/skipped';
const UPDATES_CHECK_FOR_UPDATES_REQUESTED = 'updates/check-for-updates-requested';
const UPDATES_CHECKING_FOR_UPDATE = 'updates/checking-for-update';
const UPDATES_ERROR_THROWN = 'updates/error-thrown';
const UPDATES_NEW_VERSION_AVAILABLE = 'updates/new-version-available';
const UPDATES_NEW_VERSION_NOT_AVAILABLE = 'updates/new-version-not-available';
const UPDATES_READY = 'updates/ready';
const UPDATES_CHANNEL_CHANGED = 'updates/channel-changed';

const isFlashFrameEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isFlashFrameEnabled);
    case UPDATES_READY:
      return action.payload.isFlashFrameEnabled;
    case SETTINGS_SET_FLASHFRAME_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isHardwareAccelerationEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isHardwareAccelerationEnabled);
    case UPDATES_READY:
      return action.payload.isHardwareAccelerationEnabled;
    case SETTINGS_SET_HARDWARE_ACCELERATION_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isInternalVideoChatWindowEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isInternalVideoChatWindowEnabled);
    case UPDATES_READY:
      return action.payload.isInternalVideoChatWindowEnabled;
    case SETTINGS_SET_INTERNALVIDEOCHATWINDOW_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isMenuBarEnabled = (state = true, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_MENU_BAR_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_MENU_BAR_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isMenuBarEnabled = state
        } = action.payload;
        return isMenuBarEnabled;
      }
    default:
      return state;
  }
};

const isMessageBoxFocused = (state = false, action) => {
  switch (action.type) {
    case WEBVIEW_MESSAGE_BOX_FOCUSED:
      return true;
    case WEBVIEW_DID_START_LOADING:
    case WEBVIEW_MESSAGE_BOX_BLURRED:
    case WEBVIEW_DID_FAIL_LOAD:
      return false;
    default:
      return state;
  }
};

const isMinimizeOnCloseEnabled = (state = process.platform === 'win32', action) => {
  switch (action.type) {
    case SETTINGS_SET_MINIMIZE_ON_CLOSE_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          isMinimizeOnCloseEnabled = state
        } = action.payload;
        return isMinimizeOnCloseEnabled;
      }
    default:
      return state;
  }
};

const isNTLMCredentialsEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          isNTLMCredentialsEnabled = state
        } = action.payload;
        return isNTLMCredentialsEnabled;
      }
    case SETTINGS_NTLM_CREDENTIALS_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isReportEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isReportEnabled);
    case UPDATES_READY:
      return action.payload.isReportEnabled;
    case SETTINGS_SET_REPORT_OPT_IN_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const isShowWindowOnUnreadChangedEnabled = (state = false, action) => {
  switch (action.type) {
    case MENU_BAR_TOGGLE_IS_SHOW_WINDOW_ON_UNREAD_CHANGED_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isShowWindowOnUnreadChangedEnabled = state
        } = action.payload;
        return isShowWindowOnUnreadChangedEnabled;
      }
    default:
      return state;
  }
};

const isSideBarEnabled = (state = true, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_SIDE_BAR_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_SIDE_BAR_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isSideBarEnabled = state
        } = action.payload;
        return isSideBarEnabled;
      }
    default:
      return state;
  }
};

const isTrayIconEnabled = (state = process.platform !== 'linux', action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_TRAY_ICON_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_TRAY_ICON_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isTrayIconEnabled = state
        } = action.payload;
        return isTrayIconEnabled;
      }
    default:
      return state;
  }
};

const isVideoCallDevtoolsAutoOpenEnabled = (state = false, action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CHANGED:
    case MENU_BAR_TOGGLE_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CLICKED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isVideoCallDevtoolsAutoOpenEnabled = state
        } = action.payload;
        return isVideoCallDevtoolsAutoOpenEnabled;
      }
    default:
      return state;
  }
};

const isVideoCallScreenCaptureFallbackEnabled = (state = false, action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      return Boolean(action.payload.isVideoCallScreenCaptureFallbackEnabled);
    case UPDATES_READY:
      {
        const {
          isVideoCallScreenCaptureFallbackEnabled = state
        } = action.payload;
        return isVideoCallScreenCaptureFallbackEnabled;
      }
    case SETTINGS_SET_IS_VIDEO_CALL_SCREEN_CAPTURE_FALLBACK_ENABLED_CHANGED:
      return action.payload;
    default:
      return state;
  }
};

const isVideoCallWindowPersistenceEnabled = (state = true,
// Enabled by default
action) => {
  switch (action.type) {
    case SETTINGS_SET_IS_VIDEO_CALL_WINDOW_PERSISTENCE_ENABLED_CHANGED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          isVideoCallWindowPersistenceEnabled = state
        } = action.payload;
        return isVideoCallWindowPersistenceEnabled;
      }
    default:
      return state;
  }
};

const lastSelectedServerUrl = (state = '', action) => {
  switch (action.type) {
    case APP_SETTINGS_LOADED:
      {
        const {
          lastSelectedServerUrl = state,
          servers
        } = action.payload;
        if (state === '' && servers && servers.length > 0) {
          return servers[0].url;
        }
        return lastSelectedServerUrl;
      }
    case SIDE_BAR_SERVER_SELECTED:
      return action.payload;
    default:
      return state;
  }
};

const SCREEN_SHARING_DIALOG_DISMISSED = 'screen-sharing-dialog/dismissed';

const openDialog = (state = null, action) => {
  switch (action.type) {
    case MENU_BAR_ABOUT_CLICKED:
      return 'about';
    case WEBVIEW_SCREEN_SHARING_SOURCE_REQUESTED:
      return 'screen-sharing';
    case UPDATES_NEW_VERSION_AVAILABLE:
      return 'update';
    case CERTIFICATES_CLIENT_CERTIFICATE_REQUESTED:
      return 'select-client-certificate';
    case ABOUT_DIALOG_DISMISSED:
      if (state === 'about') {
        return null;
      }
      return state;
    case OUTLOOK_CALENDAR_ASK_CREDENTIALS:
      return 'outlook-credentials';
    case SCREEN_SHARING_DIALOG_DISMISSED:
    case WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED:
    case SELECT_CLIENT_CERTIFICATE_DIALOG_CERTIFICATE_SELECTED:
    case SELECT_CLIENT_CERTIFICATE_DIALOG_DISMISSED:
    case UPDATE_DIALOG_DISMISSED:
    case UPDATE_DIALOG_SKIP_UPDATE_CLICKED:
    case UPDATE_DIALOG_REMIND_UPDATE_LATER_CLICKED:
    case UPDATE_DIALOG_INSTALL_BUTTON_CLICKED:
    case OUTLOOK_CALENDAR_DIALOG_DISMISSED:
    case OUTLOOK_CALENDAR_SET_CREDENTIALS:
      return null;
    default:
      return state;
  }
};

const rootWindowIcon = (state = null, action) => {
  switch (action.type) {
    case ROOT_WINDOW_ICON_CHANGED:
      {
        return action.payload;
      }
    default:
      return state;
  }
};

const rootWindowState = (state = {
  focused: true,
  visible: true,
  maximized: false,
  minimized: false,
  fullscreen: false,
  normal: true,
  bounds: {
    x: undefined,
    y: undefined,
    width: 1000,
    height: 600
  }
}, action) => {
  switch (action.type) {
    case ROOT_WINDOW_STATE_CHANGED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          rootWindowState = state
        } = action.payload;
        return rootWindowState;
      }
    default:
      return state;
  }
};

const selectedBrowser = (state = null, action) => {
  switch (action.type) {
    case SETTINGS_SELECTED_BROWSER_CHANGED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          selectedBrowser = state
        } = action.payload;
        return selectedBrowser;
      }
    default:
      return state;
  }
};

const videoCallWindowState = (state = {
  focused: true,
  visible: true,
  maximized: false,
  minimized: false,
  fullscreen: false,
  normal: true,
  bounds: {
    x: undefined,
    y: undefined,
    width: 0,
    height: 0
  }
}, action) => {
  switch (action.type) {
    case VIDEO_CALL_WINDOW_STATE_CHANGED:
      return action.payload;
    case APP_SETTINGS_LOADED:
      {
        const {
          videoCallWindowState = state
        } = action.payload;
        return videoCallWindowState;
      }
    default:
      return state;
  }
};

const doCheckForUpdatesOnStartup = (state = true, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          doCheckForUpdatesOnStartup
        } = action.payload;
        return doCheckForUpdatesOnStartup;
      }
    case ABOUT_DIALOG_TOGGLE_UPDATE_ON_START:
      {
        const doCheckForUpdatesOnStartup = action.payload;
        return doCheckForUpdatesOnStartup;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          doCheckForUpdatesOnStartup = state
        } = action.payload;
        return doCheckForUpdatesOnStartup;
      }
    default:
      return state;
  }
};
const isCheckingForUpdates = (state = false, action) => {
  switch (action.type) {
    case UPDATES_CHECKING_FOR_UPDATE:
      return true;
    case UPDATES_ERROR_THROWN:
      return false;
    case UPDATES_NEW_VERSION_NOT_AVAILABLE:
      return false;
    case UPDATES_NEW_VERSION_AVAILABLE:
      return false;
    default:
      return state;
  }
};
const isEachUpdatesSettingConfigurable = (state = true, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          isEachUpdatesSettingConfigurable
        } = action.payload;
        return isEachUpdatesSettingConfigurable;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          isEachUpdatesSettingConfigurable = state
        } = action.payload;
        return isEachUpdatesSettingConfigurable;
      }
    default:
      return state;
  }
};
const isUpdatingAllowed = (state = true, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          isUpdatingAllowed
        } = action.payload;
        return isUpdatingAllowed;
      }
    default:
      return state;
  }
};
const isUpdatingEnabled = (state = true, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          isUpdatingEnabled
        } = action.payload;
        return isUpdatingEnabled;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          isUpdatingEnabled = state
        } = action.payload;
        return isUpdatingEnabled;
      }
    default:
      return state;
  }
};
const newUpdateVersion = (state = null, action) => {
  switch (action.type) {
    case UPDATES_NEW_VERSION_AVAILABLE:
      {
        const newUpdateVersion = action.payload;
        return newUpdateVersion;
      }
    case UPDATES_NEW_VERSION_NOT_AVAILABLE:
    case UPDATE_SKIPPED:
      {
        return null;
      }
    default:
      return state;
  }
};
const skippedUpdateVersion = (state = null, action) => {
  switch (action.type) {
    case UPDATES_READY:
      {
        const {
          skippedUpdateVersion
        } = action.payload;
        return skippedUpdateVersion;
      }
    case UPDATE_SKIPPED:
      {
        const skippedUpdateVersion = action.payload;
        return skippedUpdateVersion;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          skippedUpdateVersion = state
        } = action.payload;
        return skippedUpdateVersion;
      }
    default:
      return state;
  }
};
const updateError = (state = null, action) => {
  switch (action.type) {
    case UPDATES_CHECKING_FOR_UPDATE:
      return null;
    case UPDATES_ERROR_THROWN:
      return action.payload;
    case UPDATES_NEW_VERSION_NOT_AVAILABLE:
      return null;
    case UPDATES_NEW_VERSION_AVAILABLE:
      return null;
    default:
      return state;
  }
};
const updateChannel = (state = 'latest', action) => {
  switch (action.type) {
    case ABOUT_DIALOG_UPDATE_CHANNEL_CHANGED:
    case UPDATES_CHANNEL_CHANGED:
      {
        return action.payload;
      }
    case UPDATES_READY:
      {
        const {
          updateChannel
        } = action.payload;
        return updateChannel;
      }
    case APP_SETTINGS_LOADED:
      {
        const {
          updateChannel = state
        } = action.payload;
        return updateChannel;
      }
    default:
      return state;
  }
};

const rootReducer = redux.combineReducers({
  allowedJitsiServers,
  appPath,
  appVersion,
  availableBrowsers,
  clientCertificates,
  currentView,
  dialogs,
  doCheckForUpdatesOnStartup,
  downloads,
  externalProtocols,
  isCheckingForUpdates,
  isEachUpdatesSettingConfigurable,
  isMenuBarEnabled,
  isMessageBoxFocused,
  isShowWindowOnUnreadChangedEnabled,
  isSideBarEnabled,
  isTrayIconEnabled,
  isMinimizeOnCloseEnabled,
  isUpdatingAllowed,
  isUpdatingEnabled,
  mainWindowTitle,
  machineTheme,
  newUpdateVersion,
  openDialog,
  rootWindowIcon,
  rootWindowState,
  selectedBrowser,
  servers,
  skippedUpdateVersion,
  trustedCertificates,
  notTrustedCertificates,
  updateError,
  isReportEnabled,
  isFlashFrameEnabled,
  isHardwareAccelerationEnabled,
  isInternalVideoChatWindowEnabled,
  isAddNewServersEnabled,
  hasHideOnTrayNotificationShown,
  lastSelectedServerUrl,
  allowedNTLMCredentialsDomains,
  isNTLMCredentialsEnabled,
  videoCallWindowState,
  isVideoCallWindowPersistenceEnabled,
  isDeveloperModeEnabled,
  updateChannel,
  screenCaptureFallbackForced,
  isVideoCallDevtoolsAutoOpenEnabled,
  isVideoCallScreenCaptureFallbackEnabled
});

let reduxStore;
let lastAction;
const catchLastAction = () => next => action => {
  lastAction = action;
  return next(action);
};
const createMainReduxStore = () => {
  const middlewares = redux.applyMiddleware(catchLastAction, forwardToRenderers);
  reduxStore = redux.createStore(rootReducer, {}, middlewares);
};
const dispatch = action => {
  reduxStore.dispatch(action);
};
const dispatchSingle = action => {
  reduxStore.dispatch({
    ...action,
    ipcMeta: {
      ...action.ipcMeta,
      scope: 'single'
    }
  });
};
const dispatchLocal = action => {
  reduxStore.dispatch({
    ...action,
    ipcMeta: {
      ...action.ipcMeta,
      scope: 'local'
    },
    meta: {
      scope: 'local'
    }
  });
};
const select = selector => selector(reduxStore.getState());
const watch = (selector, watcher) => {
  const initial = select(selector);
  watcher(initial, undefined);
  let prev = initial;
  return reduxStore.subscribe(() => {
    const curr = select(selector);
    if (Object.is(prev, curr)) {
      return;
    }
    watcher(curr, prev);
    prev = curr;
  });
};
const listen = (typeOrPredicate, listener) => {
  const effectivePredicate = typeof typeOrPredicate === 'function' ? typeOrPredicate : action => action.type === typeOrPredicate;
  return reduxStore.subscribe(() => {
    if (!effectivePredicate(lastAction)) {
      return;
    }
    listener(lastAction);
  });
};
class Service {
  constructor() {
    _defineProperty(this, "unsubscribers", new Set());
  }
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  initialize() {}

  // eslint-disable-next-line @typescript-eslint/no-empty-function
  destroy() {}
  watch(selector, watcher) {
    this.unsubscribers.add(watch(selector, watcher));
  }

  // eslint-disable-next-line no-dupe-class-members

  // eslint-disable-next-line no-dupe-class-members
  listen(typeOrPredicate, listener) {
    if (typeof typeOrPredicate === 'string') {
      this.unsubscribers.add(listen(typeOrPredicate, listener));
      return;
    }
    this.unsubscribers.add(listen(typeOrPredicate, listener));
  }
  setUp() {
    this.initialize();
  }
  tearDown() {
    this.unsubscribers.forEach(unsubscribe => unsubscribe());
    this.destroy();
  }
}

// const isResponseTo = <Response extends RootAction>(id: unknown, type: Response['type']) =>
//   (action: RootAction): action is Response =>
//     isResponse(action) && action.type === type && action.meta.id === id;

const request = (requestAction, ...types) => new Promise((resolve, reject) => {
  const id = Math.random().toString(36).slice(2);
  const unsubscribe = listen(isResponseTo(id, ...types), action => {
    unsubscribe();
    if (isErrored(action)) {
      reject(action.payload);
      return;
    }
    if (hasPayload(action)) {
      resolve(action.payload);
    }
  });
  dispatch({
    ...requestAction,
    meta: {
      request: true,
      id
    }
  });
});

const readSetting = key => {
  try {
    const filePath = path__default.default.join(electron.app.getPath('userData'), 'config.json');
    const content = fs__default.default.readFileSync(filePath, 'utf8');
    const json = JSON.parse(content);
    return json[key];
  } catch (e) {
    return null;
  }
};

const selectGlobalBadge = ({
  servers
}) => {
  const badges = servers.map(({
    badge
  }) => badge);
  const mentionCount = badges.filter(badge => Number.isInteger(badge)).reduce((sum, count) => sum + count, 0);
  return mentionCount || badges.some(badge => !!badge) && '•' || undefined;
};
const selectGlobalBadgeText = reselect.createSelector(selectGlobalBadge, badge => {
  if (badge === '•') {
    return '•';
  }
  if (Number.isInteger(badge)) {
    return String(badge);
  }
  return '';
});
const isBadgeCount = badge => Number.isInteger(badge);
const selectGlobalBadgeCount = reselect.createSelector(selectGlobalBadge, badge => isBadgeCount(badge) ? badge : 0);

function debounce(cb, wait = 20) {
  let h;
  const callable = (...args) => {
    h && clearTimeout(h);
    h = setTimeout(() => cb(...args), wait);
  };
  return callable;
}

const getAppIconPath = ({
  platform
}) => {
  if (platform !== 'win32') {
    throw Error('only win32 platform is supported');
  }
  return `${electron.app.getAppPath()}/app/images/icon.ico`;
};
const getMacOSTrayIconPath = badge => path__default.default.join(electron.app.getAppPath(), `app/images/tray/darwin/${badge ? 'notification' : 'default'}Template.png`);
const getWindowsTrayIconPath = badge => {
  const name = !badge && 'default' || badge === '•' && 'notification-dot' || typeof badge === 'number' && badge > 9 && 'notification-plus-9' || `notification-${badge}`;
  return path__default.default.join(electron.app.getAppPath(), `app/images/tray/win32/${name}.ico`);
};
const getLinuxTrayIconPath = badge => {
  const name = !badge && 'default' || badge === '•' && 'notification-dot' || typeof badge === 'number' && badge > 9 && 'notification-plus-9' || `notification-${badge}`;
  return path__default.default.join(electron.app.getAppPath(), `app/images/tray/linux/${name}.png`);
};
const getTrayIconPath = ({
  badge,
  platform
}) => {
  switch (platform !== null && platform !== void 0 ? platform : process.platform) {
    case 'darwin':
      return getMacOSTrayIconPath(badge);
    case 'win32':
      return getWindowsTrayIconPath(badge);
    case 'linux':
      return getLinuxTrayIconPath(badge);
    default:
      throw Error(`unsupported platform (${platform})`);
  }
};

const webPreferences = {
  nodeIntegration: true,
  nodeIntegrationInSubFrames: true,
  contextIsolation: false,
  webviewTag: true
};
const selectRootWindowState = ({
  rootWindowState
}) => rootWindowState !== null && rootWindowState !== void 0 ? rootWindowState : {
  bounds: {
    x: 0,
    y: 0,
    width: 0,
    height: 0
  },
  focused: false,
  fullscreen: false,
  maximized: false,
  minimized: false,
  normal: false,
  visible: false
};
let _rootWindow;
let tempWindow;
const getRootWindow = () => new Promise((resolve, reject) => {
  setTimeout(() => {
    if (!_rootWindow) {
      reject(new Error('Root window not initialized'));
      return;
    }
    if (_rootWindow.isDestroyed()) {
      reject(new Error('Root window has been destroyed'));
      return;
    }
    resolve(_rootWindow);
  }, 300);
});
const platformTitleBarStyle = process.platform === 'darwin' ? 'hidden' : 'default';
const createRootWindow = () => {
  _rootWindow = new electron.BrowserWindow({
    width: 1000,
    height: 600,
    minWidth: 400,
    minHeight: 400,
    titleBarStyle: platformTitleBarStyle,
    backgroundColor: '#2f343d',
    show: false,
    webPreferences
  });

  // Block navigation to smb:// protocol
  _rootWindow.webContents.on('will-navigate', (event, url) => {
    if (typeof url === 'string' && url.toLowerCase().startsWith('smb://')) {
      event.preventDefault();
    }
  });
  _rootWindow.webContents.setWindowOpenHandler(({
    url
  }) => {
    if (url.toLowerCase().startsWith('smb://')) {
      return {
        action: 'deny'
      };
    }
    return {
      action: 'allow'
    };
  });
  _rootWindow.addListener('close', event => {
    event.preventDefault();
  });
  tempWindow.destroy();
};
const normalizeNumber = value => value && isFinite(1 / value) ? value : 0;
const isInsideSomeScreen = ({
  x,
  y,
  width,
  height
}) => electron.screen.getAllDisplays().some(({
  bounds
}) => x >= bounds.x && y >= bounds.y && x + width <= bounds.x + bounds.width && y + height <= bounds.y + bounds.height);
const applyRootWindowState = browserWindow => {
  const rootWindowState = select(selectRootWindowState);
  const isTrayIconEnabled = select(({
    isTrayIconEnabled
  }) => isTrayIconEnabled);
  let {
    x = null,
    y = null
  } = rootWindowState.bounds;
  let {
    width,
    height
  } = rootWindowState.bounds;
  if (x === null || y === null || !isInsideSomeScreen({
    x,
    y,
    width,
    height
  })) {
    const primaryDisplay = electron.screen.getPrimaryDisplay();
    const {
      bounds: {
        width: primaryDisplayWidth,
        height: primaryDisplayHeight
      }
    } = primaryDisplay;
    x = Math.round((primaryDisplayWidth - width) / 2);
    y = Math.round((primaryDisplayHeight - height) / 2);
    width = normalizeNumber(primaryDisplay.workAreaSize.width * 0.9);
    height = normalizeNumber(primaryDisplay.workAreaSize.height * 0.9);
  }
  if (browserWindow.isVisible()) {
    return;
  }
  x = normalizeNumber(x);
  y = normalizeNumber(y);
  width = normalizeNumber(width);
  height = normalizeNumber(height);
  if (browserWindow && Number.isInteger(width) && Number.isInteger(height) && Number.isInteger(x) && Number.isInteger(y)) {
    browserWindow.setBounds({
      width,
      height,
      x,
      y
    });
  }
  if (rootWindowState.maximized) {
    browserWindow.maximize();
  }
  if (rootWindowState.minimized) {
    browserWindow.minimize();
  }
  if (rootWindowState.fullscreen) {
    browserWindow.setFullScreen(true);
  }
  if (rootWindowState.visible || !isTrayIconEnabled) {
    browserWindow.show();
  }
  if (rootWindowState.focused) {
    browserWindow.focus();
  }
};
const fetchRootWindowState = async () => {
  const browserWindow = await getRootWindow();
  return {
    focused: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isFocused(),
    visible: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isVisible(),
    maximized: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isMaximized(),
    minimized: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isMinimized(),
    fullscreen: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isFullScreen(),
    normal: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.isNormal(),
    bounds: browserWindow === null || browserWindow === void 0 ? void 0 : browserWindow.getNormalBounds()
  };
};
const setupRootWindow = () => {
  const safeWindowOperation = async (operation, operationName) => {
    try {
      const window = await getRootWindow();
      if (window.isDestroyed()) {
        return;
      }
      return await operation(window);
    } catch (error) {
    }
  };
  const unsubscribers = [watch(selectGlobalBadgeCount, async globalBadgeCount => {
    await safeWindowOperation(async browserWindow => {
      if (browserWindow.isFocused() || globalBadgeCount === 0) {
        return;
      }
      const {
        isShowWindowOnUnreadChangedEnabled,
        isFlashFrameEnabled
      } = select(({
        isShowWindowOnUnreadChangedEnabled,
        isFlashFrameEnabled
      }) => ({
        isShowWindowOnUnreadChangedEnabled,
        isFlashFrameEnabled
      }));
      if (isShowWindowOnUnreadChangedEnabled && !browserWindow.isVisible()) {
        const isMinimized = browserWindow.isMinimized();
        const isMaximized = browserWindow.isMaximized();
        browserWindow.showInactive();
        if (isMinimized) {
          browserWindow.minimize();
        }
        if (isMaximized) {
          browserWindow.maximize();
        }
        return;
      }
      if (isFlashFrameEnabled && process.platform !== 'darwin') {
        browserWindow.flashFrame(true);
      }
    });
  }), watch(({
    currentView,
    servers
  }) => {
    const currentServer = typeof currentView === 'object' ? servers.find(({
      url
    }) => url === currentView.url) : null;
    return (currentServer === null || currentServer === void 0 ? void 0 : currentServer.pageTitle) || (currentServer === null || currentServer === void 0 ? void 0 : currentServer.title) || electron.app.name;
  }, async windowTitle => {
    await safeWindowOperation(browserWindow => {
      browserWindow.setTitle(windowTitle);
      dispatch({
        type: APP_MAIN_WINDOW_TITLE_SET,
        payload: windowTitle
      });
    });
  }), listen(WEBVIEW_FOCUS_REQUESTED, async () => {
    await safeWindowOperation(rootWindow => {
      rootWindow.focus();
      rootWindow.show();
    });
  })];
  const fetchAndDispatchWindowState = debounce(async () => {
    try {
      const state = await fetchRootWindowState();
      dispatchLocal({
        type: ROOT_WINDOW_STATE_CHANGED,
        payload: state
      });
    } catch (error) {
    }
  }, 1000);
  getRootWindow().then(rootWindow => {
    rootWindow.addListener('show', fetchAndDispatchWindowState);
    rootWindow.addListener('hide', fetchAndDispatchWindowState);
    rootWindow.addListener('focus', fetchAndDispatchWindowState);
    rootWindow.addListener('blur', fetchAndDispatchWindowState);
    rootWindow.addListener('maximize', fetchAndDispatchWindowState);
    rootWindow.addListener('unmaximize', fetchAndDispatchWindowState);
    rootWindow.addListener('minimize', fetchAndDispatchWindowState);
    rootWindow.addListener('restore', fetchAndDispatchWindowState);
    rootWindow.addListener('resize', fetchAndDispatchWindowState);
    rootWindow.addListener('move', fetchAndDispatchWindowState);
    fetchAndDispatchWindowState();
    rootWindow.addListener('focus', async () => {
      rootWindow.flashFrame(false);
    });
    rootWindow.addListener('close', async event => {
      try {
        if (rootWindow.isDestroyed()) {
          return;
        }
        if (rootWindow.isFullScreen()) {
          await new Promise(resolve => rootWindow.once('leave-full-screen', () => resolve()));
          rootWindow.setFullScreen(false);
        }
        if (process.platform !== 'linux' && !rootWindow.isDestroyed()) {
          rootWindow.blur();
        }
        let isTrayIconEnabled;
        let isMinimizeOnCloseEnabled;
        try {
          isTrayIconEnabled = select(({
            isTrayIconEnabled
          }) => isTrayIconEnabled !== null && isTrayIconEnabled !== void 0 ? isTrayIconEnabled : true);
          isMinimizeOnCloseEnabled = select(({
            isMinimizeOnCloseEnabled
          }) => isMinimizeOnCloseEnabled !== null && isMinimizeOnCloseEnabled !== void 0 ? isMinimizeOnCloseEnabled : true);
        } catch (error) {
          console.warn('Failed to access application state during close:', error);
          isTrayIconEnabled = true;
          isMinimizeOnCloseEnabled = true;
        }
        if (process.platform === 'darwin' || isTrayIconEnabled) {
          if (!rootWindow.isDestroyed()) {
            rootWindow.hide();
          }
          return;
        }
        if (process.platform === 'win32' && isMinimizeOnCloseEnabled) {
          if (!rootWindow.isDestroyed()) {
            rootWindow.minimize();
          }
          return;
        }

        // Prevent race condition: window destruction during app.quit()
        event.preventDefault();
        electron.app.quit();
      } catch (error) {
        console.error('Error in close event handler:', error);
        event.preventDefault();
        electron.app.quit();
      }
    });
    unsubscribers.push(() => {
      try {
        if (rootWindow && !rootWindow.isDestroyed()) {
          rootWindow.removeAllListeners();
          setImmediate(() => {
            if (rootWindow && !rootWindow.isDestroyed()) {
              rootWindow.close();
            }
          });
        }
      } catch (error) {
        console.error('Error during root window cleanup:', error);
      }
    });
  });
  if (process.platform === 'linux' || process.platform === 'win32') {
    const selectRootWindowIcon = reselect.createStructuredSelector({
      globalBadge: selectGlobalBadge,
      rootWindowIcon: ({
        rootWindowIcon
      }) => rootWindowIcon
    });
    unsubscribers.push(watch(selectRootWindowIcon, async ({
      globalBadge,
      rootWindowIcon
    }) => {
      await safeWindowOperation(async browserWindow => {
        if (!rootWindowIcon) {
          browserWindow.setIcon(electron.nativeImage.createFromPath(getTrayIconPath({
            platform: process.platform,
            badge: globalBadge
          })));
          return;
        }
        const icon = electron.nativeImage.createEmpty();
        const {
          scaleFactor
        } = electron.screen.getPrimaryDisplay();
        if (process.platform === 'linux') {
          rootWindowIcon.icon.forEach(representation => {
            icon.addRepresentation({
              ...representation,
              scaleFactor
            });
          });
        }
        if (process.platform === 'win32') {
          for (const representation of rootWindowIcon.icon) {
            var _representation$width;
            icon.addRepresentation({
              ...representation,
              scaleFactor: Math.max(((_representation$width = representation.width) !== null && _representation$width !== void 0 ? _representation$width : 0) / 32, 1)
            });
          }
        }
        browserWindow.setIcon(icon);
        if (process.platform === 'win32') {
          let overlayIcon = null;
          const overlayDescription = typeof globalBadge === 'number' && i18next__default.default.t('unreadMention', {
            appName: electron.app.name,
            count: globalBadge
          }) || globalBadge === '•' && i18next__default.default.t('unreadMessage', {
            appName: electron.app.name
          }) || i18next__default.default.t('noUnreadMessage', {
            appName: electron.app.name
          });
          if (rootWindowIcon.overlay) {
            overlayIcon = electron.nativeImage.createEmpty();
            for (const representation of rootWindowIcon.overlay) {
              overlayIcon.addRepresentation({
                ...representation,
                scaleFactor: 1
              });
            }
          }
          const isTrayIconEnabled = select(({
            isTrayIconEnabled
          }) => isTrayIconEnabled !== null && isTrayIconEnabled !== void 0 ? isTrayIconEnabled : true);
          if (!isTrayIconEnabled) {
            const t = i18next__default.default.t.bind(i18next__default.default);
            const translate = `taskbar.${overlayDescription}`;
            const taskbarTitle = globalBadge !== undefined ? `(${globalBadge}) ${t(translate)}` : t(translate);
            browserWindow.setTitle(taskbarTitle);
          }
          browserWindow.setOverlayIcon(overlayIcon, overlayDescription);
        }
      });
    }), watch(({
      isMenuBarEnabled
    }) => isMenuBarEnabled, async isMenuBarEnabled => {
      await safeWindowOperation(browserWindow => {
        browserWindow.autoHideMenuBar = !isMenuBarEnabled;
        browserWindow.setMenuBarVisibility(isMenuBarEnabled);
      });
    }));
  }
  electron.app.addListener('before-quit', () => {
    unsubscribers.forEach(unsubscriber => {
      try {
        unsubscriber();
      } catch (error) {
        console.warn('Unsubscriber error during quit:', error);
      }
    });
  });
};
const ensureWindowsMediaRegistration = async () => {
  if (process.platform !== 'win32') {
    return;
  }
  try {
    const browserWindow = await getRootWindow();
    await browserWindow.webContents.executeJavaScript(`
      if (!window._rocketChatMediaRegistered) {
        window._rocketChatMediaRegistered = true;
        navigator.mediaDevices.getUserMedia({ audio: true, video: false })
          .then(() => console.log('Media access registered with Windows'))
          .catch(() => console.log('Media registration attempted'));
      }
    `);
  } catch (error) {
    console.log('Media registration failed:', error);
  }
};
const showRootWindow = async () => {
  const browserWindow = await getRootWindow();
  browserWindow.loadFile(path__default.default.join(electron.app.getAppPath(), 'app/index.html'));
  return new Promise(resolve => {
    browserWindow.once('ready-to-show', () => {
      applyRootWindowState(browserWindow);
      const isTrayIconEnabled = select(({
        isTrayIconEnabled
      }) => isTrayIconEnabled);
      if (electron.app.commandLine.hasSwitch('start-hidden') && isTrayIconEnabled) {
        console.debug('Start application in background');
        browserWindow.hide();
      }
      setupRootWindow();
      ensureWindowsMediaRegistration();
      resolve();
    });
  });
};
const watchMachineTheme = () => {
  dispatchMachineTheme();
  electron.nativeTheme.on('updated', () => {
    dispatchMachineTheme();
  });
};
const dispatchMachineTheme = () => {
  const isDarkMode = electron.nativeTheme.shouldUseDarkColors;
  dispatch({
    type: APP_MACHINE_THEME_SET,
    payload: isDarkMode ? 'dark' : 'light'
  });
};
const exportLocalStorage = async () => {
  try {
    tempWindow = new electron.BrowserWindow({
      show: false,
      webPreferences
    });
    tempWindow.loadFile(path__default.default.join(electron.app.getAppPath(), 'app/index.html'));
    await new Promise(resolve => {
      tempWindow.once('ready-to-show', () => {
        resolve();
      });
    });
    return tempWindow.webContents.executeJavaScript(`(() => {
      const data = ({...localStorage})
      localStorage.clear();
      return data;
    })()`);
  } catch (error) {
    console.error(error);
    return {};
  }
};

const t$7 = i18next__default.default.t.bind(i18next__default.default);
const askForAppDataReset = async parentWindow => {
  parentWindow === null || parentWindow === void 0 || parentWindow.show();
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'question',
    buttons: [t$7('dialog.resetAppData.yes'), t$7('dialog.resetAppData.cancel')],
    defaultId: 1,
    title: t$7('dialog.resetAppData.title'),
    message: t$7('dialog.resetAppData.message')
  });
  return response === 0;
};
const askForServerAddition = async (serverUrl, parentWindow) => {
  parentWindow === null || parentWindow === void 0 || parentWindow.show();
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'question',
    buttons: [t$7('dialog.addServer.add'), t$7('dialog.addServer.cancel')],
    defaultId: 0,
    title: t$7('dialog.addServer.title'),
    message: t$7('dialog.addServer.message', {
      host: serverUrl
    })
  });
  return response === 0;
};
const warnAboutInvalidServerUrl = (_serverUrl, _reason, _parentWindow) => {
  // TODO
  throw Error('not implemented');
};
let AskUpdateInstallResponse = /*#__PURE__*/function (AskUpdateInstallResponse) {
  AskUpdateInstallResponse[AskUpdateInstallResponse["INSTALL_LATER"] = 0] = "INSTALL_LATER";
  AskUpdateInstallResponse[AskUpdateInstallResponse["INSTALL_NOW"] = 1] = "INSTALL_NOW";
  return AskUpdateInstallResponse;
}({});
const askUpdateInstall = async parentWindow => {
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'question',
    title: t$7('dialog.updateReady.title'),
    message: t$7('dialog.updateReady.message'),
    buttons: [t$7('dialog.updateReady.installLater'), t$7('dialog.updateReady.installNow')],
    defaultId: 1
  });
  if (response === 1) {
    return AskUpdateInstallResponse.INSTALL_NOW;
  }
  return AskUpdateInstallResponse.INSTALL_LATER;
};
const warnAboutInstallUpdateLater = async parentWindow => {
  await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'info',
    title: t$7('dialog.updateInstallLater.title'),
    message: t$7('dialog.updateInstallLater.message'),
    buttons: [t$7('dialog.updateInstallLater.ok')],
    defaultId: 0
  });
};
let AskForCertificateTrustResponse = /*#__PURE__*/function (AskForCertificateTrustResponse) {
  AskForCertificateTrustResponse[AskForCertificateTrustResponse["YES"] = 0] = "YES";
  AskForCertificateTrustResponse[AskForCertificateTrustResponse["NO"] = 1] = "NO";
  return AskForCertificateTrustResponse;
}({});
const askForCertificateTrust = async (issuerName, detail, parentWindow) => {
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    title: t$7('dialog.certificateError.title'),
    message: t$7('dialog.certificateError.message', {
      issuerName
    }),
    detail,
    type: 'warning',
    buttons: [t$7('dialog.certificateError.yes'), t$7('dialog.certificateError.no')],
    cancelId: 1,
    defaultId: 1
  });
  if (response === 0) {
    return AskForCertificateTrustResponse.YES;
  }
  return AskForCertificateTrustResponse.NO;
};
const warnAboutUpdateDownload = async parentWindow => {
  await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'info',
    title: t$7('dialog.updateDownloading.title'),
    message: t$7('dialog.updateDownloading.message'),
    buttons: [t$7('dialog.updateDownloading.ok')],
    defaultId: 0
  });
};
const warnAboutUpdateSkipped = async parentWindow => {
  await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'warning',
    title: t$7('dialog.updateSkip.title'),
    message: t$7('dialog.updateSkip.message'),
    buttons: [t$7('dialog.updateSkip.ok')],
    defaultId: 0
  });
};
const askForOpeningExternalProtocol = async (url, parentWindow) => {
  const {
    response,
    checkboxChecked
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'warning',
    buttons: [t$7('dialog.openingExternalProtocol.yes'), t$7('dialog.openingExternalProtocol.no')],
    defaultId: 1,
    title: t$7('dialog.openingExternalProtocol.title'),
    message: t$7('dialog.openingExternalProtocol.message', {
      protocol: url.protocol
    }),
    detail: t$7('dialog.openingExternalProtocol.detail', {
      url: url.toString()
    }),
    checkboxLabel: t$7('dialog.openingExternalProtocol.dontAskAgain'),
    checkboxChecked: false
  });
  return {
    allowed: response === 0,
    dontAskAgain: checkboxChecked
  };
};
const askForJitsiCaptureScreenPermission = async (url, parentWindow) => {
  const {
    response,
    checkboxChecked
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'warning',
    buttons: [t$7('dialog.allowVideoCallCaptureScreen.yes'), t$7('dialog.allowVideoCallCaptureScreen.no')],
    defaultId: 1,
    title: t$7('dialog.allowVideoCallCaptureScreen.title'),
    message: t$7('dialog.allowVideoCallCaptureScreen.message'),
    detail: t$7('dialog.allowVideoCallCaptureScreen.detail', {
      url: url.toString()
    }),
    checkboxLabel: t$7('dialog.allowVideoCallCaptureScreen.dontAskAgain'),
    checkboxChecked: false
  });
  return {
    allowed: response === 0,
    dontAskAgain: checkboxChecked
  };
};
const askForClearScreenCapturePermission = async parentWindow => {
  parentWindow === null || parentWindow === void 0 || parentWindow.show();
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'question',
    buttons: [t$7('dialog.clearPermittedScreenCaptureServers.yes'), t$7('dialog.clearPermittedScreenCaptureServers.cancel')],
    defaultId: 1,
    title: t$7('dialog.clearPermittedScreenCaptureServers.title'),
    message: t$7('dialog.clearPermittedScreenCaptureServers.message')
  });
  return response === 0;
};
const askForMediaPermissionSettings = async (permissionType, parentWindow) => {
  parentWindow === null || parentWindow === void 0 || parentWindow.show();
  const {
    response
  } = await electron.dialog.showMessageBox(parentWindow !== null && parentWindow !== void 0 ? parentWindow : await getRootWindow(), {
    type: 'warning',
    buttons: [t$7('dialog.mediaPermission.openSettings'), t$7('dialog.mediaPermission.cancel')],
    defaultId: 0,
    title: t$7('dialog.mediaPermission.title'),
    message: t$7('dialog.mediaPermission.message', {
      permissionType: t$7(`dialog.mediaPermission.${permissionType}`)
    }),
    detail: t$7('dialog.mediaPermission.detail')
  });
  return response === 0;
};

// Cache browsers to avoid repeatedly fetching them
let cachedBrowsers = null;
let browserLoadPromise = null;

/**
 * Lazy load browsers asynchronously
 * This ensures we don't slow down app startup
 */
const loadBrowsersLazy = () => {
  if (cachedBrowsers) {
    return Promise.resolve(cachedBrowsers);
  }
  if (!browserLoadPromise) {
    // Start loading browsers asynchronously after a delay to not block the app startup
    browserLoadPromise = new Promise(resolve => {
      // Delay browser detection for 2 seconds after this function is first called
      // to avoid slowing down app startup and initial interactions
      setTimeout(async () => {
        try {
          const browsers = await detectBrowsers.getAvailableBrowsers();
          cachedBrowsers = browsers;
          const browserIds = browsers.map(browser => browser.browser);
          if (browserIds.length > 0) {
            dispatch({
              type: SETTINGS_AVAILABLE_BROWSERS_UPDATED,
              payload: browserIds
            });
          }
          resolve(browsers);
        } catch (error) {
          console.error('Error detecting browsers:', error);
          resolve([]);
        }
      }, 2000);
    });
  }
  return browserLoadPromise;
};

/**
 * Launches a URL in the selected browser from settings or falls back to system default
 *
 * @param url The URL to open
 * @returns Promise that resolves when the browser is launched
 */
const openExternal = async url => {
  // Get the selected browser from settings
  const selectedBrowser = readSetting('selectedBrowser');

  // If no specific browser is selected, use the system default
  if (!selectedBrowser) {
    return electron.shell.openExternal(url);
  }
  try {
    // Lazy load browsers when needed
    const browsers = await loadBrowsersLazy();

    // Find the selected browser in the available browsers
    const browser = browsers.find(browser => browser.browser === selectedBrowser);
    if (browser) {
      // Launch the selected browser with the URL
      return detectBrowsers.launchBrowser(browser, url);
    }
    // If the selected browser isn't available, fall back to system default
    console.warn(`Selected browser "${selectedBrowser}" not found, using system default.`);
    return electron.shell.openExternal(url);
  } catch (error) {
    console.error('Error launching browser:', error);
    // Fall back to shell.openExternal on error
    return electron.shell.openExternal(url);
  }
};

/**
 * Trigger preloading of browsers in the background
 * Call this function when the app is fully loaded
 */
const preloadBrowsersList = () => {
  // Begin loading browsers in the background after app is ready
  setTimeout(() => {
    loadBrowsersLazy().catch(error => {
      console.error('Failed to preload browsers list:', error);
    });
  }, 5000); // Delay for 5 seconds after this function is called
};

const packageJsonInformation = {
  productName: packageJson.productName,
  goUrlShortener: packageJson.goUrlShortener
};
const electronBuilderJsonInformation = {
  appId: electronBuilderJson.appId,
  protocol: electronBuilderJson.protocols.schemes[0]
};
let isScreenCaptureFallbackForced = false;
const getPlatformName = () => {
  switch (process.platform) {
    case 'win32':
      return 'Windows';
    case 'linux':
      return 'Linux';
    case 'darwin':
      return 'macOS';
    default:
      return 'Unknown';
  }
};
const relaunchApp = (...args) => {
  const command = process.argv.slice(1, electron.app.isPackaged ? 1 : 2);
  electron.app.relaunch({
    args: [...command, ...args]
  });
  electron.app.exit();
};
const performElectronStartup = () => {
  electron.app.setAsDefaultProtocolClient(electronBuilderJsonInformation.protocol);
  electron.app.setAppUserModelId(electronBuilderJsonInformation.appId);
  electron.app.commandLine.appendSwitch('--autoplay-policy', 'no-user-gesture-required');
  const disabledChromiumFeatures = ['HardwareMediaKeyHandling', 'MediaSessionService'];
  if (getPlatformName() === 'macOS' && process.mas) {
    electron.app.commandLine.appendSwitch('disable-accelerated-video-decode');
  }
  const args = process.argv.slice(electron.app.isPackaged ? 1 : 2);
  if (args.includes('--reset-app-data')) {
    rimraf.rimraf.sync(electron.app.getPath('userData'));
    relaunchApp();
    return;
  }
  const canStart = process.mas || electron.app.requestSingleInstanceLock();
  if (!canStart) {
    electron.app.exit();
    return;
  }
  const isHardwareAccelerationEnabled = readSetting('isHardwareAccelerationEnabled');
  const isScreenCaptureFallbackEnabled = readSetting('isVideoCallScreenCaptureFallbackEnabled');
  isScreenCaptureFallbackForced = false;
  if (args.includes('--disable-gpu') || isHardwareAccelerationEnabled === false) {
    console.log('Disabling Hardware acceleration');
    electron.app.disableHardwareAcceleration();
    electron.app.commandLine.appendSwitch('--disable-2d-canvas-image-chromium');
    electron.app.commandLine.appendSwitch('--disable-accelerated-2d-canvas');
    electron.app.commandLine.appendSwitch('--disable-gpu');
  }
  if (process.platform === 'win32') {
    const sessionName = process.env.SESSIONNAME;
    const isRdpSession = typeof sessionName === 'string' && sessionName !== 'Console';
    isScreenCaptureFallbackForced = isRdpSession;
    if (isScreenCaptureFallbackEnabled || isRdpSession) {
      console.log('Disabling Windows Graphics Capture for video calls', JSON.stringify({
        reason: isScreenCaptureFallbackEnabled ? 'user-setting' : 'rdp-session',
        sessionName
      }));
      disabledChromiumFeatures.push('WebRtcAllowWgcDesktopCapturer');
    }
  }

  // Apply all disabled features in a single call
  electron.app.commandLine.appendSwitch('disable-features', disabledChromiumFeatures.join(','));
};
const initializeScreenCaptureFallbackState = () => {
  dispatch({
    type: APP_SCREEN_CAPTURE_FALLBACK_FORCED_SET,
    payload: isScreenCaptureFallbackForced
  });
};
const setupApp = () => {
  electron.app.addListener('activate', async () => {
    try {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        const wasMinimized = browserWindow.isMinimized();
        const wasMaximized = browserWindow.isMaximized();
        browserWindow.showInactive();
        if (wasMinimized) browserWindow.minimize();
        if (wasMaximized) browserWindow.maximize();
      }
      browserWindow.focus();
    } catch (error) {
      console.warn('Could not activate window:', error);
    }
  });
  electron.app.addListener('window-all-closed', () => {
    // Don't quit immediately if this might be caused by video call window closure
    // especially during first launch when main window might not be fully ready
    setTimeout(() => {
      const allWindows = electron.BrowserWindow.getAllWindows();

      // Only quit if there are truly no windows left after a brief delay
      // This prevents crashes when video call window closes before main window is established
      if (allWindows.length === 0) {
        console.log('No windows remaining after delay, quitting application');
        electron.app.quit();
      } else {
        console.log(`${allWindows.length} window(s) still exist, not quitting`);
      }
    }, 100); // Brief delay to let window state stabilize
  });
  electron.app.whenReady().then(() => preloadBrowsersList());
  listen(SETTINGS_SET_HARDWARE_ACCELERATION_OPT_IN_CHANGED, () => {
    relaunchApp();
  });
  listen(SETTINGS_SET_IS_VIDEO_CALL_SCREEN_CAPTURE_FALLBACK_ENABLED_CHANGED, action => {
    const newSettingValue = action.payload;
    const currentPersistedSetting = readSetting('isVideoCallScreenCaptureFallbackEnabled');
    const sessionName = process.env.SESSIONNAME;
    const isRdpSession = typeof sessionName === 'string' && sessionName !== 'Console';

    // Relaunch only if the setting actually changes AND it's not already forced by RDP
    if (newSettingValue !== currentPersistedSetting && !isRdpSession) {
      relaunchApp();
    } else if (isRdpSession) {
      console.log('Screen Capture Fallback setting changed, but app is in RDP session. Skipping relaunch.');
    }
  });
  listen(APP_ALLOWED_NTLM_CREDENTIALS_DOMAINS_SET, action => {
    if (action.payload.length > 0) {
      electron.session.defaultSession.allowNTLMCredentialsForDomains(action.payload);
    }
  });
  listen(SETTINGS_NTLM_CREDENTIALS_CHANGED, action => {
    if (action.payload === true) {
      const allowedNTLMCredentialsDomains = readSetting('allowedNTLMCredentialsDomains');
      if (allowedNTLMCredentialsDomains) {
        console.log('Setting NTLM credentials', allowedNTLMCredentialsDomains);
        electron.session.defaultSession.allowNTLMCredentialsForDomains(allowedNTLMCredentialsDomains);
      }
    } else {
      console.log('Clearing NTLM credentials');
      electron.session.defaultSession.allowNTLMCredentialsForDomains('');
    }
  });
  listen(SETTINGS_CLEAR_PERMITTED_SCREEN_CAPTURE_PERMISSIONS, async () => {
    const permitted = await askForClearScreenCapturePermission();
    if (permitted) {
      dispatch({
        type: JITSI_SERVER_CAPTURE_SCREEN_PERMISSIONS_CLEARED,
        payload: {}
      });
    }
  });
  const allowedNTLMCredentialsDomains = readSetting('allowedNTLMCredentialsDomains');
  const isNTLMCredentialsEnabled = readSetting('isNTLMCredentialsEnabled');
  if (isNTLMCredentialsEnabled && allowedNTLMCredentialsDomains.length > 0) {
    console.log('Setting NTLM credentials', allowedNTLMCredentialsDomains);
    electron.session.defaultSession.allowNTLMCredentialsForDomains(allowedNTLMCredentialsDomains);
  }
  dispatch({
    type: APP_PATH_SET,
    payload: electron.app.getAppPath()
  });
  dispatch({
    type: APP_VERSION_SET,
    payload: electron.app.getVersion()
  });
  dispatch({
    type: APP_MAIN_WINDOW_TITLE_SET,
    payload: 'Rocket.Chat'
  });
};

const selectPersistableValues = reselect.createStructuredSelector({
  currentView: ({
    currentView
  }) => currentView,
  doCheckForUpdatesOnStartup: ({
    doCheckForUpdatesOnStartup
  }) => doCheckForUpdatesOnStartup,
  downloads: ({
    downloads
  }) => downloads,
  machineTheme: ({
    machineTheme
  }) => machineTheme,
  isMenuBarEnabled: ({
    isMenuBarEnabled
  }) => isMenuBarEnabled,
  isShowWindowOnUnreadChangedEnabled: ({
    isShowWindowOnUnreadChangedEnabled
  }) => isShowWindowOnUnreadChangedEnabled,
  isSideBarEnabled: ({
    isSideBarEnabled
  }) => isSideBarEnabled,
  isTrayIconEnabled: ({
    isTrayIconEnabled
  }) => isTrayIconEnabled,
  rootWindowState: ({
    rootWindowState
  }) => rootWindowState,
  servers: ({
    servers
  }) => servers,
  skippedUpdateVersion: ({
    skippedUpdateVersion
  }) => skippedUpdateVersion,
  trustedCertificates: ({
    trustedCertificates
  }) => trustedCertificates,
  notTrustedCertificates: ({
    notTrustedCertificates
  }) => notTrustedCertificates,
  isEachUpdatesSettingConfigurable: ({
    isEachUpdatesSettingConfigurable
  }) => isEachUpdatesSettingConfigurable,
  isUpdatingEnabled: ({
    isUpdatingEnabled
  }) => isUpdatingEnabled,
  isHardwareAccelerationEnabled: ({
    isHardwareAccelerationEnabled
  }) => isHardwareAccelerationEnabled,
  externalProtocols: ({
    externalProtocols
  }) => externalProtocols,
  allowedJitsiServers: ({
    allowedJitsiServers
  }) => allowedJitsiServers,
  isReportEnabled: ({
    isReportEnabled
  }) => isReportEnabled,
  isFlashFrameEnabled: ({
    isFlashFrameEnabled
  }) => isFlashFrameEnabled,
  isInternalVideoChatWindowEnabled: ({
    isInternalVideoChatWindowEnabled
  }) => isInternalVideoChatWindowEnabled,
  isMinimizeOnCloseEnabled: ({
    isMinimizeOnCloseEnabled
  }) => isMinimizeOnCloseEnabled,
  isAddNewServersEnabled: ({
    isAddNewServersEnabled
  }) => isAddNewServersEnabled,
  isDeveloperModeEnabled: ({
    isDeveloperModeEnabled
  }) => isDeveloperModeEnabled,
  hasHideOnTrayNotificationShown: ({
    hasHideOnTrayNotificationShown
  }) => hasHideOnTrayNotificationShown,
  lastSelectedServerUrl: ({
    lastSelectedServerUrl
  }) => lastSelectedServerUrl,
  allowedNTLMCredentialsDomains: ({
    allowedNTLMCredentialsDomains
  }) => allowedNTLMCredentialsDomains,
  isNTLMCredentialsEnabled: ({
    isNTLMCredentialsEnabled
  }) => isNTLMCredentialsEnabled,
  mainWindowTitle: ({
    mainWindowTitle
  }) => mainWindowTitle || 'Rocket.Chat',
  selectedBrowser: ({
    selectedBrowser
  }) => selectedBrowser,
  videoCallWindowState: ({
    videoCallWindowState
  }) => videoCallWindowState,
  isVideoCallWindowPersistenceEnabled: ({
    isVideoCallWindowPersistenceEnabled
  }) => isVideoCallWindowPersistenceEnabled,
  isVideoCallDevtoolsAutoOpenEnabled: ({
    isVideoCallDevtoolsAutoOpenEnabled
  }) => isVideoCallDevtoolsAutoOpenEnabled,
  isVideoCallScreenCaptureFallbackEnabled: ({
    isVideoCallScreenCaptureFallbackEnabled
  }) => isVideoCallScreenCaptureFallbackEnabled,
  updateChannel: ({
    updateChannel
  }) => updateChannel
});

const migrations = {
  '>=3.1.0': before => {
    var _rest$currentView;
    const {
      currentServerUrl,
      ...rest
    } = before;
    return {
      ...rest,
      currentView: currentServerUrl ? {
        url: currentServerUrl
      } : (_rest$currentView = rest.currentView) !== null && _rest$currentView !== void 0 ? _rest$currentView : 'add-new-server',
      downloads: {}
    };
  },
  '>=3.5.0': before => ({
    ...before,
    isReportEnabled: true,
    isInternalVideoChatWindowEnabled: true,
    isFlashFrameEnabled: process.platform === 'win32' || process.platform === 'darwin'
  }),
  '>=3.7.9': before => ({
    ...before,
    isMinimizeOnCloseEnabled: process.platform === 'win32'
  }),
  '>=3.8.0': before => ({
    ...before,
    isReportEnabled: !process.mas
  }),
  '>=3.8.4': before => ({
    ...before,
    isInternalVideoChatWindowEnabled: !process.mas,
    isAddNewServersEnabled: true
  }),
  '>=3.8.7': before => ({
    ...before,
    isHardwareAccelerationEnabled: true
  }),
  '>=3.8.9': before => ({
    ...before,
    isAddNewServersEnabled: true
  }),
  '>=3.8.12': before => ({
    ...before,
    hasHideOnTrayNotificationShown: false
  }),
  '>=3.9.6': before => ({
    ...before,
    isNTLMCredentialsEnabled: false,
    allowedNTLMCredentialsDomains: null,
    lastSelectedServerUrl: ''
  }),
  '>=4.1.0': before => ({
    ...before,
    mainWindowTitle: 'Rocket.Chat',
    machineTheme: 'light'
  }),
  '>=4.2.0': before => ({
    ...before,
    selectedBrowser: null
  }),
  '>=4.4.0': before => ({
    ...before,
    isDeveloperModeEnabled: false
  }),
  '>=4.5.0': before => ({
    ...before,
    updateChannel: 'latest'
  }),
  '>=4.7.2': before => ({
    ...before,
    isVideoCallDevtoolsAutoOpenEnabled: false
  }),
  '>=4.9.0': before => ({
    ...before,
    isVideoCallScreenCaptureFallbackEnabled: false
  })
};

let electronStore;
const getElectronStore = () => {
  if (!electronStore) {
    electronStore = new ElectronStore__default.default({
      migrations: Object.fromEntries(Object.entries(migrations).map(([semver, transform]) => [semver, store => {
        store.store = transform(store.store);
      }])),
      projectVersion: electron.app.getVersion(),
      configFileMode: 0o666
    });
  }
  return electronStore;
};
const getPersistedValues = () => getElectronStore().store;
let lastSavedTime = 0;
const persistValues = values => {
  if (Date.now() - lastSavedTime > 1000) {
    try {
      getElectronStore().set(values);
    } catch (error) {
      error instanceof Error && console.error(error);
    }
    lastSavedTime = Date.now();
  }
};

const loadUserDataOverriddenSettings = async () => {
  try {
    const filePath = path__default.default.join(electron.app.getPath('userData'), 'overridden-settings.json');
    const content = await fs__default.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const loadAppAsarOverriddenSettings = async () => {
  try {
    const filePath = path__default.default.join(electron.app.getAppPath(), electron.app.getAppPath().endsWith('app.asar') ? '..' : '.', 'overridden-settings.json');
    const content = await fs__default.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const mergePersistableValues = async localStorage => {
  var _userRootWindowState$, _values, _userRootWindowState$2, _values2, _userRootWindowState$3, _values3, _userRootWindowState$4, _values4, _userRootWindowState$5, _values5, _userRootWindowState$6, _values6, _userRootWindowState$7, _values7;
  const initialValues = select(selectPersistableValues);
  const electronStoreValues = getPersistedValues();
  const userDataOverriddenSettings = await loadUserDataOverriddenSettings();
  const appAsarOverriddenSettings = await loadAppAsarOverriddenSettings();
  const localStorageValues = Object.fromEntries(Object.entries(localStorage).map(([key, value]) => {
    try {
      return [key, JSON.parse(value)];
    } catch (error) {
      return [];
    }
  }));
  let values = selectPersistableValues({
    ...initialValues,
    ...electronStoreValues,
    ...localStorageValues,
    ...userDataOverriddenSettings,
    ...appAsarOverriddenSettings
  });
  if (localStorage.autohideMenu) {
    values = {
      ...values,
      isMenuBarEnabled: localStorage.autohideMenu !== 'true'
    };
  }
  if (localStorage.showWindowOnUnreadChanged) {
    values = {
      ...values,
      isShowWindowOnUnreadChangedEnabled: localStorage.showWindowOnUnreadChanged === 'true'
    };
  }
  if (localStorage['sidebar-closed']) {
    values = {
      ...values,
      isSideBarEnabled: localStorage['sidebar-closed'] !== 'true'
    };
  }
  if (localStorage.hideTray) {
    values = {
      ...values,
      isTrayIconEnabled: localStorage.hideTray !== 'true'
    };
  }
  const userRootWindowState = await (async () => {
    try {
      const filePath = path__default.default.join(electron.app.getPath('userData'), 'main-window-state.json');
      const content = await fs__default.default.promises.readFile(filePath, 'utf8');
      const json = JSON.parse(content);
      await fs__default.default.promises.unlink(filePath);
      return json && typeof json === 'object' ? json : {};
    } catch (error) {
      return {};
    }
  })();
  values = {
    ...values,
    rootWindowState: {
      focused: true,
      visible: !((_userRootWindowState$ = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.isHidden) !== null && _userRootWindowState$ !== void 0 ? _userRootWindowState$ : !((_values = values) !== null && _values !== void 0 && (_values = _values.rootWindowState) !== null && _values !== void 0 && _values.visible)),
      maximized: (_userRootWindowState$2 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.isMaximized) !== null && _userRootWindowState$2 !== void 0 ? _userRootWindowState$2 : (_values2 = values) === null || _values2 === void 0 || (_values2 = _values2.rootWindowState) === null || _values2 === void 0 ? void 0 : _values2.maximized,
      minimized: (_userRootWindowState$3 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.isMinimized) !== null && _userRootWindowState$3 !== void 0 ? _userRootWindowState$3 : (_values3 = values) === null || _values3 === void 0 || (_values3 = _values3.rootWindowState) === null || _values3 === void 0 ? void 0 : _values3.minimized,
      fullscreen: false,
      normal: !(userRootWindowState !== null && userRootWindowState !== void 0 && userRootWindowState.isMinimized || userRootWindowState !== null && userRootWindowState !== void 0 && userRootWindowState.isMaximized),
      bounds: {
        x: (_userRootWindowState$4 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.x) !== null && _userRootWindowState$4 !== void 0 ? _userRootWindowState$4 : normalizeNumber((_values4 = values) === null || _values4 === void 0 || (_values4 = _values4.rootWindowState) === null || _values4 === void 0 || (_values4 = _values4.bounds) === null || _values4 === void 0 ? void 0 : _values4.x),
        y: (_userRootWindowState$5 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.y) !== null && _userRootWindowState$5 !== void 0 ? _userRootWindowState$5 : normalizeNumber((_values5 = values) === null || _values5 === void 0 || (_values5 = _values5.rootWindowState) === null || _values5 === void 0 || (_values5 = _values5.bounds) === null || _values5 === void 0 ? void 0 : _values5.y),
        width: (_userRootWindowState$6 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.width) !== null && _userRootWindowState$6 !== void 0 ? _userRootWindowState$6 : (_values6 = values) === null || _values6 === void 0 || (_values6 = _values6.rootWindowState) === null || _values6 === void 0 || (_values6 = _values6.bounds) === null || _values6 === void 0 ? void 0 : _values6.width,
        height: (_userRootWindowState$7 = userRootWindowState === null || userRootWindowState === void 0 ? void 0 : userRootWindowState.height) !== null && _userRootWindowState$7 !== void 0 ? _userRootWindowState$7 : (_values7 = values) === null || _values7 === void 0 || (_values7 = _values7.rootWindowState) === null || _values7 === void 0 || (_values7 = _values7.bounds) === null || _values7 === void 0 ? void 0 : _values7.height
      }
    }
  };
  if (!values.isMenuBarEnabled && !values.isSideBarEnabled) {
    values = {
      ...values,
      isSideBarEnabled: true
    };
  }
  dispatch({
    type: APP_SETTINGS_LOADED,
    payload: values
  });
};
const watchAndPersistChanges = () => {
  watch(selectPersistableValues, values => {
    persistValues(values);
  });
};

let ServerUrlResolutionStatus = /*#__PURE__*/function (ServerUrlResolutionStatus) {
  ServerUrlResolutionStatus["OK"] = "ok";
  ServerUrlResolutionStatus["INVALID_URL"] = "invalid-url";
  ServerUrlResolutionStatus["TIMEOUT"] = "timeout";
  ServerUrlResolutionStatus["INVALID"] = "invalid";
  return ServerUrlResolutionStatus;
}({});
const isServerUrlResolutionResult = obj => {
  if (!Array.isArray(obj)) {
    return false;
  }
  return obj.length === 3 && typeof obj[0] === 'string' && [ServerUrlResolutionStatus.INVALID, ServerUrlResolutionStatus.INVALID_URL, ServerUrlResolutionStatus.TIMEOUT].includes(obj[1]) && typeof obj[2] === 'object' || obj.length === 2 && typeof obj[0] === 'string' && obj[1] === ServerUrlResolutionStatus.OK;
};

const t$6 = i18next__default.default.t.bind(i18next__default.default);
const loadUserTrustedCertificates = async () => {
  try {
    const filePath = path__default.default.join(electron.app.getPath('userData'), 'certificate.json');
    const content = await fs__default.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    await fs__default.default.promises.unlink(filePath);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const serializeCertificate = certificate => `${certificate.issuerName}\n${certificate.data.toString()}`;
const queuedTrustRequests = new Map();
const setupNavigation = async () => {
  electron.app.addListener('certificate-error', async (event, _webContents, requestedUrl, error, certificate, callback) => {
    var _queuedTrustRequests$2, _queuedTrustRequests$3;
    event.preventDefault();
    const serialized = serializeCertificate(certificate);
    const {
      host
    } = new URL(requestedUrl);
    let trustedCertificates = select(({
      trustedCertificates
    }) => trustedCertificates);
    const isTrusted = !!trustedCertificates[host] && trustedCertificates[host] === serialized;
    if (isTrusted) {
      callback(true);
      return;
    }
    let notTrustedCertificates = select(({
      notTrustedCertificates
    }) => notTrustedCertificates);
    const isNotTrusted = !!notTrustedCertificates[host] && notTrustedCertificates[host] === serialized;
    if (isNotTrusted) {
      callback(false);
      return;
    }
    if (queuedTrustRequests.has(certificate.fingerprint)) {
      var _queuedTrustRequests$;
      (_queuedTrustRequests$ = queuedTrustRequests.get(certificate.fingerprint)) === null || _queuedTrustRequests$ === void 0 || _queuedTrustRequests$.push(callback);
      return;
    }
    queuedTrustRequests.set(certificate.fingerprint, [callback]);
    let detail = `URL: ${requestedUrl}\nError: ${error}`;
    if (trustedCertificates[host]) {
      detail = t$6('error.differentCertificate', {
        detail
      });
    }
    const response = await askForCertificateTrust(certificate.issuerName, detail);
    const isTrustedByUser = response;
    (_queuedTrustRequests$2 = queuedTrustRequests.get(certificate.fingerprint)) === null || _queuedTrustRequests$2 === void 0 || _queuedTrustRequests$2.forEach(cb => cb(isTrustedByUser === AskForCertificateTrustResponse.YES));
    queuedTrustRequests.delete(certificate.fingerprint);
    trustedCertificates = select(({
      trustedCertificates
    }) => trustedCertificates);
    if (isTrustedByUser === AskForCertificateTrustResponse.YES) {
      dispatch({
        type: TRUSTED_CERTIFICATES_UPDATED,
        payload: {
          ...trustedCertificates,
          [host]: serialized
        }
      });
    }
    (_queuedTrustRequests$3 = queuedTrustRequests.get(certificate.fingerprint)) === null || _queuedTrustRequests$3 === void 0 || _queuedTrustRequests$3.forEach(cb => cb(isTrustedByUser === AskForCertificateTrustResponse.NO));
    queuedTrustRequests.delete(certificate.fingerprint);
    notTrustedCertificates = select(({
      notTrustedCertificates
    }) => notTrustedCertificates);
    if (isTrustedByUser === AskForCertificateTrustResponse.NO) {
      dispatch({
        type: NOT_TRUSTED_CERTIFICATES_UPDATED,
        payload: {
          ...notTrustedCertificates,
          [host]: serialized
        }
      });
    }
  });
  electron.app.addListener('select-client-certificate', async (event, _webContents, _url, certificateList, callback) => {
    event.preventDefault();
    if (certificateList.length === 1) {
      callback(certificateList[0]);
      return;
    }
    const fingerprint = await request({
      type: CERTIFICATES_CLIENT_CERTIFICATE_REQUESTED,
      payload: JSON.parse(JSON.stringify(certificateList))
    }, SELECT_CLIENT_CERTIFICATE_DIALOG_CERTIFICATE_SELECTED, SELECT_CLIENT_CERTIFICATE_DIALOG_DISMISSED);
    const certificate = certificateList.find(certificate => certificate.fingerprint === fingerprint);
    if (!certificate) {
      callback(undefined);
      return;
    }
    callback(certificate);
  });
  electron.app.addListener('login', (event, _webContents, authenticationResponseDetails, _authInfo, callback) => {
    event.preventDefault();
    const servers = select(({
      servers
    }) => servers);
    for (const server of servers) {
      const {
        host: serverHost,
        username,
        password
      } = new URL(server.url);
      const requestHost = new URL(authenticationResponseDetails.url).host;
      if (serverHost !== requestHost || !username) {
        callback();
        return;
      }
      callback(username, password);
    }
  });
  const trustedCertificates = select(({
    trustedCertificates
  }) => trustedCertificates);
  const userTrustedCertificates = await loadUserTrustedCertificates();
  dispatch({
    type: CERTIFICATES_LOADED,
    payload: {
      ...trustedCertificates,
      ...userTrustedCertificates
    }
  });
};
const isProtocolAllowed = async rawUrl => {
  const url = new URL(rawUrl);
  const instrinsicProtocols = ['http:', 'https:', 'mailto:'];
  const persistedProtocols = Object.entries(select(({
    externalProtocols
  }) => externalProtocols)).filter(([, allowed]) => allowed).map(([protocol]) => protocol);
  const allowedProtocols = [...instrinsicProtocols, ...persistedProtocols];
  if (allowedProtocols.includes(url.protocol)) {
    return true;
  }
  const {
    allowed,
    dontAskAgain
  } = await askForOpeningExternalProtocol(url);
  if (dontAskAgain) {
    dispatch({
      type: EXTERNAL_PROTOCOL_PERMISSION_UPDATED,
      payload: {
        protocol: url.protocol,
        allowed
      }
    });
  }
  return allowed;
};

const SPELL_CHECKING_TOGGLED = 'spell-checking/toggled';
const SPELL_CHECKING_LANGUAGE_TOGGLED = 'spell-checking/language-toggled';

const t$5 = i18next__default.default.t.bind(i18next__default.default);
const createSpellCheckingMenuTemplate = (serverViewWebContents, {
  isEditable,
  dictionarySuggestions
}) => {
  if (!isEditable) {
    return [];
  }
  const {
    availableSpellCheckerLanguages
  } = serverViewWebContents.session;
  const spellCheckerLanguages = serverViewWebContents.session.getSpellCheckerLanguages();
  return [...(spellCheckerLanguages.length > 0 && dictionarySuggestions ? [...(dictionarySuggestions.length === 0 ? [{
    label: t$5('contextMenu.noSpellingSuggestions'),
    enabled: false
  }] : dictionarySuggestions.slice(0, 6).map(dictionarySuggestion => ({
    label: dictionarySuggestion,
    click: () => {
      serverViewWebContents.replaceMisspelling(dictionarySuggestion);
    }
  }))), ...(dictionarySuggestions.length > 6 ? [{
    label: t$5('contextMenu.moreSpellingSuggestions'),
    submenu: dictionarySuggestions.slice(6).map(dictionarySuggestion => ({
      label: dictionarySuggestion,
      click: () => {
        serverViewWebContents.replaceMisspelling(dictionarySuggestion);
      }
    }))
  }] : []), {
    type: 'separator'
  }] : []), ...(process.platform === 'darwin' ? [{
    label: t$5('contextMenu.spelling'),
    type: 'checkbox',
    checked: spellCheckerLanguages.length > 0,
    click: ({
      checked
    }) => {
      dispatch({
        type: SPELL_CHECKING_TOGGLED,
        payload: checked
      });
    }
  }] : [{
    label: t$5('contextMenu.spellingLanguages'),
    enabled: availableSpellCheckerLanguages.length > 0,
    submenu: [...availableSpellCheckerLanguages.map(availableSpellCheckerLanguage => ({
      label: availableSpellCheckerLanguage,
      type: 'checkbox',
      checked: spellCheckerLanguages.includes(availableSpellCheckerLanguage),
      click: ({
        checked
      }) => {
        dispatch({
          type: SPELL_CHECKING_LANGUAGE_TOGGLED,
          payload: {
            name: availableSpellCheckerLanguage,
            enabled: checked
          }
        });
      }
    }))]
  }]), {
    type: 'separator'
  }];
};
const createImageMenuTemplate = (serverViewWebContents, {
  mediaType,
  srcURL,
  x,
  y
}) => mediaType === 'image' ? [{
  label: t$5('contextMenu.saveImageAs'),
  click: () => serverViewWebContents.downloadURL(srcURL)
}, {
  label: t$5('contextMenu.copyImage'),
  click: () => serverViewWebContents.copyImageAt(x, y)
}, {
  type: 'separator'
}] : [];
const createLinkMenuTemplate = (_serverViewWebContents, {
  linkURL,
  linkText
}) => linkURL ? [{
  label: t$5('contextMenu.openLink'),
  click: () => {
    isProtocolAllowed(linkURL).then(allowed => {
      if (!allowed) {
        return;
      }
      openExternal(linkURL);
    });
  }
}, {
  label: t$5('contextMenu.copyLinkText'),
  click: () => electron.clipboard.write({
    text: linkText,
    bookmark: linkText
  }),
  enabled: !!linkText
}, {
  label: t$5('contextMenu.copyLinkAddress'),
  click: () => electron.clipboard.write({
    text: linkURL,
    bookmark: linkText
  })
}, {
  type: 'separator'
}] : [];
const createDefaultMenuTemplate = (_serverViewWebContents, {
  editFlags: {
    canUndo = false,
    canRedo = false,
    canCut = false,
    canCopy = false,
    canPaste = false,
    canSelectAll = false
  }
}) => [{
  label: t$5('contextMenu.undo'),
  role: 'undo',
  accelerator: 'CommandOrControl+Z',
  enabled: canUndo
}, {
  label: t$5('contextMenu.redo'),
  role: 'redo',
  accelerator: process.platform === 'win32' ? 'Control+Y' : 'CommandOrControl+Shift+Z',
  enabled: canRedo
}, {
  type: 'separator'
}, {
  label: t$5('contextMenu.cut'),
  role: 'cut',
  accelerator: 'CommandOrControl+X',
  enabled: canCut
}, {
  label: t$5('contextMenu.copy'),
  role: 'copy',
  accelerator: 'CommandOrControl+C',
  enabled: canCopy
}, {
  label: t$5('contextMenu.paste'),
  role: 'paste',
  accelerator: 'CommandOrControl+V',
  enabled: canPaste
}, {
  label: t$5('contextMenu.selectAll'),
  role: 'selectAll',
  accelerator: 'CommandOrControl+A',
  enabled: canSelectAll
}];
const createPopupMenuForServerView = (serverViewWebContents, params) => electron.Menu.buildFromTemplate([...createSpellCheckingMenuTemplate(serverViewWebContents, params), ...createImageMenuTemplate(serverViewWebContents, params), ...createLinkMenuTemplate(serverViewWebContents, params), ...createDefaultMenuTemplate(serverViewWebContents, params)]);

const t$4 = i18next__default.default.t.bind(i18next__default.default);
const webContentsByServerUrl = new Map();
const getWebContentsByServerUrl = url => webContentsByServerUrl.get(url);
const initializeServerWebContentsAfterReady = (_serverUrl, guestWebContents, rootWindow) => {
  const handleContextMenu = async (event, params) => {
    event.preventDefault();
    const menu = createPopupMenuForServerView(guestWebContents, params);
    menu.popup({
      window: rootWindow
    });
  };
  guestWebContents.addListener('context-menu', handleContextMenu);
  guestWebContents.on('page-title-updated', (_event, pageTitle) => {
    dispatch({
      type: WEBVIEW_PAGE_TITLE_CHANGED,
      payload: {
        url: _serverUrl,
        pageTitle
      }
    });
  });
};
const serverReloadView = async serverUrl => {
  const url = new URL(serverUrl).href;
  const guestWebContents = getWebContentsByServerUrl(url);
  await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.loadURL(url));
  if (url) {
    dispatch({
      type: WEBVIEW_SERVER_RELOADED,
      payload: {
        url
      }
    });
  }
};
const initializeServerWebContentsAfterAttach = (serverUrl, guestWebContents, rootWindow) => {
  webContentsByServerUrl.set(serverUrl, guestWebContents);
  const webviewSession = guestWebContents.session;
  guestWebContents.addListener('destroyed', () => {
    guestWebContents.removeAllListeners();
    webviewSession.removeAllListeners();
    webContentsByServerUrl.delete(serverUrl);
    const canPurge = select(({
      servers
    }) => !servers.some(server => server.url === serverUrl));
    if (canPurge) {
      webviewSession.clearStorageData();
      return;
    }
    webviewSession.flushStorageData();
  });
  const handleDidStartLoading = () => {
    dispatch({
      type: WEBVIEW_DID_START_LOADING,
      payload: {
        url: serverUrl
      }
    });
    rootWindow.webContents.send(WEBVIEW_DID_START_LOADING, serverUrl);
  };
  const handleDidFailLoad = (_event, errorCode, _errorDescription, _validatedURL, isMainFrame, _frameProcessId, _frameRoutingId) => {
    if (errorCode === -3) {
      console.warn('Ignoring likely spurious did-fail-load with errorCode -3, cf https://github.com/electron/electron/issues/14004');
      return;
    }
    dispatch({
      type: WEBVIEW_DID_FAIL_LOAD,
      payload: {
        url: serverUrl,
        isMainFrame
      }
    });
  };
  const handleDidNavigateInPage = (_event, pageUrl, _isMainFrame, _frameProcessId, _frameRoutingId) => {
    dispatch({
      type: WEBVIEW_DID_NAVIGATE,
      payload: {
        url: serverUrl,
        pageUrl
      }
    });
  };
  const handleBeforeInputEvent = (_event, {
    type,
    key
  }) => {
    if (type !== 'keyUp' && type !== 'keyDown') {
      return;
    }
    const shortcutKey = process.platform === 'darwin' ? 'Meta' : 'Control';
    if (key !== shortcutKey && key !== 'Escape') {
      return;
    }
    rootWindow.webContents.sendInputEvent({
      type,
      keyCode: key,
      modifiers: []
    });
  };
  guestWebContents.addListener('did-start-loading', handleDidStartLoading);
  guestWebContents.addListener('did-fail-load', handleDidFailLoad);
  guestWebContents.addListener('did-navigate-in-page', handleDidNavigateInPage);
  guestWebContents.addListener('before-input-event', handleBeforeInputEvent);
};
const attachGuestWebContentsEvents = async () => {
  const rootWindow = await getRootWindow();
  const handleWillAttachWebview = (_event, webPreferences, _params) => {
    delete webPreferences.enableBlinkFeatures;
    webPreferences.preload = path__default.default.join(electron.app.getAppPath(), 'app/preload.js');
    webPreferences.nodeIntegration = false;
    webPreferences.nodeIntegrationInWorker = false;
    webPreferences.nodeIntegrationInSubFrames = false;
    webPreferences.webSecurity = true;
    webPreferences.contextIsolation = true;
    webPreferences.sandbox = false;
  };
  const handleDidAttachWebview = (_event, webContents) => {
    webContents.setWindowOpenHandler(({
      url,
      frameName,
      disposition
    }) => {
      if (disposition === 'foreground-tab' || disposition === 'background-tab') {
        isProtocolAllowed(url).then(allowed => {
          if (!allowed) {
            return {
              action: 'deny'
            };
          }
          openExternal(url);
          return {
            action: 'deny'
          };
        });
        return {
          action: 'deny'
        };
      }
      const isVideoCall = frameName === 'Video Call';
      return {
        action: 'allow',
        overrideBrowserWindowOptions: {
          ...(isVideoCall ? {
            webPreferences: {
              preload: path__default.default.join(electron.app.getAppPath(), 'app/preload.js'),
              sandbox: false
            }
          } : {}),
          show: false
        }
      };
    });
    webContents.addListener('did-create-window', (window, {
      url,
      frameName,
      disposition,
      referrer,
      postBody
    }) => {
      window.once('ready-to-show', () => {
        window.show();
      });
      isProtocolAllowed(url).then(allowed => {
        if (!allowed) {
          window.destroy();
          return;
        }
        const isGoogleSignIn = frameName === 'Login' && disposition === 'new-window' && new URL(url).hostname.match(/(\.)?google\.com$/);
        window.loadURL(url, {
          userAgent: isGoogleSignIn ? electron.app.userAgentFallback.replace(`Electron/${process.versions.electron} `, '').replace(`${electron.app.name}/${electron.app.getVersion()} `, '') : electron.app.userAgentFallback,
          httpReferrer: referrer,
          ...(postBody && {
            extraHeaders: `Content-Type: ${postBody.contentType}; boundary=${postBody.boundary}`,
            postData: postBody.data
          })
        });
      });
    });
  };
  const handlePermissionRequest = async (_webContents, permission, callback, details) => {
    console.log('Permission request', permission, details);
    switch (permission) {
      case 'media':
        {
          const {
            mediaTypes = []
          } = details;
          if (process.platform === 'darwin') {
            const allowed = (!mediaTypes.includes('audio') || (await electron.systemPreferences.askForMediaAccess('microphone'))) && (!mediaTypes.includes('video') || (await electron.systemPreferences.askForMediaAccess('camera')));
            callback(allowed);
            return;
          }
          callback(true);
          return;
        }
      case 'geolocation':
      case 'notifications':
      case 'midiSysex':
      case 'pointerLock':
      case 'fullscreen':
        callback(true);
        return;
      case 'openExternal':
        {
          if (!details.externalURL) {
            callback(false);
            return;
          }
          const allowed = await isProtocolAllowed(details.externalURL);
          callback(allowed);
          return;
        }
      default:
        callback(false);
    }
  };
  listen(WEBVIEW_READY, action => {
    const guestWebContents = electron.webContents.fromId(action.payload.webContentsId);
    initializeServerWebContentsAfterReady(action.payload.url, guestWebContents, rootWindow);
    guestWebContents.session.setPermissionRequestHandler(handlePermissionRequest);
    // Download handling is now managed by electron-dl in main.ts
    // and integrated with our downloads system via setupDownloads()

    // prevents the webview from navigating because of twitter preview links
    guestWebContents.on('will-navigate', (e, redirectUrl) => {
      const preventNavigateHosts = ['t.co', 'twitter.com'];
      if (preventNavigateHosts.includes(new URL(redirectUrl).hostname)) {
        e.preventDefault();
        isProtocolAllowed(redirectUrl).then(allowed => {
          if (!allowed) {
            return;
          }
          openExternal(redirectUrl);
        });
      }
    });
  });
  listen(WEBVIEW_ATTACHED, action => {
    const guestWebContents = electron.webContents.fromId(action.payload.webContentsId);
    initializeServerWebContentsAfterAttach(action.payload.url, guestWebContents, rootWindow);
  });
  listen(LOADING_ERROR_VIEW_RELOAD_SERVER_CLICKED, action => {
    const guestWebContents = getWebContentsByServerUrl(action.payload.url);
    guestWebContents === null || guestWebContents === void 0 || guestWebContents.loadURL(action.payload.url);
  });
  listen(SIDE_BAR_SERVER_RELOAD, action => {
    serverReloadView(action.payload);
  });
  listen(SIDE_BAR_SERVER_COPY_URL, async action => {
    const guestWebContents = getWebContentsByServerUrl(action.payload);
    const currentUrl = await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.getURL());
    electron.clipboard.writeText(currentUrl || '');
  });
  listen(SIDE_BAR_SERVER_OPEN_DEV_TOOLS, action => {
    const guestWebContents = getWebContentsByServerUrl(action.payload);
    guestWebContents === null || guestWebContents === void 0 || guestWebContents.openDevTools();
  });
  listen(SIDE_BAR_SERVER_FORCE_RELOAD, action => {
    const guestWebContents = getWebContentsByServerUrl(action.payload);
    if (!guestWebContents) {
      return;
    }
    dispatch({
      type: CLEAR_CACHE_TRIGGERED,
      payload: guestWebContents.id
    });
  });
  listen(SIDE_BAR_SERVER_REMOVE, action => {
    dispatch({
      type: SIDE_BAR_REMOVE_SERVER_CLICKED,
      payload: action.payload
    });
  });
  listen(SIDE_BAR_CONTEXT_MENU_TRIGGERED, action => {
    const {
      payload: serverUrl
    } = action;
    const menuTemplate = [{
      label: t$4('sidebar.item.reload'),
      click: () => {
        const guestWebContents = getWebContentsByServerUrl(serverUrl);
        guestWebContents === null || guestWebContents === void 0 || guestWebContents.loadURL(serverUrl);
        if (serverUrl) {
          dispatch({
            type: WEBVIEW_SERVER_RELOADED,
            payload: {
              url: serverUrl
            }
          });
        }
      }
    }, {
      label: t$4('sidebar.item.remove'),
      click: () => {
        dispatch({
          type: SIDE_BAR_REMOVE_SERVER_CLICKED,
          payload: serverUrl
        });
      }
    }, {
      type: 'separator'
    }, {
      label: t$4('sidebar.item.openDevTools'),
      click: () => {
        const guestWebContents = getWebContentsByServerUrl(serverUrl);
        guestWebContents === null || guestWebContents === void 0 || guestWebContents.openDevTools();
      }
    }, {
      label: t$4('sidebar.item.copyCurrentUrl'),
      click: async () => {
        const guestWebContents = getWebContentsByServerUrl(serverUrl);
        const currentUrl = await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.getURL());
        electron.clipboard.writeText(currentUrl || '');
      }
    }, {
      label: t$4('sidebar.item.reloadClearingCache'),
      click: async () => {
        const guestWebContents = getWebContentsByServerUrl(serverUrl);
        if (!guestWebContents) {
          return;
        }
        dispatch({
          type: CLEAR_CACHE_TRIGGERED,
          payload: guestWebContents.id
        });
      }
    }];
    const menu = electron.Menu.buildFromTemplate(menuTemplate);
    menu.popup({
      window: rootWindow
    });
  });
  listen(CERTIFICATES_CLEARED, () => {
    for (const serverViewWebContents of webContentsByServerUrl.values()) {
      serverViewWebContents.reloadIgnoringCache();
    }
  });
  rootWindow.webContents.addListener('will-attach-webview', handleWillAttachWebview);
  rootWindow.webContents.addListener('did-attach-webview', handleDidAttachWebview);
  handle('server-view/get-url', async webContents => {
    var _Array$from$find;
    return (_Array$from$find = Array.from(webContentsByServerUrl.entries()).find(([, v]) => v === webContents)) === null || _Array$from$find === void 0 ? void 0 : _Array$from$find[0];
  });
  let injectableCode;
  handle('server-view/ready', async webContents => {
    if (!injectableCode) {
      injectableCode = await fs__default.default.promises.readFile(path__default.default.join(electron.app.getAppPath(), 'app/injected.js'), 'utf8');
    }
    webContents.executeJavaScript(injectableCode, true);
  });
  handle('server-view/open-url-on-browser', async (_webContents, url) => {
    const allowed = await isProtocolAllowed(url);
    if (!allowed) {
      return;
    }
    openExternal(url);
  });
  listen(WEBVIEW_FORCE_RELOAD_WITH_CACHE_CLEAR, async action => {
    const serverUrl = action.payload;
    const guestWebContents = getWebContentsByServerUrl(serverUrl);
    if (!guestWebContents) {
      return;
    }

    // Clear cache keeping login data using the same method as Force Reload
    await guestWebContents.session.clearCache();
    await guestWebContents.session.clearStorageData({
      storages: ['cookies', 'indexdb', 'filesystem', 'shadercache', 'websql', 'serviceworkers', 'cachestorage']
    });

    // Reload ignoring cache
    guestWebContents.reloadIgnoringCache();
    dispatch({
      type: WEBVIEW_SERVER_RELOADED,
      payload: {
        url: serverUrl
      }
    });
  });
};

// This module contains all the urls used in the app

const rocketchat = {
  site: 'https://rocket.chat',
  subdomain: subdomain => `https://${subdomain}.rocket.chat`
};
const supportedVersions = ({
  domain,
  uniqueId
}) => `https://releases.rocket.chat/v2/server/supportedVersions?domain=${domain}&uniqueId=${uniqueId}&source=desktop`;
const server = serverUrl => ({
  uniqueId: `${serverUrl}api/v1/settings.public?_id=uniqueID`,
  setting: id => `${serverUrl}api/v1/settings.public?query=${encodeURIComponent(JSON.stringify({
    _id: id
  }))}`,
  info: `${serverUrl}api/info`,
  calendarEvents: {
    list: `${serverUrl}api/v1/calendar-events.list`,
    import: `${serverUrl}api/v1/calendar-events.import`,
    update: `${serverUrl}api/v1/calendar-events.update`,
    delete: `${serverUrl}api/v1/calendar-events.delete`
  }
});
const docs = {
  index: 'https://docs.rocket.chat/',
  // TODO: should it be a go link?
  supportedVersions: 'https://go.rocket.chat/i/supported-versions',
  newIssue: 'https://github.com/RocketChat/Rocket.Chat/issues/new' // TODO: should it be a go link?
};

const REQUIRED_SERVER_VERSION_RANGE = '>=2.0.0';
const convertToURL = input => {
  let url;
  if (/^https?:\/\//.test(input)) {
    url = new URL(input);
  } else {
    url = new URL(`https://${input}`);
  }
  const {
    protocol,
    username,
    password,
    hostname,
    port,
    pathname
  } = url;
  return Object.assign(new URL('https://0.0.0.0'), {
    protocol,
    username,
    password,
    hostname,
    port: protocol === 'http' && port === '80' && undefined || protocol === 'https' && port === '443' && undefined || port,
    pathname: /\/$/.test(pathname) ? pathname : `${pathname}/`
  });
};
const fetchServerInformation = async url => {
  const {
    webContents
  } = await getRootWindow();
  const [urlHref, version] = await invoke(webContents, 'servers/fetch-info', url.href);
  return [convertToURL(urlHref), version];
};
const resolveServerUrl = async input => {
  let url;
  try {
    url = convertToURL(input);
  } catch (error) {
    return [input, ServerUrlResolutionStatus.INVALID_URL, error];
  }
  let version;
  try {
    [url, version] = await fetchServerInformation(url);
  } catch (error) {
    if (!(error instanceof Error)) {
      throw error;
    }
    if (!/(^https?:\/\/)|(\.)|(^([^:]+:[^@]+@)?localhost(:\d+)?$)/.test(input)) {
      return resolveServerUrl(rocketchat.subdomain(input));
    }
    if ((error === null || error === void 0 ? void 0 : error.name) === 'AbortError') {
      return [url.href, ServerUrlResolutionStatus.TIMEOUT, error];
    }
    return [url.href, ServerUrlResolutionStatus.INVALID, error];
  }
  const semver = semver$1.coerce(version);
  if (!semver || !semver$1.satisfies(semver, REQUIRED_SERVER_VERSION_RANGE)) {
    return [url.href, ServerUrlResolutionStatus.INVALID, new Error(`incompatible server version (${version}, expected ${REQUIRED_SERVER_VERSION_RANGE})`)];
  }
  return [url.href, ServerUrlResolutionStatus.OK];
};
const loadAppServers = async () => {
  try {
    let filePath = path__default.default.join(electron.app.getAppPath(), electron.app.getAppPath().endsWith('app.asar') ? '..' : '.', 'servers.json');
    if (process.platform === 'darwin') {
      const darwinFilePath = `/Library/Preferences/${packageJsonInformation.productName}/servers.json`;
      if (fs__default.default.existsSync(darwinFilePath)) filePath = darwinFilePath;
    }
    const content = await fs__default.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const loadUserServers = async () => {
  try {
    const filePath = path__default.default.join(electron.app.getPath('userData'), 'servers.json');
    const content = await fs__default.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    await fs__default.default.promises.unlink(filePath);
    return json && typeof json === 'object' ? json : {};
  } catch (error) {
    return {};
  }
};
const setupServers = async localStorage => {
  var _ref, _serversMap$get$url, _serversMap$get, _servers$, _servers$2;
  listen(SERVER_URL_RESOLUTION_REQUESTED, async action => {
    if (!hasMeta(action)) {
      return;
    }
    try {
      dispatch({
        type: SERVER_URL_RESOLVED,
        payload: await resolveServerUrl(action.payload),
        meta: {
          response: true,
          id: action.meta.id
        }
      });
    } catch (error) {
      isServerUrlResolutionResult(error) && dispatch({
        type: SERVER_URL_RESOLVED,
        payload: error,
        error: true,
        meta: {
          response: true,
          id: action.meta.id
        }
      });
    }
  });
  listen(WEBVIEW_GIT_COMMIT_HASH_CHECK, async action => {
    const {
      url,
      gitCommitHash
    } = action.payload;
    const servers = select(({
      servers
    }) => servers);
    const server = servers.find(server => server.url === url);
    if ((server === null || server === void 0 ? void 0 : server.gitCommitHash) !== gitCommitHash && (server === null || server === void 0 ? void 0 : server.gitCommitHash) !== undefined) {
      dispatch({
        type: WEBVIEW_GIT_COMMIT_HASH_CHANGED,
        payload: {
          url,
          gitCommitHash
        }
      });
      const guestWebContents = getWebContentsByServerUrl(url);
      await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.session.clearStorageData({
        storages: ['indexdb']
      }));
      await (guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.session.clearCache());
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.reload();
    }
  });
  let servers = select(({
    servers
  }) => servers);
  let currentServerUrl = select(({
    currentView
  }) => typeof currentView === 'object' ? currentView.url : null);
  const serversMap = new Map(servers.filter(Boolean).filter(({
    url,
    title
  }) => typeof url === 'string' && typeof title === 'string').map(server => [server.url, server]));
  if (localStorage['rocket.chat.hosts']) {
    try {
      const storedString = JSON.parse(localStorage['rocket.chat.hosts']);
      if (/^https?:\/\//.test(storedString)) {
        serversMap.set(storedString, {
          url: storedString,
          title: storedString
        });
      } else {
        const storedValue = JSON.parse(storedString);
        if (Array.isArray(storedValue)) {
          storedValue.map(url => url.replace(/\/$/, '')).forEach(url => {
            serversMap.set(url, {
              url,
              title: url
            });
          });
        }
      }
    } catch (error) {
      console.warn(error);
    }
  }
  if (serversMap.size === 0) {
    const appConfiguration = await loadAppServers();
    for (const [title, url] of Object.entries(appConfiguration)) {
      serversMap.set(url, {
        url,
        title
      });
    }
    const userConfiguration = await loadUserServers();
    for (const [title, url] of Object.entries(userConfiguration)) {
      serversMap.set(url, {
        url,
        title
      });
    }
  }
  if (localStorage['rocket.chat.currentHost'] && localStorage['rocket.chat.currentHost'] !== 'null') {
    currentServerUrl = localStorage['rocket.chat.currentHost'];
  }
  servers = Array.from(serversMap.values());
  currentServerUrl = currentServerUrl ? (_ref = (_serversMap$get$url = (_serversMap$get = serversMap.get(currentServerUrl)) === null || _serversMap$get === void 0 ? void 0 : _serversMap$get.url) !== null && _serversMap$get$url !== void 0 ? _serversMap$get$url : (_servers$ = servers[0]) === null || _servers$ === void 0 ? void 0 : _servers$.url) !== null && _ref !== void 0 ? _ref : null : (_servers$2 = servers[0]) === null || _servers$2 === void 0 ? void 0 : _servers$2.url;
  if (localStorage['rocket.chat.sortOrder']) {
    try {
      const sorting = JSON.parse(localStorage['rocket.chat.sortOrder']);
      if (Array.isArray(sorting)) {
        servers = [...serversMap.values()].sort((a, b) => sorting.indexOf(a.url) - sorting.indexOf(b.url));
      }
    } catch (error) {
      console.warn(error);
    }
  }
  dispatch({
    type: SERVERS_LOADED,
    payload: {
      servers,
      selected: currentServerUrl
    }
  });
};

const isDefinedProtocol = parsedUrl => parsedUrl.protocol === `${electronBuilderJsonInformation.protocol}:`;
const isGoUrlShortener = parsedUrl => parsedUrl.protocol === 'https:' && parsedUrl.hostname === packageJsonInformation.goUrlShortener;
const parseDeepLink = input => {
  if (/^--/.test(input)) {
    // input is a CLI flag
    return null;
  }
  let url;
  try {
    url = new URL(input);
  } catch (error) {
    return null;
  }
  if (isDefinedProtocol(url)) {
    const action = url.hostname;
    const args = url.searchParams;
    return {
      action,
      args
    };
  }
  if (isGoUrlShortener(url)) {
    const action = url.pathname;
    const args = url.searchParams;
    return {
      action,
      args
    };
  }
  return null;
};
let processDeepLinksInArgs = async () => undefined;
const performOnServer = async (url, action) => {
  const [serverUrl, status, error] = await resolveServerUrl(url);
  if (status !== ServerUrlResolutionStatus.OK) {
    var _error$message;
    await warnAboutInvalidServerUrl(serverUrl, (_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : '');
    return;
  }
  const isServerAdded = select(({
    servers
  }) => servers.some(server => server.url === serverUrl));
  if (isServerAdded) {
    dispatch({
      type: DEEP_LINKS_SERVER_FOCUSED,
      payload: serverUrl
    });
    await action(serverUrl);
    return;
  }
  const permitted = await askForServerAddition(serverUrl);
  if (!permitted) {
    return;
  }
  dispatch({
    type: DEEP_LINKS_SERVER_ADDED,
    payload: serverUrl
  });
  await action(serverUrl);
};
const getWebContents = serverUrl => new Promise(resolve => {
  const poll = () => {
    const webContents = getWebContentsByServerUrl(serverUrl);
    if (webContents) {
      resolve(webContents);
      return;
    }
    setTimeout(poll, 100);
  };
  poll();
});
const performAuthentication = async ({
  host,
  token,
  userId
}) => performOnServer(host, async serverUrl => {
  const url = new URL('home', serverUrl);
  url.searchParams.append('resumeToken', token);
  url.searchParams.append('userId', userId);
  const webContents = await getWebContents(serverUrl);
  webContents.loadURL(url.href);
});

// https://developer.rocket.chat/rocket.chat/deeplink#channel-group-dm
const performOpenRoom = async ({
  host,
  path,
  token,
  userId
}) => performOnServer(host, async serverUrl => {
  if (!path) {
    return;
  }
  if (!/^\/?(direct|group|channel|livechat)\/[0-9a-zA-Z-_.]+/.test(path)) {
    return;
  }
  const url = new URL(path, serverUrl);
  if (token && userId) {
    url.searchParams.append('resumeToken', token);
    url.searchParams.append('userId', userId);
  }
  const webContents = await getWebContents(serverUrl);
  webContents.loadURL(url.href);
});
const performInvite = async ({
  host,
  path
}) => performOnServer(host, async serverUrl => {
  if (!/^invite\//.test(path)) {
    return;
  }
  const webContents = await getWebContents(serverUrl);
  webContents.loadURL(new URL(path, serverUrl).href);
});
const performConference = async ({
  host,
  path
}) => performOnServer(host, async serverUrl => {
  if (!/^conference\//.test(path)) {
    return;
  }
  const webContents = await getWebContents(serverUrl);
  webContents.loadURL(new URL(path, serverUrl).href);
});
const processDeepLink = async deepLink => {
  const parsedDeepLink = parseDeepLink(deepLink);
  if (!parsedDeepLink) {
    return;
  }
  const {
    action,
    args
  } = parsedDeepLink;
  switch (action) {
    case 'auth':
      {
        var _args$get, _args$get2, _args$get3;
        const host = (_args$get = args.get('host')) !== null && _args$get !== void 0 ? _args$get : undefined;
        const token = (_args$get2 = args.get('token')) !== null && _args$get2 !== void 0 ? _args$get2 : undefined;
        const userId = (_args$get3 = args.get('userId')) !== null && _args$get3 !== void 0 ? _args$get3 : undefined;
        if (host && token && userId) {
          await performAuthentication({
            host,
            token,
            userId
          });
        }
        break;
      }
    case 'room':
      {
        var _args$get4, _args$get5, _args$get6, _args$get7;
        const host = (_args$get4 = args.get('host')) !== null && _args$get4 !== void 0 ? _args$get4 : undefined;
        const path = (_args$get5 = args.get('path')) !== null && _args$get5 !== void 0 ? _args$get5 : undefined;
        const token = (_args$get6 = args.get('token')) !== null && _args$get6 !== void 0 ? _args$get6 : undefined;
        const userId = (_args$get7 = args.get('userId')) !== null && _args$get7 !== void 0 ? _args$get7 : undefined;
        if (host && path) {
          await performOpenRoom({
            host,
            path,
            token,
            userId
          });
        }
        break;
      }
    case 'invite':
      {
        var _args$get8, _args$get9;
        const host = (_args$get8 = args.get('host')) !== null && _args$get8 !== void 0 ? _args$get8 : undefined;
        const path = (_args$get9 = args.get('path')) !== null && _args$get9 !== void 0 ? _args$get9 : undefined;
        if (host && path) {
          await performInvite({
            host,
            path
          });
        }
        break;
      }
    case 'conference':
      {
        var _args$get10, _args$get11;
        const host = (_args$get10 = args.get('host')) !== null && _args$get10 !== void 0 ? _args$get10 : undefined;
        const path = (_args$get11 = args.get('path')) !== null && _args$get11 !== void 0 ? _args$get11 : undefined;
        if (host && path) {
          await performConference({
            host,
            path
          });
        }
        break;
      }
  }
};
const setupDeepLinks = () => {
  electron.app.addListener('open-url', async (event, url) => {
    event.preventDefault();
    const browserWindow = await getRootWindow();
    if (!browserWindow.isVisible()) {
      browserWindow.showInactive();
    }
    browserWindow.focus();
    await processDeepLink(url);
  });
  electron.app.addListener('second-instance', async (event, argv) => {
    event.preventDefault();
    const browserWindow = await getRootWindow();
    if (browserWindow && !browserWindow.isVisible()) {
      browserWindow.showInactive();
    }
    if (browserWindow) browserWindow.focus();
    const args = argv.slice(electron.app.isPackaged ? 1 : 2);
    for (const arg of args) {
      // eslint-disable-next-line no-await-in-loop
      await processDeepLink(arg);
    }
  });
  processDeepLinksInArgs = async () => {
    const args = process.argv.slice(electron.app.isPackaged ? 1 : 2);
    for (const arg of args) {
      // eslint-disable-next-line no-await-in-loop
      await processDeepLink(arg);
    }
  };
};

const startDocumentViewerHandler = () => {
  handle('document-viewer/open-window', async (event, url, _format, _options) => {
    const validUrl = new URL(url);
    const allowedProtocols = ['http:', 'https:'];
    if (!allowedProtocols.includes(validUrl.protocol)) {
      return;
    }
    const server = select(({
      servers
    }) => servers.find(s => new URL(s.url).origin === new URL(event.getURL()).origin));
    if (!server) {
      return;
    }
    dispatch({
      type: SERVER_DOCUMENT_VIEWER_OPEN_URL,
      payload: {
        server: server.url,
        documentUrl: url
      }
    });
  });
  listen(WEBVIEW_PDF_VIEWER_ATTACHED, async action => {
    const webContentsId = action.payload.WebContentsId;
    const webContent = electron.webContents.fromId(webContentsId);
    if (!webContent) {
      return;
    }
    webContent.on('will-navigate', (event, url) => {
      // Only prevent navigation for PDF viewer webviews, not video call windows
      // Check if this is actually a PDF viewer by examining the context
      const currentUrl = webContent.getURL();

      // Skip handling if this is a video call window or not a PDF viewer context
      if (currentUrl.includes('video-call-window.html') || currentUrl.includes('app/video-call-window.html')) {
        return;
      }

      // Also check if the navigation URL is an external protocol (like zoommtg://)
      // that should be handled by the system, not intercepted
      try {
        const navUrl = new URL(url);
        const isExternalProtocol = !['http:', 'https:', 'file:', 'data:', 'about:'].includes(navUrl.protocol);

        // If it's an external protocol, let the system handle it normally
        if (isExternalProtocol) {
          return;
        }
      } catch (e) {
        // If URL parsing fails, let the default handling proceed
        return;
      }
      event.preventDefault();
      setTimeout(() => {
        openExternal(url);
      }, 10);
    });
  });
};

let getAbsoluteUrl;

const NOTIFICATIONS_CREATE_REQUESTED = 'notifications/create-requested';
const NOTIFICATIONS_CREATE_RESPONDED = 'notifications/create-responded';
const NOTIFICATIONS_NOTIFICATION_ACTIONED = 'notifications/notification-actioned';
const NOTIFICATIONS_NOTIFICATION_CLICKED = 'notifications/notification-clicked';
const NOTIFICATIONS_NOTIFICATION_CLOSED = 'notifications/notification-closed';
const NOTIFICATIONS_NOTIFICATION_DISMISSED = 'notifications/notification-dismissed';
const NOTIFICATIONS_NOTIFICATION_REPLIED = 'notifications/notification-replied';
const NOTIFICATIONS_NOTIFICATION_SHOWN = 'notifications/notification-shown';

const normalizeIconUrl = iconUrl => {
  if (/^data:/.test(iconUrl)) {
    return iconUrl;
  }
  if (!/^https?:\/\//.test(iconUrl)) {
    return getAbsoluteUrl(iconUrl);
  }
  return iconUrl;
};
const eventHandlers = new Map();
const createNotification$1 = async ({
  title,
  icon,
  onEvent,
  ...options
}) => {
  const id = await request({
    type: NOTIFICATIONS_CREATE_REQUESTED,
    payload: {
      title,
      ...(icon ? {
        icon: normalizeIconUrl(icon)
      } : {}),
      ...options
    }
  }, NOTIFICATIONS_CREATE_RESPONDED);
  eventHandlers.set(id, event => onEvent === null || onEvent === void 0 ? void 0 : onEvent({
    type: event.type,
    detail: event.detail
  }));
  return id;
};

const items = new Map();
const handleWillDownloadEvent = async (_event, item, serverWebContents) => {
  const itemId = Date.now();
  items.set(itemId, item);
  const server = select(({
    servers
  }) => servers.find(server => server.webContentsId === serverWebContents.id));
  const serverUrl = (server === null || server === void 0 ? void 0 : server.url) || 'unknown';
  const serverTitle = (server === null || server === void 0 ? void 0 : server.title) || 'Unknown Server';
  const downloadPayload = {
    itemId,
    state: item.isPaused() ? 'paused' : item.getState(),
    status: item.isPaused() ? DownloadStatus.PAUSED : DownloadStatus.ALL,
    fileName: item.getFilename(),
    receivedBytes: item.getReceivedBytes(),
    totalBytes: item.getTotalBytes(),
    startTime: item.getStartTime() * 1000,
    endTime: undefined,
    url: item.getURL(),
    serverUrl,
    serverTitle,
    mimeType: item.getMimeType(),
    savePath: item.getSavePath()
  };
  dispatch({
    type: DOWNLOAD_CREATED,
    payload: downloadPayload
  });
  item.on('updated', () => {
    dispatch({
      type: DOWNLOAD_UPDATED,
      payload: {
        itemId,
        state: item.isPaused() ? 'paused' : item.getState(),
        status: item.isPaused() ? DownloadStatus.PAUSED : DownloadStatus.ALL,
        fileName: item.getFilename(),
        receivedBytes: item.getReceivedBytes(),
        totalBytes: item.getTotalBytes(),
        startTime: item.getStartTime() * 1000,
        endTime: Date.now(),
        url: item.getURL(),
        mimeType: item.getMimeType(),
        savePath: item.getSavePath()
      }
    });
  });
  item.on('done', (_event, state) => {
    createNotification$1({
      title: i18next.t('downloads.title', {
        defaultValue: 'Downloads'
      }),
      body: item.getFilename(),
      subtitle: state === 'completed' ? i18next.t('downloads.notifications.downloadFinished') : i18next.t('downloads.notifications.downloadCancelled')
    });
    dispatch({
      type: DOWNLOAD_UPDATED,
      payload: {
        itemId,
        state: item.getState(),
        status: item.getState() === 'cancelled' ? DownloadStatus.CANCELLED : DownloadStatus.ALL,
        fileName: item.getFilename(),
        receivedBytes: item.getReceivedBytes(),
        totalBytes: item.getTotalBytes(),
        startTime: item.getStartTime() * 1000,
        endTime: Date.now(),
        url: item.getURL(),
        mimeType: item.getMimeType(),
        savePath: item.getSavePath()
      }
    });
    items.delete(itemId);
  });
};
const setupDownloads = () => {
  handle('downloads/show-in-folder', async (_webContents, itemId) => {
    const download = select(({
      downloads
    }) => downloads[itemId]);
    if (!download) {
      return;
    }
    electron.shell.showItemInFolder(download.savePath);
  });
  handle('downloads/copy-link', async (_webContent, itemId) => {
    const download = select(({
      downloads
    }) => downloads[itemId]);
    if (!download) {
      return;
    }
    electron.clipboard.writeText(download.url);
  });
  handle('downloads/pause', async (_webContent, itemId) => {
    if (!items.has(itemId)) {
      return;
    }
    const item = items.get(itemId);
    if (item !== null && item !== void 0 && item.isPaused()) {
      return;
    }
    item === null || item === void 0 || item.pause();
  });
  handle('downloads/resume', async (_webContent, itemId) => {
    if (!items.has(itemId)) {
      return;
    }
    const item = items.get(itemId);
    if (!(item !== null && item !== void 0 && item.canResume())) {
      return;
    }
    item === null || item === void 0 || item.resume();
  });
  handle('downloads/cancel', async (_webContent, itemId) => {
    if (!items.has(itemId)) {
      return;
    }
    const item = items.get(itemId);
    item === null || item === void 0 || item.cancel();
  });
  handle('downloads/retry', async (_webContent, itemId) => {
    var _URL$searchParams$get;
    const {
      download,
      webContentsId
    } = select(({
      downloads,
      servers
    }) => {
      var _servers$find;
      const download = downloads[itemId];
      const {
        webContentsId
      } = (_servers$find = servers.find(server => server.url === download.serverUrl)) !== null && _servers$find !== void 0 ? _servers$find : {};
      return {
        download,
        webContentsId
      };
    });
    const downloadStartTimestamp = new URL(download.url).searchParams.get('X-Amz-Date');
    const expiresIn = (_URL$searchParams$get = new URL(download.url).searchParams.get('X-Amz-Expires')) !== null && _URL$searchParams$get !== void 0 ? _URL$searchParams$get : 120;
    const parsedStartTime = {
      year: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(0, 4),
      month: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(4, 6),
      day: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(6, 8),
      hour: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(9, 11),
      minute: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(11, 13),
      second: downloadStartTimestamp === null || downloadStartTimestamp === void 0 ? void 0 : downloadStartTimestamp.substring(13, 15)
    };
    const s3Expired = new Date().getTime() > new Date(`${parsedStartTime.year}-${parsedStartTime.month}-${parsedStartTime.day}T${parsedStartTime.hour}:${parsedStartTime.minute}:${parsedStartTime.second}Z`).getTime() + +expiresIn * 1000;
    if (s3Expired) {
      createNotification$1({
        title: i18next.t('downloads.notifications.downloadExpired'),
        body: i18next.t('downloads.notifications.downloadExpiredMessage'),
        subtitle: download.fileName
      });
      dispatch({
        type: DOWNLOAD_UPDATED,
        payload: {
          ...download,
          state: 'expired',
          status: DownloadStatus.CANCELLED
        }
      });
      return;
    }
    dispatch({
      type: DOWNLOAD_REMOVED,
      payload: itemId
    });
    if (webContentsId && electron.webContents !== undefined) {
      if (electron.webContents.fromId !== undefined) {
        const webContentsInstance = electron.webContents.fromId(webContentsId);
        if (webContentsInstance !== undefined) {
          webContentsInstance.downloadURL(download.url);
        }
      }
    }
  });
  handle('downloads/clear-all', async () => {
    dispatch({
      type: DOWNLOADS_CLEARED
    });
  });
  handle('downloads/remove', async (_webContent, itemId) => {
    if (items.has(itemId)) {
      const item = items.get(itemId);
      item === null || item === void 0 || item.cancel();
    }
    dispatch({
      type: DOWNLOAD_REMOVED,
      payload: itemId
    });
  });
};

// Lazy default download path resolution
let cachedDefaultDownloadPath = null;
function getDefaultDownloadPath() {
  if (cachedDefaultDownloadPath === null) {
    try {
      cachedDefaultDownloadPath = electron.app.getPath('downloads');
    } catch {
      cachedDefaultDownloadPath = os__default.default.tmpdir();
    }
  }
  return cachedDefaultDownloadPath;
}
function isValidDirectory(dir) {
  try {
    return !!dir && fs.existsSync(dir) && fs.statSync(dir).isDirectory();
  } catch {
    return false;
  }
}
const downloadStore = new ElectronStore__default.default({
  name: 'download-preferences',
  schema: {
    lastDownloadDirectory: {
      type: 'string'
    }
  }
});
const setupElectronDlWithTracking = () => {
  electronDl__default.default({
    saveAs: true,
    onStarted: item => {
      try {
        // Set the save dialog options with both directory and filename
        const configuredDir = downloadStore.get('lastDownloadDirectory', getDefaultDownloadPath());
        const lastDownloadDir = configuredDir && isValidDirectory(configuredDir) ? configuredDir : getDefaultDownloadPath();
        const fullPath = path__default.default.join(lastDownloadDir, item.getFilename());
        item.setSaveDialogOptions({
          defaultPath: fullPath
        });

        // Find the webContents that initiated this download
        // According to electron-dl docs, onStarted only receives DownloadItem
        // We need to find an active webContents for tracking purposes
        const webContentsArray = electron.webContents.getAllWebContents();

        // Use the first available webContents for tracking
        let sourceWebContents = null;
        for (const wc of webContentsArray) {
          if (wc && typeof wc.isDestroyed === 'function' && !wc.isDestroyed()) {
            sourceWebContents = wc;
            break;
          }
        }
        if (sourceWebContents) {
          const fakeEvent = {
            defaultPrevented: false,
            preventDefault: () => {}
          };
          handleWillDownloadEvent(fakeEvent, item, sourceWebContents).catch(() => {
            // Silently handle tracking errors
          });
        }
      } catch {
        // Silently handle any other errors in onStarted
      }
    },
    onCompleted: file => {
      try {
        // Remember the directory where the file was saved
        if (file.path) {
          const downloadDirectory = path__default.default.dirname(file.path);
          downloadStore.set('lastDownloadDirectory', downloadDirectory);
        }
        createNotification$1({
          title: i18next.t('downloads.title', {
            defaultValue: 'Downloads'
          }),
          body: file.filename || 'Unknown file',
          subtitle: i18next.t('downloads.notifications.downloadFinished')
        });
      } catch {
        // Silently handle any errors in onCompleted
      }
    }
  });
};

const DEFAULT_CRITICAL_PATTERNS = ['FATAL', 'Cannot access native module', 'Electron internal error'];
const isCriticalError = error => {
  return DEFAULT_CRITICAL_PATTERNS.some(pattern => {
    var _error$message, _error$stack;
    return ((_error$message = error.message) === null || _error$message === void 0 ? void 0 : _error$message.includes(pattern)) || ((_error$stack = error.stack) === null || _error$stack === void 0 ? void 0 : _error$stack.includes(pattern));
  });
};
let _globalHandlersBound = false;
const setupGlobalErrorHandlers = () => {
  if (_globalHandlersBound) return;
  process.on('uncaughtException', error => {
    console.error('Uncaught Exception:', error);
    if (Bugsnag__default.default.isStarted()) {
      Bugsnag__default.default.notify(error);
    }
    if (isCriticalError(error)) {
      console.error('Critical error detected, app cannot continue');
      electron.app.quit();
    }
  });
  process.on('unhandledRejection', reason => {
    const error = reason instanceof Error ? reason : new Error(`Unhandled Promise Rejection: ${String(reason)}`);
    console.error('Unhandled Promise Rejection:', error);
    if (Bugsnag__default.default.isStarted()) {
      Bugsnag__default.default.notify(error);
    }
    if (isCriticalError(error)) {
      console.error('Critical promise rejection, app cannot continue');
      electron.app.quit();
    }
  });
  _globalHandlersBound = true;
};
const listenToBugsnagEnabledToggle = async appType => {
  {
    return;
  }
};
const setupRendererErrorHandling = async appType => {
  await listenToBugsnagEnabledToggle();
};
const setupMainErrorHandling = async () => {
  setupGlobalErrorHandlers();
  await setupRendererErrorHandling();
};

const I18N_LNG_REQUESTED = 'i18n/lng-requested';
const I18N_LNG_RESPONDED = 'i18n/lng-responded';

const fallbackLng = 'en';
const byteUnits = ['byte', 'kilobyte', 'megabyte', 'gigabyte', 'terabyte', 'petabyte'];
const formatBytes = bytes => {
  const order = Math.min(Math.floor(Math.log(bytes) / Math.log(1024)), byteUnits.length - 1);
  const unit = byteUnits[order];
  if (!unit) {
    return '???';
  }
  const formatter = new Intl.NumberFormat(undefined, {
    notation: 'compact',
    style: 'unit',
    unit,
    maximumFractionDigits: 1
  });
  return formatter.format(bytes / Math.pow(1024, order));
};
const formatByteSpeed = bytesPerSecond => {
  const order = Math.min(Math.floor(Math.log(bytesPerSecond) / Math.log(1024)), byteUnits.length - 1);
  const unit = byteUnits[order];
  if (!unit) {
    return '???';
  }
  const formatter = new Intl.NumberFormat(undefined, {
    notation: 'compact',
    style: 'unit',
    unit: `${unit}-per-second`,
    maximumFractionDigits: 1
  });
  return formatter.format(bytesPerSecond / Math.pow(1024, order));
};
const formatPercentage = ratio => {
  const formatter = new Intl.NumberFormat(undefined, {
    style: 'percent',
    maximumFractionDigits: 0
  });
  return formatter.format(ratio);
};
const formatDuration = duration => {
  const formatter = new Intl.RelativeTimeFormat(undefined, {
    style: 'narrow',
    numeric: 'always'
  });
  duration /= 1000;
  if (duration / 60 < 1) {
    return formatter.format(duration, 'second');
  }
  duration /= 60;
  if (duration / 60 < 1) {
    return formatter.format(duration, 'minute');
  }
  duration /= 60;
  if (duration / 24 < 1) {
    return formatter.format(duration, 'hour');
  }
  duration /= 24;
  if (duration / 7 < 1) {
    return formatter.format(duration, 'day');
  }
  duration /= 7;
  if (duration / 30 < 1) {
    return formatter.format(duration, 'week');
  }
  duration /= 30;
  if (duration / 12 < 1) {
    return formatter.format(duration, 'month');
  }
  duration /= 12;
  return formatter.format(duration, 'year');
};
const interpolation = {
  format: (value, format, lng) => {
    if (value instanceof Date && !Number.isNaN(value.getTime())) {
      return new Intl.DateTimeFormat(lng).format(value);
    }
    switch (format) {
      case 'byteSize':
        return formatBytes(value);
      case 'byteSpeed':
        return formatByteSpeed(value);
      case 'percentage':
        return formatPercentage(value);
      case 'duration':
        return formatDuration(value);
    }
    return String(value);
  }
};

var resources = {
  'de-DE': () => Promise.resolve().then(function () { return require('./de-DE.i18n-4ehSEkGh.js'); }),
  'en': () => Promise.resolve().then(function () { return require('./en.i18n-G3nKXNjZ.js'); }),
  'es': () => Promise.resolve().then(function () { return require('./es.i18n-9WxSuxcl.js'); }),
  'fi': () => Promise.resolve().then(function () { return require('./fi.i18n-6xEr64Fx.js'); }),
  'sv': () => Promise.resolve().then(function () { return require('./sv.i18n-oh2ynq1O.js'); }),
  'no': () => Promise.resolve().then(function () { return require('./no.i18n-6AzCb8BL.js'); }),
  'fr': () => Promise.resolve().then(function () { return require('./fr.i18n-h-eBWyjU.js'); }),
  'hu': () => Promise.resolve().then(function () { return require('./hu.i18n-lmdgv3Z-.js'); }),
  'it-IT': () => Promise.resolve().then(function () { return require('./it-IT.i18n-RI03wdB6.js'); }),
  'ja': () => Promise.resolve().then(function () { return require('./ja.i18n-17s7HO6D.js'); }),
  'pl': () => Promise.resolve().then(function () { return require('./pl.i18n-CJnM_8eo.js'); }),
  'pt-BR': () => Promise.resolve().then(function () { return require('./pt-BR.i18n-9jl02ZN0.js'); }),
  'ru': () => Promise.resolve().then(function () { return require('./ru.i18n-GH94RPQd.js'); }),
  'tr-TR': () => Promise.resolve().then(function () { return require('./tr-TR.i18n-Dn_Vvi-F.js'); }),
  'uk-UA': () => Promise.resolve().then(function () { return require('./uk-UA.i18n-w0dW83P-.js'); }),
  'zh-CN': () => Promise.resolve().then(function () { return require('./zh-CN.i18n-bN_Wg5oh.js'); }),
  'zh-TW': () => Promise.resolve().then(function () { return require('./zh-TW.i18n-mm4kcWUi.js'); })
};

const hasLng = lng => lng in resources;
const getLng = async () => {
  await electron.app.whenReady();
  const locale = electron.app.getSystemLocale();
  let [languageCode, countryCode] = locale.split(/[-_]/);
  if (!languageCode || languageCode.length !== 2) {
    return fallbackLng;
  }
  languageCode = languageCode.toLowerCase();
  const isCountryCodeInexistentOrNonStandard = !countryCode || countryCode.length !== 2;
  countryCode = isCountryCodeInexistentOrNonStandard ? '' : countryCode.toUpperCase();
  const lng = countryCode ? `${languageCode}-${countryCode}` : languageCode;
  if (hasLng(lng)) {
    return lng;
  }
  return Object.keys(resources).find(language => language.startsWith(languageCode));
};
let getLanguage = 'en';
class I18nService extends Service {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "initialization", void 0);
    _defineProperty(this, "t", i18next__default.default.t.bind(i18next__default.default));
  }
  async initializeAsync() {
    const lng = await getLng();
    getLanguage = lng || 'en';
    this.t = await i18next__default.default.init({
      lng,
      fallbackLng,
      resources: {
        ...(lng && lng in resources && {
          [lng]: {
            translation: await resources[lng]()
          }
        }),
        [fallbackLng]: {
          translation: await resources[fallbackLng]()
        }
      },
      interpolation,
      initImmediate: true
    });
  }
  initialize() {
    this.initialization = this.initializeAsync();
    this.listen(I18N_LNG_REQUESTED, action => {
      var _action$meta;
      if (!hasMeta(action) || !action.meta.id) {
        return;
      }
      dispatch({
        type: I18N_LNG_RESPONDED,
        payload: hasLng(i18next__default.default.language) ? i18next__default.default.language : fallbackLng,
        meta: {
          response: true,
          id: (_action$meta = action.meta) === null || _action$meta === void 0 ? void 0 : _action$meta.id
        }
      });
    });
  }
  wait() {
    var _this$initialization;
    return (_this$initialization = this.initialization) !== null && _this$initialization !== void 0 ? _this$initialization : Promise.reject(new Error('not initialized'));
  }
}
var i18n = new I18nService();

var main = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: i18n,
  get getLanguage () { return getLanguage; }
});

const isJitsiServerAllowed = async rawUrl => {
  const url = new URL(rawUrl);
  const persistedServers = Object.entries(select(({
    allowedJitsiServers
  }) => allowedJitsiServers)).filter(([key]) => key === url.host);
  if (persistedServers.length) {
    return {
      allowed: persistedServers[0][1],
      dontAskAgain: true
    };
  }
  const {
    allowed,
    dontAskAgain
  } = await askForJitsiCaptureScreenPermission(url);
  if (dontAskAgain) {
    dispatch({
      type: JITSI_SERVER_CAPTURE_SCREEN_PERMISSION_UPDATED,
      payload: {
        jitsiServer: url.hostname,
        allowed
      }
    });
  }
  return {
    allowed,
    dontAskAgain
  };
};

let permitted = false;
let dontAskAgain = false;
let firstAskPermission = true;
const handleJitsiDesktopCapturerGetSources = () => {
  handle('jitsi-desktop-capturer-get-sources', async (_webContents, [opts, jitsiDomain]) => {
    if (permitted) return electron.desktopCapturer.getSources(opts);
    if (dontAskAgain) return [];
    if (firstAskPermission) {
      firstAskPermission = false;
      const askResult = await isJitsiServerAllowed(jitsiDomain);
      permitted = askResult.allowed;
      dontAskAgain = askResult.dontAskAgain;
    }
    return [];
  });
};

const resolveIcon = async iconUrl => {
  if (!iconUrl) {
    return undefined;
  }
  if (/^data:/.test(iconUrl)) {
    return electron.nativeImage.createFromDataURL(iconUrl);
  }
  try {
    const {
      webContents
    } = await getRootWindow();
    const dataUri = await invoke(webContents, 'notifications/fetch-icon', iconUrl);
    return electron.nativeImage.createFromDataURL(dataUri);
  } catch (error) {
    console.error(error);
    return undefined;
  }
};
const notifications = new Map();
const createNotification = async (id, {
  title,
  subtitle,
  body,
  icon,
  silent,
  canReply,
  actions
}, ipcMeta) => {
  const notification = new electron.Notification({
    title,
    subtitle,
    body: body !== null && body !== void 0 ? body : '',
    icon: await resolveIcon(icon),
    silent: silent !== null && silent !== void 0 ? silent : undefined,
    hasReply: canReply,
    actions: actions === null || actions === void 0 ? void 0 : actions.map(action => ({
      type: 'button',
      text: action.title
    }))
  });
  notification.addListener('show', () => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_SHOWN,
      payload: {
        id
      },
      ipcMeta
    });
  });
  notification.addListener('close', () => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_CLOSED,
      payload: {
        id
      },
      ipcMeta
    });
    notifications.delete(id);
  });
  notification.addListener('click', () => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_CLICKED,
      payload: {
        id,
        title
      },
      ipcMeta
    });
  });
  notification.addListener('reply', (_event, reply) => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_REPLIED,
      payload: {
        id,
        reply
      },
      ipcMeta
    });
  });
  notification.addListener('action', (_event, index) => {
    dispatchSingle({
      type: NOTIFICATIONS_NOTIFICATION_ACTIONED,
      payload: {
        id,
        index
      },
      ipcMeta
    });
  });
  notifications.set(id, notification);
  notification.show();
  return id;
};
const updateNotification = async (id, {
  title,
  body,
  silent,
  renotify
}) => {
  const notification = notifications.get(id);
  if (title) {
    notification.title = title;
  }
  if (body) {
    notification.body = body;
  }
  if (silent) {
    notification.silent = silent;
  }
  if (renotify) {
    notification.show();
  }
  return id;
};
const handleCreateEvent = async ({
  tag,
  ...options
}, ipcMeta) => {
  if (tag && notifications.has(tag)) {
    return updateNotification(tag, options);
  }
  const id = tag || Math.random().toString(36).slice(2);
  return createNotification(id, options, ipcMeta);
};
const setupNotifications = () => {
  listen(NOTIFICATIONS_CREATE_REQUESTED, async action => {
    if (!hasMeta(action)) {
      return;
    }
    dispatch({
      type: NOTIFICATIONS_CREATE_RESPONDED,
      payload: await handleCreateEvent(action.payload, action.ipcMeta),
      meta: {
        id: action.meta.id,
        response: true
      }
    });
  });
  listen(NOTIFICATIONS_NOTIFICATION_DISMISSED, action => {
    var _notifications$get;
    (_notifications$get = notifications.get(action.payload.id)) === null || _notifications$get === void 0 || _notifications$get.close();
  });
};

/**
 * Checks if a version meets or exceeds a minimum required version
 * Safely handles various version string formats by normalizing with semver.coerce
 *
 * @param version The version to check
 * @param minimumVersion The minimum version required
 * @returns boolean Whether the version meets or exceeds the minimum required version
 */
function meetsMinimumVersion(version, minimumVersion) {
  var _coerce;
  if (!version) return false;

  // Coerce version to a valid semver format and use its normalized form
  const normalizedVersion = ((_coerce = semver$1.coerce(version)) === null || _coerce === void 0 ? void 0 : _coerce.version) || '0.0.0';
  return semver$1.gte(normalizedVersion, minimumVersion);
}

/* eslint-disable new-cap */
const getOutlookEvents = async (credentials, date) => {
  try {
    const {
      login,
      password,
      serverUrl
    } = credentials;
    const xhrApi = new xhr.XhrApi({
      decompress: true
    });
    xhrApi.useNtlmAuthentication(login, password);
    ewsJavascriptApi.ConfigurationApi.ConfigureXHR(xhrApi);
    const exchange = new ewsJavascriptApi.ExchangeService(ewsJavascriptApi.ExchangeVersion.Exchange2013);
    // This credentials object isn't used when ntlm is active, but the lib still requires it.
    exchange.Credentials = new ewsJavascriptApi.WebCredentials(login, password);
    exchange.Url = new ewsJavascriptApi.Uri(`${serverUrl}/ews/exchange.asmx`);
    const validatedDate = new Date(date);
    const folderId = new ewsJavascriptApi.FolderId(ewsJavascriptApi.WellKnownFolderName.Calendar);
    const minTime = new ewsJavascriptApi.DateTime(validatedDate.getFullYear(), validatedDate.getMonth() + 1, validatedDate.getDate());
    const maxTime = new ewsJavascriptApi.DateTime(validatedDate.getFullYear(), validatedDate.getMonth() + 1, validatedDate.getDate(), 23, 59, 59);
    const view = new ewsJavascriptApi.CalendarView(minTime, maxTime);
    let appointments = [];
    try {
      appointments = (await exchange.FindAppointments(folderId, view)).Items;
    } catch (error) {
      console.error(error);
      return Promise.reject(error);
    }
    // Filter out appointments that end exactly at midnight
    const filtered = appointments.filter(appointment => appointment.End > minTime);
    if (filtered.length === 0) {
      return [];
    }
    const propertySet = new ewsJavascriptApi.PropertySet(ewsJavascriptApi.BasePropertySet.FirstClassProperties);
    try {
      await exchange.LoadPropertiesForItems(filtered, propertySet);
    } catch (error) {
      return Promise.reject(error);
    }
    return filtered.map(appointment => {
      var _appointment$IsAllDay, _appointment$IsCancel, _appointment$JoinOnli, _appointment$Reminder;
      let description = '';
      try {
        var _appointment$Body;
        if ((_appointment$Body = appointment.Body) !== null && _appointment$Body !== void 0 && _appointment$Body.Text) {
          description = appointment.Body.Text;
        }
      } catch {
        // Ignore errors when the appointment body is missing.
      }

      // Check if the busy status is Busy
      // LegacyFreeBusyStatus enum: Free = 0, Tentative = 1, Busy = 2, OOF = 3
      const isBusy = appointment.LegacyFreeBusyStatus === ewsJavascriptApi.LegacyFreeBusyStatus.Busy;
      return {
        id: appointment.Id.UniqueId,
        subject: appointment.Subject,
        startTime: appointment.Start.ToISOString(),
        endTime: appointment.End.ToISOString(),
        description,
        isAllDay: (_appointment$IsAllDay = appointment.IsAllDayEvent) !== null && _appointment$IsAllDay !== void 0 ? _appointment$IsAllDay : false,
        isCanceled: (_appointment$IsCancel = appointment.IsCancelled) !== null && _appointment$IsCancel !== void 0 ? _appointment$IsCancel : false,
        meetingUrl: (_appointment$JoinOnli = appointment.JoinOnlineMeetingUrl) !== null && _appointment$JoinOnli !== void 0 ? _appointment$JoinOnli : undefined,
        reminderMinutesBeforeStart: (_appointment$Reminder = appointment.ReminderMinutesBeforeStart) !== null && _appointment$Reminder !== void 0 ? _appointment$Reminder : undefined,
        busy: isBusy
      };
    });
  } catch (error) {
    console.error(error);
    return Promise.reject(error);
  }
};

const getServerInformationByWebContentsId = webContentsId => {
  const {
    servers
  } = select(selectPersistableValues);
  const server = servers.find(server => server.webContentsId === webContentsId);
  return server || {};
};
function checkIfCredentialsAreNotEmpty(credentials) {
  return credentials.login.trim() !== '' && credentials.password.trim() !== '' && credentials.userId.trim() !== '' && credentials.serverUrl.trim() !== '';
}
function encryptedCredentials(credentials) {
  return {
    ...credentials,
    login: electron.safeStorage.encryptString(credentials.login).toString('base64'),
    password: electron.safeStorage.encryptString(credentials.password).toString('base64')
  };
}
function decryptedCredentials(credentials) {
  return {
    ...credentials,
    login: electron.safeStorage.decryptString(Buffer.from(credentials.login, 'base64')).toString(),
    password: electron.safeStorage.decryptString(Buffer.from(credentials.password, 'base64')).toString()
  };
}
async function listEventsFromRocketChatServer(serverUrl, userId, token) {
  try {
    const response = await axios__default.default.get(server(serverUrl).calendarEvents.list, {
      headers: {
        'Content-Type': 'application/json',
        'X-Auth-Token': token,
        'X-User-Id': userId
      },
      params: {
        date: new Date().toISOString()
      }
    });
    return response.data;
  } catch (error) {
    console.error('Error sending message:', error);
  }
}
async function createEventOnRocketChatServer(serverUrl, userId, token, event) {
  try {
    // Get server object to check version
    const {
      servers
    } = select(selectPersistableValues);
    const server$1 = servers.find(server => server.url === serverUrl);

    // Base payload
    const payload = {
      externalId: event.id,
      subject: event.subject,
      startTime: event.startTime,
      description: event.description,
      reminderMinutesBeforeStart: event.reminderMinutesBeforeStart
    };

    // Add endTime and busy only for server version 7.5.0 or higher
    if (server$1 !== null && server$1 !== void 0 && server$1.version && meetsMinimumVersion(server$1.version, '7.5.0')) {
      payload.endTime = event.endTime;
      payload.busy = event.busy;
    }
    await axios__default.default.post(server(serverUrl).calendarEvents.import, payload, {
      headers: {
        'Content-Type': 'application/json',
        'X-Auth-Token': token,
        'X-User-Id': userId
      }
    });
  } catch (error) {
    console.error('Error saving event on server:', error);
  }
}
async function updateEventOnRocketChatServer(serverUrl, userId, token, rocketChatEventId, event) {
  try {
    // Get server object to check version
    const {
      servers
    } = select(selectPersistableValues);
    const server$1 = servers.find(server => server.url === serverUrl);

    // Base payload
    const payload = {
      eventId: rocketChatEventId,
      subject: event.subject,
      startTime: event.startTime,
      description: event.description,
      reminderMinutesBeforeStart: event.reminderMinutesBeforeStart
    };

    // Add endTime and busy only for server version 7.5.0 or higher
    if (server$1 !== null && server$1 !== void 0 && server$1.version && meetsMinimumVersion(server$1.version, '7.5.0')) {
      payload.endTime = event.endTime;
      payload.busy = event.busy;
    }
    await axios__default.default.post(server(serverUrl).calendarEvents.update, payload, {
      headers: {
        'Content-Type': 'application/json',
        'X-Auth-Token': token,
        'X-User-Id': userId
      }
    });
  } catch (error) {
    console.error('Error updating event on server:', error);
  }
}
async function deleteEventOnRocketChatServer(serverUrl, userId, token, rocketChatEventId) {
  try {
    await axios__default.default.post(server(serverUrl).calendarEvents.delete, {
      eventId: rocketChatEventId
    }, {
      headers: {
        'Content-Type': 'application/json',
        'X-Auth-Token': token,
        'X-User-Id': userId
      }
    });
  } catch (error) {
    console.error('Error deleting event on server:', error);
  }
}
async function syncEventsWithRocketChatServer(serverUrl, credentials, token) {
  if (!checkIfCredentialsAreNotEmpty(credentials)) return;
  const eventsOnOutlookServer = await getOutlookEvents(credentials, new Date(Date.now()));
  const eventsOnRocketChatServer = await listEventsFromRocketChatServer(serverUrl, credentials.userId, token);
  const appointmentsFound = eventsOnOutlookServer.map(appointment => appointment.id);
  const externalEventsFromRocketChatServer = eventsOnRocketChatServer === null || eventsOnRocketChatServer === void 0 ? void 0 : eventsOnRocketChatServer.data.filter(({
    externalId
  }) => externalId);

  // Get server object to check version
  const {
    servers
  } = select(selectPersistableValues);
  const server = servers.find(server => server.url === serverUrl);
  for await (const appointment of eventsOnOutlookServer) {
    try {
      const alreadyOnRocketChatServer = externalEventsFromRocketChatServer.find(({
        externalId
      }) => externalId === appointment.id);
      const {
        subject,
        startTime,
        description,
        reminderMinutesBeforeStart
      } = appointment;

      // If the appointment is not in the rocket.chat calendar for today, add it.
      if (!alreadyOnRocketChatServer) {
        createEventOnRocketChatServer(serverUrl, credentials.userId, token, appointment);
        continue;
      }

      // If nothing on the event has changed, do nothing.
      if (alreadyOnRocketChatServer.subject === subject && alreadyOnRocketChatServer.startTime === startTime && alreadyOnRocketChatServer.description === description && alreadyOnRocketChatServer.reminderMinutesBeforeStart === reminderMinutesBeforeStart && (!(server !== null && server !== void 0 && server.version) || !meetsMinimumVersion(server.version, '7.5.0') || alreadyOnRocketChatServer.endTime === appointment.endTime && alreadyOnRocketChatServer.busy === appointment.busy)) {
        continue;
      }

      // If the appointment is in the rocket.chat calendar for today, but something has changed, update it.
      await updateEventOnRocketChatServer(serverUrl, credentials.userId, token, alreadyOnRocketChatServer._id, appointment);
    } catch (error) {
      console.error('Error syncing event:', error);
    }
  }
  if (!eventsOnRocketChatServer.data.length) {
    return;
  }
  for await (const event of eventsOnRocketChatServer.data) {
    if (!event.externalId || appointmentsFound.includes(event.externalId)) {
      continue;
    }
    try {
      await deleteEventOnRocketChatServer(serverUrl, credentials.userId, token, event._id);
    } catch (e) {
      console.error(e);
    }
  }
}
let recurringSyncTaskId;
let userAPIToken;
async function maybeSyncEvents(serverToSync) {
  if (!userAPIToken) throw new Error('No user token');
  if (!serverToSync.webContentsId) throw new Error('No webContentsId');
  const server = getServerInformationByWebContentsId(serverToSync.webContentsId);
  if (!server.outlookCredentials) throw new Error('No credentials');
  const credentials = electron.safeStorage.isEncryptionAvailable() ? decryptedCredentials(server.outlookCredentials) : server.outlookCredentials;
  if (!checkIfCredentialsAreNotEmpty(credentials)) throw new Error('Credentials are empty');
  try {
    await syncEventsWithRocketChatServer(server.url, credentials, userAPIToken);
    console.log('Recurring task executed successfully');
  } catch (e) {
    console.error('Error sending events to server', e);
  }
}
async function recurringSyncTask(serverToSync) {
  try {
    console.log('Executing recurring task');
    await maybeSyncEvents(serverToSync);
  } catch (error) {
    console.error('Error occurred:', error);
    clearInterval(recurringSyncTaskId);
  }
}
function startRecurringSyncTask(server) {
  if (!userAPIToken) return;
  recurringSyncTaskId = setInterval(() => recurringSyncTask(server), 60 * 60 * 1000); // minutes * seconds * milliseconds
}
const startOutlookCalendarUrlHandler = () => {
  handle('outlook-calendar/set-user-token', async (event, token, userId) => {
    userAPIToken = token;
    const server = getServerInformationByWebContentsId(event.id);
    if (!server) return;
    const {
      outlookCredentials
    } = server;
    if (!outlookCredentials) return;
    if (outlookCredentials.userId !== userId || !userAPIToken) return;
    if (!checkIfCredentialsAreNotEmpty(outlookCredentials)) return;
    startRecurringSyncTask(server);
    setImmediate(() => {
      try {
        maybeSyncEvents(server);
      } catch (e) {
        console.error('Failed to sync outlook events on startup.', e);
      }
    });
  });
  handle('outlook-calendar/clear-credentials', async event => {
    const server = getServerInformationByWebContentsId(event.id);
    if (!server) return;
    const {
      outlookCredentials
    } = server;
    if (!outlookCredentials) return;
    dispatch({
      type: OUTLOOK_CALENDAR_SAVE_CREDENTIALS,
      payload: {
        url: server.url,
        outlookCredentials: {
          userId: outlookCredentials.userId,
          serverUrl: outlookCredentials.serverUrl,
          login: '',
          password: ''
        }
      }
    });
  });
  handle('outlook-calendar/set-exchange-url', async (event, url, userId) => {
    const server = getServerInformationByWebContentsId(event.id);
    if (!server) return;
    const {
      outlookCredentials
    } = server;
    if ((outlookCredentials === null || outlookCredentials === void 0 ? void 0 : outlookCredentials.userId) !== userId || (outlookCredentials === null || outlookCredentials === void 0 ? void 0 : outlookCredentials.serverUrl) !== url) {
      dispatch({
        type: OUTLOOK_CALENDAR_SAVE_CREDENTIALS,
        payload: {
          url: server.url,
          outlookCredentials: {
            userId,
            serverUrl: url,
            login: '',
            password: ''
          }
        }
      });
    }
  });
  handle('outlook-calendar/has-credentials', async event => {
    const server = getServerInformationByWebContentsId(event.id);
    if (!server) return false;
    const {
      outlookCredentials
    } = server;
    if (!outlookCredentials) return false;
    return checkIfCredentialsAreNotEmpty(outlookCredentials);
  });
  handle('outlook-calendar/get-events', async (event, _date) => {
    const server = getServerInformationByWebContentsId(event.id);
    const {
      outlookCredentials
    } = server;
    if (
    // eslint-disable-next-line @typescript-eslint/prefer-optional-chain
    !outlookCredentials || !outlookCredentials.userId || !outlookCredentials.serverUrl) {
      return Promise.reject(new Error('No credentials'));
    }
    let credentials;
    let saveCredentials = false;
    if (!checkIfCredentialsAreNotEmpty(outlookCredentials)) {
      const response = await request({
        type: OUTLOOK_CALENDAR_ASK_CREDENTIALS,
        payload: {
          server,
          userId: outlookCredentials.userId,
          isEncryptionAvailable: electron.safeStorage.isEncryptionAvailable()
        }
      }, OUTLOOK_CALENDAR_SET_CREDENTIALS, OUTLOOK_CALENDAR_DIALOG_DISMISSED);
      if (response.dismissDialog === true) {
        return {
          status: 'canceled'
        };
      }
      if (!checkIfCredentialsAreNotEmpty(response === null || response === void 0 ? void 0 : response.outlookCredentials)) {
        return Promise.reject(new Error('Invalid credentials'));
      }
      credentials = response.outlookCredentials;
      saveCredentials = response.saveCredentials || false;
    } else {
      credentials = electron.safeStorage.isEncryptionAvailable() ? decryptedCredentials(outlookCredentials) : outlookCredentials;
    }
    try {
      await syncEventsWithRocketChatServer(server.url, credentials, userAPIToken);
    } catch (e) {
      console.error('Error syncing events with Rocket.Chat server', e);
      return Promise.reject(e);
    }
    if (saveCredentials) {
      startRecurringSyncTask(server);
      dispatch({
        type: OUTLOOK_CALENDAR_SAVE_CREDENTIALS,
        payload: {
          url: server.url,
          outlookCredentials: electron.safeStorage.isEncryptionAvailable() ? encryptedCredentials(credentials) : credentials
        }
      });
    }
    return {
      status: 'success'
    };
  });
};

const setupScreenSharing = () => {
  listen(WEBVIEW_SCREEN_SHARING_SOURCE_REQUESTED, requestAction => {
    if (!hasMeta(requestAction) || !requestAction.meta.id) {
      return;
    }
    const predicate = action => isResponseTo(requestAction.meta.id, WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED, SCREEN_SHARING_DIALOG_DISMISSED)(action);
    const unsubscribe = listen(predicate, responseAction => {
      var _requestAction$meta;
      unsubscribe();
      const sourceId = responseAction.type === WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED ? responseAction.payload : null;
      dispatch({
        type: WEBVIEW_SCREEN_SHARING_SOURCE_RESPONDED,
        payload: sourceId,
        meta: {
          response: true,
          id: (_requestAction$meta = requestAction.meta) === null || _requestAction$meta === void 0 ? void 0 : _requestAction$meta.id
        }
      });
    });
  });
};

const clearWebviewStorageKeepingLoginData = async guestWebContents => {
  if (!guestWebContents) return;
  await guestWebContents.session.clearCache();
  await guestWebContents.session.clearStorageData({
    storages: ['cookies', 'indexdb', 'filesystem', 'shadercache', 'websql', 'serviceworkers', 'cachestorage']
  });
  guestWebContents === null || guestWebContents === void 0 || guestWebContents.reloadIgnoringCache();
};
const clearWebviewStorageDeletingLoginData = async guestWebContents => {
  if (!guestWebContents) return;
  await guestWebContents.session.clearCache();
  await guestWebContents.session.clearStorageData();
  guestWebContents === null || guestWebContents === void 0 || guestWebContents.reloadIgnoringCache();
};
const handleClearCacheDialog = () => {
  listen(CLEAR_CACHE_DIALOG_KEEP_LOGIN_DATA_CLICKED, async action => {
    const guestWebContents = electron.webContents.fromId(action.payload);
    if (!guestWebContents) {
      return;
    }
    await clearWebviewStorageKeepingLoginData(guestWebContents);
  });
  listen(CLEAR_CACHE_DIALOG_DELETE_LOGIN_DATA_CLICKED, async action => {
    const guestWebContents = electron.webContents.fromId(action.payload);
    if (!guestWebContents) {
      return;
    }
    await clearWebviewStorageDeletingLoginData(guestWebContents);
  });
};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

const debug$1 = typeof process === 'object' && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error('SEMVER', ...args) : () => {};
var debug_1 = debug$1;

// Note: this is the semver.org version of the spec that it implements
// Not necessarily the package version of this code.
const SEMVER_SPEC_VERSION = '2.0.0';
const MAX_LENGTH$1 = 256;
const MAX_SAFE_INTEGER$1 = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */9007199254740991;

// Max safe segment length for coercion.
const MAX_SAFE_COMPONENT_LENGTH = 16;

// Max safe length for a build identifier. The max length minus 6 characters for
// the shortest version with a build 0.0.0+BUILD.
const MAX_SAFE_BUILD_LENGTH = MAX_LENGTH$1 - 6;
const RELEASE_TYPES = ['major', 'premajor', 'minor', 'preminor', 'patch', 'prepatch', 'prerelease'];
var constants = {
  MAX_LENGTH: MAX_LENGTH$1,
  MAX_SAFE_COMPONENT_LENGTH,
  MAX_SAFE_BUILD_LENGTH,
  MAX_SAFE_INTEGER: MAX_SAFE_INTEGER$1,
  RELEASE_TYPES,
  SEMVER_SPEC_VERSION,
  FLAG_INCLUDE_PRERELEASE: 0b001,
  FLAG_LOOSE: 0b010
};

var re$1 = {exports: {}};

(function (module, exports) {
	const {
	  MAX_SAFE_COMPONENT_LENGTH,
	  MAX_SAFE_BUILD_LENGTH,
	  MAX_LENGTH
	} = constants;
	const debug = debug_1;
	exports = module.exports = {};

	// The actual regexps go on exports.re
	const re = exports.re = [];
	const safeRe = exports.safeRe = [];
	const src = exports.src = [];
	const t = exports.t = {};
	let R = 0;
	const LETTERDASHNUMBER = '[a-zA-Z0-9-]';

	// Replace some greedy regex tokens to prevent regex dos issues. These regex are
	// used internally via the safeRe object since all inputs in this library get
	// normalized first to trim and collapse all extra whitespace. The original
	// regexes are exported for userland consumption and lower level usage. A
	// future breaking change could export the safer regex only with a note that
	// all input should have extra whitespace removed.
	const safeRegexReplacements = [['\\s', 1], ['\\d', MAX_LENGTH], [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH]];
	const makeSafeRegex = value => {
	  for (const [token, max] of safeRegexReplacements) {
	    value = value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
	  }
	  return value;
	};
	const createToken = (name, value, isGlobal) => {
	  const safe = makeSafeRegex(value);
	  const index = R++;
	  debug(name, index, value);
	  t[name] = index;
	  src[index] = value;
	  re[index] = new RegExp(value, isGlobal ? 'g' : undefined);
	  safeRe[index] = new RegExp(safe, isGlobal ? 'g' : undefined);
	};

	// The following Regular Expressions can be used for tokenizing,
	// validating, and parsing SemVer version strings.

	// ## Numeric Identifier
	// A single `0`, or a non-zero digit followed by zero or more digits.

	createToken('NUMERICIDENTIFIER', '0|[1-9]\\d*');
	createToken('NUMERICIDENTIFIERLOOSE', '\\d+');

	// ## Non-numeric Identifier
	// Zero or more digits, followed by a letter or hyphen, and then zero or
	// more letters, digits, or hyphens.

	createToken('NONNUMERICIDENTIFIER', `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);

	// ## Main Version
	// Three dot-separated numeric identifiers.

	createToken('MAINVERSION', `(${src[t.NUMERICIDENTIFIER]})\\.` + `(${src[t.NUMERICIDENTIFIER]})\\.` + `(${src[t.NUMERICIDENTIFIER]})`);
	createToken('MAINVERSIONLOOSE', `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.` + `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.` + `(${src[t.NUMERICIDENTIFIERLOOSE]})`);

	// ## Pre-release Version Identifier
	// A numeric identifier, or a non-numeric identifier.

	createToken('PRERELEASEIDENTIFIER', `(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);
	createToken('PRERELEASEIDENTIFIERLOOSE', `(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);

	// ## Pre-release Version
	// Hyphen, followed by one or more dot-separated pre-release version
	// identifiers.

	createToken('PRERELEASE', `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
	createToken('PRERELEASELOOSE', `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);

	// ## Build Metadata Identifier
	// Any combination of digits, letters, or hyphens.

	createToken('BUILDIDENTIFIER', `${LETTERDASHNUMBER}+`);

	// ## Build Metadata
	// Plus sign, followed by one or more period-separated build metadata
	// identifiers.

	createToken('BUILD', `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);

	// ## Full Version String
	// A main version, followed optionally by a pre-release version and
	// build metadata.

	// Note that the only major, minor, patch, and pre-release sections of
	// the version string are capturing groups.  The build metadata is not a
	// capturing group, because it should not ever be used in version
	// comparison.

	createToken('FULLPLAIN', `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
	createToken('FULL', `^${src[t.FULLPLAIN]}$`);

	// like full, but allows v1.2.3 and =1.2.3, which people do sometimes.
	// also, 1.0.0alpha1 (prerelease without the hyphen) which is pretty
	// common in the npm registry.
	createToken('LOOSEPLAIN', `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
	createToken('LOOSE', `^${src[t.LOOSEPLAIN]}$`);
	createToken('GTLT', '((?:<|>)?=?)');

	// Something like "2.*" or "1.2.x".
	// Note that "x.x" is a valid xRange identifer, meaning "any version"
	// Only the first item is strictly required.
	createToken('XRANGEIDENTIFIERLOOSE', `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
	createToken('XRANGEIDENTIFIER', `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
	createToken('XRANGEPLAIN', `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})` + `(?:\\.(${src[t.XRANGEIDENTIFIER]})` + `(?:\\.(${src[t.XRANGEIDENTIFIER]})` + `(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?` + `)?)?`);
	createToken('XRANGEPLAINLOOSE', `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?` + `)?)?`);
	createToken('XRANGE', `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
	createToken('XRANGELOOSE', `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);

	// Coercion.
	// Extract anything that could conceivably be a part of a valid semver
	createToken('COERCE', `${'(^|[^\\d])' + '(\\d{1,'}${MAX_SAFE_COMPONENT_LENGTH}})` + `(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?` + `(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?` + `(?:$|[^\\d])`);
	createToken('COERCERTL', src[t.COERCE], true);

	// Tilde ranges.
	// Meaning is "reasonably at or greater than"
	createToken('LONETILDE', '(?:~>?)');
	createToken('TILDETRIM', `(\\s*)${src[t.LONETILDE]}\\s+`, true);
	exports.tildeTrimReplace = '$1~';
	createToken('TILDE', `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
	createToken('TILDELOOSE', `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);

	// Caret ranges.
	// Meaning is "at least and backwards compatible with"
	createToken('LONECARET', '(?:\\^)');
	createToken('CARETTRIM', `(\\s*)${src[t.LONECARET]}\\s+`, true);
	exports.caretTrimReplace = '$1^';
	createToken('CARET', `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
	createToken('CARETLOOSE', `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);

	// A simple gt/lt/eq thing, or just "" to indicate "any version"
	createToken('COMPARATORLOOSE', `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
	createToken('COMPARATOR', `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);

	// An expression to strip any whitespace between the gtlt and the thing
	// it modifies, so that `> 1.2.3` ==> `>1.2.3`
	createToken('COMPARATORTRIM', `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
	exports.comparatorTrimReplace = '$1$2$3';

	// Something like `1.2.3 - 1.2.4`
	// Note that these all use the loose form, because they'll be
	// checked against either the strict or loose comparator form
	// later.
	createToken('HYPHENRANGE', `^\\s*(${src[t.XRANGEPLAIN]})` + `\\s+-\\s+` + `(${src[t.XRANGEPLAIN]})` + `\\s*$`);
	createToken('HYPHENRANGELOOSE', `^\\s*(${src[t.XRANGEPLAINLOOSE]})` + `\\s+-\\s+` + `(${src[t.XRANGEPLAINLOOSE]})` + `\\s*$`);

	// Star ranges basically just allow anything at all.
	createToken('STAR', '(<|>)?=?\\s*\\*');
	// >=0.0.0 is like a star
	createToken('GTE0', '^\\s*>=\\s*0\\.0\\.0\\s*$');
	createToken('GTE0PRE', '^\\s*>=\\s*0\\.0\\.0-0\\s*$'); 
} (re$1, re$1.exports));

var reExports = re$1.exports;

// parse out just the options we care about
const looseOption = Object.freeze({
  loose: true
});
const emptyOpts = Object.freeze({});
const parseOptions$1 = options => {
  if (!options) {
    return emptyOpts;
  }
  if (typeof options !== 'object') {
    return looseOption;
  }
  return options;
};
var parseOptions_1 = parseOptions$1;

const numeric = /^[0-9]+$/;
const compareIdentifiers$1 = (a, b) => {
  const anum = numeric.test(a);
  const bnum = numeric.test(b);
  if (anum && bnum) {
    a = +a;
    b = +b;
  }
  return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
};
const rcompareIdentifiers = (a, b) => compareIdentifiers$1(b, a);
var identifiers = {
  compareIdentifiers: compareIdentifiers$1,
  rcompareIdentifiers
};

const debug = debug_1;
const {
  MAX_LENGTH,
  MAX_SAFE_INTEGER
} = constants;
const {
  safeRe: re,
  t: t$3
} = reExports;
const parseOptions = parseOptions_1;
const {
  compareIdentifiers
} = identifiers;
let SemVer$1 = class SemVer {
  constructor(version, options) {
    options = parseOptions(options);
    if (version instanceof SemVer) {
      if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
        return version;
      } else {
        version = version.version;
      }
    } else if (typeof version !== 'string') {
      throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version}".`);
    }
    if (version.length > MAX_LENGTH) {
      throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);
    }
    debug('SemVer', version, options);
    this.options = options;
    this.loose = !!options.loose;
    // this isn't actually relevant for versions, but keep it so that we
    // don't run into trouble passing this.options around.
    this.includePrerelease = !!options.includePrerelease;
    const m = version.trim().match(options.loose ? re[t$3.LOOSE] : re[t$3.FULL]);
    if (!m) {
      throw new TypeError(`Invalid Version: ${version}`);
    }
    this.raw = version;

    // these are actually numbers
    this.major = +m[1];
    this.minor = +m[2];
    this.patch = +m[3];
    if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
      throw new TypeError('Invalid major version');
    }
    if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
      throw new TypeError('Invalid minor version');
    }
    if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
      throw new TypeError('Invalid patch version');
    }

    // numberify any prerelease numeric ids
    if (!m[4]) {
      this.prerelease = [];
    } else {
      this.prerelease = m[4].split('.').map(id => {
        if (/^[0-9]+$/.test(id)) {
          const num = +id;
          if (num >= 0 && num < MAX_SAFE_INTEGER) {
            return num;
          }
        }
        return id;
      });
    }
    this.build = m[5] ? m[5].split('.') : [];
    this.format();
  }
  format() {
    this.version = `${this.major}.${this.minor}.${this.patch}`;
    if (this.prerelease.length) {
      this.version += `-${this.prerelease.join('.')}`;
    }
    return this.version;
  }
  toString() {
    return this.version;
  }
  compare(other) {
    debug('SemVer.compare', this.version, this.options, other);
    if (!(other instanceof SemVer)) {
      if (typeof other === 'string' && other === this.version) {
        return 0;
      }
      other = new SemVer(other, this.options);
    }
    if (other.version === this.version) {
      return 0;
    }
    return this.compareMain(other) || this.comparePre(other);
  }
  compareMain(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }
    return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
  }
  comparePre(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }

    // NOT having a prerelease is > having one
    if (this.prerelease.length && !other.prerelease.length) {
      return -1;
    } else if (!this.prerelease.length && other.prerelease.length) {
      return 1;
    } else if (!this.prerelease.length && !other.prerelease.length) {
      return 0;
    }
    let i = 0;
    do {
      const a = this.prerelease[i];
      const b = other.prerelease[i];
      debug('prerelease compare', i, a, b);
      if (a === undefined && b === undefined) {
        return 0;
      } else if (b === undefined) {
        return 1;
      } else if (a === undefined) {
        return -1;
      } else if (a === b) {
        continue;
      } else {
        return compareIdentifiers(a, b);
      }
    } while (++i);
  }
  compareBuild(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }
    let i = 0;
    do {
      const a = this.build[i];
      const b = other.build[i];
      debug('prerelease compare', i, a, b);
      if (a === undefined && b === undefined) {
        return 0;
      } else if (b === undefined) {
        return 1;
      } else if (a === undefined) {
        return -1;
      } else if (a === b) {
        continue;
      } else {
        return compareIdentifiers(a, b);
      }
    } while (++i);
  }

  // preminor will bump the version up to the next minor release, and immediately
  // down to pre-release. premajor and prepatch work the same way.
  inc(release, identifier, identifierBase) {
    switch (release) {
      case 'premajor':
        this.prerelease.length = 0;
        this.patch = 0;
        this.minor = 0;
        this.major++;
        this.inc('pre', identifier, identifierBase);
        break;
      case 'preminor':
        this.prerelease.length = 0;
        this.patch = 0;
        this.minor++;
        this.inc('pre', identifier, identifierBase);
        break;
      case 'prepatch':
        // If this is already a prerelease, it will bump to the next version
        // drop any prereleases that might already exist, since they are not
        // relevant at this point.
        this.prerelease.length = 0;
        this.inc('patch', identifier, identifierBase);
        this.inc('pre', identifier, identifierBase);
        break;
      // If the input is a non-prerelease version, this acts the same as
      // prepatch.
      case 'prerelease':
        if (this.prerelease.length === 0) {
          this.inc('patch', identifier, identifierBase);
        }
        this.inc('pre', identifier, identifierBase);
        break;
      case 'major':
        // If this is a pre-major version, bump up to the same major version.
        // Otherwise increment major.
        // 1.0.0-5 bumps to 1.0.0
        // 1.1.0 bumps to 2.0.0
        if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
          this.major++;
        }
        this.minor = 0;
        this.patch = 0;
        this.prerelease = [];
        break;
      case 'minor':
        // If this is a pre-minor version, bump up to the same minor version.
        // Otherwise increment minor.
        // 1.2.0-5 bumps to 1.2.0
        // 1.2.1 bumps to 1.3.0
        if (this.patch !== 0 || this.prerelease.length === 0) {
          this.minor++;
        }
        this.patch = 0;
        this.prerelease = [];
        break;
      case 'patch':
        // If this is not a pre-release version, it will increment the patch.
        // If it is a pre-release it will bump up to the same patch version.
        // 1.2.0-5 patches to 1.2.0
        // 1.2.0 patches to 1.2.1
        if (this.prerelease.length === 0) {
          this.patch++;
        }
        this.prerelease = [];
        break;
      // This probably shouldn't be used publicly.
      // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.
      case 'pre':
        {
          const base = Number(identifierBase) ? 1 : 0;
          if (!identifier && identifierBase === false) {
            throw new Error('invalid increment argument: identifier is empty');
          }
          if (this.prerelease.length === 0) {
            this.prerelease = [base];
          } else {
            let i = this.prerelease.length;
            while (--i >= 0) {
              if (typeof this.prerelease[i] === 'number') {
                this.prerelease[i]++;
                i = -2;
              }
            }
            if (i === -1) {
              // didn't increment anything
              if (identifier === this.prerelease.join('.') && identifierBase === false) {
                throw new Error('invalid increment argument: identifier already exists');
              }
              this.prerelease.push(base);
            }
          }
          if (identifier) {
            // 1.2.0-beta.1 bumps to 1.2.0-beta.2,
            // 1.2.0-beta.fooblz or 1.2.0-beta bumps to 1.2.0-beta.0
            let prerelease = [identifier, base];
            if (identifierBase === false) {
              prerelease = [identifier];
            }
            if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
              if (isNaN(this.prerelease[1])) {
                this.prerelease = prerelease;
              }
            } else {
              this.prerelease = prerelease;
            }
          }
          break;
        }
      default:
        throw new Error(`invalid increment argument: ${release}`);
    }
    this.raw = this.format();
    if (this.build.length) {
      this.raw += `+${this.build.join('.')}`;
    }
    return this;
  }
};
var semver = SemVer$1;

const SemVer = semver;
const compare$1 = (a, b, loose) => new SemVer(a, loose).compare(new SemVer(b, loose));
var compare_1 = compare$1;

const compare = compare_1;
const gte = (a, b, loose) => compare(a, b, loose) >= 0;
var gte_1 = gte;

var semverGte = /*@__PURE__*/getDefaultExportFromCjs(gte_1);

const publicKey = `-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvZ/T/RHOr6+yo/iMLUlf
agMiMLFxQR/5Qtc85ykMBvKZqbBGb9zU68VB9n54alrbZG5FdcHkSJXgJIBXF2bk
TGTfBi58JmltZirSWzvXoXnT4ieGNZv+BqnP9zzj9HXOVhVncbRmJPEIJOZfL9AQ
beix3rPgZx3ZepAaoMQnz11dZKDGzkMN75WkTdf324X3DeFgLVmjsYuAcLl/AJMA
uPKSSt0XOQUsfrT7rEqXIrj8rIJcWxIHICMRrwfjw2Qh+3pfIrh7XSzxlW4zCKBN
RpavrrCnpOFRfkC5T9eMKLgyapjufOtbjuzu25N3urBsg6oRFNzsGXWp1C7DwUO2
kwIDAQAB
-----END PUBLIC KEY-----`;
const decodeSupportedVersions = token => jwt__default.default.verify(token, publicKey, {
  algorithms: ['RS256']
});
const supportedVersionsStore = new ElectronStore__default.default({
  name: 'supportedVersions'
});
let builtinSupportedVersions;
const getBuiltinSupportedVersions = async () => {
  if (builtinSupportedVersions) return builtinSupportedVersions;
  try {
    const filePath = node_path.join(__dirname, 'supportedVersions.jwt');
    const encodedToken = await promises.readFile(filePath, 'utf8');
    builtinSupportedVersions = decodeSupportedVersions(encodedToken);
    return builtinSupportedVersions;
  } catch (e) {
    console.error('Error loading supportedVersions.jwt', e);
    return undefined;
  }
};
const logRequestError = description => error => {
  if (axios__default.default.isAxiosError(error)) {
    if (error.response) {
      console.error(`Couldn't load ${description}: ${error.response.status} ${error.response.data}`);
    } else {
      // Something happened in setting up the request that triggered an Error
      console.error(`Couldn't load ${description}: ${error.message}`);
    }
  } else {
    console.error('Fetching ${description} error:', error);
  }
  return undefined;
};
const getCacheKey = serverUrl => `supportedVersions:${serverUrl}`;
const loadFromCache = serverUrl => {
  try {
    const cached = supportedVersionsStore.get(getCacheKey(serverUrl));
    if (!cached) return undefined;
    return cached;
  } catch (error) {
    console.warn(`Error loading cache for ${serverUrl}:`, error);
    return undefined;
  }
};
const saveToCache = (serverUrl, data) => {
  try {
    supportedVersionsStore.set(getCacheKey(serverUrl), data);
  } catch (error) {
    console.warn(`Error saving cache for ${serverUrl}:`, error);
  }
};
const withRetries = async (fetchFn, maxAttempts = 3, delayMs = 2000) => {
  const attempt = async attemptNumber => {
    try {
      const result = await fetchFn();
      if (result !== undefined) {
        return result;
      }
    } catch (error) {
      // Log but continue to next attempt
      if (attemptNumber === maxAttempts) {
        // Last attempt failed
        return undefined;
      }
    }

    // If we haven't exhausted attempts, wait then try again
    if (attemptNumber < maxAttempts) {
      await new Promise(resolve => setTimeout(resolve, delayMs));
      return attempt(attemptNumber + 1);
    }
    return undefined;
  };
  return attempt(1);
};
const getCloudInfo = async (url, uniqueId) => {
  const domain = new URL(url).hostname;
  const response = await axios__default.default.get(supportedVersions({
    domain,
    uniqueId
  }));
  return response.data;
};
const getServerInfo = async url => {
  const response = await axios__default.default.get(server(url).info);
  return response.data;
};
const getUniqueId = async (url, version) => {
  var _coerce;
  const validVersion = ((_coerce = semver$1.coerce((version === null || version === void 0 ? void 0 : version.trim()) || '0.0.0')) === null || _coerce === void 0 ? void 0 : _coerce.version) || '0.0.0';
  const serverUrl = semverGte(validVersion, '7.0.0') ? server(url).uniqueId : server(url).setting('uniqueID');
  try {
    var _response$data;
    const response = await axios__default.default.get(serverUrl);
    const value = (_response$data = response.data) === null || _response$data === void 0 || (_response$data = _response$data.settings) === null || _response$data === void 0 || (_response$data = _response$data[0]) === null || _response$data === void 0 ? void 0 : _response$data.value;
    if (!value) {
      console.warn(`No unique ID found for server ${url}`);
      return null;
    }
    return value;
  } catch (error) {
    console.warn(`Error fetching unique ID for server ${url}:`, error);
    return null;
  }
};
const dispatchVersionUpdated = url => info => {
  dispatch({
    type: WEBVIEW_SERVER_VERSION_UPDATED,
    payload: {
      url,
      version: info.version
    }
  });
  return info;
};
const dispatchUniqueIdUpdated = url => uniqueID => {
  if (uniqueID) {
    dispatch({
      type: WEBVIEW_SERVER_UNIQUE_ID_UPDATED,
      payload: {
        url,
        uniqueID
      }
    });
  }
  return uniqueID;
};
const dispatchSupportedVersionsUpdated = (url, supportedVersions, {
  source
}) => {
  dispatch({
    type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_UPDATED,
    payload: {
      url,
      supportedVersions,
      source
    }
  });
};
const updateSupportedVersionsData = async serverUrl => {
  const server = select(({
    servers
  }) => servers.find(server => server.url === serverUrl));
  if (!server) return;

  // Dispatch loading state
  dispatch({
    type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_LOADING,
    payload: {
      url: serverUrl
    }
  });
  const builtinSupportedVersions = await getBuiltinSupportedVersions();

  // Fetch server info with retries (3x with 2s delays)
  const serverInfoResult = await withRetries(() => getServerInfo(server.url), 3, 2000);
  let serverEncoded;
  if (serverInfoResult) {
    var _serverInfoResult$sup;
    dispatchVersionUpdated(server.url)(serverInfoResult);
    serverEncoded = (_serverInfoResult$sup = serverInfoResult.supportedVersions) === null || _serverInfoResult$sup === void 0 ? void 0 : _serverInfoResult$sup.signed;

    // Try Server with retries (3x with 2s delays)
    if (serverEncoded) {
      try {
        const serverSupportedVersions = decodeSupportedVersions(serverEncoded);
        saveToCache(serverUrl, serverSupportedVersions);
        dispatchSupportedVersionsUpdated(server.url, serverSupportedVersions, {
          source: 'server'
        });
        return;
      } catch (error) {
        console.error('Error decoding server supported versions:', error);
        // Clear serverEncoded to allow cloud fallback
        serverEncoded = undefined;
      }
    }
  }
  const uniqueID = await getUniqueId(server.url, server.version || '').then(dispatchUniqueIdUpdated(server.url)).catch(logRequestError('unique ID'));

  // Try Cloud with retries (3x with 2s delays) if unique ID available
  if (!serverEncoded && uniqueID) {
    const cloudVersionsWithRetry = await withRetries(() => getCloudInfo(server.url, uniqueID), 3, 2000);
    if (cloudVersionsWithRetry !== null && cloudVersionsWithRetry !== void 0 && cloudVersionsWithRetry.signed) {
      try {
        const cloudSupportedVersions = decodeSupportedVersions(cloudVersionsWithRetry.signed);
        saveToCache(serverUrl, cloudSupportedVersions);
        dispatchSupportedVersionsUpdated(server.url, cloudSupportedVersions, {
          source: 'cloud'
        });
        return;
      } catch (error) {
        console.error('Error decoding cloud supported versions:', error);
      }
    }
  }

  // Try to load from cache
  const cachedVersions = loadFromCache(serverUrl);
  if (cachedVersions) {
    dispatchSupportedVersionsUpdated(server.url, cachedVersions, {
      source: 'cloud'
    });
    dispatch({
      type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR,
      payload: {
        url: serverUrl
      }
    });
    return;
  }

  // Fall back to builtin (always available)
  if (builtinSupportedVersions) {
    saveToCache(serverUrl, builtinSupportedVersions);
    dispatchSupportedVersionsUpdated(server.url, builtinSupportedVersions, {
      source: 'builtin'
    });
    dispatch({
      type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR,
      payload: {
        url: serverUrl
      }
    });
    return;
  }

  // No data available from any source
  dispatch({
    type: WEBVIEW_SERVER_SUPPORTED_VERSIONS_ERROR,
    payload: {
      url: serverUrl
    }
  });
};
function checkSupportedVersionServers() {
  listen(WEBVIEW_READY, async action => {
    updateSupportedVersionsData(action.payload.url);
  });
  listen(SUPPORTED_VERSION_DIALOG_DISMISS, async action => {
    updateSupportedVersionsData(action.payload.url);
  });
  listen(WEBVIEW_SERVER_RELOADED, async action => {
    updateSupportedVersionsData(action.payload.url);
  });
  electron.ipcMain.handle('refresh-supported-versions', async (_event, serverUrl) => {
    updateSupportedVersionsData(serverUrl);
  });
}

const setSpellCheckerLanguages = async languages => {
  await electron.app.whenReady();
  const filteredLanguages = Array.from(languages).filter(language => electron.session.defaultSession.availableSpellCheckerLanguages.includes(language));
  electron.session.defaultSession.setSpellCheckerLanguages(filteredLanguages);
  electron.webContents.getAllWebContents().forEach(webContents => {
    webContents.session.setSpellCheckerLanguages(filteredLanguages);
  });
};
const setupSpellChecking = async () => {
  setSpellCheckerLanguages(new Set(electron.session.defaultSession.getSpellCheckerLanguages()));
  listen(SPELL_CHECKING_TOGGLED, action => {
    const spellCheckerLanguages = new Set(action.payload ? electron.session.defaultSession.getSpellCheckerLanguages() : []);
    setSpellCheckerLanguages(spellCheckerLanguages);
  });
  listen(SPELL_CHECKING_LANGUAGE_TOGGLED, action => {
    const spellCheckerLanguages = new Set(electron.session.defaultSession.getSpellCheckerLanguages());
    if (action.payload.enabled) {
      spellCheckerLanguages.add(action.payload.name);
    } else {
      spellCheckerLanguages.delete(action.payload.name);
    }
    setSpellCheckerLanguages(spellCheckerLanguages);
  });
};

const handleCertificatesManager = () => {
  handle('certificatesManager/remove', async (_webContent, domain) => {
    const trustedCertificates = select(({
      trustedCertificates
    }) => trustedCertificates);
    const notTrustedCertificates = select(({
      notTrustedCertificates
    }) => notTrustedCertificates);
    if (trustedCertificates.hasOwnProperty(domain)) {
      delete trustedCertificates[domain];
      dispatch({
        type: TRUSTED_CERTIFICATES_UPDATED,
        payload: {
          ...trustedCertificates
        }
      });
    }
    if (notTrustedCertificates.hasOwnProperty(domain)) {
      delete notTrustedCertificates[domain];
      dispatch({
        type: NOT_TRUSTED_CERTIFICATES_UPDATED,
        payload: {
          ...notTrustedCertificates
        }
      });
    }
  });
};

class DockService extends Service {
  initialize() {
    if (process.platform !== 'darwin') {
      return;
    }
    this.watch(selectGlobalBadgeText, globalBadgeText => {
      var _app$dock;
      (_app$dock = electron.app.dock) === null || _app$dock === void 0 || _app$dock.setBadge(globalBadgeText);
    });
    this.watch(selectGlobalBadgeCount, (globalBadgeCount, prevGlobalBadgeCount) => {
      const {
        isFlashFrameEnabled
      } = select(({
        isFlashFrameEnabled
      }) => ({
        isFlashFrameEnabled
      }));
      if (globalBadgeCount <= 0 || (prevGlobalBadgeCount !== null && prevGlobalBadgeCount !== void 0 ? prevGlobalBadgeCount : 0) > 0) {
        return;
      }
      if (isFlashFrameEnabled) {
        var _app$dock2;
        (_app$dock2 = electron.app.dock) === null || _app$dock2 === void 0 || _app$dock2.bounce();
      }
    });
  }
}
var dock = new DockService();

const DESKTOP_CAPTURER_CACHE_TTL = 3000;
const SOURCE_VALIDATION_CACHE_TTL = 30000;
const CACHE_CLEANUP_DELAY = 60000;
const DESTRUCTION_CHECK_INTERVAL = 50;
const DEVTOOLS_TIMEOUT = 2000;
const WEBVIEW_CHECK_INTERVAL = 100;
let videoCallWindow = null;
let isVideoCallWindowDestroying = false;
let pendingVideoCallUrl = null;

// Helper function to log URL changes
const setPendingVideoCallUrl = (url, reason) => {
  const previous = pendingVideoCallUrl;
  pendingVideoCallUrl = url;
  console.log(`Video call window: pendingVideoCallUrl updated - ${reason}`, {
    previous,
    new: url,
    timestamp: new Date().toISOString()
  });
};
let desktopCapturerCache = null;
let desktopCapturerPromise = null;
const sourceValidationCache = new Set();
let sourceValidationCacheTimestamp = 0;
let cacheCleanupTimer = null;
let videoCallWindowCreationCount = 0;
let videoCallWindowDestructionCount = 0;
const logVideoCallWindowStats = () => {
  console.log('Video call window stats:', {
    created: videoCallWindowCreationCount,
    destroyed: videoCallWindowDestructionCount,
    currentInstance: videoCallWindow ? 'active' : 'none',
    cacheStatus: desktopCapturerCache ? 'cached' : 'empty',
    promiseStatus: desktopCapturerPromise ? 'pending' : 'none',
    cleanupTimer: cacheCleanupTimer ? 'active' : 'none'
  });
};
const handleDesktopCapturerGetSources = () => {
  handle('desktop-capturer-get-sources', async (_webContents, opts) => {
    try {
      const options = Array.isArray(opts) ? opts[0] : opts;
      if (desktopCapturerCache && Date.now() - desktopCapturerCache.timestamp < DESKTOP_CAPTURER_CACHE_TTL) {
        return desktopCapturerCache.sources;
      }
      if (desktopCapturerPromise) {
        return await desktopCapturerPromise;
      }
      desktopCapturerPromise = (async () => {
        try {
          const sources = await electron.desktopCapturer.getSources(options);
          const validSources = sources.filter(source => {
            if (!source.name || source.name.trim() === '') {
              return false;
            }
            const now = Date.now();
            const cacheExpired = now - sourceValidationCacheTimestamp > SOURCE_VALIDATION_CACHE_TTL;
            if (!cacheExpired && sourceValidationCache.has(source.id)) {
              return true;
            }
            if (source.thumbnail.isEmpty()) {
              return false;
            }
            if (cacheExpired) {
              sourceValidationCache.clear();
              sourceValidationCacheTimestamp = now;
            }
            sourceValidationCache.add(source.id);
            return true;
          });
          desktopCapturerCache = {
            sources: validSources,
            timestamp: Date.now()
          };
          return validSources;
        } catch (error) {
          console.error('Error getting desktop capturer sources:', error);
          desktopCapturerCache = null;
          return [];
        } finally {
          desktopCapturerPromise = null;
        }
      })();
      return await desktopCapturerPromise;
    } catch (error) {
      console.error('Error in desktop capturer handler:', error);
      desktopCapturerCache = null;
      desktopCapturerPromise = null;
      return [];
    }
  });
};
const fetchVideoCallWindowState = async browserWindow => {
  return {
    focused: browserWindow.isFocused(),
    visible: browserWindow.isVisible(),
    maximized: false,
    minimized: false,
    fullscreen: false,
    normal: true,
    bounds: browserWindow.getNormalBounds()
  };
};
const cleanupVideoCallWindow = () => {
  if (videoCallWindow && !videoCallWindow.isDestroyed() && !isVideoCallWindowDestroying) {
    console.log('Cleaning up video call window resources');
    isVideoCallWindowDestroying = true;
    try {
      // Set permission handler with additional safety
      if (videoCallWindow.webContents && !videoCallWindow.webContents.isDestroyed()) {
        videoCallWindow.webContents.session.setPermissionRequestHandler(() => false);
        videoCallWindow.webContents.executeJavaScript('void 0').catch(() => {
          // Ignore errors during cleanup
        });
      }
      try {
        const allWebContents = electron.webContents.getAllWebContents();
        const webviewContents = allWebContents.find(wc => {
          var _videoCallWindow;
          return wc.hostWebContents === ((_videoCallWindow = videoCallWindow) === null || _videoCallWindow === void 0 ? void 0 : _videoCallWindow.webContents);
        });
        if (webviewContents && !webviewContents.isDestroyed()) {
          console.log('Stopping webview JavaScript execution before window cleanup');
          webviewContents.session.setPermissionRequestHandler(() => false);
          webviewContents.loadURL('about:blank').catch(() => {});
        }
      } catch (error) {
        console.log('Could not clean webview contents, continuing with window cleanup');
      }
      if (cacheCleanupTimer) {
        clearTimeout(cacheCleanupTimer);
        cacheCleanupTimer = null;
      }
      videoCallWindow.removeAllListeners();

      // Use setImmediate to ensure this happens after current event loop
      // This prevents timing issues during app initialization
      setImmediate(() => {
        if (videoCallWindow && !videoCallWindow.isDestroyed()) {
          videoCallWindow.close();
        }
      });
    } catch (error) {
      console.error('Error during video call window cleanup:', error);
      if (videoCallWindow && !videoCallWindow.isDestroyed()) {
        try {
          videoCallWindow.removeAllListeners();
          setImmediate(() => {
            if (videoCallWindow && !videoCallWindow.isDestroyed()) {
              videoCallWindow.close();
            }
          });
        } catch (fallbackError) {
          console.error('Error in fallback cleanup:', fallbackError);
        }
      }
    }
  }

  // Use setTimeout to ensure this cleanup happens after any window events are processed
  setTimeout(() => {
    videoCallWindow = null;
    isVideoCallWindowDestroying = false;
    videoCallWindowDestructionCount++;
    console.log('Video call window cleanup completed');
    logVideoCallWindowStats();
  }, 10);
};
const setupWebviewHandlers = webContents => {
  const handleDidAttachWebview = (_event, webviewWebContents) => {
    webviewWebContents.session.setDisplayMediaRequestHandler((_request, cb) => {
      if (videoCallWindow && !videoCallWindow.isDestroyed()) {
        videoCallWindow.webContents.send('video-call-window/open-screen-picker');
        electron.ipcMain.once('video-call-window/screen-sharing-source-responded', async (_event, sourceId) => {
          if (!sourceId) {
            cb({
              video: false
            });
            return;
          }
          try {
            const sources = await electron.desktopCapturer.getSources({
              types: ['window', 'screen']
            });
            const selectedSource = sources.find(s => s.id === sourceId);
            if (!selectedSource) {
              console.warn('Selected screen sharing source no longer available:', sourceId);
              cb({
                video: false
              });
              return;
            }
            cb({
              video: selectedSource
            });
          } catch (error) {
            console.error('Error validating screen sharing source:', error);
            cb({
              video: false
            });
          }
        });
      }
    });
  };
  webContents.removeAllListeners('did-attach-webview');
  webContents.on('did-attach-webview', handleDidAttachWebview);
};
const startVideoCallWindowHandler = () => {
  handle('video-call-window/screen-recording-is-permission-granted', async () => {
    if (process__default.default.platform === 'darwin') {
      const permission = electron.systemPreferences.getMediaAccessStatus('screen');
      return permission === 'granted';
    }
    return true;
  });
  handle('video-call-window/open-screen-picker', async _webContents => {
    // This is handled by the renderer process (screenSharePicker.tsx)
    // The handler exists to satisfy the IPC call from preload script
  });
  handle('video-call-window/open-window', async (_webContents, url) => {
    console.log('Video call window: Open-window handler called with URL:', url);
    if (isVideoCallWindowDestroying) {
      console.log('Waiting for video call window destruction to complete...');
      await new Promise(resolve => {
        const checkDestructionComplete = () => {
          if (!isVideoCallWindowDestroying) {
            resolve();
          } else {
            setTimeout(checkDestructionComplete, DESTRUCTION_CHECK_INTERVAL);
          }
        };
        checkDestructionComplete();
      });
    }
    if (videoCallWindow && !videoCallWindow.isDestroyed()) {
      console.log('Closing existing video call window to create fresh one');
      videoCallWindow.close();
      videoCallWindow = null;
      if (isVideoCallWindowDestroying) {
        await new Promise(resolve => {
          const checkClosed = () => {
            if (!isVideoCallWindowDestroying) {
              resolve();
            } else {
              setTimeout(checkClosed, DESTRUCTION_CHECK_INTERVAL);
            }
          };
          checkClosed();
        });
      }
    }
    const validUrl = new URL(url);
    const allowedProtocols = ['http:', 'https:'];
    console.log('Video call window: URL validation - hostname:', validUrl.hostname, 'protocol:', validUrl.protocol);
    if (validUrl.hostname.match(/(\.)?g\.co$/)) {
      console.log('Video call window: Google URL detected, opening externally instead of internal window');
      openExternal(validUrl.toString());
      return;
    }
    if (allowedProtocols.includes(validUrl.protocol)) {
      const mainWindow = await getRootWindow();
      const winBounds = await mainWindow.getNormalBounds();
      const centeredWindowPosition = {
        x: winBounds.x + winBounds.width / 2,
        y: winBounds.y + winBounds.height / 2
      };
      const actualScreen = electron.screen.getDisplayNearestPoint({
        x: centeredWindowPosition.x,
        y: centeredWindowPosition.y
      });
      const state = select(state => ({
        videoCallWindowState: state.videoCallWindowState,
        isVideoCallWindowPersistenceEnabled: state.isVideoCallWindowPersistenceEnabled
      }));
      let {
        x,
        y,
        width,
        height
      } = state.videoCallWindowState.bounds;
      if (!state.isVideoCallWindowPersistenceEnabled || !x || !y || width === 0 || height === 0 || !isInsideSomeScreen({
        x,
        y,
        width,
        height
      })) {
        width = Math.round(actualScreen.workAreaSize.width * 0.8);
        height = Math.round(actualScreen.workAreaSize.height * 0.8);
        x = Math.round((actualScreen.workArea.width - width) / 2 + actualScreen.workArea.x);
        y = Math.round((actualScreen.workArea.height - height) / 2 + actualScreen.workArea.y);
      }
      console.log('Creating new video call window');
      videoCallWindowCreationCount++;
      if (cacheCleanupTimer) {
        clearTimeout(cacheCleanupTimer);
        cacheCleanupTimer = null;
        console.log('Cancelled cache cleanup - creating new window, cache preserved for better performance');
      }
      logVideoCallWindowStats();
      videoCallWindow = new electron.BrowserWindow({
        width,
        height,
        x,
        y,
        webPreferences: {
          nodeIntegration: true,
          nodeIntegrationInSubFrames: true,
          contextIsolation: false,
          webviewTag: true,
          experimentalFeatures: false,
          offscreen: false,
          disableHtmlFullscreenWindowResize: true,
          backgroundThrottling: true,
          v8CacheOptions: 'bypassHeatCheck',
          spellcheck: false
        },
        show: false,
        frame: true,
        transparent: false,
        skipTaskbar: false
      });
      videoCallWindow.webContents.on('will-navigate', (event, url) => {
        if (url.toLowerCase().startsWith('smb://')) {
          event.preventDefault();
        }
      });
      videoCallWindow.webContents.setWindowOpenHandler(({
        url
      }) => {
        if (url.toLowerCase().startsWith('smb://')) {
          return {
            action: 'deny'
          };
        }
        return {
          action: 'allow'
        };
      });
      if (state.isVideoCallWindowPersistenceEnabled) {
        const fetchAndDispatchWindowState = debounce(async () => {
          if (videoCallWindow && !videoCallWindow.isDestroyed()) {
            dispatchLocal({
              type: VIDEO_CALL_WINDOW_STATE_CHANGED,
              payload: await fetchVideoCallWindowState(videoCallWindow)
            });
          }
        }, 1000);
        videoCallWindow.addListener('show', fetchAndDispatchWindowState);
        videoCallWindow.addListener('hide', fetchAndDispatchWindowState);
        videoCallWindow.addListener('focus', fetchAndDispatchWindowState);
        videoCallWindow.addListener('blur', fetchAndDispatchWindowState);
        videoCallWindow.addListener('maximize', fetchAndDispatchWindowState);
        videoCallWindow.addListener('unmaximize', fetchAndDispatchWindowState);
        videoCallWindow.addListener('minimize', fetchAndDispatchWindowState);
        videoCallWindow.addListener('restore', fetchAndDispatchWindowState);
        videoCallWindow.addListener('resize', fetchAndDispatchWindowState);
        videoCallWindow.addListener('move', fetchAndDispatchWindowState);
      }
      videoCallWindow.on('closed', () => {
        console.log('Video call window closed - destroying completely');

        // Use setTimeout to ensure cleanup happens after any potential app lifecycle events
        // This prevents crashes during first launch when timing is critical
        setTimeout(() => {
          try {
            videoCallWindow = null;
            isVideoCallWindowDestroying = false;
            videoCallWindowDestructionCount++;
            cacheCleanupTimer = setTimeout(() => {
              console.log('Clearing desktop capturer cache after window idle period');
              desktopCapturerCache = null;
              desktopCapturerPromise = null;
              sourceValidationCache.clear();
              sourceValidationCacheTimestamp = 0;
              cacheCleanupTimer = null;
              console.log('Desktop capturer cache cleared due to inactivity');
            }, CACHE_CLEANUP_DELAY);
            console.log(`Desktop capturer cache will be cleared in ${CACHE_CLEANUP_DELAY / 1000} seconds if no new video call window is opened`);
            logVideoCallWindowStats();
          } catch (error) {
            console.error('Error during video call window closed event handling:', error);
          }
        }, 50); // Small delay to let app state stabilize
      });
      videoCallWindow.on('close', _event => {
        if (!isVideoCallWindowDestroying) {
          isVideoCallWindowDestroying = true;
          console.log('Video call window close initiated - preventing JS execution');
          try {
            if (videoCallWindow && !videoCallWindow.isDestroyed()) {
              videoCallWindow.webContents.session.setPermissionRequestHandler(() => false);
              videoCallWindow.webContents.executeJavaScript('void 0').catch(() => {});
            }
          } catch (error) {
            console.log('Error during close preparation:', error);
          }
        }
      });
      videoCallWindow.webContents.on('did-fail-load', (_event, errorCode, errorDescription, validatedURL, isMainFrame) => {
        console.error('Video call window failed to load:', {
          errorCode,
          errorDescription,
          validatedURL,
          isMainFrame
        });
        if (isMainFrame) {
          console.error('Main frame failed to load, this may indicate issues on low-power devices');
        }
      });
      videoCallWindow.webContents.on('dom-ready', () => {
        var _videoCallWindow2;
        (_videoCallWindow2 = videoCallWindow) === null || _videoCallWindow2 === void 0 || _videoCallWindow2.webContents.executeJavaScript(`
          if (typeof process !== 'undefined' && process.env && "production" === 'development') {
            console.log('Video call window: JavaScript execution test successful');
          }
          window.videoCallWindowJSWorking = true;
          setTimeout(() => {
            const rootElement = document.getElementById('root');
            const hasReactContent = rootElement && (
              rootElement.hasChildNodes() || 
              rootElement.innerHTML.trim() !== ''
            );
            
            if (!hasReactContent) {
              console.warn('Video call window: React may not have rendered - possible initialization issue');
            } else if (typeof process !== 'undefined' && process.env && "production" === 'development') {
              console.log('Video call window: React content detected successfully');
            }
          }, 5000);
        `).catch(error => {
          console.error('Video call window: JavaScript execution test failed:', error);
        });
      });
      videoCallWindow.webContents.on('console-message', (_event, level, message, line, sourceId) => {
        const logPrefix = 'Video call window console:';
        switch (level) {
          case 0:
            console.log(`${logPrefix} [INFO]`, message, `(${sourceId}:${line})`);
            break;
          case 1:
            console.warn(`${logPrefix} [WARN]`, message, `(${sourceId}:${line})`);
            break;
          case 2:
            console.error(`${logPrefix} [ERROR]`, message, `(${sourceId}:${line})`);
            break;
          default:
            console.log(`${logPrefix} [${level}]`, message, `(${sourceId}:${line})`);
        }
      });
      const htmlPath = path__default.default.join(electron.app.getAppPath(), 'app/video-call-window.html');
      console.log('Video call window: Loading HTML file from:', htmlPath);
      videoCallWindow.loadFile(htmlPath).catch(error => {
        console.error('Video call window: Failed to load HTML file:', error);
        console.error('This may indicate build issues or file system problems on low-power devices');
      });
      videoCallWindow.once('ready-to-show', () => {
        if (videoCallWindow && !videoCallWindow.isDestroyed()) {
          videoCallWindow.setTitle(packageJsonInformation.productName);
          console.log('Video call window: Window ready, waiting for renderer to signal ready state');
          console.log('Video call window: Current pending URL:', pendingVideoCallUrl);
          videoCallWindow.show();
        }
      });
      const {
        webContents
      } = videoCallWindow;
      setupWebviewHandlers(webContents);

      // Set the pending URL after window is created to prevent race condition with cleanup
      setPendingVideoCallUrl(url, 'open-window-after-creation');
      console.log('Video call window: Set pending URL after window creation:', url);
      webContents.setWindowOpenHandler(({
        url
      }) => {
        console.log('Video call window - new window requested:', url);
        if (url.toLowerCase().startsWith('smb://')) {
          return {
            action: 'deny'
          };
        }
        if (url.startsWith('http://') || url.startsWith('https://')) {
          openExternal(url);
          return {
            action: 'deny'
          };
        }
        return {
          action: 'allow'
        };
      });
      webContents.on('will-navigate', (event, url) => {
        console.log('Video call window will-navigate:', url);

        // Check for close pages and handle them specially to prevent crashes
        if (url.includes('/close.html') || url.includes('/close2.html')) {
          console.log('Video call window: Navigation to close page detected, will handle gracefully');
          // Don't prevent navigation, but note it for safer handling
        }
        try {
          const parsedUrl = new URL(url);
          if (!['http:', 'https:', 'file:', 'data:', 'about:'].includes(parsedUrl.protocol)) {
            console.log('External protocol detected in video call window:', parsedUrl.protocol);
            event.preventDefault();
            isProtocolAllowed(url).then(allowed => {
              if (allowed) {
                openExternal(url);
              }
            });
          }
        } catch (e) {
          console.warn('Failed to parse URL in video call window:', url, e);
        }
      });
      webContents.session.setPermissionRequestHandler(async (_webContents, permission, callback, details) => {
        console.log('Video call window permission request', permission, details);
        switch (permission) {
          case 'media':
            {
              const {
                mediaTypes = []
              } = details;
              if (process__default.default.platform === 'darwin') {
                const allowed = (!mediaTypes.includes('audio') || (await electron.systemPreferences.askForMediaAccess('microphone'))) && (!mediaTypes.includes('video') || (await electron.systemPreferences.askForMediaAccess('camera')));
                callback(allowed);
                break;
              }
              if (process__default.default.platform === 'win32') {
                let microphoneAllowed = true;
                let cameraAllowed = true;
                if (mediaTypes.includes('audio')) {
                  const micStatus = electron.systemPreferences.getMediaAccessStatus('microphone');
                  microphoneAllowed = micStatus === 'granted';
                }
                if (mediaTypes.includes('video')) {
                  const camStatus = electron.systemPreferences.getMediaAccessStatus('camera');
                  cameraAllowed = camStatus === 'granted';
                }
                const allowed = microphoneAllowed && cameraAllowed;
                if (!allowed) {
                  console.log('Media permissions denied by system:', {
                    microphone: microphoneAllowed,
                    camera: cameraAllowed,
                    requestedTypes: mediaTypes
                  });
                  let permissionType;
                  if (mediaTypes.includes('audio') && mediaTypes.includes('video')) {
                    permissionType = 'both';
                  } else if (mediaTypes.includes('audio')) {
                    permissionType = 'microphone';
                  } else {
                    permissionType = 'camera';
                  }
                  if (videoCallWindow && !videoCallWindow.isDestroyed()) {
                    askForMediaPermissionSettings(permissionType, videoCallWindow).then(openSettings => {
                      if (openSettings) {
                        electron.shell.openExternal('ms-settings:privacy-microphone');
                      }
                    });
                  }
                }
                callback(allowed);
                break;
              }
              callback(true);
              break;
            }
          case 'geolocation':
          case 'notifications':
          case 'midiSysex':
          case 'pointerLock':
          case 'fullscreen':
          case 'screen-wake-lock':
          case 'system-wake-lock':
            callback(true);
            return;
          case 'openExternal':
            {
              callback(true);
              return;
            }
          default:
            callback(false);
        }
      });
    }
  });
  handle('video-call-window/close-requested', async () => {
    console.log('Video call window: Close requested via navigation to close page');

    // Add safety check and delay to prevent crashes during first launch
    if (videoCallWindow && !videoCallWindow.isDestroyed()) {
      // Use setImmediate to ensure this happens after any pending navigation events
      setImmediate(() => {
        try {
          if (videoCallWindow && !videoCallWindow.isDestroyed() && !isVideoCallWindowDestroying) {
            console.log('Video call window: Proceeding with close after navigation delay');
            videoCallWindow.close();
          } else {
            console.log('Video call window: Already destroyed or being destroyed, skipping close');
          }
        } catch (error) {
          console.error('Error closing video call window after close page navigation:', error);
        }
      });
      return {
        success: true
      };
    }
    console.log('Video call window: Already destroyed, cannot close');
    return {
      success: false
    };
  });
  handle('video-call-window/open-webview-dev-tools', async () => {
    if (!videoCallWindow || videoCallWindow.isDestroyed()) {
      console.warn('Video call window not available for dev tools');
      return false;
    }
    try {
      const webviewWebContents = await new Promise(resolve => {
        const checkForWebview = () => {
          const allWebContents = electron.webContents.getAllWebContents();
          const webviewContents = allWebContents.find(wc => {
            var _videoCallWindow3;
            return wc.hostWebContents === ((_videoCallWindow3 = videoCallWindow) === null || _videoCallWindow3 === void 0 ? void 0 : _videoCallWindow3.webContents);
          });
          if (webviewContents) {
            resolve(webviewContents);
          } else {
            setTimeout(checkForWebview, WEBVIEW_CHECK_INTERVAL);
          }
        };
        checkForWebview();
        setTimeout(() => resolve(null), DEVTOOLS_TIMEOUT);
      });
      if (webviewWebContents && !webviewWebContents.isDestroyed()) {
        console.log('Opening developer tools for video call webview');
        webviewWebContents.openDevTools();
        return true;
      }
      console.warn('Video call webview webContents not found or destroyed');
      return false;
    } catch (error) {
      console.error('Error opening webview developer tools:', error);
      return false;
    }
  });
};
const openVideoCallWebviewDevTools = async () => {
  if (!videoCallWindow || videoCallWindow.isDestroyed()) {
    console.warn('Video call window not available for dev tools');
    return false;
  }
  try {
    const webviewWebContents = await new Promise(resolve => {
      const checkForWebview = () => {
        const allWebContents = electron.webContents.getAllWebContents();
        const webviewContents = allWebContents.find(wc => {
          var _videoCallWindow4;
          return wc.hostWebContents === ((_videoCallWindow4 = videoCallWindow) === null || _videoCallWindow4 === void 0 ? void 0 : _videoCallWindow4.webContents);
        });
        if (webviewContents) {
          resolve(webviewContents);
        } else {
          setTimeout(checkForWebview, WEBVIEW_CHECK_INTERVAL);
        }
      };
      checkForWebview();
      setTimeout(() => resolve(null), DEVTOOLS_TIMEOUT);
    });
    if (webviewWebContents && !webviewWebContents.isDestroyed()) {
      console.log('Opening developer tools for video call webview');
      webviewWebContents.openDevTools();
      return true;
    }
    console.warn('Video call webview webContents not found or destroyed');
    return false;
  } catch (error) {
    console.error('Error opening webview developer tools:', error);
    return false;
  }
};
const cleanupVideoCallResources = () => {
  console.log('Cleaning up all video call resources');
  if (cacheCleanupTimer) {
    clearTimeout(cacheCleanupTimer);
    cacheCleanupTimer = null;
    console.log('Cancelled pending cache cleanup timer');
  }
  desktopCapturerCache = null;
  desktopCapturerPromise = null;
  sourceValidationCache.clear();
  sourceValidationCacheTimestamp = 0;
  isVideoCallWindowDestroying = false;
  cleanupVideoCallWindow();
};
handle('video-call-window/test-ipc', async () => {
  console.log('Video call window: IPC test request received');
  return {
    success: true,
    timestamp: Date.now()
  };
});
handle('video-call-window/handshake', async () => {
  console.log('Video call window: Handshake request received');
  return {
    success: true,
    timestamp: Date.now()
  };
});
handle('video-call-window/renderer-ready', async () => {
  console.log('Video call window: Renderer signals ready state');
  if (!videoCallWindow || videoCallWindow.isDestroyed()) {
    console.error('Video call window: Window not available when renderer ready');
    throw new Error('Video call window not available');
  }
  console.log('Video call window: Renderer is ready to request URL');
  return {
    success: true
  };
});
handle('video-call-window/request-url', async () => {
  console.log('Video call window: Renderer requesting pending URL');
  if (!videoCallWindow || videoCallWindow.isDestroyed()) {
    console.error('Video call window: Window not available when requesting URL');
    return {
      success: false,
      url: null,
      autoOpenDevtools: false
    };
  }
  if (!pendingVideoCallUrl) {
    console.error('Video call window: No pending URL available');
    return {
      success: false,
      url: null,
      autoOpenDevtools: false
    };
  }
  const state = select(state => ({
    isAutoOpenEnabled: state.isVideoCallDevtoolsAutoOpenEnabled
  }));
  console.log('Video call window: Providing URL to renderer:', pendingVideoCallUrl);
  return {
    success: true,
    url: pendingVideoCallUrl,
    autoOpenDevtools: state.isAutoOpenEnabled
  };
});
handle('video-call-window/url-received', async () => {
  console.log('Video call window: URL received confirmation from renderer');
  return {
    success: true
  };
});
handle('video-call-window/webview-created', async () => {
  console.log('Video call window: Webview created confirmation');
  return {
    success: true
  };
});
handle('video-call-window/webview-loading', async () => {
  console.log('Video call window: Webview started loading');
  return {
    success: true
  };
});
handle('video-call-window/webview-ready', async () => {
  console.log('Video call window: Webview finished loading');
  return {
    success: true
  };
});
handle('video-call-window/webview-failed', async (_webContents, error) => {
  console.error('Video call window: Webview failed to load:', error);
  return {
    success: true
  };
});
handle('video-call-window/get-language', async () => {
  console.log('Video call window: Language request received');

  // Import the i18n service to get the current language
  try {
    const {
      getLanguage
    } = await Promise.resolve().then(function () { return main; });
    console.log('Video call window: Providing language:', getLanguage);
    return {
      success: true,
      language: getLanguage
    };
  } catch (error) {
    console.error('Video call window: Failed to get language:', error);
    return {
      success: true,
      language: fallbackLng
    };
  }
});

const t$2 = i18next__default.default.t.bind(i18next__default.default);
const on = (condition, getMenuItems) => condition ? getMenuItems() : [];
const selectAddServersDeps = reselect.createStructuredSelector({
  isAddNewServersEnabled: ({
    isAddNewServersEnabled
  }) => isAddNewServersEnabled
});
const createAppMenu = reselect.createSelector(selectAddServersDeps, ({
  isAddNewServersEnabled
}) => ({
  id: 'appMenu',
  label: process.platform === 'darwin' ? electron.app.name : t$2('menus.fileMenu'),
  submenu: [...on(process.platform === 'darwin', () => [{
    id: 'about',
    label: t$2('menus.about', {
      appName: electron.app.name
    }),
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_ABOUT_CLICKED
      });
    }
  }, {
    type: 'separator'
  }, {
    id: 'services',
    label: t$2('menus.services'),
    role: 'services'
  }, {
    type: 'separator'
  }, {
    id: 'hide',
    label: t$2('menus.hide', {
      appName: electron.app.name
    }),
    role: 'hide'
  }, {
    id: 'hideOthers',
    label: t$2('menus.hideOthers'),
    role: 'hideOthers'
  }, {
    id: 'unhide',
    label: t$2('menus.unhide'),
    role: 'unhide'
  }, {
    type: 'separator'
  }]), ...on(process.platform !== 'darwin' && isAddNewServersEnabled, () => [{
    id: 'addNewServer',
    label: t$2('menus.addNewServer'),
    accelerator: 'CommandOrControl+N',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_ADD_NEW_SERVER_CLICKED
      });
    }
  }, {
    type: 'separator'
  }]), {
    id: 'disableGpu',
    label: t$2('menus.disableGpu'),
    enabled: !electron.app.commandLine.hasSwitch('disable-gpu'),
    click: () => {
      relaunchApp('--disable-gpu');
    }
  }, {
    type: 'separator'
  }, {
    id: 'quit',
    label: t$2('menus.quit', {
      appName: electron.app.name
    }),
    accelerator: 'CommandOrControl+Q',
    click: () => {
      electron.app.quit();
    }
  }]
}));
const createEditMenu = reselect.createSelector(_ => undefined, () => ({
  id: 'editMenu',
  label: t$2('menus.editMenu'),
  submenu: [{
    id: 'undo',
    label: t$2('menus.undo'),
    role: 'undo'
  }, {
    id: 'redo',
    label: t$2('menus.redo'),
    role: 'redo'
  }, {
    type: 'separator'
  }, {
    id: 'cut',
    label: t$2('menus.cut'),
    role: 'cut'
  }, {
    id: 'copy',
    label: t$2('menus.copy'),
    role: 'copy'
  }, {
    id: 'paste',
    label: t$2('menus.paste'),
    role: 'paste'
  }, {
    id: 'selectAll',
    label: t$2('menus.selectAll'),
    role: 'selectAll'
  }]
}));
const selectViewDeps = reselect.createStructuredSelector({
  currentView: ({
    currentView
  }) => currentView,
  isSideBarEnabled: ({
    isSideBarEnabled
  }) => isSideBarEnabled,
  isTrayIconEnabled: ({
    isTrayIconEnabled
  }) => isTrayIconEnabled,
  isMenuBarEnabled: ({
    isMenuBarEnabled
  }) => isMenuBarEnabled,
  rootWindowState: ({
    rootWindowState
  }) => rootWindowState
});
const getCurrentView = async () => {
  const browserWindow = await getRootWindow();
  if (!browserWindow.isVisible()) {
    browserWindow.showInactive();
  }
  browserWindow.focus();
  return select(({
    currentView
  }) => currentView);
};
const getCurrentViewWebcontents = async () => {
  const currentView = await getCurrentView();
  const url = typeof currentView === 'object' ? currentView.url : null;
  if (!url) {
    return null;
  }
  return getWebContentsByServerUrl(url);
};
const createViewMenu = reselect.createSelector(selectViewDeps, ({
  currentView,
  isSideBarEnabled,
  isTrayIconEnabled,
  isMenuBarEnabled,
  rootWindowState
}) => ({
  id: 'viewMenu',
  label: t$2('menus.viewMenu'),
  submenu: [{
    id: 'reload',
    label: t$2('menus.reload'),
    accelerator: 'CommandOrControl+R',
    enabled: typeof currentView === 'object' && !!currentView.url,
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.reload();
      const currentView = await getCurrentView();
      if (typeof currentView === 'object' && !!currentView.url) {
        dispatch({
          type: WEBVIEW_SERVER_RELOADED,
          payload: {
            url: currentView.url
          }
        });
      }
    }
  }, {
    id: 'reloadClearingCache',
    label: t$2('menus.reloadClearingCache'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      if (guestWebContents) dispatch({
        type: CLEAR_CACHE_TRIGGERED,
        payload: guestWebContents.id
      });
      const currentView = await getCurrentView();
      if (typeof currentView === 'object' && !!currentView.url) {
        dispatch({
          type: WEBVIEW_SERVER_RELOADED,
          payload: {
            url: currentView.url
          }
        });
      }
    }
  }, {
    id: 'openDevTools',
    label: t$2('menus.openDevTools'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    accelerator: process.platform === 'darwin' ? 'Command+Alt+I' : 'Ctrl+Shift+I',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.toggleDevTools();
    }
  }, {
    id: 'openDevToolsOnAllWindows',
    label: t$2('menus.openDevToolsOnAllWindows'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    accelerator: process.platform === 'darwin' ? 'Command+Alt+G' : 'Ctrl+Shift+G',
    click: async () => {
      const windows = electron.BrowserWindow.getAllWindows();
      windows.forEach(window => {
        window.webContents.toggleDevTools();
      });
    }
  }, {
    type: 'separator'
  }, {
    id: 'back',
    label: t$2('menus.back'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    accelerator: process.platform === 'darwin' ? 'Command+[' : 'Alt+Left',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.goBack();
    }
  }, {
    id: 'forward',
    label: t$2('menus.forward'),
    enabled: typeof currentView === 'object' && !!currentView.url,
    accelerator: process.platform === 'darwin' ? 'Command+]' : 'Alt+Right',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.goForward();
    }
  }, {
    type: 'separator'
  }, {
    id: 'showTrayIcon',
    label: t$2('menus.showTrayIcon'),
    type: 'checkbox',
    checked: isTrayIconEnabled,
    accelerator: process.platform === 'darwin' ? 'Shift+Command+T' : 'Ctrl+Shift+T',
    click: ({
      checked
    }) => {
      setTimeout(() => {
        dispatch({
          type: MENU_BAR_TOGGLE_IS_TRAY_ICON_ENABLED_CLICKED,
          payload: checked
        });
      }, 10);
    }
  }, ...on(process.platform === 'darwin', () => [{
    id: 'showFullScreen',
    label: t$2('menus.showFullScreen'),
    type: 'checkbox',
    checked: rootWindowState.fullscreen,
    accelerator: 'Control+Command+F',
    click: async ({
      checked: enabled
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      browserWindow.setFullScreen(enabled);
    }
  }]), ...on(process.platform !== 'darwin', () => [{
    id: 'showMenuBar',
    label: t$2('menus.showMenuBar'),
    type: 'checkbox',
    checked: isMenuBarEnabled,
    enabled: !isMenuBarEnabled || isSideBarEnabled,
    accelerator: process.platform === 'darwin' ? 'Shift+Command+M' : 'Ctrl+Shift+M',
    click: async ({
      checked
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_TOGGLE_IS_MENU_BAR_ENABLED_CLICKED,
        payload: checked
      });
    }
  }]), {
    id: 'showServerList',
    label: t$2('menus.showServerList'),
    type: 'checkbox',
    checked: isSideBarEnabled,
    enabled: !isSideBarEnabled || isMenuBarEnabled,
    accelerator: process.platform === 'darwin' ? 'Shift+Command+S' : 'Ctrl+Shift+S',
    click: async ({
      checked
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_TOGGLE_IS_SIDE_BAR_ENABLED_CLICKED,
        payload: checked
      });
    }
  }, {
    type: 'separator'
  }, {
    id: 'resetZoom',
    label: t$2('menus.resetZoom'),
    accelerator: 'CommandOrControl+0',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      guestWebContents === null || guestWebContents === void 0 || guestWebContents.setZoomLevel(0);
    }
  }, {
    id: 'zoomIn',
    label: t$2('menus.zoomIn'),
    accelerator: 'CommandOrControl+=',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      if (!guestWebContents) {
        return;
      }
      const zoomLevel = guestWebContents === null || guestWebContents === void 0 ? void 0 : guestWebContents.getZoomLevel();
      if (zoomLevel >= 9) {
        return;
      }
      guestWebContents.setZoomLevel(zoomLevel + 1);
    }
  }, {
    id: 'zoomOut',
    label: t$2('menus.zoomOut'),
    accelerator: 'CommandOrControl+-',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      if (!guestWebContents) {
        return;
      }
      const zoomLevel = guestWebContents.getZoomLevel();
      if (zoomLevel <= -9) {
        return;
      }
      guestWebContents.setZoomLevel(zoomLevel - 1);
    }
  }]
}));
const selectWindowDeps = reselect.createStructuredSelector({
  servers: ({
    servers
  }) => servers,
  currentView: ({
    currentView
  }) => currentView,
  isShowWindowOnUnreadChangedEnabled: ({
    isShowWindowOnUnreadChangedEnabled
  }) => isShowWindowOnUnreadChangedEnabled,
  isAddNewServersEnabled: ({
    isAddNewServersEnabled
  }) => isAddNewServersEnabled
});
const createWindowMenu = reselect.createSelector(selectWindowDeps, ({
  servers,
  currentView,
  isShowWindowOnUnreadChangedEnabled,
  isAddNewServersEnabled
}) => ({
  id: 'windowMenu',
  label: t$2('menus.windowMenu'),
  role: 'windowMenu',
  submenu: [...on(process.platform === 'darwin' && isAddNewServersEnabled, () => [{
    id: 'addNewServer',
    label: t$2('menus.addNewServer'),
    accelerator: 'CommandOrControl+N',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_ADD_NEW_SERVER_CLICKED
      });
    }
  }, {
    type: 'separator'
  }]), ...on(servers.length > 0, () => [...servers.map((server, i) => {
    var _server$title;
    return {
      id: server.url,
      type: typeof currentView === 'object' && currentView.url === server.url ? 'checkbox' : 'normal',
      label: (_server$title = server.title) === null || _server$title === void 0 ? void 0 : _server$title.replace(/&/g, '&&'),
      checked: typeof currentView === 'object' && currentView.url === server.url,
      accelerator: `CommandOrControl+${i + 1}`,
      click: async () => {
        const browserWindow = await getRootWindow();
        if (!browserWindow.isVisible()) {
          browserWindow.showInactive();
        }
        browserWindow.focus();
        setTimeout(() => {
          dispatch({
            type: MENU_BAR_SELECT_SERVER_CLICKED,
            payload: server.url
          });
        }, 100);
      }
    };
  }), {
    type: 'separator'
  }]), {
    id: 'downloads',
    label: t$2('menus.downloads'),
    checked: currentView === 'downloads',
    accelerator: 'CommandOrControl+D',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: SIDE_BAR_DOWNLOADS_BUTTON_CLICKED
      });
    }
  }, {
    id: 'settings',
    label: t$2('menus.settings'),
    checked: currentView === 'settings',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: SIDE_BAR_SETTINGS_BUTTON_CLICKED
      });
    }
  }, {
    id: 'showOnUnreadMessage',
    type: 'checkbox',
    label: t$2('menus.showOnUnreadMessage'),
    checked: isShowWindowOnUnreadChangedEnabled,
    click: async ({
      checked
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_TOGGLE_IS_SHOW_WINDOW_ON_UNREAD_CHANGED_ENABLED_CLICKED,
        payload: checked
      });
    }
  }, {
    type: 'separator'
  }, {
    id: 'minimize',
    role: 'minimize',
    label: t$2('menus.minimize'),
    accelerator: 'CommandOrControl+M'
  }, {
    id: 'close',
    role: 'close',
    label: t$2('menus.close'),
    accelerator: 'CommandOrControl+W'
  }]
}));
const selectHelpDeps = reselect.createStructuredSelector({
  isDeveloperModeEnabled: ({
    isDeveloperModeEnabled
  }) => isDeveloperModeEnabled,
  isVideoCallDevtoolsAutoOpenEnabled: ({
    isVideoCallDevtoolsAutoOpenEnabled
  }) => isVideoCallDevtoolsAutoOpenEnabled
});
const createHelpMenu = reselect.createSelector(selectHelpDeps, ({
  isDeveloperModeEnabled,
  isVideoCallDevtoolsAutoOpenEnabled
}) => ({
  id: 'helpMenu',
  label: t$2('menus.helpMenu'),
  role: 'help',
  submenu: [{
    id: 'documentation',
    label: t$2('menus.documentation'),
    click: () => {
      openExternal(docs.index);
    }
  }, {
    id: 'reportIssue',
    label: t$2('menus.reportIssue'),
    click: () => {
      openExternal(docs.newIssue);
    }
  }, {
    type: 'separator'
  }, {
    id: 'reload-window',
    label: t$2('menus.reload'),
    accelerator: 'CommandOrControl+Shift+R',
    click: async () => {
      const guestWebContents = await getCurrentViewWebcontents();
      if (guestWebContents) dispatch({
        type: CLEAR_CACHE_TRIGGERED,
        payload: guestWebContents.id
      });
      const currentView = await getCurrentView();
      if (typeof currentView === 'object' && !!currentView.url) {
        dispatch({
          type: WEBVIEW_SERVER_RELOADED,
          payload: {
            url: currentView.url
          }
        });
      }
    }
  }, {
    id: 'toggleDevTools',
    label: t$2('menus.toggleDevTools'),
    accelerator: 'CommandOrControl+Shift+D',
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      browserWindow.webContents.toggleDevTools();
    }
  }, {
    id: 'developerMode',
    type: 'checkbox',
    label: t$2('menus.developerMode'),
    checked: isDeveloperModeEnabled,
    click: async ({
      checked
    }) => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_TOGGLE_IS_DEVELOPER_MODE_ENABLED_CLICKED,
        payload: checked
      });
    }
  }, {
    id: 'videoCallToolsSubmenu',
    label: t$2('menus.videoCallTools'),
    submenu: [{
      id: 'videoCallDevTools',
      label: t$2('menus.videoCallDevTools'),
      click: async () => {
        const browserWindow = await getRootWindow();
        if (!browserWindow.isVisible()) {
          browserWindow.showInactive();
        }
        browserWindow.focus();
        try {
          const success = await openVideoCallWebviewDevTools();
          if (!success) {
            console.log('No video call window available for developer tools');
          }
        } catch (error) {
          console.error('Error opening video call developer tools:', error);
        }
      }
    }, {
      id: 'videoCallDevToolsAutoOpen',
      type: 'checkbox',
      label: t$2('menus.videoCallDevToolsAutoOpen'),
      checked: isVideoCallDevtoolsAutoOpenEnabled,
      click: async ({
        checked
      }) => {
        const browserWindow = await getRootWindow();
        if (!browserWindow.isVisible()) {
          browserWindow.showInactive();
        }
        browserWindow.focus();
        dispatch({
          type: MENU_BAR_TOGGLE_IS_VIDEO_CALL_DEVTOOLS_AUTO_OPEN_ENABLED_CLICKED,
          payload: checked
        });
      }
    }]
  }, {
    id: 'openConfigFolder',
    label: t$2('menus.openConfigFolder'),
    click: async () => {
      electron.shell.showItemInFolder(path__default.default.join(electron.app.getPath('userData'), 'config.json'));
    }
  }, {
    type: 'separator'
  }, {
    id: 'clearTrustedCertificates',
    label: t$2('menus.clearTrustedCertificates'),
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: CERTIFICATES_CLEARED
      });
    }
  }, ...on(!process.mas, () => [{
    id: 'resetAppData',
    label: t$2('menus.resetAppData'),
    click: async () => {
      const permitted = await askForAppDataReset();
      if (permitted) {
        relaunchApp('--reset-app-data');
      }
    }
  }]), {
    type: 'separator'
  }, {
    id: 'learnMore',
    label: t$2('menus.learnMore'),
    click: () => {
      openExternal(rocketchat.site);
    }
  }, ...on(process.platform !== 'darwin', () => [{
    id: 'about',
    label: t$2('menus.about', {
      appName: electron.app.name
    }),
    click: async () => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: MENU_BAR_ABOUT_CLICKED
      });
    }
  }])]
}));
const selectMenuBarTemplate = reselect.createSelector([createAppMenu, createEditMenu, createViewMenu, createWindowMenu, createHelpMenu], (...menus) => menus);
const selectMenuBarTemplateAsJson = reselect.createSelector(_state => selectMenuBarTemplate, template => JSON.stringify(template));
class MenuBarService extends Service {
  initialize() {
    this.watch(selectMenuBarTemplateAsJson, async () => {
      const menuBarTemplate = select(selectMenuBarTemplate);
      const menu = electron.Menu.buildFromTemplate(menuBarTemplate);
      if (process.platform === 'darwin') {
        electron.Menu.setApplicationMenu(menu);
        return;
      }
      electron.Menu.setApplicationMenu(null);
      (await getRootWindow()).setMenu(menu);
    });
  }
}
var menuBar = new MenuBarService();

const t$1 = i18next__default.default.t.bind(i18next__default.default);
const ids = ['bold', 'italic', 'strike', 'inline_code', 'multi_line'];
const createTouchBar = () => {
  const serverSelectionScrubber = new electron.TouchBar.TouchBarScrubber({
    selectedStyle: 'background',
    mode: 'free',
    continuous: false,
    items: [],
    select: async index => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      const url = select(({
        servers
      }) => servers[index].url);
      dispatch({
        type: TOUCH_BAR_SELECT_SERVER_TOUCHED,
        payload: url
      });
    }
  });
  const serverSelectionPopover = new electron.TouchBar.TouchBarPopover({
    label: t$1('touchBar.selectServer'),
    icon: undefined,
    items: new electron.TouchBar({
      items: [serverSelectionScrubber]
    }),
    showCloseButton: true
  });
  const messageBoxFormattingButtons = new electron.TouchBar.TouchBarSegmentedControl({
    mode: 'buttons',
    segments: ids.map(id => ({
      icon: electron.nativeImage.createFromPath(`${electron.app.getAppPath()}/app/images/touch-bar/${id}.png`),
      enabled: false
    })),
    change: async selectedIndex => {
      const browserWindow = await getRootWindow();
      if (!browserWindow.isVisible()) {
        browserWindow.showInactive();
      }
      browserWindow.focus();
      dispatch({
        type: TOUCH_BAR_FORMAT_BUTTON_TOUCHED,
        payload: ids[selectedIndex]
      });
    }
  });
  const touchBar = new electron.TouchBar({
    items: [serverSelectionPopover, new electron.TouchBar.TouchBarSpacer({
      size: 'flexible'
    }), messageBoxFormattingButtons, new electron.TouchBar.TouchBarSpacer({
      size: 'flexible'
    })]
  });
  getRootWindow().then(browserWindow => browserWindow.setTouchBar(touchBar));
  return [touchBar, serverSelectionPopover, serverSelectionScrubber, messageBoxFormattingButtons];
};
const updateServerSelectionPopover = (serverSelectionPopover, currentServer) => {
  var _currentServer$title;
  serverSelectionPopover.label = (_currentServer$title = currentServer === null || currentServer === void 0 ? void 0 : currentServer.title) !== null && _currentServer$title !== void 0 ? _currentServer$title : t$1('touchBar.selectServer');
  serverSelectionPopover.icon = currentServer !== null && currentServer !== void 0 && currentServer.favicon ? electron.nativeImage.createFromDataURL(currentServer === null || currentServer === void 0 ? void 0 : currentServer.favicon) : electron.nativeImage.createEmpty();
};
const updateServerSelectionScrubber = (serverSelectionScrubber, servers) => {
  serverSelectionScrubber.items = servers.map(server => {
    var _server$title;
    return {
      label: (_server$title = server.title) === null || _server$title === void 0 ? void 0 : _server$title.padEnd(30),
      icon: server.favicon ? electron.nativeImage.createFromDataURL(server.favicon) : undefined
    };
  });
};
const toggleMessageFormattingButtons = (messageBoxFormattingButtons, isEnabled) => {
  messageBoxFormattingButtons.segments.forEach(segment => {
    segment.enabled = isEnabled;
  });
};
const selectCurrentServer = ({
  servers,
  currentView
}) => {
  var _servers$find;
  return typeof currentView === 'object' ? (_servers$find = servers.find(({
    url
  }) => url === currentView.url)) !== null && _servers$find !== void 0 ? _servers$find : null : null;
};
class TouchBarService extends Service {
  initialize() {
    if (process.platform !== 'darwin') {
      return;
    }
    const [touchBar, serverSelectionPopover, serverSelectionScrubber, messageBoxFormattingButtons] = createTouchBar();
    this.watch(selectCurrentServer, currentServer => {
      updateServerSelectionPopover(serverSelectionPopover, currentServer);
      getRootWindow().then(browserWindow => browserWindow.setTouchBar(touchBar));
    });
    this.watch(({
      servers
    }) => servers, servers => {
      updateServerSelectionScrubber(serverSelectionScrubber, servers);
      getRootWindow().then(browserWindow => browserWindow.setTouchBar(touchBar));
    });
    this.watch(({
      isMessageBoxFocused
    }) => isMessageBoxFocused !== null && isMessageBoxFocused !== void 0 ? isMessageBoxFocused : false, isMessageBoxFocused => {
      toggleMessageFormattingButtons(messageBoxFormattingButtons, isMessageBoxFocused);
      getRootWindow().then(browserWindow => browserWindow.setTouchBar(touchBar));
    });
  }
}
var touchBar = new TouchBarService();

const t = i18next__default.default.t.bind(i18next__default.default);
const selectIsRootWindowVisible = ({
  rootWindowState: {
    visible
  }
}) => visible;
const selectHasHideOnTrayNotificationShown = ({
  hasHideOnTrayNotificationShown
}) => hasHideOnTrayNotificationShown;
const createTrayIcon = () => {
  const image = getTrayIconPath({
    platform: process.platform,
    badge: undefined
  });
  const trayIcon = new electron.Tray(electron.nativeImage.createEmpty());
  if (process.platform !== 'darwin') {
    trayIcon.addListener('click', async () => {
      const isRootWindowVisible = select(selectIsRootWindowVisible);
      const browserWindow = await getRootWindow();
      if (isRootWindowVisible) {
        browserWindow.hide();
        return;
      }
      browserWindow.show();
    });
  }
  trayIcon.addListener('balloon-click', async () => {
    const isRootWindowVisible = select(selectIsRootWindowVisible);
    const browserWindow = await getRootWindow();
    if (isRootWindowVisible) {
      browserWindow.hide();
      return;
    }
    browserWindow.show();
  });
  trayIcon.addListener('right-click', (_event, bounds) => {
    trayIcon.popUpContextMenu(undefined, bounds);
  });
  trayIcon.setImage(electron.nativeImage.createFromPath(image));
  return trayIcon;
};
const updateTrayIconImage = (trayIcon, badge) => {
  const image = getTrayIconPath({
    platform: process.platform,
    badge
  });
  trayIcon.setImage(electron.nativeImage.createFromPath(image));
};
const updateTrayIconTitle = (trayIcon, globalBadge) => {
  const title = Number.isInteger(globalBadge) ? String(globalBadge) : '';
  trayIcon.setTitle(title);
};
const updateTrayIconToolTip = (trayIcon, globalBadge) => {
  if (globalBadge === '•') {
    trayIcon.setToolTip(t('tray.tooltip.unreadMessage', {
      appName: electron.app.name
    }));
    return;
  }
  if (Number.isInteger(globalBadge)) {
    trayIcon.setToolTip(t('tray.tooltip.unreadMention', {
      appName: electron.app.name,
      count: globalBadge
    }));
    return;
  }
  trayIcon.setToolTip(t('tray.tooltip.noUnreadMessage', {
    appName: electron.app.name
  }));
};
const warnStillRunning = trayIcon => {
  if (process.platform !== 'win32') {
    return;
  }
  const hasHideOnTrayNotificationShown = select(selectHasHideOnTrayNotificationShown);
  if (!hasHideOnTrayNotificationShown) {
    trayIcon.displayBalloon({
      icon: getAppIconPath({
        platform: process.platform
      }),
      title: t('tray.balloon.stillRunning.title', {
        appName: electron.app.name
      }),
      content: t('tray.balloon.stillRunning.content', {
        appName: electron.app.name
      })
    });
    dispatch({
      type: SET_HAS_TRAY_MINIMIZE_NOTIFICATION_SHOWN,
      payload: true
    });
  }
};
const manageTrayIcon = async () => {
  const trayIcon = createTrayIcon();
  const unwatchGlobalBadge = watch(selectGlobalBadge, globalBadge => {
    updateTrayIconImage(trayIcon, globalBadge);
    updateTrayIconTitle(trayIcon, globalBadge);
    updateTrayIconToolTip(trayIcon, globalBadge);
  });
  let firstTrayIconBalloonShown = false;
  const unwatchIsRootWindowVisible = watch(selectIsRootWindowVisible, (isRootWindowVisible, prevIsRootWindowVisible) => {
    const menuTemplate = [{
      label: isRootWindowVisible ? t('tray.menu.hide') : t('tray.menu.show'),
      click: async () => {
        const isRootWindowVisible = select(selectIsRootWindowVisible);
        const browserWindow = await getRootWindow();
        if (isRootWindowVisible) {
          browserWindow.hide();
          return;
        }
        browserWindow.show();
      }
    }, {
      label: t('tray.menu.quit'),
      click: () => {
        electron.app.quit();
      }
    }];
    const menu = electron.Menu.buildFromTemplate(menuTemplate);
    trayIcon.setContextMenu(menu);
    if (prevIsRootWindowVisible && !isRootWindowVisible && process.platform === 'win32' && !firstTrayIconBalloonShown) {
      warnStillRunning(trayIcon);
      firstTrayIconBalloonShown = true;
    }
  });
  return () => {
    unwatchGlobalBadge();
    unwatchIsRootWindowVisible();
    trayIcon.destroy();
  };
};
class TrayIconService extends Service {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "tearDownPromise", null);
  }
  initialize() {
    this.watch(({
      isTrayIconEnabled
    }) => isTrayIconEnabled !== null && isTrayIconEnabled !== void 0 ? isTrayIconEnabled : true, isTrayIconEnabled => {
      if (!this.tearDownPromise && isTrayIconEnabled) {
        this.tearDownPromise = manageTrayIcon();
      } else if (this.tearDownPromise && !isTrayIconEnabled) {
        this.tearDownPromise.then(cleanUp => cleanUp());
        this.tearDownPromise = null;
      }
    });
  }
  destroy() {
    var _this$tearDownPromise;
    (_this$tearDownPromise = this.tearDownPromise) === null || _this$tearDownPromise === void 0 || _this$tearDownPromise.then(cleanUp => cleanUp());
    this.tearDownPromise = null;
  }
}
var trayIcon = new TrayIconService();

const readJsonObject = async filePath => {
  try {
    const content = await fs__default.default.promises.readFile(filePath, 'utf8');
    const json = JSON.parse(content);
    return json && typeof json === 'object' && !Array.isArray(json) ? json : {};
  } catch (error) {
    return {};
  }
};
const readAppJsonObject = async basename => {
  const filePath = path__default.default.join(electron.app.getAppPath(), electron.app.getAppPath().endsWith('app.asar') ? '..' : '.', basename);
  return readJsonObject(filePath);
};
const readUserJsonObject = async basename => {
  const filePath = path__default.default.join(electron.app.getPath('userData'), basename);
  return readJsonObject(filePath);
};
const loadAppConfiguration = async () => readAppJsonObject('update.json');
const loadUserConfiguration = async () => readUserJsonObject('update.json');
const mergeConfigurations = (defaultConfiguration, appConfiguration, userConfiguration) => {
  const configuration = {
    ...defaultConfiguration,
    ...(typeof appConfiguration.forced === 'boolean' && {
      isEachUpdatesSettingConfigurable: !appConfiguration.forced
    }),
    ...(typeof appConfiguration.canUpdate === 'boolean' && {
      isUpdatingEnabled: appConfiguration.canUpdate
    }),
    ...(typeof appConfiguration.autoUpdate === 'boolean' && {
      doCheckForUpdatesOnStartup: appConfiguration.autoUpdate
    }),
    ...(typeof appConfiguration.skip === 'string' && {
      skippedUpdateVersion: appConfiguration.skip
    }),
    ...(typeof appConfiguration.channel === 'string' && {
      updateChannel: appConfiguration.channel
    })
  };
  if (typeof userConfiguration.autoUpdate === 'boolean' && (configuration.isEachUpdatesSettingConfigurable || typeof appConfiguration.autoUpdate === 'undefined')) {
    configuration.doCheckForUpdatesOnStartup = userConfiguration.autoUpdate;
  }
  if (typeof userConfiguration.skip === 'string' && (configuration.isEachUpdatesSettingConfigurable || typeof appConfiguration.skip === 'undefined')) {
    configuration.skippedUpdateVersion = userConfiguration.skip;
  }
  if (typeof userConfiguration.channel === 'string' && (configuration.isEachUpdatesSettingConfigurable || typeof appConfiguration.channel === 'undefined')) {
    configuration.updateChannel = userConfiguration.channel;
  }
  return configuration;
};
const loadConfiguration = async () => {
  const defaultConfiguration = select(({
    isUpdatingEnabled,
    doCheckForUpdatesOnStartup,
    skippedUpdateVersion,
    isReportEnabled,
    isFlashFrameEnabled,
    isHardwareAccelerationEnabled,
    isInternalVideoChatWindowEnabled,
    isVideoCallScreenCaptureFallbackEnabled,
    updateChannel
  }) => ({
    isUpdatingAllowed: process.platform === 'linux' && !!process.env.APPIMAGE || process.platform === 'win32' && !process.windowsStore || process.platform === 'darwin' && !process.mas,
    isEachUpdatesSettingConfigurable: true,
    isUpdatingEnabled,
    doCheckForUpdatesOnStartup,
    skippedUpdateVersion,
    isReportEnabled,
    isFlashFrameEnabled,
    isHardwareAccelerationEnabled,
    isInternalVideoChatWindowEnabled,
    isVideoCallScreenCaptureFallbackEnabled,
    updateChannel
  }));
  const appConfiguration = await loadAppConfiguration();
  const userConfiguration = await loadUserConfiguration();
  return mergeConfigurations(defaultConfiguration, appConfiguration, userConfiguration);
};
const setupUpdates = async () => {
  electronUpdater.autoUpdater.autoDownload = false;
  const {
    isUpdatingAllowed,
    isEachUpdatesSettingConfigurable,
    isUpdatingEnabled,
    doCheckForUpdatesOnStartup,
    skippedUpdateVersion,
    isReportEnabled,
    isFlashFrameEnabled,
    isHardwareAccelerationEnabled,
    isInternalVideoChatWindowEnabled,
    isVideoCallScreenCaptureFallbackEnabled,
    updateChannel
  } = await loadConfiguration();
  dispatch({
    type: UPDATES_READY,
    payload: {
      isUpdatingAllowed,
      isEachUpdatesSettingConfigurable,
      isUpdatingEnabled,
      doCheckForUpdatesOnStartup,
      skippedUpdateVersion,
      isReportEnabled,
      isFlashFrameEnabled,
      isHardwareAccelerationEnabled,
      isInternalVideoChatWindowEnabled,
      isVideoCallScreenCaptureFallbackEnabled,
      updateChannel
    }
  });
  if (!isUpdatingAllowed || !isUpdatingEnabled) {
    return;
  }

  // Set initial channel
  electronUpdater.autoUpdater.channel = updateChannel;

  // Enable prerelease updates for alpha and beta channels
  if (updateChannel === 'alpha' || updateChannel === 'beta') {
    electronUpdater.autoUpdater.allowPrerelease = true;
  }

  // Listen for channel changes
  listen(ABOUT_DIALOG_UPDATE_CHANNEL_CHANGED, async action => {
    const newChannel = action.payload;
    electronUpdater.autoUpdater.channel = newChannel;

    // Enable prerelease updates for alpha and beta channels
    electronUpdater.autoUpdater.allowPrerelease = newChannel === 'alpha' || newChannel === 'beta';
    dispatch({
      type: UPDATES_CHANNEL_CHANGED,
      payload: newChannel
    });
  });
  electronUpdater.autoUpdater.addListener('checking-for-update', () => {
    dispatch({
      type: UPDATES_CHECKING_FOR_UPDATE
    });
  });
  electronUpdater.autoUpdater.addListener('update-available', ({
    version
  }) => {
    const skippedUpdateVersion = select(({
      skippedUpdateVersion
    }) => skippedUpdateVersion);
    if (skippedUpdateVersion === version) {
      dispatch({
        type: UPDATES_NEW_VERSION_NOT_AVAILABLE
      });
      return;
    }
    dispatch({
      type: UPDATES_NEW_VERSION_AVAILABLE,
      payload: version
    });
  });
  electronUpdater.autoUpdater.addListener('update-not-available', () => {
    dispatch({
      type: UPDATES_NEW_VERSION_NOT_AVAILABLE
    });
  });
  const nativeUpdateDownloadedCallback = () => {
    electron.autoUpdater.removeListener('update-downloaded', nativeUpdateDownloadedCallback);
    electron.autoUpdater.quitAndInstall();
  };
  electronUpdater.autoUpdater.addListener('update-downloaded', async () => {
    const response = await askUpdateInstall();
    if (response === AskUpdateInstallResponse.INSTALL_LATER) {
      await warnAboutInstallUpdateLater();
      return;
    }
    try {
      setImmediate(() => {
        electron.app.removeAllListeners('window-all-closed');
        if (process.platform === 'darwin') {
          const allBrowserWindows = electron.BrowserWindow.getAllWindows();
          allBrowserWindows.forEach(browserWindow => {
            browserWindow.removeAllListeners('close');
            browserWindow.destroy();
          });
          electron.autoUpdater.checkForUpdates();
          electron.autoUpdater.on('update-downloaded', nativeUpdateDownloadedCallback);
        } else {
          electronUpdater.autoUpdater.quitAndInstall(true, true);
        }
      });
    } catch (error) {
      error instanceof Error && dispatch({
        type: UPDATES_ERROR_THROWN,
        payload: {
          message: error.message,
          stack: error.stack,
          name: error.name
        }
      });
    }
  });
  electronUpdater.autoUpdater.addListener('error', error => {
    dispatch({
      type: UPDATES_ERROR_THROWN,
      payload: {
        message: error.message,
        stack: error.stack,
        name: error.name
      }
    });
  });
  if (doCheckForUpdatesOnStartup) {
    try {
      await electronUpdater.autoUpdater.checkForUpdates();
    } catch (error) {
      error instanceof Error && dispatch({
        type: UPDATES_ERROR_THROWN,
        payload: {
          message: error.message,
          stack: error.stack,
          name: error.name
        }
      });
    }
  }
  listen(UPDATES_CHECK_FOR_UPDATES_REQUESTED, async () => {
    try {
      setTimeout(() => {
        electronUpdater.autoUpdater.checkForUpdates();
      }, 100);
    } catch (error) {
      error instanceof Error && dispatch({
        type: UPDATES_ERROR_THROWN,
        payload: {
          message: error.message,
          stack: error.stack,
          name: error.name
        }
      });
    }
  });
  listen(UPDATE_DIALOG_SKIP_UPDATE_CLICKED, async action => {
    await warnAboutUpdateSkipped();
    dispatch({
      type: UPDATE_SKIPPED,
      payload: action.payload
    });
  });
  listen(UPDATE_DIALOG_INSTALL_BUTTON_CLICKED, async () => {
    await warnAboutUpdateDownload();
    try {
      electronUpdater.autoUpdater.downloadUpdate();
    } catch (error) {
      error instanceof Error && dispatch({
        type: UPDATES_ERROR_THROWN,
        payload: {
          message: error.message,
          stack: error.stack,
          name: error.name
        }
      });
    }
  });
};

const SYSTEM_LOCKING_SCREEN = 'system/locking-screen';
const SYSTEM_SUSPENDING = 'system/suspending';

const setupPowerMonitor = () => {
  electron.powerMonitor.addListener('suspend', () => {
    dispatch({
      type: SYSTEM_SUSPENDING
    });
  });
  electron.powerMonitor.addListener('lock-screen', () => {
    dispatch({
      type: SYSTEM_LOCKING_SCREEN
    });
  });
  handle('power-monitor/get-system-idle-state', async (_webContents, idleThreshold) => electron.powerMonitor.getSystemIdleState(idleThreshold));
};

const start = async () => {
  performElectronStartup();
  await electron.app.whenReady();
  createMainReduxStore();

  // Initialize screen capture fallback state after store is available
  initializeScreenCaptureFallbackState();

  // Set up electron-dl with our download tracking callbacks
  setupElectronDlWithTracking();
  const localStorage = await exportLocalStorage();
  await mergePersistableValues(localStorage);
  await setupServers(localStorage);
  i18n.setUp();
  await i18n.wait();
  setupApp();
  setupMainErrorHandling();
  createRootWindow();
  startOutlookCalendarUrlHandler();
  attachGuestWebContentsEvents();
  await showRootWindow();

  // React DevTools is currently incompatible with Electron 10
  // if ("production" === 'development') {
  //   installDevTools();
  // }
  watchMachineTheme();
  setupNotifications();
  setupScreenSharing();
  startVideoCallWindowHandler();
  await setupSpellChecking();
  setupDeepLinks();
  await setupNavigation();
  setupPowerMonitor();
  await setupUpdates();
  setupDownloads();
  handleCertificatesManager();
  dock.setUp();
  menuBar.setUp();
  touchBar.setUp();
  trayIcon.setUp();
  electron.app.addListener('before-quit', () => {
    dock.tearDown();
    menuBar.tearDown();
    touchBar.tearDown();
    trayIcon.tearDown();
    cleanupVideoCallResources();
  });
  watchAndPersistChanges();
  handleJitsiDesktopCapturerGetSources();
  handleDesktopCapturerGetSources();
  handleClearCacheDialog();
  startDocumentViewerHandler();
  checkSupportedVersionServers();
  await processDeepLinksInArgs();
  console.log('Application initialization completed successfully');
};
start();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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