'use strict';

var contextMenu = {
	cut: "切り取り (&T)",
	copy: "コピー (&C)",
	paste: "貼り付け (&P)",
	selectAll: "全て選択 (&A)",
	undo: "元に戻す (&U)",
	redo: "やり直し (&R)",
	spellingLanguages: "スペルチェックの言語",
	moreSpellingSuggestions: "その他のスペルの提案",
	noSpellingSuggestions: "提案はありません",
	copyLinkAddress: "リンクURLをコピー",
	copyLinkText: "リンクテキストをコピー",
	openLink: "リンクを開く",
	saveImageAs: "画像を保存..."
};
var dialog = {
	about: {
		title: "{{- appName}} について",
		version: "バージョン: <1>{{-version}}</1>",
		checkUpdates: "アップデートを確認",
		checkUpdatesOnStart: "起動時に更新を確認",
		noUpdatesAvailable: "利用可能な更新はありません。",
		copyright: "著作権 {{copyright}}"
	},
	addServer: {
		title: "サーバーを追加",
		message: "サーバーリストに\"{{- host}}\"を追加しますか?",
		add: "追加",
		cancel: "キャンセル"
	},
	addServerError: {
		title: "無効なホスト",
		message: "ホスト \"{{- host}}\" を検証できなかったため、追加されませんでした。"
	},
	certificateError: {
		title: "証明書のエラー",
		message: "\"{{- issuerName}}\"から証明書を信頼しますか?",
		yes: "はい",
		no: "いいえ"
	},
	resetAppData: {
		title: "アプリのデータをリセット",
		message: "すべてのチームからログアウトしアプリを元の設定に戻すことができます。 これは元に戻すことはできません。",
		yes: "はい",
		cancel: "キャンセル"
	},
	screenshare: {
		title: "画面共有",
		announcement: "共有する画面を選択"
	},
	update: {
		title: "利用可能な更新",
		announcement: "新しい更新が利用可能です",
		message: "Rocket.Chat デスクトップアプリの新しいバージョンが利用可能です!",
		currentVersion: "現在のバージョン:",
		newVersion: "新しいバージョン:",
		install: "更新プログラムをインストール",
		remindLater: "後で知らせる",
		skip: "このバージョンをスキップ"
	},
	updateDownloading: {
		title: "更新プログラムをダウンロード中",
		message: "更新プログラムのインストール準備が整うと通知されます",
		ok: "OK"
	},
	updateInstallLater: {
		title: "後でインストール",
		message: "アプリを終了すると更新プログラムがインストールされます",
		ok: "OK"
	},
	updateReady: {
		title: "更新プログラムをインストールする準備が整いました",
		message: "更新プログラムがダウンロードされました",
		installNow: "今すぐインストール",
		installLater: "後でインストール"
	},
	updateSkip: {
		title: "更新をスキップ",
		message: "次回の更新プログラムが利用可能になったときにお知らせします。\n気になる場合は[バージョン情報]メニューから更新プログラムを確認できます。",
		ok: "OK"
	},
	mediaPermission: {
		title: "メディア許可が必要",
		message: "{{- permissionType}}へのアクセスは現在システム設定で無効になっています。",
		detail: "ビデオ通話機能を有効にするには、システムのプライバシー設定でアクセスを許可してからアプリケーションを再起動してください。",
		openSettings: "設定を開く",
		cancel: "キャンセル",
		microphone: "マイク",
		camera: "カメラ",
		both: "マイクとカメラ"
	}
};
var error = {
	authNeeded: "認証が必要です。<strong>{{- auth}}</strong> を試してみてください。",
	connectTimeout: "再接続がタイムアウトしました",
	differentCertificate: "証明書は以前の証明書とは異なります。\n\n {{- detail}}",
	noValidServerFound: "そのURLで有効なサーバーは見つかりません",
	offline: "インターネット接続を確認してください!"
};
var landing = {
	invalidUrl: "無効なURL",
	validating: "検証中...",
	inputUrl: "サーバーのURLを入力してください",
	connect: "接続"
};
var menus = {
	about: "{{- appName}} について",
	addNewServer: "新しいサーバーを追加 (&N)",
	back: "戻る (&B)",
	clearTrustedCertificates: "信頼する証明書をクリア",
	close: "閉じる",
	copy: "コピー (&C)",
	cut: "切り取り (&T)",
	developerMode: "開発者モード",
	documentation: "ドキュメント",
	editMenu: "編集 (&E)",
	fileMenu: "ファイル (&F)",
	forward: "進む(&F)",
	helpMenu: "ヘルプ (&H)",
	learnMore: "もっと詳しく知る",
	minimize: "最小化",
	openDevTools: "開発ツールを開く (&D)",
	paste: "貼り付け (&P)",
	quit: "{{- appName}} を終了 (&Q)",
	redo: "やり直し (&R)",
	reload: "再読み込み(&R)",
	reportIssue: "問題を報告する",
	resetAppData: "アプリデータをリセット",
	resetZoom: "ズームをリセット",
	selectAll: "全て選択 (&A)",
	showFullScreen: "全画面",
	showMenuBar: "メニューバー",
	showOnUnreadMessage: "未読メッセージを表示",
	showServerList: "サーバー一覧",
	showTrayIcon: "トレイアイコン",
	toggleDevTools: "開発ツールの切り替え (&D)",
	undo: "元に戻す (&U)",
	viewMenu: "表示 (&V)",
	windowMenu: "ウィンドウ (&W)",
	zoomIn: "拡大",
	zoomOut: "縮小"
};
var loadingError = {
	title: "サーバーの読み込みに失敗しました",
	announcement: "ヒューストン、我々は問題を抱えています",
	reload: "再読み込み"
};
var videoCall = {
	loading: {
		initial: "ビデオ通話を読み込み中...",
		reloading: "ビデオ通話を再読み込み中...",
		description: "ビデオ通話に接続中です。しばらくお待ちください"
	},
	error: {
		title: "ビデオ通話の読み込みに失敗しました",
		announcement: "ヒューストン、問題が発生しました",
		timeout: "タイムアウト - ビデオ通話が15秒以内に読み込めませんでした",
		crashed: "Webviewがクラッシュしました",
		maxRetriesReached: "複数回の試行後も読み込みに失敗しました",
		reload: "ビデオ通話を再読み込み"
	}
};
var sidebar = {
	addNewServer: "新しいサーバーを追加",
	item: {
		reload: "サーバーを再読み込み",
		remove: "サーバーを削除",
		openDevTools: "開発ツールを開く"
	}
};
var touchBar = {
	formatting: "書式",
	selectServer: "サーバーを選択"
};
var tray = {
	menu: {
		show: "表示",
		hide: "隠す",
		quit: "終了"
	},
	tooltip: {
		noUnreadMessage: "{{- appName}}: 未読のメッセージはありません",
		unreadMention: "{{- appName}}: 未読のメンション/ダイレクトメッセージがあります",
		unreadMention_plural: "{{- appName}}: 未読のメンション/ダイレクトメッセージが {{- count}} 件あります",
		unreadMessage: "{{- appName}}: 未読のメッセージがあります"
	}
};
var taskbar = {
	unreadMessage: "未読メッセージ",
	unreadMention: "未読メンション",
	noUnreadMessage: "未読メッセージはありません"
};
var screenSharing = {
	permissionDenied: "画面収録権限が拒否されました",
	permissionRequired: "画面を共有するには画面収録権限が必要です。",
	permissionInstructions: "システム環境設定で有効にして、もう一度お試しください。",
	title: "画面を共有する",
	entireScreen: "画面全体",
	applicationWindow: "アプリケーションウィンドウ",
	noScreensFound: "画面が見つかりません",
	noWindowsFound: "ウィンドウが見つかりません",
	cancel: "キャンセル",
	share: "共有"
};
var serverInfo = {
	title: "サーバー情報",
	urlLabel: "URL:",
	versionLabel: "バージョン:",
	unknown: "不明",
	exchangeUrlLabel: "Outlook Exchange URL:",
	supportedVersionsTitle: "サポートされているバージョン",
	statusLabel: "ステータス:",
	status: {
		loading: "読み込み中...",
		error: "読み込みに失敗しました",
		loaded: "読み込み済み",
		idle: "アイドル",
		from: "{{source}}から"
	},
	supported: {
		unknown: "不明",
		expiring: "期限切れ間近",
		yes: "はい",
		no: "いいえ"
	},
	expiration: {
		label: "有効期限:",
		expiresOn: "{{date}}に期限切れ"
	}
};
var ja_i18n = {
	contextMenu: contextMenu,
	dialog: dialog,
	error: error,
	landing: landing,
	menus: menus,
	loadingError: loadingError,
	videoCall: videoCall,
	sidebar: sidebar,
	touchBar: touchBar,
	tray: tray,
	taskbar: taskbar,
	screenSharing: screenSharing,
	serverInfo: serverInfo
};

exports.contextMenu = contextMenu;
exports.default = ja_i18n;
exports.dialog = dialog;
exports.error = error;
exports.landing = landing;
exports.loadingError = loadingError;
exports.menus = menus;
exports.screenSharing = screenSharing;
exports.serverInfo = serverInfo;
exports.sidebar = sidebar;
exports.taskbar = taskbar;
exports.touchBar = touchBar;
exports.tray = tray;
exports.videoCall = videoCall;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiamEuaTE4bi0xN3M3SE82RC5qcyIsInNvdXJjZXMiOltdLCJzb3VyY2VzQ29udGVudCI6W10sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OyJ9
