(function () {
  'use strict';

  function _assertClassBrand(e, t, n) {
    if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n;
    throw new TypeError("Private element is not present on this object");
  }
  function _checkPrivateRedeclaration(e, t) {
    if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object");
  }
  function _classPrivateFieldGet2(s, a) {
    return s.get(_assertClassBrand(s, a));
  }
  function _classPrivateFieldInitSpec(e, t, a) {
    _checkPrivateRedeclaration(e, t), t.set(e, a);
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _classApplyDescriptorGet(e, t) {
    return t.get ? t.get.call(e) : t.value;
  }
  function _classApplyDescriptorSet(e, t, l) {
    if (t.set) t.set.call(e, l);else {
      if (!t.writable) throw new TypeError("attempted to set read only private field");
      t.value = l;
    }
  }
  function _classPrivateFieldGet(e, t) {
    var r = _classPrivateFieldGet2(t, e);
    return _classApplyDescriptorGet(e, r);
  }
  function _classPrivateFieldSet(e, t, r) {
    var s = _classPrivateFieldGet2(t, e);
    return _classApplyDescriptorSet(e, s, r), r;
  }

  console.log('[Rocket.Chat Desktop] Injected.ts');
  const resolveWithExponentialBackoff = (fn, {
    maxRetries = 5,
    delay = 1000
  } = {}) => new Promise(resolve => resolve(fn())).catch(error => {
    if (maxRetries === 0) {
      throw error;
    }
    console.log('[Rocket.Chat Desktop] Inject resolveWithExponentialBackoff - retrying in 1 seconds');
    return new Promise(resolve => {
      setTimeout(() => {
        resolve(resolveWithExponentialBackoff(fn, {
          maxRetries: maxRetries - 1,
          delay: delay * 2
        }));
      }, delay);
    });
  });
  const tryRequire = path => resolveWithExponentialBackoff(() => window.require(path));
  let startRetryCount = 0;
  let totalRetryTime = 0;
  const MAX_RETRY_TIME = 30000; // Maximum 30 seconds total retry time
  const INITIAL_RETRY_DELAY = 1000; // Start with 1 second

  // eslint-disable-next-line complexity
  const start = async () => {
    var _class, _destroy, _onclick, _onclose, _onerror, _onshow, _onaction;
    console.log('[Rocket.Chat Desktop] Injected.ts start fired');
    if (typeof window.require !== 'function') {
      console.log('[Rocket.Chat Desktop] window.require is not defined');
      if (totalRetryTime >= MAX_RETRY_TIME) {
        console.error(`[Rocket.Chat Desktop] Maximum retry time (${MAX_RETRY_TIME}ms) reached. window.require is still not available.`);
        console.log('[Rocket.Chat Desktop] Triggering force reload with cache clear to recover...');
        // Trigger force reload with cache clear to recover
        window.RocketChatDesktop.reloadServer();
        return;
      }
      startRetryCount++;
      const retryDelay = Math.min(INITIAL_RETRY_DELAY * Math.pow(1.5, startRetryCount - 1), 5000); // Cap at 5 seconds per retry

      // Ensure we don't exceed max total time
      const actualDelay = Math.min(retryDelay, MAX_RETRY_TIME - totalRetryTime);
      totalRetryTime += actualDelay;
      console.log(`[Rocket.Chat Desktop] Inject start - retry ${startRetryCount} in ${actualDelay}ms (total time: ${totalRetryTime}ms)`);
      setTimeout(start, actualDelay);
      return;
    }

    // Reset retry counters on successful require detection
    startRetryCount = 0;
    totalRetryTime = 0;
    const {
      Info: serverInfo = {}
    } = await tryRequire('/app/utils/rocketchat.info');
    if (!serverInfo.version) {
      console.log('[Rocket.Chat Desktop] serverInfo.version is not defined');
      return;
    }
    console.log('[Rocket.Chat Desktop] Injected.ts serverInfo', serverInfo);
    window.RocketChatDesktop.setServerInfo(serverInfo);
    function versionIsGreaterOrEqualsTo(version1, version2) {
      // Extract only the core version number (before any suffix like -develop, -rc, etc.)
      const cleanVersion1 = version1.split('-')[0];
      const cleanVersion2 = version2.split('-')[0];
      const v1 = cleanVersion1.split('.').map(Number);
      const v2 = cleanVersion2.split('.').map(Number);

      // Compare each version part
      const maxLength = Math.max(v1.length, v2.length);
      for (let i = 0; i < maxLength; i++) {
        const n1 = v1[i] || 0;
        const n2 = v2[i] || 0;
        if (n1 > n2) {
          return true;
        }
        if (n1 < n2) {
          return false;
        }
      }
      return true; // Equal versions
    }
    const userPresenceModulePath = versionIsGreaterOrEqualsTo(serverInfo.version, '6.3.0') ? 'meteor/rocketchat:user-presence' : 'meteor/konecty:user-presence';
    const settingsModulePath = (() => {
      // if (versionIsGreaterOrEqualsTo(serverInfo.version, '6.0.0'))
      //   return '/app/settings/client';
      if (versionIsGreaterOrEqualsTo(serverInfo.version, '5.0.0')) return '/app/settings/client/index.ts';
      return '/app/settings';
    })();
    const utilsModulePath = (() => {
      // if (versionIsGreaterOrEqualsTo(serverInfo.version, '6.0.0'))
      //   return '/app/utils/client';
      if (versionIsGreaterOrEqualsTo(serverInfo.version, '5.0.0')) return '/app/utils/client/index.ts';
      return '/app/utils';
    })();

    // Load core modules with individual error handling (non-blocking)
    let Meteor = null;
    let Session = null;
    let Tracker = null;
    let settings = null;
    let getUserPreference = null;
    let UserPresence = null;

    // Load modules asynchronously without blocking
    const loadModule = async (modulePath, moduleName, setter, propertyName) => {
      try {
        const module = await tryRequire(modulePath);
        const value = propertyName ? module[propertyName] : module;
        setter(value);
        console.log(`[Rocket.Chat Desktop] ${moduleName} module loaded successfully`);
      } catch (error) {
        console.log(`[Rocket.Chat Desktop] Failed to load ${moduleName} module:`, error);
      }
    };

    // Start loading all modules in parallel (non-blocking)
    loadModule('meteor/meteor', 'Meteor', value => {
      Meteor = value.Meteor;
    });
    loadModule('meteor/session', 'Session', value => {
      Session = value.Session;
    });
    loadModule('meteor/tracker', 'Tracker', value => {
      Tracker = value.Tracker;
    });
    loadModule(settingsModulePath, 'Settings', value => {
      settings = value.settings;
    });
    loadModule(utilsModulePath, 'Utils', value => {
      getUserPreference = value.getUserPreference;
    });
    loadModule(userPresenceModulePath, 'UserPresence', value => {
      UserPresence = value.UserPresence;
    });

    // Initialize non-module dependent features immediately
    navigator.clipboard.writeText = async (...args) => window.RocketChatDesktop.writeTextToClipboard(...args);
    console.log('[Rocket.Chat Desktop] Injected.ts replaced Notification');
    window.Notification = (_destroy = /*#__PURE__*/new WeakMap(), _onclick = /*#__PURE__*/new WeakMap(), _onclose = /*#__PURE__*/new WeakMap(), _onerror = /*#__PURE__*/new WeakMap(), _onshow = /*#__PURE__*/new WeakMap(), _onaction = /*#__PURE__*/new WeakMap(), (_class = class RocketChatDesktopNotification extends EventTarget {
      static requestPermission() {
        return Promise.resolve(RocketChatDesktopNotification.permission);
      }
      constructor(title, options = {}) {
        super();
        _classPrivateFieldInitSpec(this, _destroy, {
          writable: true,
          value: void 0
        });
        _defineProperty(this, "actions", []);
        _defineProperty(this, "badge", '');
        _defineProperty(this, "body", '');
        _defineProperty(this, "data", undefined);
        _defineProperty(this, "dir", 'auto');
        _defineProperty(this, "icon", '');
        _defineProperty(this, "image", '');
        _defineProperty(this, "lang", document.documentElement.lang);
        _classPrivateFieldInitSpec(this, _onclick, {
          writable: true,
          value: null
        });
        _classPrivateFieldInitSpec(this, _onclose, {
          writable: true,
          value: null
        });
        _classPrivateFieldInitSpec(this, _onerror, {
          writable: true,
          value: null
        });
        _classPrivateFieldInitSpec(this, _onshow, {
          writable: true,
          value: null
        });
        _classPrivateFieldInitSpec(this, _onaction, {
          writable: true,
          value: null
        });
        _defineProperty(this, "requireInteraction", false);
        _defineProperty(this, "silent", false);
        _defineProperty(this, "tag", '');
        _defineProperty(this, "timestamp", Date.now());
        _defineProperty(this, "title", '');
        _defineProperty(this, "vibrate", []);
        _defineProperty(this, "handleEvent", ({
          type,
          detail
        }) => {
          const mainWorldEvent = new CustomEvent(type, {
            detail
          });
          const isReplyEvent = (type, detail) => type === 'reply' && typeof detail === 'object' && detail !== null && 'reply' in detail && typeof detail.reply === 'string';
          if (isReplyEvent(type, detail)) {
            mainWorldEvent.response = detail.reply;
          }
          this.dispatchEvent(mainWorldEvent);
        });
        _classPrivateFieldSet(this, _destroy, window.RocketChatDesktop.createNotification({
          title,
          ...options,
          onEvent: this.handleEvent
        }).then(id => () => {
          window.RocketChatDesktop.destroyNotification(id);
        }));
        Object.assign(this, {
          title,
          ...options
        });
      }
      get onclick() {
        return _classPrivateFieldGet(this, _onclick);
      }
      set onclick(value) {
        if (_classPrivateFieldGet(this, _onclick)) {
          this.removeEventListener('click', _classPrivateFieldGet(this, _onclick));
        }
        _classPrivateFieldSet(this, _onclick, value);
        if (_classPrivateFieldGet(this, _onclick)) {
          this.addEventListener('click', _classPrivateFieldGet(this, _onclick));
        }
      }
      get onclose() {
        return _classPrivateFieldGet(this, _onclose);
      }
      set onclose(value) {
        if (_classPrivateFieldGet(this, _onclose)) {
          this.removeEventListener('close', _classPrivateFieldGet(this, _onclose));
        }
        _classPrivateFieldSet(this, _onclose, value);
        if (_classPrivateFieldGet(this, _onclose)) {
          this.addEventListener('close', _classPrivateFieldGet(this, _onclose));
        }
      }
      get onerror() {
        return _classPrivateFieldGet(this, _onerror);
      }
      set onerror(value) {
        if (_classPrivateFieldGet(this, _onerror)) {
          this.removeEventListener('error', _classPrivateFieldGet(this, _onerror));
        }
        _classPrivateFieldSet(this, _onerror, value);
        if (_classPrivateFieldGet(this, _onerror)) {
          this.addEventListener('error', _classPrivateFieldGet(this, _onerror));
        }
      }
      get onshow() {
        return _classPrivateFieldGet(this, _onshow);
      }
      set onshow(value) {
        if (_classPrivateFieldGet(this, _onshow)) {
          this.removeEventListener('show', _classPrivateFieldGet(this, _onshow));
        }
        _classPrivateFieldSet(this, _onshow, value);
        if (_classPrivateFieldGet(this, _onshow)) {
          this.addEventListener('show', _classPrivateFieldGet(this, _onshow));
        }
      }
      get onaction() {
        return _classPrivateFieldGet(this, _onaction);
      }
      set onaction(value) {
        if (_classPrivateFieldGet(this, _onaction)) {
          this.removeEventListener('action', _classPrivateFieldGet(this, _onaction));
        }
        _classPrivateFieldSet(this, _onaction, value);
        if (_classPrivateFieldGet(this, _onaction)) {
          this.addEventListener('action', _classPrivateFieldGet(this, _onaction));
        }
      }
      close() {
        var _classPrivateFieldGet2;
        if (!_classPrivateFieldGet(this, _destroy)) {
          return;
        }
        (_classPrivateFieldGet2 = _classPrivateFieldGet(this, _destroy)) === null || _classPrivateFieldGet2 === void 0 || _classPrivateFieldGet2.then(destroy => {
          _classPrivateFieldSet(this, _destroy, undefined);
          destroy();
        });
      }
    }, _defineProperty(_class, "permission", 'granted'), _defineProperty(_class, "maxActions", process.platform === 'darwin' ? Number.MAX_SAFE_INTEGER : 0), _class));

    // Track which features have been setup to avoid duplicates
    const setupFlags = {
      urlResolver: false,
      badgeUpdates: false,
      faviconUpdates: false,
      jitsiIntegration: false,
      backgroundSettings: false,
      outlookIntegration: false,
      titleUpdates: false,
      userLoginDetection: false,
      gitCommitHash: false,
      themeAppearance: false,
      userPresence: false
    };

    // Setup reactive features that depend on modules (with polling)
    // eslint-disable-next-line complexity
    const setupReactiveFeatures = () => {
      var _Meteor;
      if ((_Meteor = Meteor) !== null && _Meteor !== void 0 && _Meteor.absoluteUrl && !setupFlags.urlResolver) {
        window.RocketChatDesktop.setUrlResolver(Meteor.absoluteUrl);
        setupFlags.urlResolver = true;
      }
      if (Tracker && Session && !setupFlags.badgeUpdates) {
        Tracker.autorun(() => {
          const unread = Session.get('unread');
          window.RocketChatDesktop.setBadge(unread);
        });
        setupFlags.badgeUpdates = true;
      }
      if (Tracker && settings && !setupFlags.faviconUpdates) {
        Tracker.autorun(() => {
          const {
            url,
            defaultUrl
          } = settings.get('Assets_favicon') || {};
          window.RocketChatDesktop.setFavicon(url || defaultUrl);
        });
        setupFlags.faviconUpdates = true;
      }
      if (Tracker && settings && !setupFlags.jitsiIntegration) {
        const open = window.open.bind(window);
        Tracker.autorun(() => {
          const serverMainVersion = serverInfo.version.split('.')[0];

          // Server version above 5.0.0 will change the way the jitsi integration is handled, now we have video provider as an app
          // if the server is above 5.1.1 it will use window.RocketChatDesktop?.openInternalVideoChatWindow to open the video call
          if (serverMainVersion < 5) {
            const jitsiDomain = settings.get('Jitsi_Domain') || '';
            console.log('[Rocket.Chat Desktop] window.open for Jitsi overloaded', jitsiDomain);
            window.open = (url, name, features = '') => {
              if (!process.mas && window.RocketChatDesktop.getInternalVideoChatWindowEnabled() && typeof url === 'string' && jitsiDomain.length > 0 && url.includes(jitsiDomain)) {
                console.log('[Rocket.Chat Desktop] window.open for Jitsi fired');
                return open(url, 'Video Call', `scrollbars=true,${features}`);
              }
              return open(url, name, features);
            };
          }
        });
        setupFlags.jitsiIntegration = true;
      }
      if (!versionIsGreaterOrEqualsTo(serverInfo.version, '6.4.0') && Tracker && settings && !setupFlags.backgroundSettings) {
        Tracker.autorun(() => {
          const {
            url,
            defaultUrl
          } = settings.get('Assets_background') || {};
          window.RocketChatDesktop.setBackground(url || defaultUrl);
        });
        setupFlags.backgroundSettings = true;
      }

      // Helper function to get Outlook settings based on server version
      const getOutlookSettings = () => {
        var _Meteor$_localStorage, _Meteor$user, _Meteor3, _user$settings;
        if (!Meteor || !settings) return {};
        const userToken = (_Meteor$_localStorage = Meteor._localStorage) === null || _Meteor$_localStorage === void 0 ? void 0 : _Meteor$_localStorage.getItem('Meteor.loginToken');
        if (!versionIsGreaterOrEqualsTo(serverInfo.version, '7.8.0')) {
          var _Meteor$userId, _Meteor2;
          // Pre-7.8.0: Use global server settings
          return {
            userToken,
            userId: (_Meteor$userId = (_Meteor2 = Meteor).userId) === null || _Meteor$userId === void 0 ? void 0 : _Meteor$userId.call(_Meteor2),
            outlookCalendarEnabled: settings.get('Outlook_Calendar_Enabled'),
            outlookExchangeUrl: settings.get('Outlook_Calendar_Exchange_Url')
          };
        }
        // 7.8.0+: Use user-specific settings
        const user = (_Meteor$user = (_Meteor3 = Meteor).user) === null || _Meteor$user === void 0 ? void 0 : _Meteor$user.call(_Meteor3);
        const outlookSettings = user === null || user === void 0 || (_user$settings = user.settings) === null || _user$settings === void 0 || (_user$settings = _user$settings.calendar) === null || _user$settings === void 0 ? void 0 : _user$settings.outlook;
        return {
          userToken,
          userId: user === null || user === void 0 ? void 0 : user._id,
          outlookCalendarEnabled: outlookSettings === null || outlookSettings === void 0 ? void 0 : outlookSettings.Enabled,
          outlookExchangeUrl: outlookSettings === null || outlookSettings === void 0 ? void 0 : outlookSettings.Exchange_Url
        };
      };
      if (Tracker && !setupFlags.outlookIntegration) {
        Tracker.autorun(() => {
          const {
            userToken,
            userId,
            outlookCalendarEnabled,
            outlookExchangeUrl
          } = getOutlookSettings();
          if (!userToken || !userId || !outlookCalendarEnabled || !outlookExchangeUrl) {
            return;
          }
          window.RocketChatDesktop.setUserToken(userToken, userId);
          window.RocketChatDesktop.setOutlookExchangeUrl(outlookExchangeUrl, userId);
        });
        setupFlags.outlookIntegration = true;
      }
      if (Tracker && settings && !setupFlags.titleUpdates) {
        Tracker.autorun(() => {
          const siteName = settings.get('Site_Name');
          window.RocketChatDesktop.setTitle(siteName);
        });
        setupFlags.titleUpdates = true;
      }
      if (Tracker && Meteor && !setupFlags.userLoginDetection) {
        Tracker.autorun(() => {
          const userId = Meteor.userId();
          window.RocketChatDesktop.setUserLoggedIn(userId !== null);
        });
        setupFlags.userLoginDetection = true;
      }
      if (Tracker && Meteor && !setupFlags.gitCommitHash) {
        Tracker.autorun(() => {
          const {
            gitCommitHash
          } = Meteor;
          if (!gitCommitHash) return;
          window.RocketChatDesktop.setGitCommitHash(gitCommitHash);
        });
        setupFlags.gitCommitHash = true;
      }
      if (Tracker && Meteor && getUserPreference && !setupFlags.themeAppearance) {
        Tracker.autorun(() => {
          const uid = Meteor.userId();
          if (!uid) return;
          const themeAppearance = getUserPreference(uid, 'themeAppearence');
          if (['dark', 'light', 'auto', 'high-contrast'].includes(themeAppearance)) {
            window.RocketChatDesktop.setUserThemeAppearance(themeAppearance);
          }
        });
        setupFlags.themeAppearance = true;
      }
      if (Tracker && Meteor && getUserPreference && !setupFlags.userPresence) {
        Tracker.autorun(() => {
          const uid = Meteor.userId();
          if (!uid) return;
          const isAutoAwayEnabled = getUserPreference(uid, 'enableAutoAway');
          const idleThreshold = getUserPreference(uid, 'idleTimeLimit');
          if (isAutoAwayEnabled && UserPresence) {
            delete UserPresence.awayTime;
            UserPresence.start();
          }
          window.RocketChatDesktop.setUserPresenceDetection({
            isAutoAwayEnabled: Boolean(isAutoAwayEnabled),
            idleThreshold: idleThreshold ? Number(idleThreshold) : null,
            setUserOnline: online => {
              if (!online && Meteor.call) {
                Meteor.call('UserPresence:away');
                return;
              }
              if (Meteor.call) {
                Meteor.call('UserPresence:online');
              }
            }
          });
        });
        setupFlags.userPresence = true;
      }
    };

    // Call setupReactiveFeatures immediately and then periodically check for new modules
    setupReactiveFeatures();
    setInterval(setupReactiveFeatures, 1000); // Check every second for newly loaded modules

    console.log('[Rocket.Chat Desktop] Injected');
  };
  start();

})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5qZWN0ZWQuanMiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbmplY3RlZC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgdHlwZSB7IE5vdGlmaWNhdGlvbkFjdGlvbiB9IGZyb20gJ2VsZWN0cm9uJztcblxuY29uc29sZS5sb2coJ1tSb2NrZXQuQ2hhdCBEZXNrdG9wXSBJbmplY3RlZC50cycpO1xuXG5jb25zdCByZXNvbHZlV2l0aEV4cG9uZW50aWFsQmFja29mZiA9IDxUPihcbiAgZm46ICgpID0+IFByb21pc2U8VD4sXG4gIHsgbWF4UmV0cmllcyA9IDUsIGRlbGF5ID0gMTAwMCB9ID0ge31cbikgPT5cbiAgbmV3IFByb21pc2U8VD4oKHJlc29sdmUpID0+IHJlc29sdmUoZm4oKSkpLmNhdGNoKChlcnJvcikgPT4ge1xuICAgIGlmIChtYXhSZXRyaWVzID09PSAwKSB7XG4gICAgICB0aHJvdyBlcnJvcjtcbiAgICB9XG4gICAgY29uc29sZS5sb2coXG4gICAgICAnW1JvY2tldC5DaGF0IERlc2t0b3BdIEluamVjdCByZXNvbHZlV2l0aEV4cG9uZW50aWFsQmFja29mZiAtIHJldHJ5aW5nIGluIDEgc2Vjb25kcydcbiAgICApO1xuICAgIHJldHVybiBuZXcgUHJvbWlzZTxUPigocmVzb2x2ZSkgPT4ge1xuICAgICAgc2V0VGltZW91dCgoKSA9PiB7XG4gICAgICAgIHJlc29sdmUoXG4gICAgICAgICAgcmVzb2x2ZVdpdGhFeHBvbmVudGlhbEJhY2tvZmYoZm4sIHtcbiAgICAgICAgICAgIG1heFJldHJpZXM6IG1heFJldHJpZXMgLSAxLFxuICAgICAgICAgICAgZGVsYXk6IGRlbGF5ICogMixcbiAgICAgICAgICB9KVxuICAgICAgICApO1xuICAgICAgfSwgZGVsYXkpO1xuICAgIH0pO1xuICB9KTtcblxuY29uc3QgdHJ5UmVxdWlyZSA9IDxUID0gYW55PihwYXRoOiBzdHJpbmcpID0+XG4gIHJlc29sdmVXaXRoRXhwb25lbnRpYWxCYWNrb2ZmPFQ+KCgpID0+IHdpbmRvdy5yZXF1aXJlKHBhdGgpKTtcblxubGV0IHN0YXJ0UmV0cnlDb3VudCA9IDA7XG5sZXQgdG90YWxSZXRyeVRpbWUgPSAwO1xuY29uc3QgTUFYX1JFVFJZX1RJTUUgPSAzMDAwMDsgLy8gTWF4aW11bSAzMCBzZWNvbmRzIHRvdGFsIHJldHJ5IHRpbWVcbmNvbnN0IElOSVRJQUxfUkVUUllfREVMQVkgPSAxMDAwOyAvLyBTdGFydCB3aXRoIDEgc2Vjb25kXG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBjb21wbGV4aXR5XG5jb25zdCBzdGFydCA9IGFzeW5jICgpID0+IHtcbiAgY29uc29sZS5sb2coJ1tSb2NrZXQuQ2hhdCBEZXNrdG9wXSBJbmplY3RlZC50cyBzdGFydCBmaXJlZCcpO1xuICBpZiAodHlwZW9mIHdpbmRvdy5yZXF1aXJlICE9PSAnZnVuY3Rpb24nKSB7XG4gICAgY29uc29sZS5sb2coJ1tSb2NrZXQuQ2hhdCBEZXNrdG9wXSB3aW5kb3cucmVxdWlyZSBpcyBub3QgZGVmaW5lZCcpO1xuXG4gICAgaWYgKHRvdGFsUmV0cnlUaW1lID49IE1BWF9SRVRSWV9USU1FKSB7XG4gICAgICBjb25zb2xlLmVycm9yKFxuICAgICAgICBgW1JvY2tldC5DaGF0IERlc2t0b3BdIE1heGltdW0gcmV0cnkgdGltZSAoJHtNQVhfUkVUUllfVElNRX1tcykgcmVhY2hlZC4gd2luZG93LnJlcXVpcmUgaXMgc3RpbGwgbm90IGF2YWlsYWJsZS5gXG4gICAgICApO1xuICAgICAgY29uc29sZS5sb2coXG4gICAgICAgICdbUm9ja2V0LkNoYXQgRGVza3RvcF0gVHJpZ2dlcmluZyBmb3JjZSByZWxvYWQgd2l0aCBjYWNoZSBjbGVhciB0byByZWNvdmVyLi4uJ1xuICAgICAgKTtcbiAgICAgIC8vIFRyaWdnZXIgZm9yY2UgcmVsb2FkIHdpdGggY2FjaGUgY2xlYXIgdG8gcmVjb3ZlclxuICAgICAgd2luZG93LlJvY2tldENoYXREZXNrdG9wLnJlbG9hZFNlcnZlcigpO1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIHN0YXJ0UmV0cnlDb3VudCsrO1xuICAgIGNvbnN0IHJldHJ5RGVsYXkgPSBNYXRoLm1pbihcbiAgICAgIElOSVRJQUxfUkVUUllfREVMQVkgKiBNYXRoLnBvdygxLjUsIHN0YXJ0UmV0cnlDb3VudCAtIDEpLFxuICAgICAgNTAwMFxuICAgICk7IC8vIENhcCBhdCA1IHNlY29uZHMgcGVyIHJldHJ5XG5cbiAgICAvLyBFbnN1cmUgd2UgZG9uJ3QgZXhjZWVkIG1heCB0b3RhbCB0aW1lXG4gICAgY29uc3QgYWN0dWFsRGVsYXkgPSBNYXRoLm1pbihyZXRyeURlbGF5LCBNQVhfUkVUUllfVElNRSAtIHRvdGFsUmV0cnlUaW1lKTtcbiAgICB0b3RhbFJldHJ5VGltZSArPSBhY3R1YWxEZWxheTtcblxuICAgIGNvbnNvbGUubG9nKFxuICAgICAgYFtSb2NrZXQuQ2hhdCBEZXNrdG9wXSBJbmplY3Qgc3RhcnQgLSByZXRyeSAke3N0YXJ0UmV0cnlDb3VudH0gaW4gJHthY3R1YWxEZWxheX1tcyAodG90YWwgdGltZTogJHt0b3RhbFJldHJ5VGltZX1tcylgXG4gICAgKTtcbiAgICBzZXRUaW1lb3V0KHN0YXJ0LCBhY3R1YWxEZWxheSk7XG4gICAgcmV0dXJuO1xuICB9XG5cbiAgLy8gUmVzZXQgcmV0cnkgY291bnRlcnMgb24gc3VjY2Vzc2Z1bCByZXF1aXJlIGRldGVjdGlvblxuICBzdGFydFJldHJ5Q291bnQgPSAwO1xuICB0b3RhbFJldHJ5VGltZSA9IDA7XG5cbiAgY29uc3QgeyBJbmZvOiBzZXJ2ZXJJbmZvID0ge30gfSA9IGF3YWl0IHRyeVJlcXVpcmUoXG4gICAgJy9hcHAvdXRpbHMvcm9ja2V0Y2hhdC5pbmZvJ1xuICApO1xuXG4gIGlmICghc2VydmVySW5mby52ZXJzaW9uKSB7XG4gICAgY29uc29sZS5sb2coJ1tSb2NrZXQuQ2hhdCBEZXNrdG9wXSBzZXJ2ZXJJbmZvLnZlcnNpb24gaXMgbm90IGRlZmluZWQnKTtcbiAgICByZXR1cm47XG4gIH1cblxuICBjb25zb2xlLmxvZygnW1JvY2tldC5DaGF0IERlc2t0b3BdIEluamVjdGVkLnRzIHNlcnZlckluZm8nLCBzZXJ2ZXJJbmZvKTtcblxuICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0U2VydmVySW5mbyhzZXJ2ZXJJbmZvKTtcblxuICBmdW5jdGlvbiB2ZXJzaW9uSXNHcmVhdGVyT3JFcXVhbHNUbyhcbiAgICB2ZXJzaW9uMTogc3RyaW5nLFxuICAgIHZlcnNpb24yOiBzdHJpbmdcbiAgKTogYm9vbGVhbiB7XG4gICAgLy8gRXh0cmFjdCBvbmx5IHRoZSBjb3JlIHZlcnNpb24gbnVtYmVyIChiZWZvcmUgYW55IHN1ZmZpeCBsaWtlIC1kZXZlbG9wLCAtcmMsIGV0Yy4pXG4gICAgY29uc3QgY2xlYW5WZXJzaW9uMSA9IHZlcnNpb24xLnNwbGl0KCctJylbMF07XG4gICAgY29uc3QgY2xlYW5WZXJzaW9uMiA9IHZlcnNpb24yLnNwbGl0KCctJylbMF07XG5cbiAgICBjb25zdCB2MSA9IGNsZWFuVmVyc2lvbjEuc3BsaXQoJy4nKS5tYXAoTnVtYmVyKTtcbiAgICBjb25zdCB2MiA9IGNsZWFuVmVyc2lvbjIuc3BsaXQoJy4nKS5tYXAoTnVtYmVyKTtcblxuICAgIC8vIENvbXBhcmUgZWFjaCB2ZXJzaW9uIHBhcnRcbiAgICBjb25zdCBtYXhMZW5ndGggPSBNYXRoLm1heCh2MS5sZW5ndGgsIHYyLmxlbmd0aCk7XG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCBtYXhMZW5ndGg7IGkrKykge1xuICAgICAgY29uc3QgbjEgPSB2MVtpXSB8fCAwO1xuICAgICAgY29uc3QgbjIgPSB2MltpXSB8fCAwO1xuXG4gICAgICBpZiAobjEgPiBuMikge1xuICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgIH1cbiAgICAgIGlmIChuMSA8IG4yKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gdHJ1ZTsgLy8gRXF1YWwgdmVyc2lvbnNcbiAgfVxuXG4gIGNvbnN0IHVzZXJQcmVzZW5jZU1vZHVsZVBhdGggPSB2ZXJzaW9uSXNHcmVhdGVyT3JFcXVhbHNUbyhcbiAgICBzZXJ2ZXJJbmZvLnZlcnNpb24sXG4gICAgJzYuMy4wJ1xuICApXG4gICAgPyAnbWV0ZW9yL3JvY2tldGNoYXQ6dXNlci1wcmVzZW5jZSdcbiAgICA6ICdtZXRlb3Iva29uZWN0eTp1c2VyLXByZXNlbmNlJztcblxuICBjb25zdCBzZXR0aW5nc01vZHVsZVBhdGggPSAoKCkgPT4ge1xuICAgIC8vIGlmICh2ZXJzaW9uSXNHcmVhdGVyT3JFcXVhbHNUbyhzZXJ2ZXJJbmZvLnZlcnNpb24sICc2LjAuMCcpKVxuICAgIC8vICAgcmV0dXJuICcvYXBwL3NldHRpbmdzL2NsaWVudCc7XG4gICAgaWYgKHZlcnNpb25Jc0dyZWF0ZXJPckVxdWFsc1RvKHNlcnZlckluZm8udmVyc2lvbiwgJzUuMC4wJykpXG4gICAgICByZXR1cm4gJy9hcHAvc2V0dGluZ3MvY2xpZW50L2luZGV4LnRzJztcbiAgICByZXR1cm4gJy9hcHAvc2V0dGluZ3MnO1xuICB9KSgpO1xuXG4gIGNvbnN0IHV0aWxzTW9kdWxlUGF0aCA9ICgoKSA9PiB7XG4gICAgLy8gaWYgKHZlcnNpb25Jc0dyZWF0ZXJPckVxdWFsc1RvKHNlcnZlckluZm8udmVyc2lvbiwgJzYuMC4wJykpXG4gICAgLy8gICByZXR1cm4gJy9hcHAvdXRpbHMvY2xpZW50JztcbiAgICBpZiAodmVyc2lvbklzR3JlYXRlck9yRXF1YWxzVG8oc2VydmVySW5mby52ZXJzaW9uLCAnNS4wLjAnKSlcbiAgICAgIHJldHVybiAnL2FwcC91dGlscy9jbGllbnQvaW5kZXgudHMnO1xuICAgIHJldHVybiAnL2FwcC91dGlscyc7XG4gIH0pKCk7XG5cbiAgLy8gTG9hZCBjb3JlIG1vZHVsZXMgd2l0aCBpbmRpdmlkdWFsIGVycm9yIGhhbmRsaW5nIChub24tYmxvY2tpbmcpXG4gIGxldCBNZXRlb3I6IGFueSA9IG51bGw7XG4gIGxldCBTZXNzaW9uOiBhbnkgPSBudWxsO1xuICBsZXQgVHJhY2tlcjogYW55ID0gbnVsbDtcbiAgbGV0IHNldHRpbmdzOiBhbnkgPSBudWxsO1xuICBsZXQgZ2V0VXNlclByZWZlcmVuY2U6IGFueSA9IG51bGw7XG4gIGxldCBVc2VyUHJlc2VuY2U6IGFueSA9IG51bGw7XG5cbiAgLy8gTG9hZCBtb2R1bGVzIGFzeW5jaHJvbm91c2x5IHdpdGhvdXQgYmxvY2tpbmdcbiAgY29uc3QgbG9hZE1vZHVsZSA9IGFzeW5jIChcbiAgICBtb2R1bGVQYXRoOiBzdHJpbmcsXG4gICAgbW9kdWxlTmFtZTogc3RyaW5nLFxuICAgIHNldHRlcjogKHZhbHVlOiBhbnkpID0+IHZvaWQsXG4gICAgcHJvcGVydHlOYW1lPzogc3RyaW5nXG4gICkgPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCBtb2R1bGUgPSBhd2FpdCB0cnlSZXF1aXJlKG1vZHVsZVBhdGgpO1xuICAgICAgY29uc3QgdmFsdWUgPSBwcm9wZXJ0eU5hbWUgPyBtb2R1bGVbcHJvcGVydHlOYW1lXSA6IG1vZHVsZTtcbiAgICAgIHNldHRlcih2YWx1ZSk7XG4gICAgICBjb25zb2xlLmxvZyhcbiAgICAgICAgYFtSb2NrZXQuQ2hhdCBEZXNrdG9wXSAke21vZHVsZU5hbWV9IG1vZHVsZSBsb2FkZWQgc3VjY2Vzc2Z1bGx5YFxuICAgICAgKTtcbiAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgY29uc29sZS5sb2coXG4gICAgICAgIGBbUm9ja2V0LkNoYXQgRGVza3RvcF0gRmFpbGVkIHRvIGxvYWQgJHttb2R1bGVOYW1lfSBtb2R1bGU6YCxcbiAgICAgICAgZXJyb3JcbiAgICAgICk7XG4gICAgfVxuICB9O1xuXG4gIC8vIFN0YXJ0IGxvYWRpbmcgYWxsIG1vZHVsZXMgaW4gcGFyYWxsZWwgKG5vbi1ibG9ja2luZylcbiAgbG9hZE1vZHVsZSgnbWV0ZW9yL21ldGVvcicsICdNZXRlb3InLCAodmFsdWUpID0+IHtcbiAgICBNZXRlb3IgPSB2YWx1ZS5NZXRlb3I7XG4gIH0pO1xuICBsb2FkTW9kdWxlKCdtZXRlb3Ivc2Vzc2lvbicsICdTZXNzaW9uJywgKHZhbHVlKSA9PiB7XG4gICAgU2Vzc2lvbiA9IHZhbHVlLlNlc3Npb247XG4gIH0pO1xuICBsb2FkTW9kdWxlKCdtZXRlb3IvdHJhY2tlcicsICdUcmFja2VyJywgKHZhbHVlKSA9PiB7XG4gICAgVHJhY2tlciA9IHZhbHVlLlRyYWNrZXI7XG4gIH0pO1xuICBsb2FkTW9kdWxlKHNldHRpbmdzTW9kdWxlUGF0aCwgJ1NldHRpbmdzJywgKHZhbHVlKSA9PiB7XG4gICAgc2V0dGluZ3MgPSB2YWx1ZS5zZXR0aW5ncztcbiAgfSk7XG4gIGxvYWRNb2R1bGUodXRpbHNNb2R1bGVQYXRoLCAnVXRpbHMnLCAodmFsdWUpID0+IHtcbiAgICBnZXRVc2VyUHJlZmVyZW5jZSA9IHZhbHVlLmdldFVzZXJQcmVmZXJlbmNlO1xuICB9KTtcbiAgbG9hZE1vZHVsZSh1c2VyUHJlc2VuY2VNb2R1bGVQYXRoLCAnVXNlclByZXNlbmNlJywgKHZhbHVlKSA9PiB7XG4gICAgVXNlclByZXNlbmNlID0gdmFsdWUuVXNlclByZXNlbmNlO1xuICB9KTtcblxuICAvLyBJbml0aWFsaXplIG5vbi1tb2R1bGUgZGVwZW5kZW50IGZlYXR1cmVzIGltbWVkaWF0ZWx5XG4gIG5hdmlnYXRvci5jbGlwYm9hcmQud3JpdGVUZXh0ID0gYXN5bmMgKC4uLmFyZ3MpID0+XG4gICAgd2luZG93LlJvY2tldENoYXREZXNrdG9wLndyaXRlVGV4dFRvQ2xpcGJvYXJkKC4uLmFyZ3MpO1xuXG4gIGNvbnNvbGUubG9nKCdbUm9ja2V0LkNoYXQgRGVza3RvcF0gSW5qZWN0ZWQudHMgcmVwbGFjZWQgTm90aWZpY2F0aW9uJyk7XG5cbiAgd2luZG93Lk5vdGlmaWNhdGlvbiA9IGNsYXNzIFJvY2tldENoYXREZXNrdG9wTm90aWZpY2F0aW9uXG4gICAgZXh0ZW5kcyBFdmVudFRhcmdldFxuICAgIGltcGxlbWVudHMgTm90aWZpY2F0aW9uXG4gIHtcbiAgICBzdGF0aWMgcmVhZG9ubHkgcGVybWlzc2lvbjogTm90aWZpY2F0aW9uUGVybWlzc2lvbiA9ICdncmFudGVkJztcblxuICAgIHN0YXRpYyByZWFkb25seSBtYXhBY3Rpb25zOiBudW1iZXIgPVxuICAgICAgcHJvY2Vzcy5wbGF0Zm9ybSA9PT0gJ2RhcndpbicgPyBOdW1iZXIuTUFYX1NBRkVfSU5URUdFUiA6IDA7XG5cbiAgICBzdGF0aWMgcmVxdWVzdFBlcm1pc3Npb24oKTogUHJvbWlzZTxOb3RpZmljYXRpb25QZXJtaXNzaW9uPiB7XG4gICAgICByZXR1cm4gUHJvbWlzZS5yZXNvbHZlKFJvY2tldENoYXREZXNrdG9wTm90aWZpY2F0aW9uLnBlcm1pc3Npb24pO1xuICAgIH1cblxuICAgICNkZXN0cm95PzogUHJvbWlzZTwoKSA9PiB2b2lkPjtcblxuICAgIGNvbnN0cnVjdG9yKFxuICAgICAgdGl0bGU6IHN0cmluZyxcbiAgICAgIG9wdGlvbnM6IE5vdGlmaWNhdGlvbk9wdGlvbnMgJiB7IGNhblJlcGx5PzogYm9vbGVhbiB9ID0ge31cbiAgICApIHtcbiAgICAgIHN1cGVyKCk7XG5cbiAgICAgIHRoaXMuI2Rlc3Ryb3kgPSB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3AuY3JlYXRlTm90aWZpY2F0aW9uKHtcbiAgICAgICAgdGl0bGUsXG4gICAgICAgIC4uLm9wdGlvbnMsXG4gICAgICAgIG9uRXZlbnQ6IHRoaXMuaGFuZGxlRXZlbnQsXG4gICAgICB9KS50aGVuKChpZCkgPT4gKCkgPT4ge1xuICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3AuZGVzdHJveU5vdGlmaWNhdGlvbihpZCk7XG4gICAgICB9KTtcblxuICAgICAgT2JqZWN0LmFzc2lnbih0aGlzLCB7IHRpdGxlLCAuLi5vcHRpb25zIH0pO1xuICAgIH1cblxuICAgIGFjdGlvbnM6IHJlYWRvbmx5IE5vdGlmaWNhdGlvbkFjdGlvbltdID0gW107XG5cbiAgICBiYWRnZSA9ICcnO1xuXG4gICAgYm9keSA9ICcnO1xuXG4gICAgZGF0YTogYW55ID0gdW5kZWZpbmVkO1xuXG4gICAgZGlyOiBOb3RpZmljYXRpb25EaXJlY3Rpb24gPSAnYXV0byc7XG5cbiAgICBpY29uID0gJyc7XG5cbiAgICBpbWFnZSA9ICcnO1xuXG4gICAgbGFuZyA9IGRvY3VtZW50LmRvY3VtZW50RWxlbWVudC5sYW5nO1xuXG4gICAgI29uY2xpY2s6ICgodGhpczogTm90aWZpY2F0aW9uLCBldjogRXZlbnQpID0+IGFueSkgfCBudWxsID0gbnVsbDtcblxuICAgIGdldCBvbmNsaWNrKCkge1xuICAgICAgcmV0dXJuIHRoaXMuI29uY2xpY2s7XG4gICAgfVxuXG4gICAgc2V0IG9uY2xpY2sodmFsdWUpIHtcbiAgICAgIGlmICh0aGlzLiNvbmNsaWNrKSB7XG4gICAgICAgIHRoaXMucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xpY2snLCB0aGlzLiNvbmNsaWNrKTtcbiAgICAgIH1cblxuICAgICAgdGhpcy4jb25jbGljayA9IHZhbHVlO1xuXG4gICAgICBpZiAodGhpcy4jb25jbGljaykge1xuICAgICAgICB0aGlzLmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgdGhpcy4jb25jbGljayk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgI29uY2xvc2U6ICgodGhpczogTm90aWZpY2F0aW9uLCBldjogRXZlbnQpID0+IGFueSkgfCBudWxsID0gbnVsbDtcblxuICAgIGdldCBvbmNsb3NlKCkge1xuICAgICAgcmV0dXJuIHRoaXMuI29uY2xvc2U7XG4gICAgfVxuXG4gICAgc2V0IG9uY2xvc2UodmFsdWUpIHtcbiAgICAgIGlmICh0aGlzLiNvbmNsb3NlKSB7XG4gICAgICAgIHRoaXMucmVtb3ZlRXZlbnRMaXN0ZW5lcignY2xvc2UnLCB0aGlzLiNvbmNsb3NlKTtcbiAgICAgIH1cblxuICAgICAgdGhpcy4jb25jbG9zZSA9IHZhbHVlO1xuXG4gICAgICBpZiAodGhpcy4jb25jbG9zZSkge1xuICAgICAgICB0aGlzLmFkZEV2ZW50TGlzdGVuZXIoJ2Nsb3NlJywgdGhpcy4jb25jbG9zZSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgI29uZXJyb3I6ICgodGhpczogTm90aWZpY2F0aW9uLCBldjogRXZlbnQpID0+IGFueSkgfCBudWxsID0gbnVsbDtcblxuICAgIGdldCBvbmVycm9yKCkge1xuICAgICAgcmV0dXJuIHRoaXMuI29uZXJyb3I7XG4gICAgfVxuXG4gICAgc2V0IG9uZXJyb3IodmFsdWUpIHtcbiAgICAgIGlmICh0aGlzLiNvbmVycm9yKSB7XG4gICAgICAgIHRoaXMucmVtb3ZlRXZlbnRMaXN0ZW5lcignZXJyb3InLCB0aGlzLiNvbmVycm9yKTtcbiAgICAgIH1cblxuICAgICAgdGhpcy4jb25lcnJvciA9IHZhbHVlO1xuXG4gICAgICBpZiAodGhpcy4jb25lcnJvcikge1xuICAgICAgICB0aGlzLmFkZEV2ZW50TGlzdGVuZXIoJ2Vycm9yJywgdGhpcy4jb25lcnJvcik7XG4gICAgICB9XG4gICAgfVxuXG4gICAgI29uc2hvdzogKCh0aGlzOiBOb3RpZmljYXRpb24sIGV2OiBFdmVudCkgPT4gYW55KSB8IG51bGwgPSBudWxsO1xuXG4gICAgZ2V0IG9uc2hvdygpIHtcbiAgICAgIHJldHVybiB0aGlzLiNvbnNob3c7XG4gICAgfVxuXG4gICAgc2V0IG9uc2hvdyh2YWx1ZSkge1xuICAgICAgaWYgKHRoaXMuI29uc2hvdykge1xuICAgICAgICB0aGlzLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ3Nob3cnLCB0aGlzLiNvbnNob3cpO1xuICAgICAgfVxuXG4gICAgICB0aGlzLiNvbnNob3cgPSB2YWx1ZTtcblxuICAgICAgaWYgKHRoaXMuI29uc2hvdykge1xuICAgICAgICB0aGlzLmFkZEV2ZW50TGlzdGVuZXIoJ3Nob3cnLCB0aGlzLiNvbnNob3cpO1xuICAgICAgfVxuICAgIH1cblxuICAgICNvbmFjdGlvbjogKCh0aGlzOiBOb3RpZmljYXRpb24sIGV2OiBFdmVudCkgPT4gYW55KSB8IG51bGwgPSBudWxsO1xuXG4gICAgZ2V0IG9uYWN0aW9uKCkge1xuICAgICAgcmV0dXJuIHRoaXMuI29uYWN0aW9uO1xuICAgIH1cblxuICAgIHNldCBvbmFjdGlvbih2YWx1ZSkge1xuICAgICAgaWYgKHRoaXMuI29uYWN0aW9uKSB7XG4gICAgICAgIHRoaXMucmVtb3ZlRXZlbnRMaXN0ZW5lcignYWN0aW9uJywgdGhpcy4jb25hY3Rpb24pO1xuICAgICAgfVxuXG4gICAgICB0aGlzLiNvbmFjdGlvbiA9IHZhbHVlO1xuXG4gICAgICBpZiAodGhpcy4jb25hY3Rpb24pIHtcbiAgICAgICAgdGhpcy5hZGRFdmVudExpc3RlbmVyKCdhY3Rpb24nLCB0aGlzLiNvbmFjdGlvbik7XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmVxdWlyZUludGVyYWN0aW9uID0gZmFsc2U7XG5cbiAgICBzaWxlbnQgPSBmYWxzZTtcblxuICAgIHRhZyA9ICcnO1xuXG4gICAgdGltZXN0YW1wOiBudW1iZXIgPSBEYXRlLm5vdygpO1xuXG4gICAgdGl0bGUgPSAnJztcblxuICAgIHZpYnJhdGU6IHJlYWRvbmx5IG51bWJlcltdID0gW107XG5cbiAgICBwcml2YXRlIGhhbmRsZUV2ZW50ID0gKHtcbiAgICAgIHR5cGUsXG4gICAgICBkZXRhaWwsXG4gICAgfToge1xuICAgICAgdHlwZTogc3RyaW5nO1xuICAgICAgZGV0YWlsOiB1bmtub3duO1xuICAgIH0pOiB2b2lkID0+IHtcbiAgICAgIGNvbnN0IG1haW5Xb3JsZEV2ZW50ID0gbmV3IEN1c3RvbUV2ZW50KHR5cGUsIHsgZGV0YWlsIH0pO1xuXG4gICAgICBjb25zdCBpc1JlcGx5RXZlbnQgPSAoXG4gICAgICAgIHR5cGU6IHN0cmluZyxcbiAgICAgICAgZGV0YWlsOiB1bmtub3duXG4gICAgICApOiBkZXRhaWwgaXMgeyByZXBseTogc3RyaW5nIH0gPT5cbiAgICAgICAgdHlwZSA9PT0gJ3JlcGx5JyAmJlxuICAgICAgICB0eXBlb2YgZGV0YWlsID09PSAnb2JqZWN0JyAmJlxuICAgICAgICBkZXRhaWwgIT09IG51bGwgJiZcbiAgICAgICAgJ3JlcGx5JyBpbiBkZXRhaWwgJiZcbiAgICAgICAgdHlwZW9mIChkZXRhaWwgYXMgeyByZXBseTogc3RyaW5nIH0pLnJlcGx5ID09PSAnc3RyaW5nJztcblxuICAgICAgaWYgKGlzUmVwbHlFdmVudCh0eXBlLCBkZXRhaWwpKSB7XG4gICAgICAgIChtYWluV29ybGRFdmVudCBhcyBhbnkpLnJlc3BvbnNlID0gZGV0YWlsLnJlcGx5O1xuICAgICAgfVxuICAgICAgdGhpcy5kaXNwYXRjaEV2ZW50KG1haW5Xb3JsZEV2ZW50KTtcbiAgICB9O1xuXG4gICAgY2xvc2UoKTogdm9pZCB7XG4gICAgICBpZiAoIXRoaXMuI2Rlc3Ryb3kpIHtcbiAgICAgICAgcmV0dXJuO1xuICAgICAgfVxuXG4gICAgICB0aGlzLiNkZXN0cm95Py50aGVuKChkZXN0cm95KSA9PiB7XG4gICAgICAgIHRoaXMuI2Rlc3Ryb3kgPSB1bmRlZmluZWQ7XG4gICAgICAgIGRlc3Ryb3koKTtcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcblxuICAvLyBUcmFjayB3aGljaCBmZWF0dXJlcyBoYXZlIGJlZW4gc2V0dXAgdG8gYXZvaWQgZHVwbGljYXRlc1xuICBjb25zdCBzZXR1cEZsYWdzID0ge1xuICAgIHVybFJlc29sdmVyOiBmYWxzZSxcbiAgICBiYWRnZVVwZGF0ZXM6IGZhbHNlLFxuICAgIGZhdmljb25VcGRhdGVzOiBmYWxzZSxcbiAgICBqaXRzaUludGVncmF0aW9uOiBmYWxzZSxcbiAgICBiYWNrZ3JvdW5kU2V0dGluZ3M6IGZhbHNlLFxuICAgIG91dGxvb2tJbnRlZ3JhdGlvbjogZmFsc2UsXG4gICAgdGl0bGVVcGRhdGVzOiBmYWxzZSxcbiAgICB1c2VyTG9naW5EZXRlY3Rpb246IGZhbHNlLFxuICAgIGdpdENvbW1pdEhhc2g6IGZhbHNlLFxuICAgIHRoZW1lQXBwZWFyYW5jZTogZmFsc2UsXG4gICAgdXNlclByZXNlbmNlOiBmYWxzZSxcbiAgfTtcblxuICAvLyBTZXR1cCByZWFjdGl2ZSBmZWF0dXJlcyB0aGF0IGRlcGVuZCBvbiBtb2R1bGVzICh3aXRoIHBvbGxpbmcpXG4gIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBjb21wbGV4aXR5XG4gIGNvbnN0IHNldHVwUmVhY3RpdmVGZWF0dXJlcyA9ICgpID0+IHtcbiAgICBpZiAoTWV0ZW9yPy5hYnNvbHV0ZVVybCAmJiAhc2V0dXBGbGFncy51cmxSZXNvbHZlcikge1xuICAgICAgd2luZG93LlJvY2tldENoYXREZXNrdG9wLnNldFVybFJlc29sdmVyKE1ldGVvci5hYnNvbHV0ZVVybCk7XG4gICAgICBzZXR1cEZsYWdzLnVybFJlc29sdmVyID0gdHJ1ZTtcbiAgICB9XG5cbiAgICBpZiAoVHJhY2tlciAmJiBTZXNzaW9uICYmICFzZXR1cEZsYWdzLmJhZGdlVXBkYXRlcykge1xuICAgICAgVHJhY2tlci5hdXRvcnVuKCgpID0+IHtcbiAgICAgICAgY29uc3QgdW5yZWFkID0gU2Vzc2lvbi5nZXQoJ3VucmVhZCcpO1xuICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0QmFkZ2UodW5yZWFkKTtcbiAgICAgIH0pO1xuICAgICAgc2V0dXBGbGFncy5iYWRnZVVwZGF0ZXMgPSB0cnVlO1xuICAgIH1cblxuICAgIGlmIChUcmFja2VyICYmIHNldHRpbmdzICYmICFzZXR1cEZsYWdzLmZhdmljb25VcGRhdGVzKSB7XG4gICAgICBUcmFja2VyLmF1dG9ydW4oKCkgPT4ge1xuICAgICAgICBjb25zdCB7IHVybCwgZGVmYXVsdFVybCB9ID0gc2V0dGluZ3MuZ2V0KCdBc3NldHNfZmF2aWNvbicpIHx8IHt9O1xuICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0RmF2aWNvbih1cmwgfHwgZGVmYXVsdFVybCk7XG4gICAgICB9KTtcbiAgICAgIHNldHVwRmxhZ3MuZmF2aWNvblVwZGF0ZXMgPSB0cnVlO1xuICAgIH1cblxuICAgIGlmIChUcmFja2VyICYmIHNldHRpbmdzICYmICFzZXR1cEZsYWdzLmppdHNpSW50ZWdyYXRpb24pIHtcbiAgICAgIGNvbnN0IG9wZW4gPSB3aW5kb3cub3Blbi5iaW5kKHdpbmRvdyk7XG5cbiAgICAgIFRyYWNrZXIuYXV0b3J1bigoKSA9PiB7XG4gICAgICAgIGNvbnN0IHNlcnZlck1haW5WZXJzaW9uID0gc2VydmVySW5mby52ZXJzaW9uLnNwbGl0KCcuJylbMF07XG5cbiAgICAgICAgLy8gU2VydmVyIHZlcnNpb24gYWJvdmUgNS4wLjAgd2lsbCBjaGFuZ2UgdGhlIHdheSB0aGUgaml0c2kgaW50ZWdyYXRpb24gaXMgaGFuZGxlZCwgbm93IHdlIGhhdmUgdmlkZW8gcHJvdmlkZXIgYXMgYW4gYXBwXG4gICAgICAgIC8vIGlmIHRoZSBzZXJ2ZXIgaXMgYWJvdmUgNS4xLjEgaXQgd2lsbCB1c2Ugd2luZG93LlJvY2tldENoYXREZXNrdG9wPy5vcGVuSW50ZXJuYWxWaWRlb0NoYXRXaW5kb3cgdG8gb3BlbiB0aGUgdmlkZW8gY2FsbFxuICAgICAgICBpZiAoc2VydmVyTWFpblZlcnNpb24gPCA1KSB7XG4gICAgICAgICAgY29uc3Qgaml0c2lEb21haW4gPSBzZXR0aW5ncy5nZXQoJ0ppdHNpX0RvbWFpbicpIHx8ICcnO1xuXG4gICAgICAgICAgY29uc29sZS5sb2coXG4gICAgICAgICAgICAnW1JvY2tldC5DaGF0IERlc2t0b3BdIHdpbmRvdy5vcGVuIGZvciBKaXRzaSBvdmVybG9hZGVkJyxcbiAgICAgICAgICAgIGppdHNpRG9tYWluXG4gICAgICAgICAgKTtcbiAgICAgICAgICB3aW5kb3cub3BlbiA9ICh1cmwsIG5hbWUsIGZlYXR1cmVzID0gJycpID0+IHtcbiAgICAgICAgICAgIGlmIChcbiAgICAgICAgICAgICAgIXByb2Nlc3MubWFzICYmXG4gICAgICAgICAgICAgIHdpbmRvdy5Sb2NrZXRDaGF0RGVza3RvcC5nZXRJbnRlcm5hbFZpZGVvQ2hhdFdpbmRvd0VuYWJsZWQoKSAmJlxuICAgICAgICAgICAgICB0eXBlb2YgdXJsID09PSAnc3RyaW5nJyAmJlxuICAgICAgICAgICAgICBqaXRzaURvbWFpbi5sZW5ndGggPiAwICYmXG4gICAgICAgICAgICAgIHVybC5pbmNsdWRlcyhqaXRzaURvbWFpbilcbiAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICBjb25zb2xlLmxvZygnW1JvY2tldC5DaGF0IERlc2t0b3BdIHdpbmRvdy5vcGVuIGZvciBKaXRzaSBmaXJlZCcpO1xuICAgICAgICAgICAgICByZXR1cm4gb3Blbih1cmwsICdWaWRlbyBDYWxsJywgYHNjcm9sbGJhcnM9dHJ1ZSwke2ZlYXR1cmVzfWApO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICByZXR1cm4gb3Blbih1cmwsIG5hbWUsIGZlYXR1cmVzKTtcbiAgICAgICAgICB9O1xuICAgICAgICB9XG4gICAgICB9KTtcbiAgICAgIHNldHVwRmxhZ3Muaml0c2lJbnRlZ3JhdGlvbiA9IHRydWU7XG4gICAgfVxuXG4gICAgaWYgKFxuICAgICAgIXZlcnNpb25Jc0dyZWF0ZXJPckVxdWFsc1RvKHNlcnZlckluZm8udmVyc2lvbiwgJzYuNC4wJykgJiZcbiAgICAgIFRyYWNrZXIgJiZcbiAgICAgIHNldHRpbmdzICYmXG4gICAgICAhc2V0dXBGbGFncy5iYWNrZ3JvdW5kU2V0dGluZ3NcbiAgICApIHtcbiAgICAgIFRyYWNrZXIuYXV0b3J1bigoKSA9PiB7XG4gICAgICAgIGNvbnN0IHsgdXJsLCBkZWZhdWx0VXJsIH0gPSBzZXR0aW5ncy5nZXQoJ0Fzc2V0c19iYWNrZ3JvdW5kJykgfHwge307XG4gICAgICAgIHdpbmRvdy5Sb2NrZXRDaGF0RGVza3RvcC5zZXRCYWNrZ3JvdW5kKHVybCB8fCBkZWZhdWx0VXJsKTtcbiAgICAgIH0pO1xuICAgICAgc2V0dXBGbGFncy5iYWNrZ3JvdW5kU2V0dGluZ3MgPSB0cnVlO1xuICAgIH1cblxuICAgIC8vIEhlbHBlciBmdW5jdGlvbiB0byBnZXQgT3V0bG9vayBzZXR0aW5ncyBiYXNlZCBvbiBzZXJ2ZXIgdmVyc2lvblxuICAgIGNvbnN0IGdldE91dGxvb2tTZXR0aW5ncyA9ICgpID0+IHtcbiAgICAgIGlmICghTWV0ZW9yIHx8ICFzZXR0aW5ncykgcmV0dXJuIHt9O1xuICAgICAgY29uc3QgdXNlclRva2VuID0gTWV0ZW9yLl9sb2NhbFN0b3JhZ2U/LmdldEl0ZW0oJ01ldGVvci5sb2dpblRva2VuJyk7XG5cbiAgICAgIGlmICghdmVyc2lvbklzR3JlYXRlck9yRXF1YWxzVG8oc2VydmVySW5mby52ZXJzaW9uLCAnNy44LjAnKSkge1xuICAgICAgICAvLyBQcmUtNy44LjA6IFVzZSBnbG9iYWwgc2VydmVyIHNldHRpbmdzXG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgdXNlclRva2VuLFxuICAgICAgICAgIHVzZXJJZDogTWV0ZW9yLnVzZXJJZD8uKCksXG4gICAgICAgICAgb3V0bG9va0NhbGVuZGFyRW5hYmxlZDogc2V0dGluZ3MuZ2V0KCdPdXRsb29rX0NhbGVuZGFyX0VuYWJsZWQnKSxcbiAgICAgICAgICBvdXRsb29rRXhjaGFuZ2VVcmw6IHNldHRpbmdzLmdldCgnT3V0bG9va19DYWxlbmRhcl9FeGNoYW5nZV9VcmwnKSxcbiAgICAgICAgfTtcbiAgICAgIH1cbiAgICAgIC8vIDcuOC4wKzogVXNlIHVzZXItc3BlY2lmaWMgc2V0dGluZ3NcbiAgICAgIGNvbnN0IHVzZXIgPSBNZXRlb3IudXNlcj8uKCk7XG4gICAgICBjb25zdCBvdXRsb29rU2V0dGluZ3MgPSB1c2VyPy5zZXR0aW5ncz8uY2FsZW5kYXI/Lm91dGxvb2s7XG4gICAgICByZXR1cm4ge1xuICAgICAgICB1c2VyVG9rZW4sXG4gICAgICAgIHVzZXJJZDogdXNlcj8uX2lkLFxuICAgICAgICBvdXRsb29rQ2FsZW5kYXJFbmFibGVkOiBvdXRsb29rU2V0dGluZ3M/LkVuYWJsZWQsXG4gICAgICAgIG91dGxvb2tFeGNoYW5nZVVybDogb3V0bG9va1NldHRpbmdzPy5FeGNoYW5nZV9VcmwsXG4gICAgICB9O1xuICAgIH07XG5cbiAgICBpZiAoVHJhY2tlciAmJiAhc2V0dXBGbGFncy5vdXRsb29rSW50ZWdyYXRpb24pIHtcbiAgICAgIFRyYWNrZXIuYXV0b3J1bigoKSA9PiB7XG4gICAgICAgIGNvbnN0IHtcbiAgICAgICAgICB1c2VyVG9rZW4sXG4gICAgICAgICAgdXNlcklkLFxuICAgICAgICAgIG91dGxvb2tDYWxlbmRhckVuYWJsZWQsXG4gICAgICAgICAgb3V0bG9va0V4Y2hhbmdlVXJsLFxuICAgICAgICB9ID0gZ2V0T3V0bG9va1NldHRpbmdzKCk7XG5cbiAgICAgICAgaWYgKFxuICAgICAgICAgICF1c2VyVG9rZW4gfHxcbiAgICAgICAgICAhdXNlcklkIHx8XG4gICAgICAgICAgIW91dGxvb2tDYWxlbmRhckVuYWJsZWQgfHxcbiAgICAgICAgICAhb3V0bG9va0V4Y2hhbmdlVXJsXG4gICAgICAgICkge1xuICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIHdpbmRvdy5Sb2NrZXRDaGF0RGVza3RvcC5zZXRVc2VyVG9rZW4odXNlclRva2VuLCB1c2VySWQpO1xuICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0T3V0bG9va0V4Y2hhbmdlVXJsKFxuICAgICAgICAgIG91dGxvb2tFeGNoYW5nZVVybCxcbiAgICAgICAgICB1c2VySWRcbiAgICAgICAgKTtcbiAgICAgIH0pO1xuICAgICAgc2V0dXBGbGFncy5vdXRsb29rSW50ZWdyYXRpb24gPSB0cnVlO1xuICAgIH1cblxuICAgIGlmIChUcmFja2VyICYmIHNldHRpbmdzICYmICFzZXR1cEZsYWdzLnRpdGxlVXBkYXRlcykge1xuICAgICAgVHJhY2tlci5hdXRvcnVuKCgpID0+IHtcbiAgICAgICAgY29uc3Qgc2l0ZU5hbWUgPSBzZXR0aW5ncy5nZXQoJ1NpdGVfTmFtZScpO1xuICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0VGl0bGUoc2l0ZU5hbWUpO1xuICAgICAgfSk7XG4gICAgICBzZXR1cEZsYWdzLnRpdGxlVXBkYXRlcyA9IHRydWU7XG4gICAgfVxuXG4gICAgaWYgKFRyYWNrZXIgJiYgTWV0ZW9yICYmICFzZXR1cEZsYWdzLnVzZXJMb2dpbkRldGVjdGlvbikge1xuICAgICAgVHJhY2tlci5hdXRvcnVuKCgpID0+IHtcbiAgICAgICAgY29uc3QgdXNlcklkID0gTWV0ZW9yLnVzZXJJZCgpO1xuICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0VXNlckxvZ2dlZEluKHVzZXJJZCAhPT0gbnVsbCk7XG4gICAgICB9KTtcbiAgICAgIHNldHVwRmxhZ3MudXNlckxvZ2luRGV0ZWN0aW9uID0gdHJ1ZTtcbiAgICB9XG5cbiAgICBpZiAoVHJhY2tlciAmJiBNZXRlb3IgJiYgIXNldHVwRmxhZ3MuZ2l0Q29tbWl0SGFzaCkge1xuICAgICAgVHJhY2tlci5hdXRvcnVuKCgpID0+IHtcbiAgICAgICAgY29uc3QgeyBnaXRDb21taXRIYXNoIH0gPSBNZXRlb3I7XG4gICAgICAgIGlmICghZ2l0Q29tbWl0SGFzaCkgcmV0dXJuO1xuICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0R2l0Q29tbWl0SGFzaChnaXRDb21taXRIYXNoKTtcbiAgICAgIH0pO1xuICAgICAgc2V0dXBGbGFncy5naXRDb21taXRIYXNoID0gdHJ1ZTtcbiAgICB9XG5cbiAgICBpZiAoVHJhY2tlciAmJiBNZXRlb3IgJiYgZ2V0VXNlclByZWZlcmVuY2UgJiYgIXNldHVwRmxhZ3MudGhlbWVBcHBlYXJhbmNlKSB7XG4gICAgICBUcmFja2VyLmF1dG9ydW4oKCkgPT4ge1xuICAgICAgICBjb25zdCB1aWQgPSBNZXRlb3IudXNlcklkKCk7XG4gICAgICAgIGlmICghdWlkKSByZXR1cm47XG4gICAgICAgIGNvbnN0IHRoZW1lQXBwZWFyYW5jZTogc3RyaW5nID0gZ2V0VXNlclByZWZlcmVuY2UoXG4gICAgICAgICAgdWlkLFxuICAgICAgICAgICd0aGVtZUFwcGVhcmVuY2UnXG4gICAgICAgICk7XG4gICAgICAgIGlmIChcbiAgICAgICAgICBbJ2RhcmsnLCAnbGlnaHQnLCAnYXV0bycsICdoaWdoLWNvbnRyYXN0J10uaW5jbHVkZXMoXG4gICAgICAgICAgICB0aGVtZUFwcGVhcmFuY2UgYXMgYW55XG4gICAgICAgICAgKVxuICAgICAgICApIHtcbiAgICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0VXNlclRoZW1lQXBwZWFyYW5jZShcbiAgICAgICAgICAgIHRoZW1lQXBwZWFyYW5jZSBhcyAnYXV0bycgfCAnZGFyaycgfCAnbGlnaHQnIHwgJ2hpZ2gtY29udHJhc3QnXG4gICAgICAgICAgKTtcbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgICBzZXR1cEZsYWdzLnRoZW1lQXBwZWFyYW5jZSA9IHRydWU7XG4gICAgfVxuXG4gICAgaWYgKFRyYWNrZXIgJiYgTWV0ZW9yICYmIGdldFVzZXJQcmVmZXJlbmNlICYmICFzZXR1cEZsYWdzLnVzZXJQcmVzZW5jZSkge1xuICAgICAgVHJhY2tlci5hdXRvcnVuKCgpID0+IHtcbiAgICAgICAgY29uc3QgdWlkID0gTWV0ZW9yLnVzZXJJZCgpO1xuICAgICAgICBpZiAoIXVpZCkgcmV0dXJuO1xuICAgICAgICBjb25zdCBpc0F1dG9Bd2F5RW5hYmxlZDogdW5rbm93biA9IGdldFVzZXJQcmVmZXJlbmNlKFxuICAgICAgICAgIHVpZCxcbiAgICAgICAgICAnZW5hYmxlQXV0b0F3YXknXG4gICAgICAgICk7XG4gICAgICAgIGNvbnN0IGlkbGVUaHJlc2hvbGQ6IHVua25vd24gPSBnZXRVc2VyUHJlZmVyZW5jZSh1aWQsICdpZGxlVGltZUxpbWl0Jyk7XG5cbiAgICAgICAgaWYgKGlzQXV0b0F3YXlFbmFibGVkICYmIFVzZXJQcmVzZW5jZSkge1xuICAgICAgICAgIGRlbGV0ZSBVc2VyUHJlc2VuY2UuYXdheVRpbWU7XG4gICAgICAgICAgVXNlclByZXNlbmNlLnN0YXJ0KCk7XG4gICAgICAgIH1cblxuICAgICAgICB3aW5kb3cuUm9ja2V0Q2hhdERlc2t0b3Auc2V0VXNlclByZXNlbmNlRGV0ZWN0aW9uKHtcbiAgICAgICAgICBpc0F1dG9Bd2F5RW5hYmxlZDogQm9vbGVhbihpc0F1dG9Bd2F5RW5hYmxlZCksXG4gICAgICAgICAgaWRsZVRocmVzaG9sZDogaWRsZVRocmVzaG9sZCA/IE51bWJlcihpZGxlVGhyZXNob2xkKSA6IG51bGwsXG4gICAgICAgICAgc2V0VXNlck9ubGluZTogKG9ubGluZSkgPT4ge1xuICAgICAgICAgICAgaWYgKCFvbmxpbmUgJiYgTWV0ZW9yLmNhbGwpIHtcbiAgICAgICAgICAgICAgTWV0ZW9yLmNhbGwoJ1VzZXJQcmVzZW5jZTphd2F5Jyk7XG4gICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmIChNZXRlb3IuY2FsbCkge1xuICAgICAgICAgICAgICBNZXRlb3IuY2FsbCgnVXNlclByZXNlbmNlOm9ubGluZScpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgIH0sXG4gICAgICAgIH0pO1xuICAgICAgfSk7XG4gICAgICBzZXR1cEZsYWdzLnVzZXJQcmVzZW5jZSA9IHRydWU7XG4gICAgfVxuICB9O1xuXG4gIC8vIENhbGwgc2V0dXBSZWFjdGl2ZUZlYXR1cmVzIGltbWVkaWF0ZWx5IGFuZCB0aGVuIHBlcmlvZGljYWxseSBjaGVjayBmb3IgbmV3IG1vZHVsZXNcbiAgc2V0dXBSZWFjdGl2ZUZlYXR1cmVzKCk7XG4gIHNldEludGVydmFsKHNldHVwUmVhY3RpdmVGZWF0dXJlcywgMTAwMCk7IC8vIENoZWNrIGV2ZXJ5IHNlY29uZCBmb3IgbmV3bHkgbG9hZGVkIG1vZHVsZXNcblxuICBjb25zb2xlLmxvZygnW1JvY2tldC5DaGF0IERlc2t0b3BdIEluamVjdGVkJyk7XG59O1xuXG5zdGFydCgpO1xuIl0sIm5hbWVzIjpbImNvbnNvbGUiLCJsb2ciLCJyZXNvbHZlV2l0aEV4cG9uZW50aWFsQmFja29mZiIsImZuIiwibWF4UmV0cmllcyIsImRlbGF5IiwiUHJvbWlzZSIsInJlc29sdmUiLCJjYXRjaCIsImVycm9yIiwic2V0VGltZW91dCIsInRyeVJlcXVpcmUiLCJwYXRoIiwid2luZG93IiwicmVxdWlyZSIsInN0YXJ0UmV0cnlDb3VudCIsInRvdGFsUmV0cnlUaW1lIiwiTUFYX1JFVFJZX1RJTUUiLCJJTklUSUFMX1JFVFJZX0RFTEFZIiwic3RhcnQiLCJfY2xhc3MiLCJfZGVzdHJveSIsIl9vbmNsaWNrIiwiX29uY2xvc2UiLCJfb25lcnJvciIsIl9vbnNob3ciLCJfb25hY3Rpb24iLCJSb2NrZXRDaGF0RGVza3RvcCIsInJlbG9hZFNlcnZlciIsInJldHJ5RGVsYXkiLCJNYXRoIiwibWluIiwicG93IiwiYWN0dWFsRGVsYXkiLCJJbmZvIiwic2VydmVySW5mbyIsInZlcnNpb24iLCJzZXRTZXJ2ZXJJbmZvIiwidmVyc2lvbklzR3JlYXRlck9yRXF1YWxzVG8iLCJ2ZXJzaW9uMSIsInZlcnNpb24yIiwiY2xlYW5WZXJzaW9uMSIsInNwbGl0IiwiY2xlYW5WZXJzaW9uMiIsInYxIiwibWFwIiwiTnVtYmVyIiwidjIiLCJtYXhMZW5ndGgiLCJtYXgiLCJsZW5ndGgiLCJpIiwibjEiLCJuMiIsInVzZXJQcmVzZW5jZU1vZHVsZVBhdGgiLCJzZXR0aW5nc01vZHVsZVBhdGgiLCJ1dGlsc01vZHVsZVBhdGgiLCJNZXRlb3IiLCJTZXNzaW9uIiwiVHJhY2tlciIsInNldHRpbmdzIiwiZ2V0VXNlclByZWZlcmVuY2UiLCJVc2VyUHJlc2VuY2UiLCJsb2FkTW9kdWxlIiwibW9kdWxlUGF0aCIsIm1vZHVsZU5hbWUiLCJzZXR0ZXIiLCJwcm9wZXJ0eU5hbWUiLCJtb2R1bGUiLCJ2YWx1ZSIsIm5hdmlnYXRvciIsImNsaXBib2FyZCIsIndyaXRlVGV4dCIsImFyZ3MiLCJ3cml0ZVRleHRUb0NsaXBib2FyZCIsIk5vdGlmaWNhdGlvbiIsIldlYWtNYXAiLCJSb2NrZXRDaGF0RGVza3RvcE5vdGlmaWNhdGlvbiIsIkV2ZW50VGFyZ2V0IiwicmVxdWVzdFBlcm1pc3Npb24iLCJwZXJtaXNzaW9uIiwiY29uc3RydWN0b3IiLCJ0aXRsZSIsIm9wdGlvbnMiLCJfY2xhc3NQcml2YXRlRmllbGRJbml0U3BlYyIsIndyaXRhYmxlIiwiX2RlZmluZVByb3BlcnR5IiwidW5kZWZpbmVkIiwiZG9jdW1lbnQiLCJkb2N1bWVudEVsZW1lbnQiLCJsYW5nIiwiRGF0ZSIsIm5vdyIsInR5cGUiLCJkZXRhaWwiLCJtYWluV29ybGRFdmVudCIsIkN1c3RvbUV2ZW50IiwiaXNSZXBseUV2ZW50IiwicmVwbHkiLCJyZXNwb25zZSIsImRpc3BhdGNoRXZlbnQiLCJfY2xhc3NQcml2YXRlRmllbGRTZXQiLCJjcmVhdGVOb3RpZmljYXRpb24iLCJvbkV2ZW50IiwiaGFuZGxlRXZlbnQiLCJ0aGVuIiwiaWQiLCJkZXN0cm95Tm90aWZpY2F0aW9uIiwiT2JqZWN0IiwiYXNzaWduIiwib25jbGljayIsIl9jbGFzc1ByaXZhdGVGaWVsZEdldCIsInJlbW92ZUV2ZW50TGlzdGVuZXIiLCJhZGRFdmVudExpc3RlbmVyIiwib25jbG9zZSIsIm9uZXJyb3IiLCJvbnNob3ciLCJvbmFjdGlvbiIsImNsb3NlIiwiX2NsYXNzUHJpdmF0ZUZpZWxkR2V0MiIsImRlc3Ryb3kiLCJwcm9jZXNzIiwicGxhdGZvcm0iLCJNQVhfU0FGRV9JTlRFR0VSIiwic2V0dXBGbGFncyIsInVybFJlc29sdmVyIiwiYmFkZ2VVcGRhdGVzIiwiZmF2aWNvblVwZGF0ZXMiLCJqaXRzaUludGVncmF0aW9uIiwiYmFja2dyb3VuZFNldHRpbmdzIiwib3V0bG9va0ludGVncmF0aW9uIiwidGl0bGVVcGRhdGVzIiwidXNlckxvZ2luRGV0ZWN0aW9uIiwiZ2l0Q29tbWl0SGFzaCIsInRoZW1lQXBwZWFyYW5jZSIsInVzZXJQcmVzZW5jZSIsInNldHVwUmVhY3RpdmVGZWF0dXJlcyIsIl9NZXRlb3IiLCJhYnNvbHV0ZVVybCIsInNldFVybFJlc29sdmVyIiwiYXV0b3J1biIsInVucmVhZCIsImdldCIsInNldEJhZGdlIiwidXJsIiwiZGVmYXVsdFVybCIsInNldEZhdmljb24iLCJvcGVuIiwiYmluZCIsInNlcnZlck1haW5WZXJzaW9uIiwiaml0c2lEb21haW4iLCJuYW1lIiwiZmVhdHVyZXMiLCJtYXMiLCJnZXRJbnRlcm5hbFZpZGVvQ2hhdFdpbmRvd0VuYWJsZWQiLCJpbmNsdWRlcyIsInNldEJhY2tncm91bmQiLCJnZXRPdXRsb29rU2V0dGluZ3MiLCJfTWV0ZW9yJF9sb2NhbFN0b3JhZ2UiLCJfTWV0ZW9yJHVzZXIiLCJfTWV0ZW9yMyIsIl91c2VyJHNldHRpbmdzIiwidXNlclRva2VuIiwiX2xvY2FsU3RvcmFnZSIsImdldEl0ZW0iLCJfTWV0ZW9yJHVzZXJJZCIsIl9NZXRlb3IyIiwidXNlcklkIiwiY2FsbCIsIm91dGxvb2tDYWxlbmRhckVuYWJsZWQiLCJvdXRsb29rRXhjaGFuZ2VVcmwiLCJ1c2VyIiwib3V0bG9va1NldHRpbmdzIiwiY2FsZW5kYXIiLCJvdXRsb29rIiwiX2lkIiwiRW5hYmxlZCIsIkV4Y2hhbmdlX1VybCIsInNldFVzZXJUb2tlbiIsInNldE91dGxvb2tFeGNoYW5nZVVybCIsInNpdGVOYW1lIiwic2V0VGl0bGUiLCJzZXRVc2VyTG9nZ2VkSW4iLCJzZXRHaXRDb21taXRIYXNoIiwidWlkIiwic2V0VXNlclRoZW1lQXBwZWFyYW5jZSIsImlzQXV0b0F3YXlFbmFibGVkIiwiaWRsZVRocmVzaG9sZCIsImF3YXlUaW1lIiwic2V0VXNlclByZXNlbmNlRGV0ZWN0aW9uIiwiQm9vbGVhbiIsInNldFVzZXJPbmxpbmUiLCJvbmxpbmUiLCJzZXRJbnRlcnZhbCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RUFFQUEsT0FBTyxDQUFDQyxHQUFHLENBQUMsbUNBQW1DLENBQUMsQ0FBQTtFQUVoRCxNQUFNQyw2QkFBNkIsR0FBR0EsQ0FDcENDLEVBQW9CLEVBQ3BCO0VBQUVDLEVBQUFBLFVBQVUsR0FBRyxDQUFDO0VBQUVDLEVBQUFBLEtBQUssR0FBRyxJQUFBO0VBQUssQ0FBQyxHQUFHLEVBQUUsS0FFckMsSUFBSUMsT0FBTyxDQUFLQyxPQUFPLElBQUtBLE9BQU8sQ0FBQ0osRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDSyxLQUFLLENBQUVDLEtBQUssSUFBSztJQUMxRCxJQUFJTCxVQUFVLEtBQUssQ0FBQyxFQUFFO0VBQ3BCLElBQUEsTUFBTUssS0FBSyxDQUFBO0VBQ2IsR0FBQTtFQUNBVCxFQUFBQSxPQUFPLENBQUNDLEdBQUcsQ0FDVCxvRkFDRixDQUFDLENBQUE7RUFDRCxFQUFBLE9BQU8sSUFBSUssT0FBTyxDQUFLQyxPQUFPLElBQUs7RUFDakNHLElBQUFBLFVBQVUsQ0FBQyxNQUFNO0VBQ2ZILE1BQUFBLE9BQU8sQ0FDTEwsNkJBQTZCLENBQUNDLEVBQUUsRUFBRTtVQUNoQ0MsVUFBVSxFQUFFQSxVQUFVLEdBQUcsQ0FBQztVQUMxQkMsS0FBSyxFQUFFQSxLQUFLLEdBQUcsQ0FBQTtFQUNqQixPQUFDLENBQ0gsQ0FBQyxDQUFBO09BQ0YsRUFBRUEsS0FBSyxDQUFDLENBQUE7RUFDWCxHQUFDLENBQUMsQ0FBQTtFQUNKLENBQUMsQ0FBQyxDQUFBO0VBRUosTUFBTU0sVUFBVSxHQUFhQyxJQUFZLElBQ3ZDViw2QkFBNkIsQ0FBSSxNQUFNVyxNQUFNLENBQUNDLE9BQU8sQ0FBQ0YsSUFBSSxDQUFDLENBQUMsQ0FBQTtFQUU5RCxJQUFJRyxlQUFlLEdBQUcsQ0FBQyxDQUFBO0VBQ3ZCLElBQUlDLGNBQWMsR0FBRyxDQUFDLENBQUE7RUFDdEIsTUFBTUMsY0FBYyxHQUFHLEtBQUssQ0FBQztFQUM3QixNQUFNQyxtQkFBbUIsR0FBRyxJQUFJLENBQUM7O0VBRWpDO0VBQ0EsTUFBTUMsS0FBSyxHQUFHLFlBQVk7RUFBQSxFQUFBLElBQUFDLE1BQUEsRUFBQUMsUUFBQSxFQUFBQyxRQUFBLEVBQUFDLFFBQUEsRUFBQUMsUUFBQSxFQUFBQyxPQUFBLEVBQUFDLFNBQUEsQ0FBQTtFQUN4QjFCLEVBQUFBLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDLCtDQUErQyxDQUFDLENBQUE7RUFDNUQsRUFBQSxJQUFJLE9BQU9ZLE1BQU0sQ0FBQ0MsT0FBTyxLQUFLLFVBQVUsRUFBRTtFQUN4Q2QsSUFBQUEsT0FBTyxDQUFDQyxHQUFHLENBQUMscURBQXFELENBQUMsQ0FBQTtNQUVsRSxJQUFJZSxjQUFjLElBQUlDLGNBQWMsRUFBRTtFQUNwQ2pCLE1BQUFBLE9BQU8sQ0FBQ1MsS0FBSyxDQUNYLENBQTZDUSwwQ0FBQUEsRUFBQUEsY0FBYyxxREFDN0QsQ0FBQyxDQUFBO0VBQ0RqQixNQUFBQSxPQUFPLENBQUNDLEdBQUcsQ0FDVCw4RUFDRixDQUFDLENBQUE7RUFDRDtFQUNBWSxNQUFBQSxNQUFNLENBQUNjLGlCQUFpQixDQUFDQyxZQUFZLEVBQUUsQ0FBQTtFQUN2QyxNQUFBLE9BQUE7RUFDRixLQUFBO0VBRUFiLElBQUFBLGVBQWUsRUFBRSxDQUFBO01BQ2pCLE1BQU1jLFVBQVUsR0FBR0MsSUFBSSxDQUFDQyxHQUFHLENBQ3pCYixtQkFBbUIsR0FBR1ksSUFBSSxDQUFDRSxHQUFHLENBQUMsR0FBRyxFQUFFakIsZUFBZSxHQUFHLENBQUMsQ0FBQyxFQUN4RCxJQUNGLENBQUMsQ0FBQzs7RUFFRjtNQUNBLE1BQU1rQixXQUFXLEdBQUdILElBQUksQ0FBQ0MsR0FBRyxDQUFDRixVQUFVLEVBQUVaLGNBQWMsR0FBR0QsY0FBYyxDQUFDLENBQUE7RUFDekVBLElBQUFBLGNBQWMsSUFBSWlCLFdBQVcsQ0FBQTtNQUU3QmpDLE9BQU8sQ0FBQ0MsR0FBRyxDQUNULENBQThDYywyQ0FBQUEsRUFBQUEsZUFBZSxPQUFPa0IsV0FBVyxDQUFBLGdCQUFBLEVBQW1CakIsY0FBYyxDQUFBLEdBQUEsQ0FDbEgsQ0FBQyxDQUFBO0VBQ0ROLElBQUFBLFVBQVUsQ0FBQ1MsS0FBSyxFQUFFYyxXQUFXLENBQUMsQ0FBQTtFQUM5QixJQUFBLE9BQUE7RUFDRixHQUFBOztFQUVBO0VBQ0FsQixFQUFBQSxlQUFlLEdBQUcsQ0FBQyxDQUFBO0VBQ25CQyxFQUFBQSxjQUFjLEdBQUcsQ0FBQyxDQUFBO0lBRWxCLE1BQU07TUFBRWtCLElBQUksRUFBRUMsVUFBVSxHQUFHLEVBQUM7RUFBRSxHQUFDLEdBQUcsTUFBTXhCLFVBQVUsQ0FDaEQsNEJBQ0YsQ0FBQyxDQUFBO0VBRUQsRUFBQSxJQUFJLENBQUN3QixVQUFVLENBQUNDLE9BQU8sRUFBRTtFQUN2QnBDLElBQUFBLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDLHlEQUF5RCxDQUFDLENBQUE7RUFDdEUsSUFBQSxPQUFBO0VBQ0YsR0FBQTtFQUVBRCxFQUFBQSxPQUFPLENBQUNDLEdBQUcsQ0FBQyw4Q0FBOEMsRUFBRWtDLFVBQVUsQ0FBQyxDQUFBO0VBRXZFdEIsRUFBQUEsTUFBTSxDQUFDYyxpQkFBaUIsQ0FBQ1UsYUFBYSxDQUFDRixVQUFVLENBQUMsQ0FBQTtFQUVsRCxFQUFBLFNBQVNHLDBCQUEwQkEsQ0FDakNDLFFBQWdCLEVBQ2hCQyxRQUFnQixFQUNQO0VBQ1Q7TUFDQSxNQUFNQyxhQUFhLEdBQUdGLFFBQVEsQ0FBQ0csS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFBO01BQzVDLE1BQU1DLGFBQWEsR0FBR0gsUUFBUSxDQUFDRSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUE7RUFFNUMsSUFBQSxNQUFNRSxFQUFFLEdBQUdILGFBQWEsQ0FBQ0MsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDRyxHQUFHLENBQUNDLE1BQU0sQ0FBQyxDQUFBO0VBQy9DLElBQUEsTUFBTUMsRUFBRSxHQUFHSixhQUFhLENBQUNELEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQ0csR0FBRyxDQUFDQyxNQUFNLENBQUMsQ0FBQTs7RUFFL0M7RUFDQSxJQUFBLE1BQU1FLFNBQVMsR0FBR2xCLElBQUksQ0FBQ21CLEdBQUcsQ0FBQ0wsRUFBRSxDQUFDTSxNQUFNLEVBQUVILEVBQUUsQ0FBQ0csTUFBTSxDQUFDLENBQUE7TUFDaEQsS0FBSyxJQUFJQyxDQUFDLEdBQUcsQ0FBQyxFQUFFQSxDQUFDLEdBQUdILFNBQVMsRUFBRUcsQ0FBQyxFQUFFLEVBQUU7RUFDbEMsTUFBQSxNQUFNQyxFQUFFLEdBQUdSLEVBQUUsQ0FBQ08sQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFBO0VBQ3JCLE1BQUEsTUFBTUUsRUFBRSxHQUFHTixFQUFFLENBQUNJLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQTtRQUVyQixJQUFJQyxFQUFFLEdBQUdDLEVBQUUsRUFBRTtFQUNYLFFBQUEsT0FBTyxJQUFJLENBQUE7RUFDYixPQUFBO1FBQ0EsSUFBSUQsRUFBRSxHQUFHQyxFQUFFLEVBQUU7RUFDWCxRQUFBLE9BQU8sS0FBSyxDQUFBO0VBQ2QsT0FBQTtFQUNGLEtBQUE7TUFFQSxPQUFPLElBQUksQ0FBQztFQUNkLEdBQUE7RUFFQSxFQUFBLE1BQU1DLHNCQUFzQixHQUFHaEIsMEJBQTBCLENBQ3ZESCxVQUFVLENBQUNDLE9BQU8sRUFDbEIsT0FDRixDQUFDLEdBQ0csaUNBQWlDLEdBQ2pDLDhCQUE4QixDQUFBO0lBRWxDLE1BQU1tQixrQkFBa0IsR0FBRyxDQUFDLE1BQU07RUFDaEM7RUFDQTtNQUNBLElBQUlqQiwwQkFBMEIsQ0FBQ0gsVUFBVSxDQUFDQyxPQUFPLEVBQUUsT0FBTyxDQUFDLEVBQ3pELE9BQU8sK0JBQStCLENBQUE7RUFDeEMsSUFBQSxPQUFPLGVBQWUsQ0FBQTtFQUN4QixHQUFDLEdBQUcsQ0FBQTtJQUVKLE1BQU1vQixlQUFlLEdBQUcsQ0FBQyxNQUFNO0VBQzdCO0VBQ0E7TUFDQSxJQUFJbEIsMEJBQTBCLENBQUNILFVBQVUsQ0FBQ0MsT0FBTyxFQUFFLE9BQU8sQ0FBQyxFQUN6RCxPQUFPLDRCQUE0QixDQUFBO0VBQ3JDLElBQUEsT0FBTyxZQUFZLENBQUE7RUFDckIsR0FBQyxHQUFHLENBQUE7O0VBRUo7SUFDQSxJQUFJcUIsTUFBVyxHQUFHLElBQUksQ0FBQTtJQUN0QixJQUFJQyxPQUFZLEdBQUcsSUFBSSxDQUFBO0lBQ3ZCLElBQUlDLE9BQVksR0FBRyxJQUFJLENBQUE7SUFDdkIsSUFBSUMsUUFBYSxHQUFHLElBQUksQ0FBQTtJQUN4QixJQUFJQyxpQkFBc0IsR0FBRyxJQUFJLENBQUE7SUFDakMsSUFBSUMsWUFBaUIsR0FBRyxJQUFJLENBQUE7O0VBRTVCO0lBQ0EsTUFBTUMsVUFBVSxHQUFHLE9BQ2pCQyxVQUFrQixFQUNsQkMsVUFBa0IsRUFDbEJDLE1BQTRCLEVBQzVCQyxZQUFxQixLQUNsQjtNQUNILElBQUk7RUFDRixNQUFBLE1BQU1DLE1BQU0sR0FBRyxNQUFNekQsVUFBVSxDQUFDcUQsVUFBVSxDQUFDLENBQUE7UUFDM0MsTUFBTUssS0FBSyxHQUFHRixZQUFZLEdBQUdDLE1BQU0sQ0FBQ0QsWUFBWSxDQUFDLEdBQUdDLE1BQU0sQ0FBQTtRQUMxREYsTUFBTSxDQUFDRyxLQUFLLENBQUMsQ0FBQTtFQUNickUsTUFBQUEsT0FBTyxDQUFDQyxHQUFHLENBQ1QsQ0FBeUJnRSxzQkFBQUEsRUFBQUEsVUFBVSw2QkFDckMsQ0FBQyxDQUFBO09BQ0YsQ0FBQyxPQUFPeEQsS0FBSyxFQUFFO1FBQ2RULE9BQU8sQ0FBQ0MsR0FBRyxDQUNULENBQUEscUNBQUEsRUFBd0NnRSxVQUFVLENBQVUsUUFBQSxDQUFBLEVBQzVEeEQsS0FDRixDQUFDLENBQUE7RUFDSCxLQUFBO0tBQ0QsQ0FBQTs7RUFFRDtFQUNBc0QsRUFBQUEsVUFBVSxDQUFDLGVBQWUsRUFBRSxRQUFRLEVBQUdNLEtBQUssSUFBSztNQUMvQ1osTUFBTSxHQUFHWSxLQUFLLENBQUNaLE1BQU0sQ0FBQTtFQUN2QixHQUFDLENBQUMsQ0FBQTtFQUNGTSxFQUFBQSxVQUFVLENBQUMsZ0JBQWdCLEVBQUUsU0FBUyxFQUFHTSxLQUFLLElBQUs7TUFDakRYLE9BQU8sR0FBR1csS0FBSyxDQUFDWCxPQUFPLENBQUE7RUFDekIsR0FBQyxDQUFDLENBQUE7RUFDRkssRUFBQUEsVUFBVSxDQUFDLGdCQUFnQixFQUFFLFNBQVMsRUFBR00sS0FBSyxJQUFLO01BQ2pEVixPQUFPLEdBQUdVLEtBQUssQ0FBQ1YsT0FBTyxDQUFBO0VBQ3pCLEdBQUMsQ0FBQyxDQUFBO0VBQ0ZJLEVBQUFBLFVBQVUsQ0FBQ1Isa0JBQWtCLEVBQUUsVUFBVSxFQUFHYyxLQUFLLElBQUs7TUFDcERULFFBQVEsR0FBR1MsS0FBSyxDQUFDVCxRQUFRLENBQUE7RUFDM0IsR0FBQyxDQUFDLENBQUE7RUFDRkcsRUFBQUEsVUFBVSxDQUFDUCxlQUFlLEVBQUUsT0FBTyxFQUFHYSxLQUFLLElBQUs7TUFDOUNSLGlCQUFpQixHQUFHUSxLQUFLLENBQUNSLGlCQUFpQixDQUFBO0VBQzdDLEdBQUMsQ0FBQyxDQUFBO0VBQ0ZFLEVBQUFBLFVBQVUsQ0FBQ1Qsc0JBQXNCLEVBQUUsY0FBYyxFQUFHZSxLQUFLLElBQUs7TUFDNURQLFlBQVksR0FBR08sS0FBSyxDQUFDUCxZQUFZLENBQUE7RUFDbkMsR0FBQyxDQUFDLENBQUE7O0VBRUY7RUFDQVEsRUFBQUEsU0FBUyxDQUFDQyxTQUFTLENBQUNDLFNBQVMsR0FBRyxPQUFPLEdBQUdDLElBQUksS0FDNUM1RCxNQUFNLENBQUNjLGlCQUFpQixDQUFDK0Msb0JBQW9CLENBQUMsR0FBR0QsSUFBSSxDQUFDLENBQUE7RUFFeER6RSxFQUFBQSxPQUFPLENBQUNDLEdBQUcsQ0FBQyx5REFBeUQsQ0FBQyxDQUFBO0VBRXRFWSxFQUFBQSxNQUFNLENBQUM4RCxZQUFZLElBQUF0RCxRQUFBLG9CQUFBdUQsT0FBQSxFQUFBLEVBQUF0RCxRQUFBLGdCQUFBLElBQUFzRCxPQUFBLEVBQUEsRUFBQXJELFFBQUEsZ0JBQUEsSUFBQXFELE9BQUEsRUFBQXBELEVBQUFBLFFBQUEsZ0JBQUFvRCxJQUFBQSxPQUFBLEVBQUFuRCxFQUFBQSxPQUFBLGdCQUFBbUQsSUFBQUEsT0FBQSxJQUFBbEQsU0FBQSxnQkFBQSxJQUFBa0QsT0FBQSxFQUFBLEdBQUF4RCxNQUFBLEdBQUcsTUFBTXlELDZCQUE2QixTQUMvQ0MsV0FBVyxDQUVyQjtNQU1FLE9BQU9DLGlCQUFpQkEsR0FBb0M7RUFDMUQsTUFBQSxPQUFPekUsT0FBTyxDQUFDQyxPQUFPLENBQUNzRSw2QkFBNkIsQ0FBQ0csVUFBVSxDQUFDLENBQUE7RUFDbEUsS0FBQTtFQUlBQyxJQUFBQSxXQUFXQSxDQUNUQyxLQUFhLEVBQ2JDLE9BQXFELEdBQUcsRUFBRSxFQUMxRDtFQUNBLE1BQUEsS0FBSyxFQUFFLENBQUE7RUFBQ0MsTUFBQUEsMEJBQUEsT0FBQS9ELFFBQUEsRUFBQTtVQUFBZ0UsUUFBQSxFQUFBLElBQUE7VUFBQWhCLEtBQUEsRUFBQSxLQUFBLENBQUE7RUFBQSxPQUFBLENBQUEsQ0FBQTtFQUFBaUIsTUFBQUEsZUFBQSxrQkFhK0IsRUFBRSxDQUFBLENBQUE7RUFBQUEsTUFBQUEsZUFBQSxnQkFFbkMsRUFBRSxDQUFBLENBQUE7RUFBQUEsTUFBQUEsZUFBQSxlQUVILEVBQUUsQ0FBQSxDQUFBO0VBQUFBLE1BQUFBLGVBQUEsZUFFR0MsU0FBUyxDQUFBLENBQUE7RUFBQUQsTUFBQUEsZUFBQSxjQUVRLE1BQU0sQ0FBQSxDQUFBO0VBQUFBLE1BQUFBLGVBQUEsZUFFNUIsRUFBRSxDQUFBLENBQUE7RUFBQUEsTUFBQUEsZUFBQSxnQkFFRCxFQUFFLENBQUEsQ0FBQTtFQUFBQSxNQUFBQSxlQUFBLENBRUhFLElBQUFBLEVBQUFBLE1BQUFBLEVBQUFBLFFBQVEsQ0FBQ0MsZUFBZSxDQUFDQyxJQUFJLENBQUEsQ0FBQTtFQUFBTixNQUFBQSwwQkFBQSxPQUFBOUQsUUFBQSxFQUFBO1VBQUErRCxRQUFBLEVBQUEsSUFBQTtFQUFBaEIsUUFBQUEsS0FBQSxFQUV3QixJQUFBO0VBQUksT0FBQSxDQUFBLENBQUE7RUFBQWUsTUFBQUEsMEJBQUEsT0FBQTdELFFBQUEsRUFBQTtVQUFBOEQsUUFBQSxFQUFBLElBQUE7RUFBQWhCLFFBQUFBLEtBQUEsRUFrQkosSUFBQTtFQUFJLE9BQUEsQ0FBQSxDQUFBO0VBQUFlLE1BQUFBLDBCQUFBLE9BQUE1RCxRQUFBLEVBQUE7VUFBQTZELFFBQUEsRUFBQSxJQUFBO0VBQUFoQixRQUFBQSxLQUFBLEVBa0JKLElBQUE7RUFBSSxPQUFBLENBQUEsQ0FBQTtFQUFBZSxNQUFBQSwwQkFBQSxPQUFBM0QsT0FBQSxFQUFBO1VBQUE0RCxRQUFBLEVBQUEsSUFBQTtFQUFBaEIsUUFBQUEsS0FBQSxFQWtCTCxJQUFBO0VBQUksT0FBQSxDQUFBLENBQUE7RUFBQWUsTUFBQUEsMEJBQUEsT0FBQTFELFNBQUEsRUFBQTtVQUFBMkQsUUFBQSxFQUFBLElBQUE7RUFBQWhCLFFBQUFBLEtBQUEsRUFrQkYsSUFBQTtFQUFJLE9BQUEsQ0FBQSxDQUFBO0VBQUFpQixNQUFBQSxlQUFBLDZCQWtCNUMsS0FBSyxDQUFBLENBQUE7RUFBQUEsTUFBQUEsZUFBQSxpQkFFakIsS0FBSyxDQUFBLENBQUE7RUFBQUEsTUFBQUEsZUFBQSxjQUVSLEVBQUUsQ0FBQSxDQUFBO0VBQUFBLE1BQUFBLGVBQUEsQ0FFWUssSUFBQUEsRUFBQUEsV0FBQUEsRUFBQUEsSUFBSSxDQUFDQyxHQUFHLEVBQUUsQ0FBQSxDQUFBO0VBQUFOLE1BQUFBLGVBQUEsZ0JBRXRCLEVBQUUsQ0FBQSxDQUFBO0VBQUFBLE1BQUFBLGVBQUEsa0JBRW1CLEVBQUUsQ0FBQSxDQUFBO0VBQUFBLE1BQUFBLGVBQUEsc0JBRVQsQ0FBQztVQUNyQk8sSUFBSTtFQUNKQyxRQUFBQSxNQUFBQTtFQUlGLE9BQUMsS0FBVztFQUNWLFFBQUEsTUFBTUMsY0FBYyxHQUFHLElBQUlDLFdBQVcsQ0FBQ0gsSUFBSSxFQUFFO0VBQUVDLFVBQUFBLE1BQUFBO0VBQU8sU0FBQyxDQUFDLENBQUE7RUFFeEQsUUFBQSxNQUFNRyxZQUFZLEdBQUdBLENBQ25CSixJQUFZLEVBQ1pDLE1BQWUsS0FFZkQsSUFBSSxLQUFLLE9BQU8sSUFDaEIsT0FBT0MsTUFBTSxLQUFLLFFBQVEsSUFDMUJBLE1BQU0sS0FBSyxJQUFJLElBQ2YsT0FBTyxJQUFJQSxNQUFNLElBQ2pCLE9BQVFBLE1BQU0sQ0FBdUJJLEtBQUssS0FBSyxRQUFRLENBQUE7RUFFekQsUUFBQSxJQUFJRCxZQUFZLENBQUNKLElBQUksRUFBRUMsTUFBTSxDQUFDLEVBQUU7RUFDN0JDLFVBQUFBLGNBQWMsQ0FBU0ksUUFBUSxHQUFHTCxNQUFNLENBQUNJLEtBQUssQ0FBQTtFQUNqRCxTQUFBO0VBQ0EsUUFBQSxJQUFJLENBQUNFLGFBQWEsQ0FBQ0wsY0FBYyxDQUFDLENBQUE7U0FDbkMsQ0FBQSxDQUFBO1FBeEpDTSxxQkFBQSxDQUFBLElBQUksRUFBQWhGLFFBQUEsRUFBWVIsTUFBTSxDQUFDYyxpQkFBaUIsQ0FBQzJFLGtCQUFrQixDQUFDO1VBQzFEcEIsS0FBSztFQUNMLFFBQUEsR0FBR0MsT0FBTztVQUNWb0IsT0FBTyxFQUFFLElBQUksQ0FBQ0MsV0FBQUE7RUFDaEIsT0FBQyxDQUFDLENBQUNDLElBQUksQ0FBRUMsRUFBRSxJQUFLLE1BQU07RUFDcEI3RixRQUFBQSxNQUFNLENBQUNjLGlCQUFpQixDQUFDZ0YsbUJBQW1CLENBQUNELEVBQUUsQ0FBQyxDQUFBO0VBQ2xELE9BQUMsQ0FBQyxDQUFBLENBQUE7RUFFRkUsTUFBQUEsTUFBTSxDQUFDQyxNQUFNLENBQUMsSUFBSSxFQUFFO1VBQUUzQixLQUFLO1VBQUUsR0FBR0MsT0FBQUE7RUFBUSxPQUFDLENBQUMsQ0FBQTtFQUM1QyxLQUFBO01Bb0JBLElBQUkyQixPQUFPQSxHQUFHO0VBQ1osTUFBQSxPQUFBQyxxQkFBQSxDQUFPLElBQUksRUFBQXpGLFFBQUEsQ0FBQSxDQUFBO0VBQ2IsS0FBQTtNQUVBLElBQUl3RixPQUFPQSxDQUFDekMsS0FBSyxFQUFFO0VBQ2pCLE1BQUEsSUFBQTBDLHFCQUFBLENBQUksSUFBSSxFQUFBekYsUUFBQSxDQUFXLEVBQUE7VUFDakIsSUFBSSxDQUFDMEYsbUJBQW1CLENBQUMsT0FBTyxFQUFBRCxxQkFBQSxDQUFFLElBQUksRUFBQXpGLFFBQUEsQ0FBUyxDQUFDLENBQUE7RUFDbEQsT0FBQTtFQUVBK0UsTUFBQUEscUJBQUEsQ0FBSSxJQUFBLEVBQUEvRSxRQUFBLEVBQVkrQyxLQUFLLENBQUEsQ0FBQTtFQUVyQixNQUFBLElBQUEwQyxxQkFBQSxDQUFJLElBQUksRUFBQXpGLFFBQUEsQ0FBVyxFQUFBO1VBQ2pCLElBQUksQ0FBQzJGLGdCQUFnQixDQUFDLE9BQU8sRUFBQUYscUJBQUEsQ0FBRSxJQUFJLEVBQUF6RixRQUFBLENBQVMsQ0FBQyxDQUFBO0VBQy9DLE9BQUE7RUFDRixLQUFBO01BSUEsSUFBSTRGLE9BQU9BLEdBQUc7RUFDWixNQUFBLE9BQUFILHFCQUFBLENBQU8sSUFBSSxFQUFBeEYsUUFBQSxDQUFBLENBQUE7RUFDYixLQUFBO01BRUEsSUFBSTJGLE9BQU9BLENBQUM3QyxLQUFLLEVBQUU7RUFDakIsTUFBQSxJQUFBMEMscUJBQUEsQ0FBSSxJQUFJLEVBQUF4RixRQUFBLENBQVcsRUFBQTtVQUNqQixJQUFJLENBQUN5RixtQkFBbUIsQ0FBQyxPQUFPLEVBQUFELHFCQUFBLENBQUUsSUFBSSxFQUFBeEYsUUFBQSxDQUFTLENBQUMsQ0FBQTtFQUNsRCxPQUFBO0VBRUE4RSxNQUFBQSxxQkFBQSxDQUFJLElBQUEsRUFBQTlFLFFBQUEsRUFBWThDLEtBQUssQ0FBQSxDQUFBO0VBRXJCLE1BQUEsSUFBQTBDLHFCQUFBLENBQUksSUFBSSxFQUFBeEYsUUFBQSxDQUFXLEVBQUE7VUFDakIsSUFBSSxDQUFDMEYsZ0JBQWdCLENBQUMsT0FBTyxFQUFBRixxQkFBQSxDQUFFLElBQUksRUFBQXhGLFFBQUEsQ0FBUyxDQUFDLENBQUE7RUFDL0MsT0FBQTtFQUNGLEtBQUE7TUFJQSxJQUFJNEYsT0FBT0EsR0FBRztFQUNaLE1BQUEsT0FBQUoscUJBQUEsQ0FBTyxJQUFJLEVBQUF2RixRQUFBLENBQUEsQ0FBQTtFQUNiLEtBQUE7TUFFQSxJQUFJMkYsT0FBT0EsQ0FBQzlDLEtBQUssRUFBRTtFQUNqQixNQUFBLElBQUEwQyxxQkFBQSxDQUFJLElBQUksRUFBQXZGLFFBQUEsQ0FBVyxFQUFBO1VBQ2pCLElBQUksQ0FBQ3dGLG1CQUFtQixDQUFDLE9BQU8sRUFBQUQscUJBQUEsQ0FBRSxJQUFJLEVBQUF2RixRQUFBLENBQVMsQ0FBQyxDQUFBO0VBQ2xELE9BQUE7RUFFQTZFLE1BQUFBLHFCQUFBLENBQUksSUFBQSxFQUFBN0UsUUFBQSxFQUFZNkMsS0FBSyxDQUFBLENBQUE7RUFFckIsTUFBQSxJQUFBMEMscUJBQUEsQ0FBSSxJQUFJLEVBQUF2RixRQUFBLENBQVcsRUFBQTtVQUNqQixJQUFJLENBQUN5RixnQkFBZ0IsQ0FBQyxPQUFPLEVBQUFGLHFCQUFBLENBQUUsSUFBSSxFQUFBdkYsUUFBQSxDQUFTLENBQUMsQ0FBQTtFQUMvQyxPQUFBO0VBQ0YsS0FBQTtNQUlBLElBQUk0RixNQUFNQSxHQUFHO0VBQ1gsTUFBQSxPQUFBTCxxQkFBQSxDQUFPLElBQUksRUFBQXRGLE9BQUEsQ0FBQSxDQUFBO0VBQ2IsS0FBQTtNQUVBLElBQUkyRixNQUFNQSxDQUFDL0MsS0FBSyxFQUFFO0VBQ2hCLE1BQUEsSUFBQTBDLHFCQUFBLENBQUksSUFBSSxFQUFBdEYsT0FBQSxDQUFVLEVBQUE7VUFDaEIsSUFBSSxDQUFDdUYsbUJBQW1CLENBQUMsTUFBTSxFQUFBRCxxQkFBQSxDQUFFLElBQUksRUFBQXRGLE9BQUEsQ0FBUSxDQUFDLENBQUE7RUFDaEQsT0FBQTtFQUVBNEUsTUFBQUEscUJBQUEsQ0FBSSxJQUFBLEVBQUE1RSxPQUFBLEVBQVc0QyxLQUFLLENBQUEsQ0FBQTtFQUVwQixNQUFBLElBQUEwQyxxQkFBQSxDQUFJLElBQUksRUFBQXRGLE9BQUEsQ0FBVSxFQUFBO1VBQ2hCLElBQUksQ0FBQ3dGLGdCQUFnQixDQUFDLE1BQU0sRUFBQUYscUJBQUEsQ0FBRSxJQUFJLEVBQUF0RixPQUFBLENBQVEsQ0FBQyxDQUFBO0VBQzdDLE9BQUE7RUFDRixLQUFBO01BSUEsSUFBSTRGLFFBQVFBLEdBQUc7RUFDYixNQUFBLE9BQUFOLHFCQUFBLENBQU8sSUFBSSxFQUFBckYsU0FBQSxDQUFBLENBQUE7RUFDYixLQUFBO01BRUEsSUFBSTJGLFFBQVFBLENBQUNoRCxLQUFLLEVBQUU7RUFDbEIsTUFBQSxJQUFBMEMscUJBQUEsQ0FBSSxJQUFJLEVBQUFyRixTQUFBLENBQVksRUFBQTtVQUNsQixJQUFJLENBQUNzRixtQkFBbUIsQ0FBQyxRQUFRLEVBQUFELHFCQUFBLENBQUUsSUFBSSxFQUFBckYsU0FBQSxDQUFVLENBQUMsQ0FBQTtFQUNwRCxPQUFBO0VBRUEyRSxNQUFBQSxxQkFBQSxDQUFJLElBQUEsRUFBQTNFLFNBQUEsRUFBYTJDLEtBQUssQ0FBQSxDQUFBO0VBRXRCLE1BQUEsSUFBQTBDLHFCQUFBLENBQUksSUFBSSxFQUFBckYsU0FBQSxDQUFZLEVBQUE7VUFDbEIsSUFBSSxDQUFDdUYsZ0JBQWdCLENBQUMsUUFBUSxFQUFBRixxQkFBQSxDQUFFLElBQUksRUFBQXJGLFNBQUEsQ0FBVSxDQUFDLENBQUE7RUFDakQsT0FBQTtFQUNGLEtBQUE7RUF1Q0E0RixJQUFBQSxLQUFLQSxHQUFTO0VBQUEsTUFBQSxJQUFBQyxzQkFBQSxDQUFBO0VBQ1osTUFBQSxJQUFJLENBQUFSLHFCQUFBLENBQUMsSUFBSSxFQUFBMUYsUUFBQSxDQUFTLEVBQUU7RUFDbEIsUUFBQSxPQUFBO0VBQ0YsT0FBQTtFQUVBLE1BQUEsQ0FBQWtHLHNCQUFBLEdBQUFSLHFCQUFBLENBQUEsSUFBSSxFQUFBMUYsUUFBQSxDQUFBLE1BQUEsSUFBQSxJQUFBa0csc0JBQUEsS0FBQSxLQUFBLENBQUEsSUFBSkEsc0JBQUEsQ0FBZWQsSUFBSSxDQUFFZSxPQUFPLElBQUs7RUFDL0JuQixRQUFBQSxxQkFBQSxDQUFJLElBQUEsRUFBQWhGLFFBQUEsRUFBWWtFLFNBQVMsQ0FBQSxDQUFBO0VBQ3pCaUMsUUFBQUEsT0FBTyxFQUFFLENBQUE7RUFDWCxPQUFDLENBQUMsQ0FBQTtFQUNKLEtBQUE7S0FDRCxFQUFBbEMsZUFBQSxDQUFBbEUsTUFBQSxFQUFBLFlBQUEsRUFyTHNELFNBQVMsQ0FBQWtFLEVBQUFBLGVBQUEsQ0FBQWxFLE1BQUEsRUFHNURxRyxZQUFBQSxFQUFBQSxPQUFPLENBQUNDLFFBQVEsS0FBSyxRQUFRLEdBQUc1RSxNQUFNLENBQUM2RSxnQkFBZ0IsR0FBRyxDQUFDLENBQUF2RyxFQUFBQSxNQUFBLENBa0w5RCxDQUFBLENBQUE7O0VBRUQ7RUFDQSxFQUFBLE1BQU13RyxVQUFVLEdBQUc7RUFDakJDLElBQUFBLFdBQVcsRUFBRSxLQUFLO0VBQ2xCQyxJQUFBQSxZQUFZLEVBQUUsS0FBSztFQUNuQkMsSUFBQUEsY0FBYyxFQUFFLEtBQUs7RUFDckJDLElBQUFBLGdCQUFnQixFQUFFLEtBQUs7RUFDdkJDLElBQUFBLGtCQUFrQixFQUFFLEtBQUs7RUFDekJDLElBQUFBLGtCQUFrQixFQUFFLEtBQUs7RUFDekJDLElBQUFBLFlBQVksRUFBRSxLQUFLO0VBQ25CQyxJQUFBQSxrQkFBa0IsRUFBRSxLQUFLO0VBQ3pCQyxJQUFBQSxhQUFhLEVBQUUsS0FBSztFQUNwQkMsSUFBQUEsZUFBZSxFQUFFLEtBQUs7RUFDdEJDLElBQUFBLFlBQVksRUFBRSxLQUFBO0tBQ2YsQ0FBQTs7RUFFRDtFQUNBO0lBQ0EsTUFBTUMscUJBQXFCLEdBQUdBLE1BQU07RUFBQSxJQUFBLElBQUFDLE9BQUEsQ0FBQTtFQUNsQyxJQUFBLElBQUksQ0FBQUEsT0FBQSxHQUFBaEYsTUFBTSxjQUFBZ0YsT0FBQSxLQUFBLEtBQUEsQ0FBQSxJQUFOQSxPQUFBLENBQVFDLFdBQVcsSUFBSSxDQUFDZCxVQUFVLENBQUNDLFdBQVcsRUFBRTtRQUNsRGhILE1BQU0sQ0FBQ2MsaUJBQWlCLENBQUNnSCxjQUFjLENBQUNsRixNQUFNLENBQUNpRixXQUFXLENBQUMsQ0FBQTtRQUMzRGQsVUFBVSxDQUFDQyxXQUFXLEdBQUcsSUFBSSxDQUFBO0VBQy9CLEtBQUE7TUFFQSxJQUFJbEUsT0FBTyxJQUFJRCxPQUFPLElBQUksQ0FBQ2tFLFVBQVUsQ0FBQ0UsWUFBWSxFQUFFO1FBQ2xEbkUsT0FBTyxDQUFDaUYsT0FBTyxDQUFDLE1BQU07RUFDcEIsUUFBQSxNQUFNQyxNQUFNLEdBQUduRixPQUFPLENBQUNvRixHQUFHLENBQUMsUUFBUSxDQUFDLENBQUE7RUFDcENqSSxRQUFBQSxNQUFNLENBQUNjLGlCQUFpQixDQUFDb0gsUUFBUSxDQUFDRixNQUFNLENBQUMsQ0FBQTtFQUMzQyxPQUFDLENBQUMsQ0FBQTtRQUNGakIsVUFBVSxDQUFDRSxZQUFZLEdBQUcsSUFBSSxDQUFBO0VBQ2hDLEtBQUE7TUFFQSxJQUFJbkUsT0FBTyxJQUFJQyxRQUFRLElBQUksQ0FBQ2dFLFVBQVUsQ0FBQ0csY0FBYyxFQUFFO1FBQ3JEcEUsT0FBTyxDQUFDaUYsT0FBTyxDQUFDLE1BQU07VUFDcEIsTUFBTTtZQUFFSSxHQUFHO0VBQUVDLFVBQUFBLFVBQUFBO1dBQVksR0FBR3JGLFFBQVEsQ0FBQ2tGLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsQ0FBQTtVQUNoRWpJLE1BQU0sQ0FBQ2MsaUJBQWlCLENBQUN1SCxVQUFVLENBQUNGLEdBQUcsSUFBSUMsVUFBVSxDQUFDLENBQUE7RUFDeEQsT0FBQyxDQUFDLENBQUE7UUFDRnJCLFVBQVUsQ0FBQ0csY0FBYyxHQUFHLElBQUksQ0FBQTtFQUNsQyxLQUFBO01BRUEsSUFBSXBFLE9BQU8sSUFBSUMsUUFBUSxJQUFJLENBQUNnRSxVQUFVLENBQUNJLGdCQUFnQixFQUFFO1FBQ3ZELE1BQU1tQixJQUFJLEdBQUd0SSxNQUFNLENBQUNzSSxJQUFJLENBQUNDLElBQUksQ0FBQ3ZJLE1BQU0sQ0FBQyxDQUFBO1FBRXJDOEMsT0FBTyxDQUFDaUYsT0FBTyxDQUFDLE1BQU07RUFDcEIsUUFBQSxNQUFNUyxpQkFBaUIsR0FBR2xILFVBQVUsQ0FBQ0MsT0FBTyxDQUFDTSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUE7O0VBRTFEO0VBQ0E7VUFDQSxJQUFJMkcsaUJBQWlCLEdBQUcsQ0FBQyxFQUFFO1lBQ3pCLE1BQU1DLFdBQVcsR0FBRzFGLFFBQVEsQ0FBQ2tGLEdBQUcsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLENBQUE7RUFFdEQ5SSxVQUFBQSxPQUFPLENBQUNDLEdBQUcsQ0FDVCx3REFBd0QsRUFDeERxSixXQUNGLENBQUMsQ0FBQTtZQUNEekksTUFBTSxDQUFDc0ksSUFBSSxHQUFHLENBQUNILEdBQUcsRUFBRU8sSUFBSSxFQUFFQyxRQUFRLEdBQUcsRUFBRSxLQUFLO0VBQzFDLFlBQUEsSUFDRSxDQUFDL0IsT0FBTyxDQUFDZ0MsR0FBRyxJQUNaNUksTUFBTSxDQUFDYyxpQkFBaUIsQ0FBQytILGlDQUFpQyxFQUFFLElBQzVELE9BQU9WLEdBQUcsS0FBSyxRQUFRLElBQ3ZCTSxXQUFXLENBQUNwRyxNQUFNLEdBQUcsQ0FBQyxJQUN0QjhGLEdBQUcsQ0FBQ1csUUFBUSxDQUFDTCxXQUFXLENBQUMsRUFDekI7RUFDQXRKLGNBQUFBLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDLG1EQUFtRCxDQUFDLENBQUE7Z0JBQ2hFLE9BQU9rSixJQUFJLENBQUNILEdBQUcsRUFBRSxZQUFZLEVBQUUsQ0FBQSxnQkFBQSxFQUFtQlEsUUFBUSxDQUFBLENBQUUsQ0FBQyxDQUFBO0VBQy9ELGFBQUE7RUFFQSxZQUFBLE9BQU9MLElBQUksQ0FBQ0gsR0FBRyxFQUFFTyxJQUFJLEVBQUVDLFFBQVEsQ0FBQyxDQUFBO2FBQ2pDLENBQUE7RUFDSCxTQUFBO0VBQ0YsT0FBQyxDQUFDLENBQUE7UUFDRjVCLFVBQVUsQ0FBQ0ksZ0JBQWdCLEdBQUcsSUFBSSxDQUFBO0VBQ3BDLEtBQUE7RUFFQSxJQUFBLElBQ0UsQ0FBQzFGLDBCQUEwQixDQUFDSCxVQUFVLENBQUNDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFDeER1QixPQUFPLElBQ1BDLFFBQVEsSUFDUixDQUFDZ0UsVUFBVSxDQUFDSyxrQkFBa0IsRUFDOUI7UUFDQXRFLE9BQU8sQ0FBQ2lGLE9BQU8sQ0FBQyxNQUFNO1VBQ3BCLE1BQU07WUFBRUksR0FBRztFQUFFQyxVQUFBQSxVQUFBQTtXQUFZLEdBQUdyRixRQUFRLENBQUNrRixHQUFHLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLENBQUE7VUFDbkVqSSxNQUFNLENBQUNjLGlCQUFpQixDQUFDaUksYUFBYSxDQUFDWixHQUFHLElBQUlDLFVBQVUsQ0FBQyxDQUFBO0VBQzNELE9BQUMsQ0FBQyxDQUFBO1FBQ0ZyQixVQUFVLENBQUNLLGtCQUFrQixHQUFHLElBQUksQ0FBQTtFQUN0QyxLQUFBOztFQUVBO01BQ0EsTUFBTTRCLGtCQUFrQixHQUFHQSxNQUFNO0VBQUEsTUFBQSxJQUFBQyxxQkFBQSxFQUFBQyxZQUFBLEVBQUFDLFFBQUEsRUFBQUMsY0FBQSxDQUFBO1FBQy9CLElBQUksQ0FBQ3hHLE1BQU0sSUFBSSxDQUFDRyxRQUFRLEVBQUUsT0FBTyxFQUFFLENBQUE7RUFDbkMsTUFBQSxNQUFNc0csU0FBUyxHQUFBLENBQUFKLHFCQUFBLEdBQUdyRyxNQUFNLENBQUMwRyxhQUFhLE1BQUFMLElBQUFBLElBQUFBLHFCQUFBLHVCQUFwQkEscUJBQUEsQ0FBc0JNLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxDQUFBO1FBRXBFLElBQUksQ0FBQzlILDBCQUEwQixDQUFDSCxVQUFVLENBQUNDLE9BQU8sRUFBRSxPQUFPLENBQUMsRUFBRTtVQUFBLElBQUFpSSxjQUFBLEVBQUFDLFFBQUEsQ0FBQTtFQUM1RDtVQUNBLE9BQU87WUFDTEosU0FBUztFQUNUSyxVQUFBQSxNQUFNLEdBQUFGLGNBQUEsR0FBRSxDQUFBQyxRQUFBLEdBQUE3RyxNQUFNLEVBQUM4RyxNQUFNLE1BQUEsSUFBQSxJQUFBRixjQUFBLEtBQWJBLEtBQUFBLENBQUFBLEdBQUFBLEtBQUFBLENBQUFBLEdBQUFBLGNBQUEsQ0FBQUcsSUFBQSxDQUFBRixRQUFnQixDQUFDO0VBQ3pCRyxVQUFBQSxzQkFBc0IsRUFBRTdHLFFBQVEsQ0FBQ2tGLEdBQUcsQ0FBQywwQkFBMEIsQ0FBQztFQUNoRTRCLFVBQUFBLGtCQUFrQixFQUFFOUcsUUFBUSxDQUFDa0YsR0FBRyxDQUFDLCtCQUErQixDQUFBO1dBQ2pFLENBQUE7RUFDSCxPQUFBO0VBQ0E7RUFDQSxNQUFBLE1BQU02QixJQUFJLEdBQUFaLENBQUFBLFlBQUEsR0FBRyxDQUFBQyxRQUFBLEdBQUF2RyxNQUFNLEVBQUNrSCxJQUFJLE1BQUEsSUFBQSxJQUFBWixZQUFBLEtBQVhBLEtBQUFBLENBQUFBLEdBQUFBLEtBQUFBLENBQUFBLEdBQUFBLFlBQUEsQ0FBQVMsSUFBQSxDQUFBUixRQUFjLENBQUMsQ0FBQTtRQUM1QixNQUFNWSxlQUFlLEdBQUdELElBQUksS0FBSkEsSUFBQUEsSUFBQUEsSUFBSSxnQkFBQVYsY0FBQSxHQUFKVSxJQUFJLENBQUUvRyxRQUFRLE1BQUEsSUFBQSxJQUFBcUcsY0FBQSxLQUFBQSxLQUFBQSxDQUFBQSxJQUFBQSxDQUFBQSxjQUFBLEdBQWRBLGNBQUEsQ0FBZ0JZLFFBQVEsY0FBQVosY0FBQSxLQUFBLEtBQUEsQ0FBQSxHQUFBLEtBQUEsQ0FBQSxHQUF4QkEsY0FBQSxDQUEwQmEsT0FBTyxDQUFBO1FBQ3pELE9BQU87VUFDTFosU0FBUztFQUNUSyxRQUFBQSxNQUFNLEVBQUVJLElBQUksS0FBQSxJQUFBLElBQUpBLElBQUksS0FBSkEsS0FBQUEsQ0FBQUEsR0FBQUEsS0FBQUEsQ0FBQUEsR0FBQUEsSUFBSSxDQUFFSSxHQUFHO0VBQ2pCTixRQUFBQSxzQkFBc0IsRUFBRUcsZUFBZSxLQUFBLElBQUEsSUFBZkEsZUFBZSxLQUFmQSxLQUFBQSxDQUFBQSxHQUFBQSxLQUFBQSxDQUFBQSxHQUFBQSxlQUFlLENBQUVJLE9BQU87RUFDaEROLFFBQUFBLGtCQUFrQixFQUFFRSxlQUFlLEtBQUEsSUFBQSxJQUFmQSxlQUFlLEtBQUEsS0FBQSxDQUFBLEdBQUEsS0FBQSxDQUFBLEdBQWZBLGVBQWUsQ0FBRUssWUFBQUE7U0FDdEMsQ0FBQTtPQUNGLENBQUE7RUFFRCxJQUFBLElBQUl0SCxPQUFPLElBQUksQ0FBQ2lFLFVBQVUsQ0FBQ00sa0JBQWtCLEVBQUU7UUFDN0N2RSxPQUFPLENBQUNpRixPQUFPLENBQUMsTUFBTTtVQUNwQixNQUFNO1lBQ0pzQixTQUFTO1lBQ1RLLE1BQU07WUFDTkUsc0JBQXNCO0VBQ3RCQyxVQUFBQSxrQkFBQUE7V0FDRCxHQUFHYixrQkFBa0IsRUFBRSxDQUFBO1VBRXhCLElBQ0UsQ0FBQ0ssU0FBUyxJQUNWLENBQUNLLE1BQU0sSUFDUCxDQUFDRSxzQkFBc0IsSUFDdkIsQ0FBQ0Msa0JBQWtCLEVBQ25CO0VBQ0EsVUFBQSxPQUFBO0VBQ0YsU0FBQTtVQUVBN0osTUFBTSxDQUFDYyxpQkFBaUIsQ0FBQ3VKLFlBQVksQ0FBQ2hCLFNBQVMsRUFBRUssTUFBTSxDQUFDLENBQUE7VUFDeEQxSixNQUFNLENBQUNjLGlCQUFpQixDQUFDd0oscUJBQXFCLENBQzVDVCxrQkFBa0IsRUFDbEJILE1BQ0YsQ0FBQyxDQUFBO0VBQ0gsT0FBQyxDQUFDLENBQUE7UUFDRjNDLFVBQVUsQ0FBQ00sa0JBQWtCLEdBQUcsSUFBSSxDQUFBO0VBQ3RDLEtBQUE7TUFFQSxJQUFJdkUsT0FBTyxJQUFJQyxRQUFRLElBQUksQ0FBQ2dFLFVBQVUsQ0FBQ08sWUFBWSxFQUFFO1FBQ25EeEUsT0FBTyxDQUFDaUYsT0FBTyxDQUFDLE1BQU07RUFDcEIsUUFBQSxNQUFNd0MsUUFBUSxHQUFHeEgsUUFBUSxDQUFDa0YsR0FBRyxDQUFDLFdBQVcsQ0FBQyxDQUFBO0VBQzFDakksUUFBQUEsTUFBTSxDQUFDYyxpQkFBaUIsQ0FBQzBKLFFBQVEsQ0FBQ0QsUUFBUSxDQUFDLENBQUE7RUFDN0MsT0FBQyxDQUFDLENBQUE7UUFDRnhELFVBQVUsQ0FBQ08sWUFBWSxHQUFHLElBQUksQ0FBQTtFQUNoQyxLQUFBO01BRUEsSUFBSXhFLE9BQU8sSUFBSUYsTUFBTSxJQUFJLENBQUNtRSxVQUFVLENBQUNRLGtCQUFrQixFQUFFO1FBQ3ZEekUsT0FBTyxDQUFDaUYsT0FBTyxDQUFDLE1BQU07RUFDcEIsUUFBQSxNQUFNMkIsTUFBTSxHQUFHOUcsTUFBTSxDQUFDOEcsTUFBTSxFQUFFLENBQUE7VUFDOUIxSixNQUFNLENBQUNjLGlCQUFpQixDQUFDMkosZUFBZSxDQUFDZixNQUFNLEtBQUssSUFBSSxDQUFDLENBQUE7RUFDM0QsT0FBQyxDQUFDLENBQUE7UUFDRjNDLFVBQVUsQ0FBQ1Esa0JBQWtCLEdBQUcsSUFBSSxDQUFBO0VBQ3RDLEtBQUE7TUFFQSxJQUFJekUsT0FBTyxJQUFJRixNQUFNLElBQUksQ0FBQ21FLFVBQVUsQ0FBQ1MsYUFBYSxFQUFFO1FBQ2xEMUUsT0FBTyxDQUFDaUYsT0FBTyxDQUFDLE1BQU07VUFDcEIsTUFBTTtFQUFFUCxVQUFBQSxhQUFBQTtFQUFjLFNBQUMsR0FBRzVFLE1BQU0sQ0FBQTtVQUNoQyxJQUFJLENBQUM0RSxhQUFhLEVBQUUsT0FBQTtFQUNwQnhILFFBQUFBLE1BQU0sQ0FBQ2MsaUJBQWlCLENBQUM0SixnQkFBZ0IsQ0FBQ2xELGFBQWEsQ0FBQyxDQUFBO0VBQzFELE9BQUMsQ0FBQyxDQUFBO1FBQ0ZULFVBQVUsQ0FBQ1MsYUFBYSxHQUFHLElBQUksQ0FBQTtFQUNqQyxLQUFBO01BRUEsSUFBSTFFLE9BQU8sSUFBSUYsTUFBTSxJQUFJSSxpQkFBaUIsSUFBSSxDQUFDK0QsVUFBVSxDQUFDVSxlQUFlLEVBQUU7UUFDekUzRSxPQUFPLENBQUNpRixPQUFPLENBQUMsTUFBTTtFQUNwQixRQUFBLE1BQU00QyxHQUFHLEdBQUcvSCxNQUFNLENBQUM4RyxNQUFNLEVBQUUsQ0FBQTtVQUMzQixJQUFJLENBQUNpQixHQUFHLEVBQUUsT0FBQTtFQUNWLFFBQUEsTUFBTWxELGVBQXVCLEdBQUd6RSxpQkFBaUIsQ0FDL0MySCxHQUFHLEVBQ0gsaUJBQ0YsQ0FBQyxDQUFBO0VBQ0QsUUFBQSxJQUNFLENBQUMsTUFBTSxFQUFFLE9BQU8sRUFBRSxNQUFNLEVBQUUsZUFBZSxDQUFDLENBQUM3QixRQUFRLENBQ2pEckIsZUFDRixDQUFDLEVBQ0Q7RUFDQXpILFVBQUFBLE1BQU0sQ0FBQ2MsaUJBQWlCLENBQUM4SixzQkFBc0IsQ0FDN0NuRCxlQUNGLENBQUMsQ0FBQTtFQUNILFNBQUE7RUFDRixPQUFDLENBQUMsQ0FBQTtRQUNGVixVQUFVLENBQUNVLGVBQWUsR0FBRyxJQUFJLENBQUE7RUFDbkMsS0FBQTtNQUVBLElBQUkzRSxPQUFPLElBQUlGLE1BQU0sSUFBSUksaUJBQWlCLElBQUksQ0FBQytELFVBQVUsQ0FBQ1csWUFBWSxFQUFFO1FBQ3RFNUUsT0FBTyxDQUFDaUYsT0FBTyxDQUFDLE1BQU07RUFDcEIsUUFBQSxNQUFNNEMsR0FBRyxHQUFHL0gsTUFBTSxDQUFDOEcsTUFBTSxFQUFFLENBQUE7VUFDM0IsSUFBSSxDQUFDaUIsR0FBRyxFQUFFLE9BQUE7RUFDVixRQUFBLE1BQU1FLGlCQUEwQixHQUFHN0gsaUJBQWlCLENBQ2xEMkgsR0FBRyxFQUNILGdCQUNGLENBQUMsQ0FBQTtFQUNELFFBQUEsTUFBTUcsYUFBc0IsR0FBRzlILGlCQUFpQixDQUFDMkgsR0FBRyxFQUFFLGVBQWUsQ0FBQyxDQUFBO1VBRXRFLElBQUlFLGlCQUFpQixJQUFJNUgsWUFBWSxFQUFFO1lBQ3JDLE9BQU9BLFlBQVksQ0FBQzhILFFBQVEsQ0FBQTtZQUM1QjlILFlBQVksQ0FBQzNDLEtBQUssRUFBRSxDQUFBO0VBQ3RCLFNBQUE7RUFFQU4sUUFBQUEsTUFBTSxDQUFDYyxpQkFBaUIsQ0FBQ2tLLHdCQUF3QixDQUFDO0VBQ2hESCxVQUFBQSxpQkFBaUIsRUFBRUksT0FBTyxDQUFDSixpQkFBaUIsQ0FBQztZQUM3Q0MsYUFBYSxFQUFFQSxhQUFhLEdBQUc3SSxNQUFNLENBQUM2SSxhQUFhLENBQUMsR0FBRyxJQUFJO1lBQzNESSxhQUFhLEVBQUdDLE1BQU0sSUFBSztFQUN6QixZQUFBLElBQUksQ0FBQ0EsTUFBTSxJQUFJdkksTUFBTSxDQUFDK0csSUFBSSxFQUFFO0VBQzFCL0csY0FBQUEsTUFBTSxDQUFDK0csSUFBSSxDQUFDLG1CQUFtQixDQUFDLENBQUE7RUFDaEMsY0FBQSxPQUFBO0VBQ0YsYUFBQTtjQUNBLElBQUkvRyxNQUFNLENBQUMrRyxJQUFJLEVBQUU7RUFDZi9HLGNBQUFBLE1BQU0sQ0FBQytHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFBO0VBQ3BDLGFBQUE7RUFDRixXQUFBO0VBQ0YsU0FBQyxDQUFDLENBQUE7RUFDSixPQUFDLENBQUMsQ0FBQTtRQUNGNUMsVUFBVSxDQUFDVyxZQUFZLEdBQUcsSUFBSSxDQUFBO0VBQ2hDLEtBQUE7S0FDRCxDQUFBOztFQUVEO0VBQ0FDLEVBQUFBLHFCQUFxQixFQUFFLENBQUE7RUFDdkJ5RCxFQUFBQSxXQUFXLENBQUN6RCxxQkFBcUIsRUFBRSxJQUFJLENBQUMsQ0FBQzs7RUFFekN4SSxFQUFBQSxPQUFPLENBQUNDLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFBO0VBQy9DLENBQUMsQ0FBQTtFQUVEa0IsS0FBSyxFQUFFOzs7Ozs7In0=
