'use strict';

var contextMenu = {
	cut: "&Ausschneiden",
	copy: "&Kopieren",
	paste: "&Einfügen",
	selectAll: "Alle auswählen",
	undo: "Wider&rufen",
	redo: "Wieder&holen",
	spelling: "Rechtschreibung",
	spellingLanguages: "Sprachen für die Rechtschreibprüfung",
	moreSpellingSuggestions: "Mehr Rechtschreibvorschläge",
	noSpellingSuggestions: "Keine Vorschläge",
	copyLinkAddress: "Link kopieren",
	copyLinkText: "Linktext kopieren",
	openLink: "Link öffnen",
	saveImageAs: "Bild speichern als...",
	copyImage: "Kopiere das Bild"
};
var dialog = {
	about: {
		title: "Über {{- appName}}",
		version: "Version: <1>{{-version}}</1>",
		checkUpdates: "Auf Aktualisierungen prüfen",
		checkUpdatesOnStart: "Beim Start auf Aktualisierungen prüfen",
		noUpdatesAvailable: "Es sind keine Aktualisierungen verfügbar.",
		copyright: "Copyright {{copyright}}",
		errorWhenLookingForUpdates: "Bei der Suche nach Updates ist ein Fehler aufgetreten",
		updateChannel: {
			label: "Update-Kanal",
			latest: "Stabil",
			beta: "Beta",
			alpha: "Alpha (Experimentell)"
		}
	},
	addServer: {
		title: "Server hinzufügen",
		message: "Möchten Sie \"{{- host}}\" zu Ihrer Serverliste hinzufügen?",
		add: "Hinzufügen",
		cancel: "Abbrechen"
	},
	addServerError: {
		title: "Ungültiger Host",
		message: "Der Host \"{{- host}}\" konnte nicht validiert werden, er wurde also nicht hinzugefügt."
	},
	certificateError: {
		title: "Zertifikatsfehler",
		message: "Vertrauen Sie dem Zertifikat von \"{{- issuerName}}\"?",
		yes: "Ja",
		no: "Nein"
	},
	downloadRemoval: {
		title: "Bist du dir sicher?",
		message: "Diesen Download entfernen?",
		yes: "Ja",
		no: "Nein"
	},
	resetAppData: {
		title: "Bist du dir sicher?",
		yes: "Ja",
		cancel: "Abbrechen"
	},
	screenshare: {
		title: "Bildschirm teilen",
		announcement: "Wählen Sie den zu teilenden Bildschirm aus"
	},
	update: {
		title: "Aktualisierung verfügbar",
		announcement: "Neue Aktualisierung verfügbar",
		message: "Eine neue Version der Rocket.Chat Desktop App ist verfügbar!",
		currentVersion: "Aktuelle Version:",
		newVersion: "Neue Version:",
		install: "Update installieren",
		remindLater: "Später erinnern",
		skip: "Diese Version überspringen"
	},
	updateDownloading: {
		title: "Aktualisierung wird heruntergeladen",
		message: "Sie werden benachrichtigt, wenn die Aktualisierung bereit zur Installation ist",
		ok: "OK"
	},
	updateInstallLater: {
		title: "Wird später installiert",
		message: "Die Aktualisierung wird durchgeführt, wenn Sie die App beenden",
		ok: "OK"
	},
	updateReady: {
		title: "Aktualisierung bereit zur Installation",
		message: "Aktualisierung wurde heruntergeladen",
		installNow: "Jetzt installieren",
		installLater: "Später installieren"
	},
	updateSkip: {
		title: "Aktualisierung überspringen",
		message: "Wir werden Sie benachrichtigen, wenn die nächste Aktualisierung verfügbar ist\n Wenn Sie Ihre Meinung ändern, können Sie im Über Menü nach Aktualisierungen suchen.",
		ok: "OK"
	},
	selectClientCertificate: {
		announcement: "Wählen Sie Zertifikat aus",
		select: "Auswählen",
		validDates: "Gültig ab {{-validStart,}} zu {{-validExpiry,}}"
	},
	openingExternalProtocol: {
		title: "Link mit benutzerdefiniertem Protokoll",
		message: "{{- protocol }} Link erfordert eine externe Anwendung.",
		detail: "Der angeforderte Link ist {{- url }} . Möchtest du weiter machen?",
		dontAskAgain: "Öffnen Sie solche Links immer in der zugehörigen App",
		yes: "Ja",
		no: "Nein"
	},
	allowVideoCallCaptureScreen: {
		title: "Der Videoanruf versucht, Ihren Bildschirm aufnehmen",
		message: "Der Videoanruf fragt nach der Erlaubnis, Ihren Bildschirm aufzunehmen.",
		detail: "Der Videoanrufserver {{- url }} benötigt die Erlaubnis, deinen Bildschirm mit anderen zu teilen.",
		dontAskAgain: "Lassen Sie immer zu, dass Videoanrufe von diesem Server Ihren Bildschirm erfassen",
		yes: "Erlauben",
		no: "Absagen"
	},
	mediaPermission: {
		title: "Medienberechtigung Erforderlich",
		message: "Der Zugriff auf {{- permissionType}} ist derzeit in Ihren Systemeinstellungen deaktiviert.",
		detail: "Um Videoanruf-Funktionen zu aktivieren, erlauben Sie bitte den Zugriff in den Datenschutzeinstellungen Ihres Systems und starten Sie dann die Anwendung neu.",
		openSettings: "Einstellungen Öffnen",
		cancel: "Abbrechen",
		microphone: "Mikrofon",
		camera: "Kamera",
		both: "Mikrofon und Kamera"
	}
};
var downloads = {
	title: "Downloads",
	notifications: {
		downloadFinished: "Fertig herunterladen",
		downloadInterrupted: "Herunterladen unterbrochen",
		downloadCancelled: "Herunterladen abgebrochen",
		downloadFailed: "Herunterladen fehlgeschlagen",
		downloadExpired: "Herunterladen abgelaufen",
		downloadExpiredMessage: "Bitte versuchen Sie erneut, von der Quelle herunterzuladen."
	},
	filters: {
		search: "Suche",
		server: "Server",
		mimeType: "Typ",
		status: "Status",
		clear: "Filter löschen",
		all: "Alle",
		mimes: {
			images: "Bilder",
			videos: "Videos",
			audios: "Audios",
			texts: "Texte",
			files: "Dateien"
		},
		statuses: {
			paused: "Angehalten",
			cancelled: "Abgesagt"
		}
	},
	item: {
		cancel: "Absagen",
		copyLink: "Link kopieren",
		errored: "Herunterladen abgebrochen",
		pause: "Pause",
		progressSize: "{{receivedBytes, byteSize}} von {{totalBytes, byteSize}} ({{ratio, percentage}})",
		remove: "Aus Liste entfernen",
		resume: "Fortsetzen",
		retry: "Wiederholen",
		showInFolder: "Im Ordner anzeigen"
	},
	showingResults: "Ergebnisse anzeigen {{first}} - {{last}} von {{count}}"
};
var certificatesManager = {
	title: "Zertifikatsmanager",
	trustedCertificates: "Vertrauenswürdige Zertifikate",
	notTrustedCertificates: "Nicht vertrauenswürdige Zertifikate",
	item: {
		domain: "Domain",
		actions: "Aktionen",
		remove: "Entfernen"
	}
};
var settings = {
	title: "Einstellungen",
	general: "Allgemein",
	certificates: "Zertifikate",
	options: {
		report: {
			title: "Fehler an Entwickler melden",
			description: "Melden Sie Fehler anonym an die Entwickler. Zu den freigegebenen Informationen gehören App-Versionsnummer, Betriebssystemtyp, Server-URL, Gerätesprache und Fehlertyp. Es werden keine Inhalte oder Benutzernamen geteilt.",
			masDescription: "Diese Option ist bei der Installation aus dem Mac App Store deaktiviert, die Fehler werden über den Fehlerberichtsprozess des Mac App Store gemeldet."
		},
		flashFrame: {
			title: "Flashframe aktivieren",
			titleDarwin: "Schalten Sie Dock Bounce bei Alarm um",
			description: "Lässt das Fenster blinken, um die Aufmerksamkeit des Benutzers zu erregen.",
			onLinux: "Einige Linux-Distributionen unterstützen diese Funktion nicht.",
			descriptionDarwin: "Lässt das App-Symbol im Dock hüpfen, um die Aufmerksamkeit des Benutzers zu erregen."
		},
		hardwareAcceleration: {
			title: "Hardware-Beschleunigung",
			description: "Aktiviert die Verwendung der Hardwarebeschleunigung, sofern verfügbar. Die Anwendung wird bei Änderung neu geladen."
		},
		videoCallScreenCaptureFallback: {
			title: "Alternative Bildschirmaufnahme für Videoanrufe",
			description: "Deaktiviert Windows Graphics Capture, damit das Teilen in RDP-Sitzungen funktioniert. Die App startet neu, wenn Sie diese Option ändern.",
			forcedDescription: "Bereits aktiv, weil die Anwendung eine RDP-Sitzung erkannt hat. Der Schalter bestimmt das Verhalten bei zukünftigen lokalen Starts."
		},
		internalVideoChatWindow: {
			title: "Öffnen Sie den Video-Chat mit dem Anwendungsfenster",
			description: "Wenn diese Option aktiviert ist, wird der Video-Chat im Anwendungsfenster anstelle des Standardbrowsers geöffnet. Allerdings wird für <strong>Google Meet</strong> und <strong>Jitsi</strong> die Bildschirmaufzeichnung in Electron-Anwendungen nicht unterstützt, daher werden sie unabhängig von dieser Einstellung immer im Browser geöffnet.",
			masDescription: "Diese Option ist deaktiviert, wenn sie aus dem Mac App Store installiert wird. Aus Sicherheitsgründen wird der Video-Chat standardmäßig über den Browser geöffnet."
		},
		minimizeOnClose: {
			title: "Beim Schließen minimieren",
			description: "Beim Schließen wird die App minimiert, andernfalls wird die Anwendung beendet. Das Taskleistensymbol muss deaktiviert werden, damit dies wirksam wird."
		},
		menubar: {
			title: "Menüleiste",
			description: "Menüleiste oben im Fenster anzeigen.",
			disabledHint: "Die Menüleiste kann nicht deaktiviert werden, wenn die Seitenleiste bereits deaktiviert ist. Die Einstellungen wären sonst nicht erreichbar."
		},
		sidebar: {
			title: "Seitenleiste",
			description: "Seitenleiste auf der linken Seite des Fensters mit Serverliste, Downloads und Einstellungen anzeigen.",
			disabledHint: "Die Seitenleiste kann nicht deaktiviert werden, wenn die Menüleiste bereits deaktiviert ist. Die Einstellungen wären sonst nicht erreichbar."
		},
		trayIcon: {
			title: "Taskleistensymbol",
			description: "Zeigt ein Symbol in der Systemleiste an. Wenn das Taskleistensymbol aktiv ist, wird die App beim Schließen in der Taskleiste minimiert. Andernfalls wird die Anwendung beendet."
		},
		availableBrowsers: {
			title: "Standard-Browser",
			description: "Wählen Sie aus, welcher Browser externe Links aus dieser App öffnen soll. Systemstandard verwendet die Einstellungen Ihres Betriebssystems.",
			systemDefault: "Systemstandard",
			loading: "Browser werden geladen...",
			current: "Aktuell verwendet:"
		},
		clearPermittedScreenCaptureServers: {
			title: "Erlaubte Bildschirmaufnahmeserver löschen",
			description: "Löschen Sie Server, die Bildschirme von dieser App erfassen dürfen"
		},
		ntlmCredentials: {
			title: "NTLM-Anmeldeinformationen",
			description: "Erlauben Sie die Verwendung von NTLM-Anmeldeinformationen bei der Verbindung mit einem Server.",
			domains: "Domänen, die die Anmeldeinformationen verwenden werden. Durch Komma getrennt. Verwenden Sie *, um alle Domänen abzugleichen."
		},
		videoCallWindowPersistence: {
			title: "Videoanruf-Fensterposition speichern",
			description: "Position und Größe der Videoanruf-Fenster zwischen Sitzungen speichern und wiederherstellen"
		}
	}
};
var error = {
	authNeeded: "Auth benötigt, probieren Sie <strong>{{- auth}}</strong>",
	connectTimeout: "Zeitüberschreitung beim Verbindungsaufbau",
	differentCertificate: "Zertifikat unterscheidet sich vom Vorigen.\n\n {{- detail}}",
	noValidServerFound: "Kein gültiger Server unter dieser URL gefunden",
	offline: "Überprüfen Sie Ihre Internetverbindung!"
};
var landing = {
	invalidUrl: "Ungültige url",
	validating: "Validieren...",
	inputUrl: "Server URL eingeben",
	connect: "Verbinden"
};
var menus = {
	about: "Über {{- appName}}",
	addNewServer: "&Neuen server hinzufügen",
	back: "&Der Rücken",
	clearTrustedCertificates: "Vertraute zertifikate löschen",
	close: "Schließen",
	copy: "&Kopieren",
	cut: "&Ausschneiden",
	developerMode: "Entwicklermodus",
	disableGpu: "GPU deaktivieren",
	documentation: "Dokumentation",
	downloads: "Downloads",
	settings: "Einstellungen",
	editMenu: "&Bearbeiten",
	fileMenu: "&Datei",
	forward: "&Nach vorne",
	helpMenu: "&Hilfe",
	hide: "Ausblenden {{- appName}}",
	learnMore: "Mehr erfahren",
	minimize: "Minimieren",
	openDevTools: "&DevTools öffnen",
	openDevToolsOnAllWindows: "Öffnen Sie &DevTools in allen Fenstern",
	paste: "&Einfügen",
	quit: "{{- appName}} &beenden",
	redo: "Wieder&holen",
	reload: "&Neu laden",
	reportIssue: "Problem melden",
	resetAppData: "Appdaten löschen",
	resetZoom: "Originalgröße",
	selectAll: "Alle auswählen",
	services: "Dienstleistungen",
	showFullScreen: "Vollbildmodus",
	showMenuBar: "MenuBar",
	showOnUnreadMessage: "Bei ungelesenen Nachrichten anzeigen",
	showServerList: "Server liste",
	showTrayIcon: "Symbole in menüleiste",
	toggleDevTools: "&DevTools ein-/ausblenden",
	undo: "Wider&rufen",
	unhide: "Zeige alles",
	viewMenu: "Darstellung",
	windowMenu: "&Fenster",
	zoomIn: "Vergrößern",
	zoomOut: "Verkleinern"
};
var loadingError = {
	title: "Server konnte nicht geladen werden",
	announcement: "Houston, we have a problem",
	reload: "Neu laden"
};
var videoCall = {
	loading: {
		initial: "Videoanruf wird geladen...",
		reloading: "Videoanruf wird neu geladen...",
		description: "Bitte warten Sie, während wir eine Verbindung zum Videoanruf herstellen"
	},
	error: {
		title: "Videoanruf konnte nicht geladen werden",
		announcement: "Houston, wir haben ein Problem",
		timeout: "Ladezeitüberschreitung - Videoanruf konnte nicht innerhalb von 15 Sekunden geladen werden",
		crashed: "Webview ist abgestürzt",
		maxRetriesReached: "Laden nach mehreren Versuchen fehlgeschlagen",
		reload: "Videoanruf neu laden"
	}
};
var selfxss = {
	title: "Halt!",
	description: "Dies ist eine Browserfunktion, die für Entwickler gedacht ist. Wenn Ihnen jemand gesagt hat, dass Sie hier etwas kopieren und einfügen sollen, um eine Rocket.Chat-Funktion zu aktivieren, oder \"hack\" das Konto einer anderen Person, ist dies ein Betrug und verschafft dieser Person Zugriff auf Ihr Rocket.Chat-Konto.",
	moreInfo: "Weitere Informationen finden Sie unter https://go.rocket.chat/i/xss."
};
var sidebar = {
	addNewServer: "Neuen Server hinzufügen",
	downloads: "Downloads",
	settings: "Einstellungen",
	item: {
		reload: "Server neu laden",
		remove: "Server entfernen",
		openDevTools: "DevTools öffnen",
		clearCache: "Cache leeren",
		clearStorageData: "Speicherdaten löschen"
	}
};
var touchBar = {
	formatting: "Formatierung",
	selectServer: "Server auswählen"
};
var tray = {
	menu: {
		show: "Anzeigen",
		hide: "Ausblenden",
		quit: "Beenden"
	},
	tooltip: {
		noUnreadMessage: "{{- appName}}: keine ungelesene Nachricht",
		unreadMention: "{{- appName}}: Sie haben eine ungelesene Erwähnung/Direktnachricht",
		unreadMention_plural: "{{- appName}}: you have {{- count}} ungelesene Erwähnungen/Direktnachrichten",
		unreadMessage: "{{- appName}}: Sie haben ungelesene Nachrichten"
	},
	balloon: {
		stillRunning: {
			title: "{{- appName}} läuft noch",
			content: "{{- appName }} ist so eingestellt, dass es in der Taskleiste/im Benachrichtigungsbereich ausgeführt wird."
		}
	}
};
var taskbar = {
	unreadMessage: "Ungelesene Nachrichten",
	unreadMention: "Ungelesene Erwähnungen",
	noUnreadMessage: "Keine ungelesenen Nachrichten"
};
var screenSharing = {
	permissionDenied: "Bildschirmaufnahme-Berechtigung verweigert",
	permissionRequired: "Die Bildschirmaufnahme-Berechtigung ist erforderlich, um Ihren Bildschirm zu teilen.",
	permissionInstructions: "Bitte aktivieren Sie diese in den Systemeinstellungen und versuchen Sie es erneut.",
	title: "Bildschirm teilen",
	entireScreen: "Ihr gesamter Bildschirm",
	applicationWindow: "Anwendungsfenster",
	noScreensFound: "Keine Bildschirme gefunden",
	noWindowsFound: "Keine Fenster gefunden",
	cancel: "Abbrechen",
	share: "Teilen"
};
var serverInfo = {
	title: "Serverinformationen",
	urlLabel: "URL:",
	versionLabel: "Version:",
	unknown: "Unbekannt",
	exchangeUrlLabel: "Outlook Exchange URL:",
	supportedVersionsTitle: "Unterstützte Versionen",
	statusLabel: "Status:",
	status: {
		loading: "Lädt...",
		error: "Laden fehlgeschlagen",
		loaded: "Geladen",
		idle: "Inaktiv",
		from: "von {{source}}"
	},
	supported: {
		unknown: "Unbekannt",
		expiring: "Läuft ab",
		yes: "Ja",
		no: "Nein"
	},
	expiration: {
		label: "Ablauf:",
		expiresOn: "Läuft ab am {{date}}"
	}
};
var deDE_i18n = {
	contextMenu: contextMenu,
	dialog: dialog,
	downloads: downloads,
	certificatesManager: certificatesManager,
	settings: settings,
	error: error,
	landing: landing,
	menus: menus,
	loadingError: loadingError,
	videoCall: videoCall,
	selfxss: selfxss,
	sidebar: sidebar,
	touchBar: touchBar,
	tray: tray,
	taskbar: taskbar,
	screenSharing: screenSharing,
	serverInfo: serverInfo
};

exports.certificatesManager = certificatesManager;
exports.contextMenu = contextMenu;
exports.default = deDE_i18n;
exports.dialog = dialog;
exports.downloads = downloads;
exports.error = error;
exports.landing = landing;
exports.loadingError = loadingError;
exports.menus = menus;
exports.screenSharing = screenSharing;
exports.selfxss = selfxss;
exports.serverInfo = serverInfo;
exports.settings = settings;
exports.sidebar = sidebar;
exports.taskbar = taskbar;
exports.touchBar = touchBar;
exports.tray = tray;
exports.videoCall = videoCall;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGUtREUuaTE4bi00ZWhTRWtHaC5qcyIsInNvdXJjZXMiOltdLCJzb3VyY2VzQ29udGVudCI6W10sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7In0=
