"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Uri = void 0;
const ExtensionMethods_1 = require("./ExtensionMethods");
/**
* Uri: c# uri shim for js
*/
class Uri {
    constructor(url) {
        this.m_scheme = null;
        if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(url)) {
            throw new Error("Uri - ctor- argument is not string or it is null or empty");
        }
        this.url = url;
        var parsed = ExtensionMethods_1.UriHelper.parseString(url);
        this.m_scheme = parsed.scheme.toLowerCase();
    }
    /**returns string url component, no transformations yet */
    get AbsoluteUri() { return this.url; }
    get Host() { return ExtensionMethods_1.UriHelper.getHost(this.url); }
    get Scheme() { return this.m_scheme; }
    ToString() {
        return this.url;
    }
    toString() {
        return this.url;
    }
    // GetDomain(): string {
    //     return UriHelper.getDomain(this.url);
    // }
    // GetHost(url: string): string {
    //     return this.GetDomain();
    // }
    static ParseString(url) {
        return ExtensionMethods_1.UriHelper.parseString(url);
    }
}
exports.Uri = Uri;
Uri.UriSchemeHttp = "http";
Uri.UriSchemeHttps = "https";
//# sourceMappingURL=Uri.js.map