"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemChange = void 0;
const ItemId_1 = require("../ComplexProperties/ItemId");
const Change_1 = require("./Change");
/**
 * Represents a change on an item as returned by a synchronization operation.
 *
 * @sealed
 */
class ItemChange extends Change_1.Change {
    /**
     * @internal Initializes a new instance of **ItemChange** class.
     */
    constructor() {
        super();
        this.isRead = false;
    }
    /**
     * Gets the item the change applies to. Item is null when ChangeType is equal to either ChangeType.Delete or ChangeType.ReadFlagChange. In those cases, use the ItemId property to retrieve the Id of the item that was deleted or whose IsRead property changed.
     */
    get Item() {
        return this.ServiceObject;
    }
    /**
     * Gets the IsRead property for the item that the change applies to. IsRead is only valid when ChangeType is equal to ChangeType.ReadFlagChange.
     */
    get IsRead() {
        return this.isRead;
    }
    set IsRead(value) {
        this.isRead = value;
    }
    /**
     * Gets the Id of the item the change applies to.
     */
    get ItemId() {
        return this.Id;
    }
    /**
     * @internal Creates an ItemId instance.
     *
     * @return  {ServiceId}      A ItemId.
     */
    CreateId() {
        return new ItemId_1.ItemId();
    }
}
exports.ItemChange = ItemChange;
//# sourceMappingURL=ItemChange.js.map