"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FolderChange = void 0;
const FolderId_1 = require("../ComplexProperties/FolderId");
const Change_1 = require("./Change");
/**
 * Represents a change on a folder as returned by a synchronization operation.
 *
 * @sealed
 */
class FolderChange extends Change_1.Change {
    /**
     * Gets the folder the change applies to. Folder is null when ChangeType is equal to ChangeType.Delete. In that case, use the FolderId property to retrieve the Id of the folder that was deleted.
     */
    get Folder() {
        return this.ServiceObject;
    }
    /**
     * Gets the Id of the folder the change applies to.
     */
    get FolderId() {
        return this.Id;
    }
    /**
     * @internal Initializes a new instance of **FolderChange** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Creates an FolderId instance.
     *
     * @return  {ServiceId}      A FolderId.
     */
    CreateId() {
        return new FolderId_1.FolderId();
    }
}
exports.FolderChange = FolderChange;
//# sourceMappingURL=FolderChange.js.map