"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupedFindItemsResults = void 0;
/**
 * Represents the results of an item search operation.
 *
 * @sealed
 * @type    {TItem} The type of item returned by the search operation.
 */
class GroupedFindItemsResults {
    /**
     * @internal Initializes a new instance of the **GroupedFindItemsResults<TItem>** class.
     */
    constructor() {
        this.totalCount = 0;
        this.nextPageOffset = null;
        this.moreAvailable = false;
        /**
         * List of ItemGroups.
         */
        this.itemGroups = [];
    }
    /**
     * Gets the total number of items matching the search criteria available in the searched folder.
     */
    get TotalCount() {
        return this.totalCount;
    }
    set TotalCount(value) {
        this.totalCount = value;
    }
    /**
     * Gets the offset that should be used with ItemView to retrieve the next page of items in a FindItems operation.
     */
    get NextPageOffset() {
        return this.nextPageOffset;
    }
    set NextPageOffset(value) {
        this.nextPageOffset = value;
    }
    /**
     * Gets a value indicating whether more items corresponding to the search criteria are available in the searched folder.
     */
    get MoreAvailable() {
        return this.moreAvailable;
    }
    set MoreAvailable(value) {
        this.moreAvailable = value;
    }
    /**
     * Gets the item groups returned by the search operation.
     */
    get ItemGroups() {
        return this.itemGroups;
    }
    GetEnumerator() { throw new Error("GroupedFindItemsResults.ts - GetEnumerator : Not implemented."); }
}
exports.GroupedFindItemsResults = GroupedFindItemsResults;
//# sourceMappingURL=GroupedFindItemsResults.js.map