"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Not = void 0;
const ExtensionMethods_1 = require("../../ExtensionMethods");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const Strings_1 = require("../../Strings");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const SearchFilter_1 = require("./SearchFilter");
/**
 * Represents a search filter that negates another. Applications can use NotFilter to define conditions such as "NOT(other filter)".
 */
class Not extends SearchFilter_1.SearchFilter {
    constructor(searchFilter = null) {
        super();
        this.searchFilter = searchFilter;
    }
    /**
     * Gets or sets the search filter to negate. Available search filter classes include SearchFilter.IsEqualTo, SearchFilter.ContainsSubstring and SearchFilter.SearchFilterCollection.
     */
    get SearchFilter() {
        return this.searchFilter;
    }
    set SearchFilter(value) {
        if (this.searchFilter !== null) {
            ExtensionMethods_1.ArrayHelper.RemoveEntry(this.searchFilter.OnChange, this.SearchFilterChanged);
        }
        this.SetFieldValue({ getValue: () => this.searchFilter, setValue: (updateValue) => { this.searchFilter = updateValue; } }, value);
        if (this.searchFilter !== null) {
            this.searchFilter.OnChange.push(this.SearchFilterChanged.bind(this));
        }
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.Not; }
    /**
     * @internal Validate instance.
     */
    InternalValidate() {
        if (this.searchFilter == null) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.SearchFilterMustBeSet);
        }
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        this.searchFilter = SearchFilter_1.SearchFilter.LoadFromXmlJsObject(jsObject, service);
    }
    /**
     * Gets or sets the search filter to negate. Available search filter classes include SearchFilter.IsEqualTo, SearchFilter.ContainsSubstring and SearchFilter.SearchFilterCollection.
     */
    SearchFilterChanged(complexProperty) { this.Changed(); }
    /**
     * @internal Writes the elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) { this.SearchFilter.WriteToXml(writer); }
}
exports.Not = Not;
//# sourceMappingURL=SearchFilter.Not.js.map