"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsGreaterThanOrEqualTo = void 0;
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const SearchFilter_RelationalFilter_1 = require("./SearchFilter.RelationalFilter");
/**
 * Represents a search filter that checks if a property is greater than or equal to a given value or other property.
 */
class IsGreaterThanOrEqualTo extends SearchFilter_RelationalFilter_1.RelationalFilter {
    constructor(propertyDefinition, otherPropertyDefinitionOrValue) {
        arguments.length === 0 ? super() : super(propertyDefinition, otherPropertyDefinitionOrValue);
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.IsGreaterThanOrEqualTo; }
}
exports.IsGreaterThanOrEqualTo = IsGreaterThanOrEqualTo;
//# sourceMappingURL=SearchFilter.IsGreaterThanOrEqualTo.js.map