"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Exists = void 0;
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const SearchFilter_PropertyBasedFilter_1 = require("./SearchFilter.PropertyBasedFilter");
/**
 * Represents a search filter checking if a field is set. Applications can use ExistsFilter to define conditions such as "Field IS SET".
 */
class Exists extends SearchFilter_PropertyBasedFilter_1.PropertyBasedFilter {
    constructor(propertyDefinition) {
        arguments.length === 0 ? super() : super(propertyDefinition);
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.Exists; }
}
exports.Exists = Exists;
//# sourceMappingURL=SearchFilter.Exists.js.map