"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExcludesBitmask = void 0;
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlAttributeNames_1 = require("../../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SearchFilter_PropertyBasedFilter_1 = require("./SearchFilter.PropertyBasedFilter");
/**
 * Represents a bitmask exclusion search filter. Applications can use ExcludesBitExcludesBitmaskFilter to define conditions such as "(OrdinalField and 0x0010) != 0x0010"
 */
class ExcludesBitmask extends SearchFilter_PropertyBasedFilter_1.PropertyBasedFilter {
    constructor(propertyDefinition, bitmask = 0) {
        arguments.length === 0 ? super() : super(propertyDefinition);
        this.bitmask = bitmask;
    }
    /**
     * Gets or sets the bitmask to compare the property with.
     */
    get Bitmask() {
        return this.bitmask;
    }
    set Bitmask(value) {
        this.SetFieldValue({ getValue: () => this.bitmask, setValue: (updateValue) => { this.bitmask = updateValue; } }, value);
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.Excludes; }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}               jsObject                Json Object converted from XML.
     * @param   {ExchangeService}   service                 The service.
     * @param   {string}            typeName                 type name, when provided prevent call for type name check.
     * @return  {SearchFilter}      SearchFilter instance.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        this.bitmask = ExtensionMethods_1.Convert.toInt(jsObject[XmlElementNames_1.XmlElementNames.Bitmask][XmlElementNames_1.XmlElementNames.Value]);
    }
    /**
     * @internal Writes the elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Bitmask);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Value, this.Bitmask);
        writer.WriteEndElement(); // Bitmask
    }
}
exports.ExcludesBitmask = ExcludesBitmask;
//# sourceMappingURL=SearchFilter.ExcludesBitmask.js.map