"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypedPropertyDefinition = void 0;
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const PropertyDefinition_1 = require("./PropertyDefinition");
/**
 * @internal Represents typed property definition.
 */
class TypedPropertyDefinition extends PropertyDefinition_1.PropertyDefinition {
    constructor(propertyName, xmlElementName, uri, versionOrFlags, version, isNullable) {
        switch (arguments.length) {
            case 4:
                super(propertyName, xmlElementName, uri, versionOrFlags);
                break;
            case 5:
            case 6:
                super(propertyName, xmlElementName, uri, versionOrFlags, version);
                break;
            default:
                break;
        }
        // @ts-ignore
        this.isNullable = isNullable || false;
    }
    /**
     * @internal Gets a value indicating whether this property definition is for a nullable type (ref, int?, bool?...).
     *
     */
    get IsNullable() { return this.isNullable; }
    ;
    /**
     * @internal Loads the property value from XMLJsObject.
     *
     * @param   {any}               value         The JsObject value.  Can be a JsonObject, string, number, bool, array, or null.
     * @param   {ExchangeService}   service       The service.
     * @param   {PropertyBag}       propertyBag   The property bag.
     */
    LoadPropertyValueFromXmlJsObject(jsObject, service, propertyBag) {
        if (jsObject) {
            propertyBag._setItem(this, this.Parse(jsObject));
        }
        // if (typeof jsObject === 'string' || jsObject instanceof String) {
        //     propertyBag._setItem(this, this.Parse(jsObject));
        // }
        // else if (jsObject != null) { //undefined == null returns true, false for === comparison.
        //     propertyBag._setItem(this, this.Parse(jsObject));
        // }
    }
    /**
     * @internal Convert instance to string.
     *
     * @param   {any}   value   The value.
     * @return  {string}        String representation of property value.
     */
    ToString(value) {
        if (value !== null && typeof value !== 'undefined')
            return value.toString();
        throw new Error("TypedPropertydefinition: incorrect call of ToString(value): value is undefined");
    }
    toString(value) {
        if (arguments.length > 0) {
            return this.ToString(value);
        }
        else {
            return this.ToString();
        }
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer              The writer.
     * @param   {PropertyBag}           propertyBag         The property bag.
     * @param   {boolean}               isUpdateOperation   Indicates whether the context is an update operation.
     */
    WritePropertyValueToXml(writer, propertyBag, isUpdateOperation) {
        var value = propertyBag._getItem(this);
        if (typeof value !== 'undefined') {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, this.XmlElementName, this.Name, this.ToString(value));
        }
    }
}
exports.TypedPropertyDefinition = TypedPropertyDefinition;
//# sourceMappingURL=TypedPropertyDefinition.js.map