"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartTimeZonePropertyDefinition = void 0;
const ExchangeVersion_1 = require("../Enumerations/ExchangeVersion");
const MeetingTimeZone_1 = require("../ComplexProperties/MeetingTimeZone");
const Schemas_1 = require("../Core/ServiceObjects/Schemas/Schemas");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const TimeZonePropertyDefinition_1 = require("./TimeZonePropertyDefinition");
/**
 * @internal Represents a property definition for properties of type TimeZoneInfo.
 */
class StartTimeZonePropertyDefinition extends TimeZonePropertyDefinition_1.TimeZonePropertyDefinition {
    /**
     * @internal Initializes a new instance of the **StartTimeZonePropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version);
    }
    /**
     * @internal Determines whether the specified flag is set.
     *
     * @param   {PropertyDefinitionFlags}   flag      The flag.
     * @param   {ExchangeVersion}           version   Requested version.
     * @return  {boolean}                   true if the specified flag is set; otherwise, false.
     */
    HasFlag(flag, version) {
        if (version && (version === ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1)) {
            return Schemas_1.Schemas.AppointmentSchema.MeetingTimeZone.HasFlag(flag, version);
        }
        else {
            return super.HasFlag(flag, version);
        }
    }
    /**
     * @internal Registers associated internal properties.
     *
     * @param   {PropertyDefinition[]}   properties   The list in which to add the associated properties.
     */
    RegisterAssociatedInternalProperties(properties) {
        super.RegisterAssociatedInternalProperties(properties);
        properties.push(Schemas_1.Schemas.AppointmentSchema.MeetingTimeZone);
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer              The writer.
     * @param   {PropertyBag}           propertyBag         The property bag.
     * @param   {boolean}               isUpdateOperation   Indicates whether the context is an update operation.
     */
    WritePropertyValueToXml(writer, propertyBag, isUpdateOperation) {
        var value = propertyBag._getItem(this);
        if (value != null) {
            if (writer.Service.RequestedServerVersion == ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1) {
                var service = writer.Service;
                if (service != null && service.Exchange2007CompatibilityMode == false) {
                    var meetingTimeZone = new MeetingTimeZone_1.MeetingTimeZone(value);
                    meetingTimeZone.WriteToXml(writer, XmlElementNames_1.XmlElementNames.MeetingTimeZone);
                }
            }
            else {
                super.WritePropertyValueToXml(writer, propertyBag, isUpdateOperation);
            }
        }
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteToXml(writer) {
        if (writer.Service.RequestedServerVersion == ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1) {
            Schemas_1.Schemas.AppointmentSchema.MeetingTimeZone.WriteToXml(writer);
        }
        else {
            super.WriteToXml(writer);
        }
    }
}
exports.StartTimeZonePropertyDefinition = StartTimeZonePropertyDefinition;
//# sourceMappingURL=StartTimeZonePropertyDefinition.js.map