"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EffectiveRightsPropertyDefinition = void 0;
const EffectiveRights_1 = require("../Enumerations/EffectiveRights");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtensionMethods_1 = require("../ExtensionMethods");
const PropertyDefinition_1 = require("./PropertyDefinition");
/**
 * @internal Represents effective rights property definition.
 */
class EffectiveRightsPropertyDefinition extends PropertyDefinition_1.PropertyDefinition {
    /**
     * Gets the property type.
     */
    // Type: any;//System.Type;
    /**
     * @internal Initializes a new instance of the **EffectiveRightsPropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version);
    }
    /**
     * @internal Loads the property value from XMLJsObject.
     *
     * @param   {any}               value         The JSON value.  Can be a JsonObject, string, number, bool, array, or null.
     * @param   {ExchangeService}   service       The service.
     * @param   {PropertyBag}       propertyBag   The property bag.
     */
    LoadPropertyValueFromXmlJsObject(jsObject, service, propertyBag) {
        var effectiveRightsValue = EffectiveRights_1.EffectiveRights.None;
        if (jsObject != null) {
            for (var key in jsObject) {
                switch (key) {
                    case XmlElementNames_1.XmlElementNames.CreateAssociated:
                        if (ExtensionMethods_1.Convert.toBool(jsObject[key])) {
                            effectiveRightsValue |= EffectiveRights_1.EffectiveRights.CreateAssociated;
                        }
                        break;
                    case XmlElementNames_1.XmlElementNames.CreateContents:
                        if (ExtensionMethods_1.Convert.toBool(jsObject[key])) {
                            effectiveRightsValue |= EffectiveRights_1.EffectiveRights.CreateContents;
                        }
                        break;
                    case XmlElementNames_1.XmlElementNames.CreateHierarchy:
                        if (ExtensionMethods_1.Convert.toBool(jsObject[key])) {
                            effectiveRightsValue |= EffectiveRights_1.EffectiveRights.CreateHierarchy;
                        }
                        break;
                    case XmlElementNames_1.XmlElementNames.Delete:
                        if (ExtensionMethods_1.Convert.toBool(jsObject[key])) {
                            effectiveRightsValue |= EffectiveRights_1.EffectiveRights.Delete;
                        }
                        break;
                    case XmlElementNames_1.XmlElementNames.Modify:
                        if (ExtensionMethods_1.Convert.toBool(jsObject[key])) {
                            effectiveRightsValue |= EffectiveRights_1.EffectiveRights.Modify;
                        }
                        break;
                    case XmlElementNames_1.XmlElementNames.Read:
                        if (ExtensionMethods_1.Convert.toBool(jsObject[key])) {
                            effectiveRightsValue |= EffectiveRights_1.EffectiveRights.Read;
                        }
                        break;
                    case XmlElementNames_1.XmlElementNames.ViewPrivateItems:
                        if (ExtensionMethods_1.Convert.toBool(jsObject[key])) {
                            effectiveRightsValue |= EffectiveRights_1.EffectiveRights.ViewPrivateItems;
                        }
                        break;
                }
            }
        }
        propertyBag._setItem(this, effectiveRightsValue);
    }
    /**
     * @internal Writes the property value to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer              The writer.
     * @param   {PropertyBag}           propertyBag         The property bag.
     * @param   {boolean}               isUpdateOperation   Indicates whether the context is an update operation.
     */
    WritePropertyValueToXml(writer, propertyBag, isUpdateOperation) {
        // EffectiveRights is a read-only property, no need to implement this.
    }
}
exports.EffectiveRightsPropertyDefinition = EffectiveRightsPropertyDefinition;
//# sourceMappingURL=EffectiveRightsPropertyDefinition.js.map