"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DoublePropertyDefinition = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const GenericPropertyDefinition_1 = require("./GenericPropertyDefinition");
/**
 * @internal Represents double-precision floating point property definition.
 */
class DoublePropertyDefinition extends GenericPropertyDefinition_1.GenericPropertyDefinition {
    /**
     * @internal Initializes a new instance of the **DoublePropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version, false);
    }
    /**
     * @internal Parses the specified value (added to workaround Generic based value conversion in c#).
     *
     * @param   {string}    value   The value.
     * @return  {any}       Value of string.
     */
    Parse(value) {
        return ExtensionMethods_1.Convert.toNumber(value);
    }
}
exports.DoublePropertyDefinition = DoublePropertyDefinition;
//# sourceMappingURL=DoublePropertyDefinition.js.map