"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainedPropertyDefinition = void 0;
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexPropertyDefinition_1 = require("./ComplexPropertyDefinition");
/**
 * @internal Represents contained property definition.
 *
 * @type    <TComplexProperty>  ComplexProperty
 */
class ContainedPropertyDefinition extends ComplexPropertyDefinition_1.ComplexPropertyDefinition {
    /**
     * @internal Initializes a new instance of the **ContainedPropertyDefinition<TComplexProperty>** class.
     *
     * @param   {string}                                            propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                                            xmlElementName             Name of the XML element.
     * @param   {string}                                            uri                        The URI.
     * @param   {string}                                            containedXmlElementName    Name of the contained XML element.
     * @param   {PropertyDefinitionFlags}                           flags                      The flags.
     * @param   {ExchangeVersion}                                   version                    The version.
     * @param   {CreateComplexPropertyDelegate<TComplexProperty>}   propertyCreationDelegate   Delegate used to create instances of ComplexProperty.
     */
    constructor(propertyName, xmlElementName, uri, containedXmlElementName, flags, version, propertyCreationDelegate) {
        super(propertyName, xmlElementName, uri, flags, version, propertyCreationDelegate);
        this.containedXmlElementName = containedXmlElementName;
    }
    /**
     * @internal Load from XMLJsObject.
     *
     * @param   {any}               reader        The reader.
     * @param   {ExchangeService}   service        The Service.
     * @param   {PropertyBag}       propertyBag   The property bag.
     */
    InternalLoadFromXmlJsObject(jsObject, service, propertyBag) {
        //debug: //check for correct contained element name
        if (jsObject[this.containedXmlElementName]) {
            jsObject = jsObject[this.containedXmlElementName];
        }
        super.InternalLoadFromXmlJsObject(jsObject, service, propertyBag);
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer              The writer.
     * @param   {PropertyBag}           propertyBag         The property bag.
     * @param   {boolean}               isUpdateOperation   Indicates whether the context is an update operation.
     */
    WritePropertyValueToXml(writer, propertyBag, isUpdateOperation) {
        var complexProperty = propertyBag._getItem(this);
        if (complexProperty) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, this.XmlElementName);
            complexProperty.WriteToXml(writer, this.containedXmlElementName);
            writer.WriteEndElement(); // this.XmlElementName
        }
    }
}
exports.ContainedPropertyDefinition = ContainedPropertyDefinition;
//# sourceMappingURL=ContainedPropertyDefinition.js.map