"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttachmentsPropertyDefinition = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const AttachmentCollection_1 = require("../ComplexProperties/AttachmentCollection");
const PropertyDefinitionFlags_1 = require("../Enumerations/PropertyDefinitionFlags");
const ExchangeVersion_1 = require("../Enumerations/ExchangeVersion");
const ComplexPropertyDefinition_1 = require("./ComplexPropertyDefinition");
/**
 * @internal Represents base Attachments property type.
 */
class AttachmentsPropertyDefinition extends ComplexPropertyDefinition_1.ComplexPropertyDefinition {
    /**
     * Initializes a new instance of the **AttachmentsPropertyDefinition** class.
     *
     * @param   {string}    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     */
    constructor(propertyName) {
        super(propertyName, XmlElementNames_1.XmlElementNames.Attachments, "item:Attachments", PropertyDefinitionFlags_1.PropertyDefinitionFlags.AutoInstantiateOnRead, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1, () => { return new AttachmentCollection_1.AttachmentCollection(); });
    }
    /**
     * @internal Determines whether the specified flag is set.
     *
     * @param   {PropertyDefinitionFlags}   flag      The flag.
     * @param   {ExchangeVersion}           version   Requested version.
     * @return  {boolean}                   true if the specified flag is set; otherwise, false.
     */
    HasFlag(flag, version) {
        if (version && version >= ExchangeVersion_1.ExchangeVersion.Exchange2010_SP2) {
            return (flag & AttachmentsPropertyDefinition.Exchange2010SP2PropertyDefinitionFlags) == flag;
        }
        return super.HasFlag(flag, version);
    }
}
exports.AttachmentsPropertyDefinition = AttachmentsPropertyDefinition;
AttachmentsPropertyDefinition.Exchange2010SP2PropertyDefinitionFlags = PropertyDefinitionFlags_1.PropertyDefinitionFlags.AutoInstantiateOnRead | PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanSet | PropertyDefinitionFlags_1.PropertyDefinitionFlags.ReuseInstance | PropertyDefinitionFlags_1.PropertyDefinitionFlags.UpdateCollectionItems;
//# sourceMappingURL=AttachmentsPropertyDefinition.js.map