"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamingSubscription = void 0;
const SubscriptionBase_1 = require("./SubscriptionBase");
/**
 * Represents a streaming subscription.
 *
 * @sealed
 */
class StreamingSubscription extends SubscriptionBase_1.SubscriptionBase {
    /**
     * Gets the service used to create this subscription.
     */
    get Service() {
        return this.service;
    }
    /**
     * Gets a value indicating whether this subscription uses watermarks.
     */
    get UsesWatermark() {
        return false;
    }
    /**
     * @internal Initializes a new instance of the **StreamingSubscription** class.
     *
     * @param   {ExchangeService}   service     The service.
     */
    constructor(service) {
        super(service);
        this.service = service;
    }
    /**
     * Unsubscribes from the streaming subscription.
     */
    Unsubscribe() { return this.Service.Unsubscribe(this.Id); }
}
exports.StreamingSubscription = StreamingSubscription;
//# sourceMappingURL=StreamingSubscription.js.map