"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MobilePhone = void 0;
const ServiceValidationException_1 = require("../Exceptions/ServiceValidationException");
const ExtensionMethods_1 = require("../ExtensionMethods");
/**
 * Represents a mobile phone.
 *
 * @sealed
 */
class MobilePhone {
    constructor(name = null, phoneNumber = null) {
        this.name = name;
        this.phoneNumber = phoneNumber;
    }
    /**
     * Gets or sets the name associated with this mobile phone.
     */
    get Name() {
        return this.name;
    }
    set Name(value) {
        this.name = value;
    }
    /**
     * Gets or sets the number of this mobile phone.
     */
    get PhoneNumber() {
        return this.phoneNumber;
    }
    set PhoneNumber(value) {
        this.phoneNumber = value;
    }
    /**
     * Validates this instance.
     * ISelfValidate.Validate
     */
    Validate() {
        if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.PhoneNumber)) {
            throw new ServiceValidationException_1.ServiceValidationException("PhoneNumber cannot be empty.");
        }
    }
    ;
}
exports.MobilePhone = MobilePhone;
//# sourceMappingURL=MobilePhone.js.map