"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImpersonatedUserId = void 0;
const ConnectingIdType_1 = require("../Enumerations/ConnectingIdType");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ExchangeVersion_1 = require("../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../Core/XmlElementNames");
//todo: should be done
class ImpersonatedUserId {
    //private idType: ConnectingIdType;
    //private id: string;
    constructor(idType, id) {
        this.IdType = idType;
        this.Id = id;
    }
    /**@internal */
    WriteToXml(writer) {
        if (!this.Id || this.Id === "") {
            throw new Error("Id property must be set before serialization"); // ArgumentException(Strings.IdPropertyMustBeSet);
        }
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.ExchangeImpersonation);
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.ConnectingSID);
        // For 2007 SP1, use PrimarySmtpAddress for type SmtpAddress
        var connectingIdTypeLocalName = (this.IdType == ConnectingIdType_1.ConnectingIdType.SmtpAddress) && (writer.Service.RequestedServerVersion == ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1)
            ? XmlElementNames_1.XmlElementNames.PrimarySmtpAddress
            : ConnectingIdType_1.ConnectingIdType[this.IdType];
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, connectingIdTypeLocalName, this.Id);
        writer.WriteEndElement(); // ConnectingSID
        writer.WriteEndElement(); // ExchangeImpersonation
    }
}
exports.ImpersonatedUserId = ImpersonatedUserId;
//# sourceMappingURL=ImpersonatedUserId.js.map