"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlternateIdBase = void 0;
const IdFormat_1 = require("../../Enumerations/IdFormat");
const XmlAttributeNames_1 = require("../../Core/XmlAttributeNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
/**
 * Represents the base class for Id expressed in a specific format.
 */
class AlternateIdBase {
    constructor(format = IdFormat_1.IdFormat.EwsLegacyId) {
        this.Format = format;
    }
    /**
     * @internal Validate this instance.
     */
    InternalValidate() { }
    /**
     * @internal Loads the attributes from Xml JsObject.
     *
     * @param   {any}   responseObject   The response object.
     */
    LoadAttributesFromXmlJsObject(responseObject) {
        this.Format = IdFormat_1.IdFormat[responseObject[XmlAttributeNames_1.XmlAttributeNames.Format]];
    }
    /**
     * Validate this instance.
     * ISelfValidate.Validate
     *
     */
    Validate() {
        this.InternalValidate();
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Format, IdFormat_1.IdFormat[this.Format]);
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, this.GetXmlElementName());
        this.WriteAttributesToXml(writer);
        writer.WriteEndElement(); // this.GetXmlElementName()
    }
}
exports.AlternateIdBase = AlternateIdBase;
//# sourceMappingURL=AlternateIdBase.js.map