"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlternateId = void 0;
const ExtensionMethods_1 = require("../../ExtensionMethods");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const IdFormat_1 = require("../../Enumerations/IdFormat");
const XmlAttributeNames_1 = require("../../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const AlternateIdBase_1 = require("./AlternateIdBase");
/**
 * Represents an Id expressed in a specific format.
 */
class AlternateId extends AlternateIdBase_1.AlternateIdBase {
    constructor(format = IdFormat_1.IdFormat.EwsLegacyId, id = null, mailbox = null, isArchive = false) {
        super(format);
        /**
         * Gets or sets the Id.
         */
        this.UniqueId = null;
        /**
         * Gets or sets the mailbox to which the Id belongs.
         */
        this.Mailbox = null;
        /**
         * Gets or sets the type (primary or archive) mailbox to which the Id belongs.
         */
        this.IsArchive = false;
        this.UniqueId = id;
        this.Mailbox = mailbox;
        this.IsArchive = isArchive;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.AlternateId;
    }
    /**
     * @internal Validate this instance.
     */
    InternalValidate() {
        EwsUtilities_1.EwsUtilities.ValidateParam(this.Mailbox, "mailbox");
    }
    /**
     * @internal Loads the attributes from Xml JsObject.
     *
     * @param   {any}   responseObject   The response object.
     */
    LoadAttributesFromXmlJsObject(responseObject) {
        super.LoadAttributesFromXmlJsObject(responseObject);
        this.UniqueId = responseObject[XmlAttributeNames_1.XmlAttributeNames.Id];
        this.Mailbox = responseObject[XmlAttributeNames_1.XmlAttributeNames.Mailbox];
        if (responseObject[XmlAttributeNames_1.XmlAttributeNames.IsArchive]) {
            this.IsArchive = ExtensionMethods_1.Convert.toBool(responseObject[XmlAttributeNames_1.XmlAttributeNames.IsArchive]);
        }
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Id, this.UniqueId);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Mailbox, this.Mailbox);
        // this is optional attribute will default false so we will write
        // it only if it is true
        if (this.IsArchive) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.IsArchive, true);
        }
    }
}
exports.AlternateId = AlternateId;
/**
 * @internal Name of schema type used for AlternateId.
 */
AlternateId.SchemaTypeName = "AlternateIdType";
//# sourceMappingURL=AlternateId.js.map