"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FolderWrapper = void 0;
const EwsLogging_1 = require("../Core/EwsLogging");
const AbstractFolderIdWrapper_1 = require("./AbstractFolderIdWrapper");
class FolderWrapper extends AbstractFolderIdWrapper_1.AbstractFolderIdWrapper {
    constructor(folder) {
        super();
        EwsLogging_1.EwsLogging.Assert(folder != null, "FolderWrapper.ctor", "folder is null");
        EwsLogging_1.EwsLogging.Assert(!folder.IsNew, "FolderWrapper.ctor", "folder does not have an Id");
        this.folder = folder;
    }
    GetFolder() { return this.folder; }
    //InternalToJson(service: ExchangeService): void{ throw new Error("FolderWrapper.ts - InternalToJson : Not implemented.");}
    /**@internal */
    WriteToXml(writer) { this.folder.Id.WriteToXml(writer); }
}
exports.FolderWrapper = FolderWrapper;
//# sourceMappingURL=FolderWrapper.js.map