"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FolderIdWrapperList = void 0;
const Folder_1 = require("../Core/ServiceObjects/Folders/Folder");
const FolderId_1 = require("../ComplexProperties/FolderId");
const FolderIdWrapper_1 = require("./FolderIdWrapper");
const FolderWrapper_1 = require("./FolderWrapper");
/**
 * @internal Represents a list a abstracted folder Ids.
 */
class FolderIdWrapperList {
    constructor() {
        /**
         * List of AbstractFolderIdWrapper.
         */
        this.ids = [];
    }
    /**
     * Gets the id count.
     *
     * @value   The count.
     */
    get Count() {
        return this.ids.length;
    }
    /**
     * @internal Gets the **AbstractFolderIdWrapper** at the specified index.
     *
     * @param   {}   index   the index
     */
    _getItem(index) {
        return this.ids[index];
    }
    Add(folderOrId) {
        if (folderOrId instanceof Folder_1.Folder)
            this.ids.push(new FolderWrapper_1.FolderWrapper(folderOrId));
        else if (folderOrId instanceof FolderId_1.FolderId)
            this.ids.push(new FolderIdWrapper_1.FolderIdWrapper(folderOrId));
        else
            throw new Error("FolderIdWrapperList.ts - Add - should not be seeing this.");
    }
    AddRange(foldersOrIds) {
        if (foldersOrIds != null) {
            for (var folderOrId of foldersOrIds) {
                this.Add(folderOrId);
            }
        }
    }
    /**
     *  Returns an enumerator that iterates through the collection. this case this.ids
     */
    GetEnumerator() {
        return this.ids;
    }
    /**
     * @internal Validates list of folderIds against a specified request version.
     *
     * @param   {ExchangeVersion}   version   The version.
     */
    Validate(version) {
        for (var folderIdWrapper of this.ids) {
            //var folderIdWrapper: AbstractFolderIdWrapper = item;
            folderIdWrapper.Validate(version);
        }
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer           The writer.
     * @param   {XmlNamespace}          ewsNamesapce     The ews namesapce.
     * @param   {string}                xmlElementName   Name of the XML element.
     */
    WriteToXml(writer, ewsNamesapce, xmlElementName) {
        if (this.Count > 0) {
            writer.WriteStartElement(ewsNamesapce, xmlElementName);
            for (var folderIdWrapper of this.ids) {
                //var folderIdWrapper: AbstractFolderIdWrapper = item;
                folderIdWrapper.WriteToXml(writer);
            }
            writer.WriteEndElement();
        }
    }
}
exports.FolderIdWrapperList = FolderIdWrapperList;
//# sourceMappingURL=FolderIdWrapperList.js.map