"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpandGroupResults = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const EmailAddress_1 = require("../ComplexProperties/EmailAddress");
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents the results of an ExpandGroup operation.
 *
 * @sealed
 */
class ExpandGroupResults {
    /**
     * @internal Initializes a new instance of the **ExpandGroupResults** class.
     */
    constructor() {
        /**
         * True, if all members are returned.
         * EWS always returns true on ExpandDL, i.e. all members are returned.
         */
        this.includesAllMembers = false;
        /**
         * DL members.
         */
        this.members = [];
    }
    /**
     * Gets the number of members that were returned by the ExpandGroup operation.
     * Count might be less than the total number of members in the group, in which case the value of the IncludesAllMembers is false.
     */
    get Count() {
        return this.members.length;
    }
    /**
     * Gets a value indicating whether all the members of the group have been returned by ExpandGroup.
     */
    get IncludesAllMembers() {
        return this.includesAllMembers;
    }
    /**
     * Gets the members of the expanded group.
     */
    get Members() {
        return this.members;
    }
    /**
     *  Returns an enumerator that iterates through the collection. this case this.members
     */
    GetEnumerator() {
        return this.members;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        var dlResponse = jsObject[XmlElementNames_1.XmlElementNames.DLExpansion];
        var mailboxes = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(dlResponse, XmlElementNames_1.XmlElementNames.Mailbox);
        this.includesAllMembers = ExtensionMethods_1.Convert.toBool(dlResponse[XmlAttributeNames_1.XmlAttributeNames.IncludesLastItemInRange]);
        var mailboxCount = ExtensionMethods_1.Convert.toNumber(dlResponse[XmlAttributeNames_1.XmlAttributeNames.TotalItemsInView]);
        for (var mailbox of mailboxes) {
            var emailAddress = new EmailAddress_1.EmailAddress();
            emailAddress.LoadFromXmlJsObject(mailbox, service);
            this.members.push(emailAddress);
        }
    }
}
exports.ExpandGroupResults = ExpandGroupResults;
//# sourceMappingURL=ExpandGroupResults.js.map