"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EwsTraceListener = void 0;
/**
 * @internal EwsTraceListener logs request/responses to a text writer.
 */
class EwsTraceListener {
    constructor(writer = { Write: console.log }) {
        this.writer = null;
        this.writer = writer;
    }
    /**
     * Handles a trace message
     *
     * @param   {string}   traceType      Type of trace message.
     * @param   {string}   traceMessage   The trace message.
     */
    Trace(traceType, traceMessage) {
        this.writer.Write(traceMessage);
    }
}
exports.EwsTraceListener = EwsTraceListener;
//# sourceMappingURL=EwsTraceListener.js.map